/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search.component;

import com.alibabacloud.intellij.cosy.ui.search.component.RefreshColorComponent;
import com.alibabacloud.intellij.cosy.ui.search.generate.AskInputPanel;
import com.alibabacloud.intellij.cosy.ui.search.generate.InputTagsPanel;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBTextArea;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import lombok.Generated;

public class AutoHeightTextArea
extends JBTextArea
implements RefreshColorComponent {
    private static final Logger LOGGER = Logger.getInstance(AutoHeightTextArea.class);
    Color defaultColor;
    List<EnterKeyListener> listeners = new ArrayList<EnterKeyListener>();
    List<OnShowPlaceHolderListener> placeHolderListeners = new ArrayList<OnShowPlaceHolderListener>();
    AtomicBoolean inputMethodCommit = new AtomicBoolean(false);
    boolean showPlaceHolder = true;
    private String placeholder;
    int maxHeight;
    InputTagsPanel inputTagsPanel;

    public AutoHeightTextArea(Project project, AskInputPanel parentPanel, String placeholderText, int maxHeight) {
        this.placeholder = placeholderText;
        this.maxHeight = maxHeight;
        this.inputTagsPanel = this.inputTagsPanel;
        this.setLineWrap(true);
        this.setWrapStyleWord(false);
        this.setEditable(true);
        this.setBackground(ColorUtil.getEditorBackgroundColor());
        this.defaultColor = ColorUtil.getTextForegroundColor();
        this.addInputMethodListener(new InputMethodListener(){

            @Override
            public void inputMethodTextChanged(InputMethodEvent event) {
                if (event.getCommittedCharacterCount() > 0) {
                    AutoHeightTextArea.this.inputMethodCommit.getAndSet(true);
                }
            }

            @Override
            public void caretPositionChanged(InputMethodEvent event) {
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                boolean pinyinComment = false;
                if (e.getKeyCode() == 10) {
                    if (e.isControlDown() || e.isMetaDown()) {
                        e.consume();
                        int pos = AutoHeightTextArea.this.getCaretPosition();
                        AutoHeightTextArea.this.insert("\n", pos);
                        AutoHeightTextArea.this.inputMethodCommit.getAndSet(false);
                    } else if (e.getModifiersEx() == 0) {
                        e.consume();
                        if (pinyinComment) {
                            return;
                        }
                        AutoHeightTextArea.this.doSendMessage();
                    }
                    AutoHeightTextArea.this.revalidate();
                }
            }
        });
        this.getEmptyText().setText(this.placeholder);
    }

    public void doSendMessage() {
        String content = this.getText().trim();
        this.listeners.forEach(listener -> listener.onEnterKeyPressed(content));
    }

    public void clearTextArea() {
        this.setText("");
    }

    public void setBackground(Color bg) {
        super.setBackground(ColorUtil.getEditorBackgroundColor());
    }

    public void disablePlaceHolder() {
        this.showPlaceHolder = false;
    }

    public void enablePlaceHolder() {
        this.showPlaceHolder = true;
        this.getEmptyText().setText(this.placeholder);
    }

    public void addEnterKeyListener(EnterKeyListener listener) {
        this.listeners.add(listener);
    }

    public void addOnShowPlaceHolderListener(OnShowPlaceHolderListener listener) {
        this.placeHolderListeners.add(listener);
    }

    public Dimension getPreferredSize() {
        int lineCount;
        Dimension dim = super.getPreferredSize();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int lineHeight = fm.getHeight();
        String text = this.getText();
        String[] lines = text.split("\n");
        int splitLineCount = lines.length;
        if (text.endsWith("\n")) {
            ++splitLineCount;
        }
        if ((lineCount = Math.max(this.getLineCount(), splitLineCount)) <= 0) {
            lineCount = 1;
        }
        int height = lineHeight * lineCount;
        Insets insets = this.getInsets();
        if ((height += insets.top + insets.bottom) < lineHeight) {
            height = lineHeight;
        }
        dim.height = Math.max(height, dim.height);
        if (this.maxHeight > 0) {
            dim.height = Math.min(dim.height, this.maxHeight);
        }
        return dim;
    }

    public int getLineOfOffset(int offset) throws BadLocationException {
        try {
            return super.getLineOfOffset(offset);
        }
        catch (BadLocationException e) {
            Document doc = this.getDocument();
            LOGGER.warn("get line of offset error:" + offset + " len:" + doc.getLength(), (Throwable)e);
            if (offset < 0) {
                return super.getLineOfOffset(0);
            }
            if (offset > doc.getLength()) {
                return super.getLineOfOffset(doc.getLength());
            }
            throw e;
        }
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
        this.getEmptyText().setText(placeholder);
        this.showPlaceHolder = true;
        this.revalidate();
        this.repaint();
    }

    @Override
    public void refreshColor(EditorColorsScheme scheme, Color themeColor) {
        this.setBackground(ColorUtil.getEditorBackgroundColor());
    }

    public void updateUI() {
        this.setUI(new BasicTextAreaUI());
    }

    @Generated
    public boolean isShowPlaceHolder() {
        return this.showPlaceHolder;
    }

    public static interface OnShowPlaceHolderListener {
        public void onShowPlaceHolder();

        public void onHiddenPlaceHolder();
    }

    public static interface EnterKeyListener {
        public void onEnterKeyPressed(String var1);
    }
}

