/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search;

import com.alibabacloud.intellij.cosy.common.BuildFeature;
import com.alibabacloud.intellij.cosy.common.CosyConfig;
import com.alibabacloud.intellij.cosy.ui.search.I18NConstant;
import com.alibabacloud.intellij.cosy.ui.search.LingmaToolWindowPanel;
import com.alibabacloud.intellij.cosy.ui.search.topic.LingmaOpenToolWindowNotifier;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class SearchToolWindowFactory
implements DumbAware,
ToolWindowFactory {
    public static void showToolWindow(Project project) {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Code Search");
        if (toolWindow != null) {
            toolWindow.show(null);
            ((LingmaOpenToolWindowNotifier)project.getMessageBus().syncPublisher(LingmaOpenToolWindowNotifier.LINGMA_OPEN_TOOL_WINDOW_NOTIFIER_TOPIC)).openToolWindow();
        }
    }

    public static void hideToolWindow(Project project) {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Code Search");
        if (toolWindow != null && toolWindow.isVisible()) {
            toolWindow.hide(null);
        }
    }

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            SearchToolWindowFactory.$$$reportNull$$$0(0);
        }
        if (toolWindow == null) {
            SearchToolWindowFactory.$$$reportNull$$$0(1);
        }
        SearchToolWindowFactory.createSearchMainPanel(project, toolWindow, null);
    }

    public static void createSearchMainPanelAndGenerateContentForm(@NotNull Project project, @NotNull ToolWindow toolWindow, Consumer<Project> consumer) {
        if (project == null) {
            SearchToolWindowFactory.$$$reportNull$$$0(2);
        }
        if (toolWindow == null) {
            SearchToolWindowFactory.$$$reportNull$$$0(3);
        }
        SearchToolWindowFactory.createSearchMainPanel(project, toolWindow, consumer);
    }

    private static void createSearchMainPanel(@NotNull Project project, @NotNull ToolWindow toolWindow, Consumer<Project> consumer) {
        if (project == null) {
            SearchToolWindowFactory.$$$reportNull$$$0(4);
        }
        if (toolWindow == null) {
            SearchToolWindowFactory.$$$reportNull$$$0(5);
        }
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        LingmaToolWindowPanel mainPanel = new LingmaToolWindowPanel(project);
        mainPanel.delayInit();
        Content content = contentFactory.createContent((JComponent)mainPanel.getMainPanel(), I18NConstant.MAIN_CONTENT_NAME, false);
        content.setCloseable(false);
        toolWindow.setTitle(I18NConstant.COSY_PLUGIN_NAME);
        toolWindow.getContentManager().addContent(content);
        SearchToolWindowFactory.createToolWindowActions(project, toolWindow);
        if (consumer != null) {
            consumer.consume((Object)project);
        }
    }

    private static void createToolWindowActions(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            SearchToolWindowFactory.$$$reportNull$$$0(6);
        }
        if (toolWindow == null) {
            SearchToolWindowFactory.$$$reportNull$$$0(7);
        }
        AnAction action = null;
        action = CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false) ? ActionManager.getInstance().getAction("cosyToolWindowTitleActionsVpcGroup") : ActionManager.getInstance().getAction("cosyToolWindowTitleActionsGroup");
        if (action != null) {
            ArrayList<AnAction> actions = new ArrayList<AnAction>();
            actions.add(action);
            toolWindow.setTitleActions(actions);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
        }
        objectArray2[1] = "com/alibabacloud/intellij/cosy/ui/search/SearchToolWindowFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createToolWindowContent";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createSearchMainPanelAndGenerateContentForm";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createSearchMainPanel";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createToolWindowActions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

