/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search;

import com.alibabacloud.intellij.cosy.common.CosySetting;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.CodeDocOverviewDetail;
import com.alibabacloud.intellij.cosy.search.enums.SearchActionTypeEnum;
import com.alibabacloud.intellij.cosy.search.result.SearchContext;
import com.alibabacloud.intellij.cosy.search.ui.WrapTabbedPaneUI;
import com.alibabacloud.intellij.cosy.ui.BaseComponent;
import com.alibabacloud.intellij.cosy.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.cosy.ui.search.SearchResultFilterButton;
import com.alibabacloud.intellij.cosy.ui.search.SwingManager;
import com.alibabacloud.intellij.cosy.ui.search.form.DocumentPanel;
import com.alibabacloud.intellij.cosy.ui.search.topic.AsynchronousSearchNotifier;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.plaf.TabbedPaneUI;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchResultPanel
implements BaseComponent {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchResultPanel.class);
    private JPanel basePanel;
    private boolean isSearchCode;
    private boolean isSearchQA;
    private JScrollPane codeScrollPanel;
    private JPanel resultPane;
    private JTabbedPane contentTabPane;
    private JPanel qaPanel;
    private JScrollPane qaScrollPane;
    private JPanel codeDocResultPanel;
    private JPanel codeSnippetResultPanel;
    private JPanel codeSnippetPanel;
    private JLabel snippetCntLabel;
    private JPanel documentPane;
    private JLabel docCntLabel;
    private SearchResultFilterButton snippetResultFilterButton;
    private SearchResultFilterButton docResultFilterButton;
    private Project project;
    private MessageBusConnection messageBusConnection;
    private List<CodeDocOverviewDetail> codeDocOverviewDetailList;
    public static List<String> defaultSnippetSources;
    public static List<String> defaultDocSources;

    public JPanel getBasePanel() {
        return this.basePanel;
    }

    public SearchResultPanel(Project project) {
        this.project = project;
        this.$$$setupUI$$$();
        this.contentTabPane.setUI((TabbedPaneUI)((Object)new WrapTabbedPaneUI()));
        SwingManager.INSTANCE.registerComponent(project, "RESULT_BASE_PANEL_KEY", this.basePanel);
        this.isSearchQA = false;
        this.isSearchCode = false;
        this.contentTabPane.addChangeListener(e -> {
            JTabbedPane tabbedPane = (JTabbedPane)e.getSource();
            int selectedIndex = tabbedPane.getSelectedIndex();
            SearchContext context = new SearchContext(null, SearchActionTypeEnum.CHANGE_TAB_TRIGGER.getType());
            if (!this.isSearchCode && selectedIndex == 0 || !this.isSearchQA && selectedIndex == 1) {
                ((AsynchronousSearchNotifier)project.getMessageBus().syncPublisher(AsynchronousSearchNotifier.ASYNCHRONOUS_SEARCH_NOTIFICATION)).asynchronousSearch(context, selectedIndex);
            }
        });
        this.messageBusConnection = project.getMessageBus().connect();
        this.codeScrollPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.codeScrollPanel.getVerticalScrollBar().setUnitIncrement(30);
        this.codeScrollPanel.setVerticalScrollBarPolicy(22);
        this.qaScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.qaScrollPane.getVerticalScrollBar().setUnitIncrement(30);
        this.qaScrollPane.setHorizontalScrollBarPolicy(31);
        this.qaScrollPane.setVerticalScrollBarPolicy(22);
    }

    @Override
    public int getPreferredWidth() {
        return 0;
    }

    @Override
    public int getPreferredHeight() {
        return 0;
    }

    @Override
    public Component getComponent() {
        return this.basePanel;
    }

    private void createUIComponents() {
        this.codeScrollPanel = new JBScrollPane(10);
        this.qaScrollPane = new JBScrollPane(10);
        CosySetting setting = CosyPersistentSetting.getInstance().getState();
        this.documentPane = new DocumentPanel(this);
        this.codeSnippetPanel = new DocumentPanel(this);
        this.snippetResultFilterButton = new SearchResultFilterButton(this.project, 0);
        this.docResultFilterButton = new SearchResultFilterButton(this.project, 1);
    }

    @Generated
    public void setBasePanel(JPanel basePanel) {
        this.basePanel = basePanel;
    }

    @Generated
    public void setSearchCode(boolean isSearchCode) {
        this.isSearchCode = isSearchCode;
    }

    @Generated
    public void setSearchQA(boolean isSearchQA) {
        this.isSearchQA = isSearchQA;
    }

    @Generated
    public void setCodeScrollPanel(JScrollPane codeScrollPanel) {
        this.codeScrollPanel = codeScrollPanel;
    }

    @Generated
    public void setResultPane(JPanel resultPane) {
        this.resultPane = resultPane;
    }

    @Generated
    public void setContentTabPane(JTabbedPane contentTabPane) {
        this.contentTabPane = contentTabPane;
    }

    @Generated
    public void setQaPanel(JPanel qaPanel) {
        this.qaPanel = qaPanel;
    }

    @Generated
    public void setQaScrollPane(JScrollPane qaScrollPane) {
        this.qaScrollPane = qaScrollPane;
    }

    @Generated
    public void setCodeDocResultPanel(JPanel codeDocResultPanel) {
        this.codeDocResultPanel = codeDocResultPanel;
    }

    @Generated
    public void setCodeSnippetResultPanel(JPanel codeSnippetResultPanel) {
        this.codeSnippetResultPanel = codeSnippetResultPanel;
    }

    @Generated
    public void setCodeSnippetPanel(JPanel codeSnippetPanel) {
        this.codeSnippetPanel = codeSnippetPanel;
    }

    @Generated
    public void setSnippetCntLabel(JLabel snippetCntLabel) {
        this.snippetCntLabel = snippetCntLabel;
    }

    @Generated
    public void setDocumentPane(JPanel documentPane) {
        this.documentPane = documentPane;
    }

    @Generated
    public void setDocCntLabel(JLabel docCntLabel) {
        this.docCntLabel = docCntLabel;
    }

    @Generated
    public void setSnippetResultFilterButton(SearchResultFilterButton snippetResultFilterButton) {
        this.snippetResultFilterButton = snippetResultFilterButton;
    }

    @Generated
    public void setDocResultFilterButton(SearchResultFilterButton docResultFilterButton) {
        this.docResultFilterButton = docResultFilterButton;
    }

    @Generated
    public void setProject(Project project) {
        this.project = project;
    }

    @Generated
    public void setMessageBusConnection(MessageBusConnection messageBusConnection) {
        this.messageBusConnection = messageBusConnection;
    }

    @Generated
    public void setCodeDocOverviewDetailList(List<CodeDocOverviewDetail> codeDocOverviewDetailList) {
        this.codeDocOverviewDetailList = codeDocOverviewDetailList;
    }

    @Generated
    public boolean isSearchCode() {
        return this.isSearchCode;
    }

    @Generated
    public boolean isSearchQA() {
        return this.isSearchQA;
    }

    @Generated
    public JScrollPane getCodeScrollPanel() {
        return this.codeScrollPanel;
    }

    @Generated
    public JPanel getResultPane() {
        return this.resultPane;
    }

    @Generated
    public JTabbedPane getContentTabPane() {
        return this.contentTabPane;
    }

    @Generated
    public JPanel getQaPanel() {
        return this.qaPanel;
    }

    @Generated
    public JScrollPane getQaScrollPane() {
        return this.qaScrollPane;
    }

    @Generated
    public JPanel getCodeDocResultPanel() {
        return this.codeDocResultPanel;
    }

    @Generated
    public JPanel getCodeSnippetResultPanel() {
        return this.codeSnippetResultPanel;
    }

    @Generated
    public JPanel getCodeSnippetPanel() {
        return this.codeSnippetPanel;
    }

    @Generated
    public JLabel getSnippetCntLabel() {
        return this.snippetCntLabel;
    }

    @Generated
    public JPanel getDocumentPane() {
        return this.documentPane;
    }

    @Generated
    public JLabel getDocCntLabel() {
        return this.docCntLabel;
    }

    @Generated
    public SearchResultFilterButton getSnippetResultFilterButton() {
        return this.snippetResultFilterButton;
    }

    @Generated
    public SearchResultFilterButton getDocResultFilterButton() {
        return this.docResultFilterButton;
    }

    @Generated
    public Project getProject() {
        return this.project;
    }

    @Generated
    public MessageBusConnection getMessageBusConnection() {
        return this.messageBusConnection;
    }

    @Generated
    public List<CodeDocOverviewDetail> getCodeDocOverviewDetailList() {
        return this.codeDocOverviewDetailList;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JPanel jPanel;
        JPanel jPanel2;
        JLabel jLabel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JTabbedPane jTabbedPane;
        JPanel jPanel5;
        this.createUIComponents();
        this.basePanel = jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        this.contentTabPane = jTabbedPane = new JTabbedPane();
        jTabbedPane.setTabPlacement(1);
        jPanel5.add((Component)jTabbedPane, "Center");
        this.resultPane = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jTabbedPane.addTab(ResourceBundle.getBundle("messageBundle").getString("code.pane.name"), null, jPanel4, null);
        JScrollPane jScrollPane = this.codeScrollPanel;
        jPanel4.add((Component)jScrollPane, "Center");
        this.codeSnippetResultPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jScrollPane.setViewportView(jPanel3);
        JPanel jPanel6 = this.codeSnippetPanel;
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel6, "Center");
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel7, "North");
        this.snippetCntLabel = jLabel2 = new JLabel();
        jLabel2.setText(" ");
        jPanel7.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        SearchResultFilterButton searchResultFilterButton = this.snippetResultFilterButton;
        jPanel7.add((Component)searchResultFilterButton, new GridConstraints(0, 1, 1, 1, 4, 0, 3, 3, null, null, null));
        this.qaPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jTabbedPane.addTab(ResourceBundle.getBundle("messageBundle").getString("Q&A.pane.name"), null, jPanel2, null);
        JScrollPane jScrollPane2 = this.qaScrollPane;
        jPanel2.add((Component)jScrollPane2, "Center");
        this.codeDocResultPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jScrollPane2.setViewportView(jPanel);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel8, "North");
        this.docCntLabel = jLabel = new JLabel();
        jLabel.setText("");
        jPanel8.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        SearchResultFilterButton searchResultFilterButton2 = this.docResultFilterButton;
        jPanel8.add((Component)searchResultFilterButton2, new GridConstraints(0, 1, 1, 1, 4, 0, 3, 3, null, null, null));
        JPanel jPanel9 = this.documentPane;
        jPanel.add((Component)jPanel9, "Center");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.basePanel;
    }
}

