/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search;

import com.alibaba.fastjson.JSON;
import com.alibabacloud.intellij.cosy.search.enums.SearchActionTypeEnum;
import com.alibabacloud.intellij.cosy.search.result.SearchContext;
import com.alibabacloud.intellij.cosy.shared.cache.CacheManager;
import com.alibabacloud.intellij.cosy.ui.search.I18NConstant;
import com.alibabacloud.intellij.cosy.ui.search.SearchResultPanel;
import com.alibabacloud.intellij.cosy.ui.search.enums.OperationEnum;
import com.alibabacloud.intellij.cosy.ui.search.model.Source;
import com.alibabacloud.intellij.cosy.ui.search.model.SourceList;
import com.alibabacloud.intellij.cosy.ui.search.topic.FilterSelectionNotifier;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.border.Border;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchResultFilterButton
extends JButton {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchResultFilterButton.class);
    private Project project;
    private JPopupMenu sourceFilterPopupMenu;
    private List<String> sourceFilters;
    private Integer buttonIndex;
    private boolean popupShown;
    private static final String LOCAL_SOURCE_CONFIG_FILE_PATH = "/search/CosySources.json";
    private static final String REMOTE_SOURCE_CONFIG_URL_PATH = "https://codeup-algo.oss-cn-hangzhou.aliyuncs.com/biz/cosy-search/CosySources.json";

    public SearchResultFilterButton(Project project, Integer buttonIndex) {
        this.project = project;
        this.buttonIndex = buttonIndex;
        this.resetSourceFilterPopupMenu();
        this.setText(I18NConstant.SOURCE_FILTER_BUTTON_TEXT);
        this.addActionListener(e -> {
            if (this.popupShown) {
                this.sourceFilterPopupMenu.setVisible(false);
                this.popupShown = false;
            } else {
                this.sourceFilterPopupMenu.show(this, this.getWidth() - this.sourceFilterPopupMenu.getPreferredSize().width, this.getY() + this.getHeight());
                this.popupShown = true;
            }
        });
    }

    public void resetSourceFilterPopupMenu() {
        PopupActionListener actionListener = new PopupActionListener();
        this.sourceFilterPopupMenu = new SourceFilterPopupMenu("Source Filter");
        try {
            SourceList sources = this.initSourceConfig();
            if (sources == null || sources.getSnippetSources() == null || sources.getDocSources() == null) {
                log.error("Failed to reset source menu.");
                return;
            }
            Locale locale = Locale.getDefault();
            List<Source> sourceList = this.buttonIndex == 0 ? sources.getSnippetSources() : sources.getDocSources();
            ArrayList<String> sourceIndexes = new ArrayList<String>();
            for (Source source : sourceList) {
                String label = Locale.CHINESE.getDisplayLanguage().equals(locale.getDisplayLanguage()) ? source.getSourceCn() : source.getSourceEn();
                JCheckBoxMenuItem item = new JCheckBoxMenuItem(label, true);
                item.setName(source.getSourceIdx());
                this.sourceFilterPopupMenu.add(this.customizeCheckBoxMenuItem(item, actionListener));
                sourceIndexes.add(source.getSourceIdx());
            }
            if (this.buttonIndex == 0) {
                SearchResultPanel.defaultSnippetSources = sourceIndexes;
            } else {
                SearchResultPanel.defaultDocSources = sourceIndexes;
            }
            this.sourceFilters = sourceIndexes;
        }
        catch (Exception e) {
            log.error("Failed to setup source filter menu, because: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public SourceList initSourceConfig() throws IOException {
        String sourceJson;
        Optional optionalSourceMenuConfig = CacheManager.getCosySourceMenuConfigCache().get("SOURCE_MENU_CONFIG_CACHE");
        if (optionalSourceMenuConfig.isEmpty()) {
            try {
                URL url = new URL(REMOTE_SOURCE_CONFIG_URL_PATH);
                InputStream is = url.openStream();
                sourceJson = new String(is.readAllBytes(), StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                log.warn("Failed to load cosy sources config online, use local sources config..");
                InputStream is = SearchResultFilterButton.class.getResourceAsStream(LOCAL_SOURCE_CONFIG_FILE_PATH);
                if (is == null) {
                    log.error("Failed to load local sources config.");
                    return null;
                }
                sourceJson = new String(is.readAllBytes(), StandardCharsets.UTF_8);
            }
            CacheManager.getCosySourceMenuConfigCache().set(sourceJson);
        } else {
            sourceJson = (String)optionalSourceMenuConfig.get();
        }
        return (SourceList)JSON.parseObject((String)sourceJson, SourceList.class);
    }

    private JCheckBoxMenuItem customizeCheckBoxMenuItem(JCheckBoxMenuItem item, ActionListener actionListener) {
        item.addActionListener(actionListener);
        item.putClientProperty("CheckBoxMenuItem.doNotCloseOnMouseClick", Boolean.TRUE);
        item.setBorder((Border)JBUI.Borders.empty((int)2, (int)5));
        return item;
    }

    @Generated
    public Project getProject() {
        return this.project;
    }

    @Generated
    public JPopupMenu getSourceFilterPopupMenu() {
        return this.sourceFilterPopupMenu;
    }

    @Generated
    public List<String> getSourceFilters() {
        return this.sourceFilters;
    }

    @Generated
    public Integer getButtonIndex() {
        return this.buttonIndex;
    }

    @Generated
    public boolean isPopupShown() {
        return this.popupShown;
    }

    @Generated
    public void setProject(Project project) {
        this.project = project;
    }

    @Generated
    public void setSourceFilterPopupMenu(JPopupMenu sourceFilterPopupMenu) {
        this.sourceFilterPopupMenu = sourceFilterPopupMenu;
    }

    @Generated
    public void setSourceFilters(List<String> sourceFilters) {
        this.sourceFilters = sourceFilters;
    }

    @Generated
    public void setButtonIndex(Integer buttonIndex) {
        this.buttonIndex = buttonIndex;
    }

    @Generated
    public void setPopupShown(boolean popupShown) {
        this.popupShown = popupShown;
    }

    static class SourceFilterPopupMenu
    extends JPopupMenu {
        public SourceFilterPopupMenu(String title) {
            super(title);
        }
    }

    class PopupActionListener
    implements ActionListener {
        PopupActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SearchResultFilterButton.this.sourceFilterPopupMenu.show(SearchResultFilterButton.this, SearchResultFilterButton.this.getWidth() - SearchResultFilterButton.this.sourceFilterPopupMenu.getPreferredSize().width, SearchResultFilterButton.this.getY() + SearchResultFilterButton.this.getHeight());
            MenuElement[] path = MenuSelectionManager.defaultManager().getSelectedPath();
            if (path.length == 0) {
                log.info("No menus are opened or menu items selected");
            }
            for (MenuElement menuElement : path) {
                Component c = menuElement.getComponent();
                if (!(c instanceof SourceFilterPopupMenu)) continue;
                SourceFilterPopupMenu menu = (SourceFilterPopupMenu)c;
                Component[] components = menu.getComponents();
                ArrayList<String> selectedSources = new ArrayList<String>();
                for (Component component : components) {
                    if (!(component instanceof JCheckBoxMenuItem)) continue;
                    JCheckBoxMenuItem item = (JCheckBoxMenuItem)component;
                    if (SearchResultFilterButton.this.sourceFilters.size() == 1 && item.getText().equals(actionEvent.getActionCommand()) && !item.getState()) {
                        item.setState(true);
                        return;
                    }
                    if (!item.getState()) continue;
                    selectedSources.add(item.getName());
                }
                SearchResultFilterButton.this.sourceFilters = selectedSources;
                SearchContext context = new SearchContext(OperationEnum.FILTER.text, SearchActionTypeEnum.SOURCE_FILTER_TRIGGER.getType());
                if (SearchResultFilterButton.this.buttonIndex == 0) {
                    context.setSnippetSources(SearchResultFilterButton.this.sourceFilters);
                } else {
                    context.setDocSources(SearchResultFilterButton.this.sourceFilters);
                }
                ((FilterSelectionNotifier)SearchResultFilterButton.this.getProject().getMessageBus().syncPublisher(FilterSelectionNotifier.FILTER_SELECTION_NOTIFICATION)).selectFilter(context);
            }
        }
    }
}

