/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.search;

import com.alibabacloud.intellij.cosy.common.BuildFeature;
import com.alibabacloud.intellij.cosy.common.CosyCacheKeys;
import com.alibabacloud.intellij.cosy.common.CosyConfig;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStateEnum;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.ChatSession;
import com.alibabacloud.intellij.cosy.service.UserAuthService;
import com.alibabacloud.intellij.cosy.ui.search.SearchMainPanel;
import com.alibabacloud.intellij.cosy.ui.search.component.AvatarLabel;
import com.alibabacloud.intellij.cosy.ui.search.component.DisplayIcon;
import com.alibabacloud.intellij.cosy.ui.search.component.FixedHeightLabel;
import com.alibabacloud.intellij.cosy.ui.search.component.TabLabel;
import com.alibabacloud.intellij.cosy.ui.search.generate.ChatHistoryPanel;
import com.alibabacloud.intellij.cosy.ui.search.generate.GenerateContentForm;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.ui.search.topic.AuthLoginNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.AuthLogoutNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.AuthStateChangeNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.LingmaSessionRecoverNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.LingmaTabChangeNotifier;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.LoginUtil;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import icons.CommonIcons;
import icons.LingmaIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class LingmaToolWindowPanel {
    private static final int MIN_TOOLWINDOW_WIDTH = 470;
    private static final int LOGOUT_POPUP_LABEL_FIX_WIDTH = 122;
    private static final int TAB_DEFAULT_MARGIN = 32;
    private static final int TAB_MIN_MAX_MARGIN = 8;
    public static final String CHAT_TAB = "chat";
    public static final String SEARCH_TAB = "search";
    private static final int HEADER_HEIGHT = 40;
    private JPanel mainPanel;
    private JPanel headerPanel;
    private JPanel contentPanel;
    private JPanel tabPanel;
    private JPanel infoPanel;
    private JPanel headerContentPanel;
    private SearchMainPanel searchMainPanel;
    private GenerateContentForm generateContentForm;
    private ChatHistoryPanel chatHistoryPanel;
    JLabel chatTabBtn;
    JLabel searchTabBtn;
    JLabel createNewChatBtn;
    JLabel chatHistoryBtn;
    JPanel userInfoPanel;
    AvatarLabel userAvatarLabel;
    JLabel popupIconLabel;
    JLabel loginBtn;
    Box loggedBox;
    JBPopup userInfoPopup;
    JPanel popupPanel;
    private Box.Filler tabMarginFilter;
    private Project project;
    private MessageBusConnection messageBusConnection;

    public LingmaToolWindowPanel(@NotNull Project project) {
        if (project == null) {
            LingmaToolWindowPanel.$$$reportNull$$$0(0);
        }
        this.project = project;
        this.$$$setupUI$$$();
        this.headerPanel.setBorder(JBUI.Borders.customLine((Color)ColorUtil.getEditorBackgroundColor(), (int)0, (int)0, (int)1, (int)0));
        this.headerContentPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)12));
    }

    public void delayInit() {
        this.setupTabPanel(this.project);
        this.setupToolbar();
        this.setupPanelResizable();
        this.messageBusConnection = this.project.getMessageBus().connect();
        this.messageBusConnection.subscribe(AuthLoginNotifier.AUTH_LOGIN_NOTIFICATION, this::notifyLoginAuth);
        this.messageBusConnection.subscribe(AuthStateChangeNotifier.AUTH_CHANGE_NOTIFICATION, this::notifyChangeAuth);
        this.messageBusConnection.subscribe(AuthLogoutNotifier.AUTH_LOGOUT_NOTIFICATION, this::notifyLogoutAuth);
        this.messageBusConnection.subscribe(LingmaTabChangeNotifier.CHANGE_MAIN_TAB_NOTIFICATION, this::changeTab);
        this.messageBusConnection.subscribe(LingmaSessionRecoverNotifier.SESSION_RECOVER_NOTIFICATION, this::recoverSession);
    }

    private void setupTabPanel(@NotNull Project project) {
        if (project == null) {
            LingmaToolWindowPanel.$$$reportNull$$$0(1);
        }
        if (CosyConfig.IDE_NAME.contains("IDEA")) {
            this.searchMainPanel = new SearchMainPanel(project);
        }
        this.generateContentForm = new GenerateContentForm(project, "", this.contentPanel);
        this.chatHistoryPanel = new ChatHistoryPanel(project);
        Box container = Box.createHorizontalBox();
        this.chatTabBtn = new TabLabel(CosyBundle.message("toolwindow.main.tab.title.chat", new Object[0]), 40);
        this.setupTabColor(this.chatTabBtn);
        container.add(this.chatTabBtn);
        this.tabMarginFilter = new Box.Filler(new Dimension(32, 0), new Dimension(32, 0), new Dimension(32, Short.MAX_VALUE));
        container.add(this.tabMarginFilter);
        this.searchTabBtn = new TabLabel(CosyBundle.message("toolwindow.main.tab.title.search", new Object[0]), 40);
        this.setupTabColor(this.searchTabBtn);
        container.add(this.searchTabBtn);
        this.tabPanel.add((Component)container, "Center");
        this.showChatPanel();
        this.searchTabBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LingmaToolWindowPanel.this.showSearchPanel();
            }
        });
        this.chatTabBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LingmaToolWindowPanel.this.showChatPanel();
            }
        });
        if (!CosyConfig.IDE_NAME.contains("IDEA") || CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false)) {
            this.searchTabBtn.setVisible(false);
        }
    }

    public void showChatPanel() {
        ((TabLabel)this.chatTabBtn).setExternBorder(JBUI.Borders.customLine((Color)ColorUtil.getTabbedUnderlineColor(), (int)0, (int)0, (int)2, (int)0));
        ((TabLabel)this.searchTabBtn).setExternBorder((Border)JBUI.Borders.emptyBottom((int)2));
        if (this.searchMainPanel != null) {
            this.contentPanel.remove(this.searchMainPanel.getContent());
        }
        this.contentPanel.remove(this.chatHistoryPanel);
        this.contentPanel.add((Component)this.generateContentForm.getBasePanel(), "Center");
        this.contentPanel.invalidate();
        this.contentPanel.validate();
        this.contentPanel.repaint();
    }

    private void recoverSession(ChatSession chatSession) {
        this.generateContentForm.recoverSession(chatSession);
        this.showChatPanel();
    }

    public void showSearchPanel() {
        if (this.searchMainPanel != null) {
            ((TabLabel)this.searchTabBtn).setExternBorder(JBUI.Borders.customLine((Color)ColorUtil.getTabbedUnderlineColor(), (int)0, (int)0, (int)2, (int)0));
            ((TabLabel)this.chatTabBtn).setExternBorder((Border)JBUI.Borders.emptyBottom((int)2));
            this.contentPanel.remove(this.chatHistoryPanel);
            this.contentPanel.remove(this.generateContentForm.getBasePanel());
            this.contentPanel.add((Component)this.searchMainPanel.getContent(), "Center");
            this.contentPanel.invalidate();
            this.contentPanel.validate();
            this.contentPanel.repaint();
        }
    }

    private void setupToolbar() {
        this.setupNotLoggedInToolbar();
        this.setupLoggedInToolbar();
        this.changeLoginState(null);
    }

    private void changeLoginState(AuthStatus status) {
        if (status == null) {
            status = LoginUtil.getAuthStatus(this.project);
        } else {
            CosyCacheKeys.KEY_AUTH_STATUS.set((UserDataHolder)ApplicationManager.getApplication(), (Object)status);
        }
        if (status.getStatus() != null && AuthStateEnum.LOGIN.getValue() == status.getStatus().intValue()) {
            this.infoPanel.removeAll();
            this.infoPanel.add((Component)this.loggedBox, "Center");
            this.updateUserInfo(status);
        } else {
            this.infoPanel.removeAll();
            this.infoPanel.add((Component)this.loginBtn, "Center");
        }
        this.infoPanel.revalidate();
        this.infoPanel.repaint();
    }

    private void setupNotLoggedInToolbar() {
        this.loginBtn = new JLabel(CosyBundle.message("main.toolbar.btn.login", new Object[0]));
        this.loginBtn.setCursor(Cursor.getPredefinedCursor(12));
        this.loginBtn.setFont(this.loginBtn.getFont().deriveFont(14.0f));
        this.loginBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                UserAuthService.getInstance().login(LingmaToolWindowPanel.this.project, LingmaToolWindowPanel.this.loginBtn);
            }
        });
    }

    private void setupLoggedInToolbar() {
        this.buildUserInfoPopupPanel();
        this.loggedBox = Box.createHorizontalBox();
        this.createNewChatBtn = new DisplayIcon(LingmaIcons.NewIcon);
        this.createNewChatBtn.setToolTipText(CosyBundle.message("main.toolbar.btn.new.chat", new Object[0]));
        this.createNewChatBtn.setCursor(Cursor.getPredefinedCursor(12));
        this.createNewChatBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LingmaToolWindowPanel.this.showChatPanel();
                LingmaToolWindowPanel.this.generateContentForm.initFlowPanel();
            }
        });
        this.chatHistoryBtn = new DisplayIcon(LingmaIcons.HistoryIcon);
        this.chatHistoryBtn.setToolTipText(CosyBundle.message("main.toolbar.btn.chat.history", new Object[0]));
        this.chatHistoryBtn.setCursor(Cursor.getPredefinedCursor(12));
        this.chatHistoryBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ((TabLabel)LingmaToolWindowPanel.this.chatTabBtn).setExternBorder((Border)JBUI.Borders.emptyBottom((int)2));
                ((TabLabel)LingmaToolWindowPanel.this.searchTabBtn).setExternBorder((Border)JBUI.Borders.emptyBottom((int)2));
                LingmaToolWindowPanel.this.contentPanel.removeAll();
                LingmaToolWindowPanel.this.contentPanel.add((Component)LingmaToolWindowPanel.this.chatHistoryPanel, "Center");
                LingmaToolWindowPanel.this.chatHistoryPanel.fetchHistories();
                LingmaToolWindowPanel.this.contentPanel.revalidate();
                LingmaToolWindowPanel.this.contentPanel.repaint();
            }
        });
        this.userInfoPanel = new JPanel(new FlowLayout(0, 8, 0));
        this.userInfoPanel.setOpaque(false);
        this.userAvatarLabel = new AvatarLabel(null, 20);
        this.userAvatarLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.popupIconLabel = new FixedHeightLabel(LingmaIcons.ArrowdownIcon, 40);
        this.userInfoPanel.add(this.userAvatarLabel);
        this.userInfoPanel.add(this.popupIconLabel);
        this.addUserInfoPopupEvent(this.userAvatarLabel);
        this.addUserInfoPopupEvent(this.popupIconLabel);
        this.userInfoPanel.setCursor(Cursor.getPredefinedCursor(12));
        JLabel sepLabel = new JLabel(" ");
        sepLabel.setBorder(JBUI.Borders.customLine((Color)ColorUtil.getEditorBackgroundColor(), (int)0, (int)0, (int)0, (int)1));
        this.loggedBox.add(this.createNewChatBtn);
        this.loggedBox.add(Box.createHorizontalStrut(12));
        this.loggedBox.add(this.chatHistoryBtn);
        this.loggedBox.add(Box.createHorizontalStrut(12));
        this.loggedBox.add(sepLabel);
        this.loggedBox.add(Box.createHorizontalStrut(12));
        this.loggedBox.add(this.userInfoPanel);
    }

    private void addUserInfoPopupEvent(JComponent component) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (LingmaToolWindowPanel.this.userInfoPopup != null && LingmaToolWindowPanel.this.userInfoPopup.isVisible()) {
                    LingmaToolWindowPanel.this.userInfoPopup.cancel();
                }
                LingmaToolWindowPanel.this.userInfoPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)LingmaToolWindowPanel.this.popupPanel, null).setFocusable(true).setRequestFocus(true).setResizable(false).setCancelOnClickOutside(true).createPopup();
                LingmaToolWindowPanel.this.userInfoPopup.showUnderneathOf((Component)LingmaToolWindowPanel.this.userInfoPanel);
            }
        });
    }

    private void buildUserInfoPopupPanel() {
        this.popupPanel = new JPanel();
        this.popupPanel.setLayout(new BorderLayout());
        this.popupPanel.setBorder(JBUI.Borders.empty((int)8));
        final JLabel logoutPopupLabel = new JLabel(CosyBundle.message("settings.login.panel.btn.logout", new Object[0]), CommonIcons.logoutIcon, 10){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.width = 122;
                return size;
            }
        };
        logoutPopupLabel.setFont(logoutPopupLabel.getFont().deriveFont(14.0f));
        logoutPopupLabel.setBorder(JBUI.Borders.empty((int)2));
        logoutPopupLabel.setCursor(Cursor.getPredefinedCursor(12));
        logoutPopupLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (LingmaToolWindowPanel.this.userInfoPopup != null && LingmaToolWindowPanel.this.userInfoPopup.isVisible()) {
                    LingmaToolWindowPanel.this.userInfoPopup.cancel();
                }
                ActionManager actionManager = ActionManager.getInstance();
                AnAction action = actionManager.getAction("CosyAuthLogoutAction");
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)LingmaToolWindowPanel.this.mainPanel);
                DataContext simpleCtx = SimpleDataContext.getSimpleContext((String)CommonDataKeys.PROJECT.getName(), (Object)LingmaToolWindowPanel.this.project, (DataContext)dataContext);
                ActionUtil.invokeAction((AnAction)action, (DataContext)simpleCtx, (String)"popup", null, null);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                logoutPopupLabel.setOpaque(true);
                logoutPopupLabel.setBackground(ColorUtil.getPopupMenuSelectionBackground());
                logoutPopupLabel.invalidate();
                logoutPopupLabel.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                logoutPopupLabel.setOpaque(false);
                logoutPopupLabel.setBackground(ColorUtil.getToolWindowBackgroundColor());
                logoutPopupLabel.invalidate();
                logoutPopupLabel.repaint();
            }
        });
        this.popupPanel.add((Component)logoutPopupLabel, "Center");
    }

    private void updateUserInfo(AuthStatus status) {
        this.userAvatarLabel.setStatus(status);
        this.userAvatarLabel.revalidate();
        this.userAvatarLabel.repaint();
    }

    private void setupTabColor(final JLabel label) {
        label.setBackground(ColorUtil.getTabbedBgColor());
        label.setBorder((Border)JBUI.Borders.empty((int)0, (int)12));
        label.setCursor(Cursor.getPredefinedCursor(12));
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                label.setOpaque(true);
                label.setBackground(ColorUtil.getTabbedHoverBgColor());
                label.invalidate();
                label.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                label.setOpaque(false);
                label.setBackground(ColorUtil.getTabbedBgColor());
                label.invalidate();
                label.repaint();
            }
        });
    }

    private void notifyLoginAuth(AuthStatus status) {
        this.changeLoginState(status);
    }

    private void notifyChangeAuth(AuthStatus status) {
        this.changeLoginState(status);
    }

    private void notifyLogoutAuth(AuthStatus status) {
        this.changeLoginState(status);
    }

    private void changeTab(String tabName) {
        if (CHAT_TAB.equals(tabName)) {
            this.showChatPanel();
        } else if (SEARCH_TAB.equals(tabName)) {
            this.showSearchPanel();
        }
    }

    private void setupPanelResizable() {
        this.mainPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                LingmaToolWindowPanel.this.checkMainPanelSize(e.getComponent());
            }
        });
        this.checkMainPanelSize(this.mainPanel);
    }

    private void checkMainPanelSize(Component component) {
        if (component != null && component.getSize().width < 470) {
            this.userAvatarLabel.setHideName(true);
        } else {
            this.userAvatarLabel.setHideName(false);
        }
        if (component != null && component.getSize().width < 350) {
            this.tabMarginFilter.setPreferredSize(new Dimension(8, this.tabMarginFilter.getHeight()));
        } else {
            this.tabMarginFilter.setPreferredSize(new Dimension(32, this.tabMarginFilter.getHeight()));
        }
        this.tabMarginFilter.revalidate();
        this.tabPanel.revalidate();
        this.tabPanel.repaint();
        this.userInfoPanel.revalidate();
        this.userInfoPanel.repaint();
    }

    @Generated
    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    @Generated
    public JPanel getHeaderPanel() {
        return this.headerPanel;
    }

    @Generated
    public JPanel getContentPanel() {
        return this.contentPanel;
    }

    @Generated
    public JPanel getTabPanel() {
        return this.tabPanel;
    }

    @Generated
    public JPanel getInfoPanel() {
        return this.infoPanel;
    }

    @Generated
    public JPanel getHeaderContentPanel() {
        return this.headerContentPanel;
    }

    @Generated
    public SearchMainPanel getSearchMainPanel() {
        return this.searchMainPanel;
    }

    @Generated
    public GenerateContentForm getGenerateContentForm() {
        return this.generateContentForm;
    }

    @Generated
    public ChatHistoryPanel getChatHistoryPanel() {
        return this.chatHistoryPanel;
    }

    @Generated
    public JLabel getChatTabBtn() {
        return this.chatTabBtn;
    }

    @Generated
    public JLabel getSearchTabBtn() {
        return this.searchTabBtn;
    }

    @Generated
    public JLabel getCreateNewChatBtn() {
        return this.createNewChatBtn;
    }

    @Generated
    public JLabel getChatHistoryBtn() {
        return this.chatHistoryBtn;
    }

    @Generated
    public JPanel getUserInfoPanel() {
        return this.userInfoPanel;
    }

    @Generated
    public AvatarLabel getUserAvatarLabel() {
        return this.userAvatarLabel;
    }

    @Generated
    public JLabel getPopupIconLabel() {
        return this.popupIconLabel;
    }

    @Generated
    public JLabel getLoginBtn() {
        return this.loginBtn;
    }

    @Generated
    public Box getLoggedBox() {
        return this.loggedBox;
    }

    @Generated
    public JBPopup getUserInfoPopup() {
        return this.userInfoPopup;
    }

    @Generated
    public JPanel getPopupPanel() {
        return this.popupPanel;
    }

    @Generated
    public Box.Filler getTabMarginFilter() {
        return this.tabMarginFilter;
    }

    @Generated
    public Project getProject() {
        return this.project;
    }

    @Generated
    public MessageBusConnection getMessageBusConnection() {
        return this.messageBusConnection;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        JPanel jPanel6;
        this.mainPanel = jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(0, 0));
        this.headerPanel = jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        jPanel6.add((Component)jPanel5, "North");
        this.headerContentPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel4, "Center");
        this.tabPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel3, "West");
        this.infoPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel2, "East");
        this.contentPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel6.add((Component)jPanel, "Center");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/alibabacloud/intellij/cosy/ui/search/LingmaToolWindowPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setupTabPanel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class LoginPopupItem {
        private String label;
        private Icon icon;
        private String type;
        private String actionId;

        @Generated
        public String getLabel() {
            return this.label;
        }

        @Generated
        public Icon getIcon() {
            return this.icon;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getActionId() {
            return this.actionId;
        }

        @Generated
        public void setLabel(String label) {
            this.label = label;
        }

        @Generated
        public void setIcon(Icon icon) {
            this.icon = icon;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LoginPopupItem)) {
                return false;
            }
            LoginPopupItem other = (LoginPopupItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$label = this.getLabel();
            String other$label = other.getLabel();
            if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
                return false;
            }
            Icon this$icon = this.getIcon();
            Icon other$icon = other.getIcon();
            if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$actionId = this.getActionId();
            String other$actionId = other.getActionId();
            return !(this$actionId == null ? other$actionId != null : !this$actionId.equals(other$actionId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LoginPopupItem;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $label = this.getLabel();
            result = result * 59 + ($label == null ? 43 : $label.hashCode());
            Icon $icon = this.getIcon();
            result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $actionId = this.getActionId();
            result = result * 59 + ($actionId == null ? 43 : $actionId.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LingmaToolWindowPanel.LoginPopupItem(label=" + this.getLabel() + ", icon=" + this.getIcon() + ", type=" + this.getType() + ", actionId=" + this.getActionId() + ")";
        }

        @Generated
        public LoginPopupItem(String label, Icon icon, String type, String actionId) {
            this.label = label;
            this.icon = icon;
            this.type = type;
            this.actionId = actionId;
        }

        @Generated
        public LoginPopupItem() {
        }
    }
}

