/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.notifications;

import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.util.FileUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.io.File;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nullable;

public class PrivacyPolicyDialog
extends DialogWrapper {
    File privacyPolicyFile;
    Consumer<File> doHandler;

    public PrivacyPolicyDialog(File privacyPolicyFile, Consumer<File> doHandler) {
        super(true);
        this.privacyPolicyFile = privacyPolicyFile;
        this.doHandler = doHandler;
        this.init();
        this.setTitle(CosyBundle.message("notifications.auth.agreement.title", new Object[0]));
        this.setOKButtonText(CosyBundle.message("notifications.auth.agreement.button.agree", new Object[0]));
        this.setCancelButtonText(CosyBundle.message("notifications.auth.agreement.button.cancel", new Object[0]));
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel dialogPanel = new JPanel(new BorderLayout());
        JTextPane textPane = new JTextPane();
        textPane.setFont((Font)JBUI.Fonts.label());
        textPane.setOpaque(false);
        textPane.setEditable(false);
        textPane.setContentType("text/html;charset=UTF-8");
        textPane.setText(CosyBundle.message("notifications.auth.agreement.content", new Object[0]));
        dialogPanel.add((Component)textPane, "Center");
        textPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String command = e.getDescription();
                    BrowserUtil.browse((String)command);
                }
            }
        });
        return dialogPanel;
    }

    protected void doOKAction() {
        try {
            if (!this.privacyPolicyFile.getParentFile().exists()) {
                this.privacyPolicyFile.getParentFile().mkdirs();
            }
            FileUtil.createPrivacyPolicyFile(this.privacyPolicyFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.doOKAction();
        if (this.doHandler != null) {
            this.doHandler.accept(this.privacyPolicyFile);
        }
    }
}

