/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.notifications;

import com.alibabacloud.intellij.cosy.common.CosySetting;
import com.alibabacloud.intellij.cosy.constants.LingmaUrls;
import com.alibabacloud.intellij.cosy.core.Cosy;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStateEnum;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthWhitelistStatusEnum;
import com.alibabacloud.intellij.cosy.service.ConfigService;
import com.alibabacloud.intellij.cosy.service.UserAuthService;
import com.alibabacloud.intellij.cosy.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.cosy.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.cosy.ui.search.I18NConstant;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.util.CosyBrowserUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GrantAuthorNotification {
    static Map<String, Boolean> showNeedLoginMap = new ConcurrentHashMap<String, Boolean>();
    static Map<String, Boolean> showEnableLocalMap = new ConcurrentHashMap<String, Boolean>();

    public static void notifyStartup(@Nullable Project project) {
        Notification notification;
        if (CosyPersistentSetting.getInstance().getState() == null) {
            return;
        }
        if (CosyPersistentSetting.getInstance().getState().isShowCheckReportUsage() && !CosyPersistentSetting.getInstance().getState().isAllowReportUsage() && (notification = NotificationFactory.createInfoStickyNotification(I18NConstant.TRACE_NOTIFY_TITLE, I18NConstant.TRACE_NOTIFY_CONTENT)) != null) {
            notification.addAction((AnAction)new AllowNotificationAction(I18NConstant.TRACE_NOTIFY_AGREE));
            notification.addAction((AnAction)new ForbiddenNotificationAction(I18NConstant.TRACE_NOTIFY_DISAGREE));
            notification.notify(project);
        }
    }

    public static void notifyNeedLoginDirectly(@Nullable Project project) {
        Notification notification = NotificationFactory.createInfoStickyNotification(I18NConstant.LOGIN_MSG_REQUIRE_LOGIN);
        if (notification != null) {
            notification.addAction((AnAction)new GotoLoginNotificationAction(CosyBundle.message("notifications.action.button.login", new Object[0])));
            notification.addAction((AnAction)new DismissLoginNotificationAction(CosyBundle.message("notifications.action.button.dismiss", new Object[0])));
            notification.notify(project);
        }
    }

    public static void notifyNeedWhitelistDirectly(@Nullable Project project, AuthStatus authStatus) {
        Notification notification;
        if (authStatus == null) {
            return;
        }
        String message = String.format(CosyBundle.message("notifications.auth.whitelist.not.apply", new Object[0]), authStatus.getName());
        if (StringUtils.isNotBlank((CharSequence)authStatus.getOrgId())) {
            message = String.format(CosyBundle.message("notifications.auth.org.whitelist.not.apply", new Object[0]), authStatus.getName(), authStatus.getOrgName());
        }
        if ((notification = NotificationFactory.createInfoStickyNotification(I18NConstant.COSY_PLUGIN_NAME, message)) != null) {
            if (StringUtils.isBlank((CharSequence)authStatus.getOrgId())) {
                notification.addAction((AnAction)new GotoUrlNotificationAction(CosyBundle.message("notifications.action.button.learn", new Object[0]), LingmaUrls.EXPR_APPLY_URL.getRealUrl()));
            }
            notification.addAction((AnAction)new DismissLoginNotificationAction(CosyBundle.message("notifications.action.button.dismiss", new Object[0])));
            notification.notify(project);
        }
    }

    public static void notifyNetworkErrorDirectly(@Nullable Project project, AuthStatus authStatus) {
        if (authStatus == null) {
            return;
        }
        String message = CosyBundle.message("notifications.auth.network.error", new Object[0]);
        Notification notification = NotificationFactory.createInfoStickyNotification(I18NConstant.COSY_PLUGIN_NAME, message);
        if (notification != null) {
            notification.addAction((AnAction)new GotoUrlNotificationAction(CosyBundle.message("notifications.action.button.learn", new Object[0]), LingmaUrls.NETWORK_ERROR_URL.getRealUrl()));
            notification.addAction((AnAction)new DismissLoginNotificationAction(CosyBundle.message("notifications.action.button.dismiss", new Object[0])));
            notification.notify(project);
        }
    }

    public static void notifyIpBannedErrorDirectly(@Nullable Project project, AuthStatus authStatus) {
        if (authStatus == null) {
            return;
        }
        String message = CosyBundle.message("notifications.auth.ip.whitelist.error", new Object[0]);
        Notification notification = NotificationFactory.createInfoStickyNotification(I18NConstant.COSY_PLUGIN_NAME, message);
        if (notification != null) {
            notification.addAction((AnAction)new DismissLoginNotificationAction(CosyBundle.message("notifications.action.button.dismiss", new Object[0])));
            notification.notify(project);
        }
    }

    public static void notifyAppDisabledErrorDirectly(@Nullable Project project, AuthStatus authStatus) {
        if (authStatus == null) {
            return;
        }
        String message = CosyBundle.message("notifications.auth.app.disabled.error", new Object[0]);
        Notification notification = NotificationFactory.createInfoStickyNotification(I18NConstant.COSY_PLUGIN_NAME, message);
        if (notification != null) {
            notification.addAction((AnAction)new DismissLoginNotificationAction(CosyBundle.message("notifications.action.button.dismiss", new Object[0])));
            notification.notify(project);
        }
    }

    public static void notifyRequireLicenseDirectly(@Nullable Project project, AuthStatus authStatus) {
        if (authStatus == null) {
            return;
        }
        String message = CosyBundle.message("notifications.auth.require.license.error", new Object[0]);
        Notification notification = NotificationFactory.createInfoStickyNotification(I18NConstant.COSY_PLUGIN_NAME, message);
        if (notification != null) {
            notification.addAction((AnAction)new DismissLoginNotificationAction(CosyBundle.message("notifications.action.button.dismiss", new Object[0])));
            notification.notify(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyNeedLogin(@Nullable Project project, boolean forceCheck) {
        String projectName = project.getName();
        if (!forceCheck) {
            if (showNeedLoginMap.containsKey(projectName)) {
                return;
            }
            String string = projectName.intern();
            synchronized (string) {
                if (showNeedLoginMap.containsKey(projectName)) {
                    return;
                }
                showNeedLoginMap.put(projectName, true);
            }
        }
        if (!Cosy.INSTANCE.checkCosy(project)) {
            return;
        }
        AuthStatus authStatus = UserAuthService.getInstance().getState(project);
        if (authStatus != null && authStatus.getStatus().intValue() == AuthStateEnum.NETWORK_ERROR.getValue()) {
            GrantAuthorNotification.notifyNetworkErrorDirectly(project, authStatus);
        } else if (authStatus != null && authStatus.getStatus().intValue() == AuthStateEnum.IP_BANNED_ERROR.getValue() && StringUtils.isNotBlank((CharSequence)authStatus.getOrgName())) {
            GrantAuthorNotification.notifyIpBannedErrorDirectly(project, authStatus);
        } else if (authStatus != null && authStatus.getStatus().intValue() == AuthStateEnum.APP_DISABLED_ERROR.getValue()) {
            GrantAuthorNotification.notifyAppDisabledErrorDirectly(project, authStatus);
        } else if (authStatus != null && authStatus.getStatus().intValue() != AuthStateEnum.LOGIN.getValue()) {
            GrantAuthorNotification.notifyNeedLoginDirectly(project);
        } else if (authStatus != null && authStatus.getWhitelist() != null && authStatus.getWhitelist().intValue() != AuthWhitelistStatusEnum.PASS.getValue()) {
            if (authStatus.getWhitelist().intValue() == AuthWhitelistStatusEnum.NOT_WHITELIST.getValue()) {
                GrantAuthorNotification.notifyNeedWhitelistDirectly(project, authStatus);
            } else if (authStatus.getWhitelist().intValue() == AuthWhitelistStatusEnum.NO_LICENCE.getValue()) {
                GrantAuthorNotification.notifyRequireLicenseDirectly(project, authStatus);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyEnableLocalService(@Nullable Project project) {
        String projectName = project.getName();
        if (showEnableLocalMap.containsKey(projectName)) {
            return;
        }
        String string = projectName.intern();
        synchronized (string) {
            if (showEnableLocalMap.containsKey(projectName)) {
                return;
            }
            showEnableLocalMap.put(projectName, true);
        }
        CosySetting setting = CosyPersistentSetting.getInstance().getState();
        if (setting != null && setting.getParameter() != null && setting.getParameter().getLocal().getEnable() != null && setting.getParameter().getLocal().getEnable().booleanValue()) {
            return;
        }
        Notification notification = NotificationFactory.createInfoStickyNotification(CosyBundle.message("notifications.local.service.title", new Object[0]), CosyBundle.message("notifications.local.service.content", new Object[0]));
        if (notification != null) {
            notification.addAction((AnAction)new EnableLocalServiceNotificationAction(CosyBundle.message("notifications.local.service.enable", new Object[0])));
            notification.addAction((AnAction)new NotWantEnableLocalServiceNotificationAction(I18NConstant.TRACE_NOTIFY_DISAGREE));
            notification.notify(project);
        }
    }

    public static void notifyError(@Nullable Project project) {
        NotificationFactory.showWarnNotification(project, I18NConstant.ERROR_NOTIFY_TITLE, I18NConstant.ERROR_NOTIFY_CONTENT);
    }

    public static void notifyUninstall(@Nullable Project project) {
        Notification notification = NotificationFactory.createInfoStickyNotification(I18NConstant.TRACE_NOTIFY_TITLE, I18NConstant.UNINSTALL_NOTIFY_CONTENT);
        if (notification != null) {
            notification.addAction((AnAction)new OpenQuestionnaireNotificationAction(I18NConstant.UNINSTALL_NOTIFY_AGREE));
            notification.addAction((AnAction)new NotOpenQuestionnaireNotificationAction(I18NConstant.UNINSTALL_NOTIFY_DISAGREE));
            notification.notify(project);
        }
    }

    static class NotWantEnableLocalServiceNotificationAction
    extends NotificationAction {
        public NotWantEnableLocalServiceNotificationAction(@Nullable @Nls(capitalization=Nls.Capitalization.Title) String text) {
            super(text);
        }

        public void actionPerformed(@NotNull AnActionEvent anActionEvent, @NotNull Notification notification) {
            if (anActionEvent == null) {
                NotWantEnableLocalServiceNotificationAction.$$$reportNull$$$0(0);
            }
            if (notification == null) {
                NotWantEnableLocalServiceNotificationAction.$$$reportNull$$$0(1);
            }
            notification.expire();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "anActionEvent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
            }
            objectArray[1] = "com/alibabacloud/intellij/cosy/ui/notifications/GrantAuthorNotification$NotWantEnableLocalServiceNotificationAction";
            objectArray[2] = "actionPerformed";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class EnableLocalServiceNotificationAction
    extends NotificationAction {
        public EnableLocalServiceNotificationAction(@Nullable @Nls(capitalization=Nls.Capitalization.Title) String text) {
            super(text);
        }

        public void actionPerformed(@NotNull AnActionEvent anActionEvent, @NotNull Notification notification) {
            if (anActionEvent == null) {
                EnableLocalServiceNotificationAction.$$$reportNull$$$0(0);
            }
            if (notification == null) {
                EnableLocalServiceNotificationAction.$$$reportNull$$$0(1);
            }
            ConfigService.getInstance().configLocalCompletionSwitch(anActionEvent.getProject(), true);
            notification.expire();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "anActionEvent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
            }
            objectArray[1] = "com/alibabacloud/intellij/cosy/ui/notifications/GrantAuthorNotification$EnableLocalServiceNotificationAction";
            objectArray[2] = "actionPerformed";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class DismissLoginNotificationAction
    extends NotificationAction {
        public DismissLoginNotificationAction(@Nullable @Nls(capitalization=Nls.Capitalization.Title) String text) {
            super(text);
        }

        public void actionPerformed(@NotNull AnActionEvent anActionEvent, @NotNull Notification notification) {
            if (anActionEvent == null) {
                DismissLoginNotificationAction.$$$reportNull$$$0(0);
            }
            if (notification == null) {
                DismissLoginNotificationAction.$$$reportNull$$$0(1);
            }
            notification.expire();
            GrantAuthorNotification.notifyEnableLocalService(anActionEvent.getProject());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "anActionEvent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
            }
            objectArray[1] = "com/alibabacloud/intellij/cosy/ui/notifications/GrantAuthorNotification$DismissLoginNotificationAction";
            objectArray[2] = "actionPerformed";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class GotoUrlNotificationAction
    extends NotificationAction {
        String url;

        public GotoUrlNotificationAction(@Nullable @Nls(capitalization=Nls.Capitalization.Title) String text, String url) {
            super(text);
            this.url = url;
        }

        public void actionPerformed(@NotNull AnActionEvent anActionEvent, @NotNull Notification notification) {
            if (anActionEvent == null) {
                GotoUrlNotificationAction.$$$reportNull$$$0(0);
            }
            if (notification == null) {
                GotoUrlNotificationAction.$$$reportNull$$$0(1);
            }
            BrowserUtil.browse((String)this.url);
            notification.expire();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "anActionEvent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
            }
            objectArray[1] = "com/alibabacloud/intellij/cosy/ui/notifications/GrantAuthorNotification$GotoUrlNotificationAction";
            objectArray[2] = "actionPerformed";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class GotoLoginNotificationAction
    extends NotificationAction {
        public GotoLoginNotificationAction(@Nullable @Nls(capitalization=Nls.Capitalization.Title) String text) {
            super(text);
        }

        public void actionPerformed(@NotNull AnActionEvent anActionEvent, @NotNull Notification notification) {
            if (anActionEvent == null) {
                GotoLoginNotificationAction.$$$reportNull$$$0(0);
            }
            if (notification == null) {
                GotoLoginNotificationAction.$$$reportNull$$$0(1);
            }
            UserAuthService.getInstance().login(anActionEvent.getProject(), null);
            notification.expire();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "anActionEvent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
            }
            objectArray[1] = "com/alibabacloud/intellij/cosy/ui/notifications/GrantAuthorNotification$GotoLoginNotificationAction";
            objectArray[2] = "actionPerformed";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ForbiddenNotificationAction
    extends NotificationAction {
        public ForbiddenNotificationAction(@Nullable @Nls(capitalization=Nls.Capitalization.Title) String text) {
            super(text);
        }

        public void actionPerformed(@NotNull AnActionEvent anActionEvent, @NotNull Notification notification) {
            if (anActionEvent == null) {
                ForbiddenNotificationAction.$$$reportNull$$$0(0);
            }
            if (notification == null) {
                ForbiddenNotificationAction.$$$reportNull$$$0(1);
            }
            if (CosyPersistentSetting.getInstance().getState() != null) {
                CosyPersistentSetting.getInstance().getState().setAllowReportUsage(false);
                CosyPersistentSetting.getInstance().getState().setShowCheckReportUsage(false);
                CosyPersistentSetting.getInstance().getState().getParameter().setAllowReportUsage(false);
                Cosy.INSTANCE.updateConfig(CosyPersistentSetting.getInstance().getState().getParameter());
            }
            notification.expire();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "anActionEvent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
            }
            objectArray[1] = "com/alibabacloud/intellij/cosy/ui/notifications/GrantAuthorNotification$ForbiddenNotificationAction";
            objectArray[2] = "actionPerformed";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class AllowNotificationAction
    extends NotificationAction {
        public AllowNotificationAction(@Nullable @Nls(capitalization=Nls.Capitalization.Title) String text) {
            super(text);
        }

        public void actionPerformed(@NotNull AnActionEvent anActionEvent, @NotNull Notification notification) {
            if (anActionEvent == null) {
                AllowNotificationAction.$$$reportNull$$$0(0);
            }
            if (notification == null) {
                AllowNotificationAction.$$$reportNull$$$0(1);
            }
            if (CosyPersistentSetting.getInstance().getState() != null) {
                CosyPersistentSetting.getInstance().getState().setAllowReportUsage(true);
                CosyPersistentSetting.getInstance().getState().setShowCheckReportUsage(false);
                CosyPersistentSetting.getInstance().getState().getParameter().setAllowReportUsage(true);
                Cosy.INSTANCE.updateConfig(CosyPersistentSetting.getInstance().getState().getParameter());
            }
            notification.expire();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "anActionEvent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
            }
            objectArray[1] = "com/alibabacloud/intellij/cosy/ui/notifications/GrantAuthorNotification$AllowNotificationAction";
            objectArray[2] = "actionPerformed";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class NotOpenQuestionnaireNotificationAction
    extends NotificationAction {
        public NotOpenQuestionnaireNotificationAction(@Nullable @Nls(capitalization=Nls.Capitalization.Title) String text) {
            super(text);
        }

        public void actionPerformed(@NotNull AnActionEvent anActionEvent, @NotNull Notification notification) {
            if (anActionEvent == null) {
                NotOpenQuestionnaireNotificationAction.$$$reportNull$$$0(0);
            }
            if (notification == null) {
                NotOpenQuestionnaireNotificationAction.$$$reportNull$$$0(1);
            }
            notification.expire();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "anActionEvent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
            }
            objectArray[1] = "com/alibabacloud/intellij/cosy/ui/notifications/GrantAuthorNotification$NotOpenQuestionnaireNotificationAction";
            objectArray[2] = "actionPerformed";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class OpenQuestionnaireNotificationAction
    extends NotificationAction {
        public OpenQuestionnaireNotificationAction(@Nullable @Nls(capitalization=Nls.Capitalization.Title) String text) {
            super(text);
        }

        public void actionPerformed(@NotNull AnActionEvent anActionEvent, @NotNull Notification notification) {
            if (anActionEvent == null) {
                OpenQuestionnaireNotificationAction.$$$reportNull$$$0(0);
            }
            if (notification == null) {
                OpenQuestionnaireNotificationAction.$$$reportNull$$$0(1);
            }
            CosyBrowserUtil.browse(LingmaUrls.MESSAGE_FEEDBACK_URL);
            notification.expire();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "anActionEvent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
            }
            objectArray[1] = "com/alibabacloud/intellij/cosy/ui/notifications/GrantAuthorNotification$OpenQuestionnaireNotificationAction";
            objectArray[2] = "actionPerformed";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

