/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.config;

import com.alibaba.fastjson.JSON;
import com.alibabacloud.intellij.cosy.common.BuildFeature;
import com.alibabacloud.intellij.cosy.common.CosyCacheKeys;
import com.alibabacloud.intellij.cosy.common.CosyConfig;
import com.alibabacloud.intellij.cosy.common.CosySetting;
import com.alibabacloud.intellij.cosy.constants.LingmaUrls;
import com.alibabacloud.intellij.cosy.core.Cosy;
import com.alibabacloud.intellij.cosy.core.CosyStartupAdapter;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStateEnum;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.GlobalConfig;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.GlobalEndpointConfig;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.UpdateConfigResult;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.LoginParams;
import com.alibabacloud.intellij.cosy.search.enums.CodeCompletionCandidateEnum;
import com.alibabacloud.intellij.cosy.search.enums.CodeCompletionModeEnum;
import com.alibabacloud.intellij.cosy.search.enums.CompletionGenerateLengthLevelEnum;
import com.alibabacloud.intellij.cosy.search.enums.DocumentOpenModeEnum;
import com.alibabacloud.intellij.cosy.search.enums.ExceptionResolveModeEnum;
import com.alibabacloud.intellij.cosy.search.enums.LoginModeEnum;
import com.alibabacloud.intellij.cosy.search.enums.MethodQuickSwitchEnum;
import com.alibabacloud.intellij.cosy.search.enums.ModelPowerLevelEnum;
import com.alibabacloud.intellij.cosy.search.enums.ProxyModeEnum;
import com.alibabacloud.intellij.cosy.search.enums.UpgradeChecklEnum;
import com.alibabacloud.intellij.cosy.service.UserAuthService;
import com.alibabacloud.intellij.cosy.ui.config.AuthOrgItem;
import com.alibabacloud.intellij.cosy.ui.config.ConfigAccessKeyUI;
import com.alibabacloud.intellij.cosy.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.cosy.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.cosy.ui.search.color.CosyColor;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.ui.search.topic.AuthLoginNotifier;
import com.alibabacloud.intellij.cosy.ui.search.topic.AuthLogoutNotifier;
import com.alibabacloud.intellij.cosy.ui.statusbar.CosyStatusBarWidget;
import com.alibabacloud.intellij.cosy.util.ColorUtil;
import com.alibabacloud.intellij.cosy.util.CosyBrowserUtil;
import com.alibabacloud.intellij.cosy.util.KeyboardUtil;
import com.alibabacloud.intellij.cosy.util.LingmaAgentUtil;
import com.alibabacloud.intellij.cosy.util.LoginUtil;
import com.alibabacloud.intellij.cosy.util.ThreadUtil;
import com.alibabacloud.intellij.cosy.util.UrlUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import icons.LingmaIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class ConfigMainForm
implements Disposable {
    private static final int MAX_ORG_NAME_DISPLAY_LENGTH = 24;
    private JPanel mainPanel;
    private JRadioButton ideaButton;
    private JRadioButton browserButton;
    private JRadioButton completionAutoMode;
    private JRadioButton completionSpeedMode;
    private JRadioButton completionWholeLineMode;
    private JComboBox<String> candidateNumberSelector;
    private JRadioButton enableSearchModeRadioButton;
    private JRadioButton enableGenerateModeRadioButton;
    private JRadioButton enabledMethodQuickOperRadioButton;
    private JRadioButton disabledMethodQuickOperRadioButton;
    private JButton btnLogin;
    private JButton btnLogout;
    private JLabel labelLoginState;
    private JCheckBox localModelCheckBox;
    private JCheckBox cloudModelCheckBox;
    private JComboBox<KeyValue> autoTriggerLengthComboBox;
    private JComboBox<KeyValue> manualTriggerLengthComboBox;
    private JPanel cloudModelPanel;
    private JPanel localModelPanel;
    private JLabel privacyLabel;
    private JLabel cloudManualShortcutLabel;
    private JLabel loginWarnLabel;
    private JPanel exceptionPanel;
    private JPanel methodQuickPanel;
    private JPanel documentOpenPanel;
    private JPanel auxiliaryPanel;
    private TitledSeparator auxiliaryTitleSeparator;
    private JCheckBox autoUpdateCheckBox;
    private JTextField proxyUrlTextField;
    private JRadioButton systemProxyConfigurationRadioButton;
    private JRadioButton manualProxyConfigurationRadioButton;
    private JPanel manualProxyUrlPanel;
    private JRadioButton loggedInByAccountRadioButton;
    private JRadioButton loggedInByAKRadioButton;
    private JTextField akTextField;
    private JPasswordField skTextField;
    private JButton akLogInButton;
    private JPanel akConfigPanel;
    private JPanel loginModeConfigPanel;
    private JLabel getAkLabel;
    private JCheckBox showInlineCheckBox;
    private JComboBox<Object> orgIdComboBox;
    private JTextField langTriggerTextField;
    private JRadioButton logInByAccessTokenRadioButton;
    private JPanel tokenConfigPanel;
    private JTextField accessTokenTextField;
    private JComboBox<Object> orgIdTokenComboBox;
    private JButton tokenLogInButton;
    private JPanel tokenConfigHeaderPanel;
    private JPanel akConfigHeaderPanel;
    private JPanel privacyPanel;
    private TitledSeparator privacyTitleLabel;
    private TextFieldWithBrowseButton localStoragePathField;
    private JRadioButton aliyunAccountRadioButton;
    private JRadioButton dedicatedDomainRadioButton;
    private JTextField dedicatedUrlField;
    private JButton dedicatedLoginBtn;
    private JPanel accountPanel;
    private JLabel dedicatedLabel;
    private JPanel dedicatedPanel;
    private JPanel dedicatedConfigPanel;
    private JLabel aliyunAccountRadioLabel;
    private ConfigAccessKeyUI configAccessKeyUI;
    private MessageBusConnection messageBusConnection;
    private static final Logger log = Logger.getInstance(ConfigMainForm.class);

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public ConfigMainForm() {
        this.$$$setupUI$$$();
        ArrayList<KeyValue> autoGenLengthList = new ArrayList<KeyValue>();
        autoGenLengthList.add(new KeyValue(CompletionGenerateLengthLevelEnum.LINE_LEVEL.getLabel(), CosyBundle.message("settings.completion.generate.length.line", new Object[0])));
        autoGenLengthList.add(new KeyValue(CompletionGenerateLengthLevelEnum.LEVEL_1.getLabel(), CosyBundle.message("settings.completion.generate.length.level1", new Object[0])));
        autoGenLengthList.add(new KeyValue(CompletionGenerateLengthLevelEnum.LEVEL_2.getLabel(), CosyBundle.message("settings.completion.generate.length.level2", new Object[0])));
        autoGenLengthList.add(new KeyValue(CompletionGenerateLengthLevelEnum.LEVEL_3.getLabel(), CosyBundle.message("settings.completion.generate.length.level3", new Object[0])));
        autoGenLengthList.add(new KeyValue(CompletionGenerateLengthLevelEnum.NO.getLabel(), CosyBundle.message("settings.completion.generate.length.disabled", new Object[0])));
        ArrayList<KeyValue> manualGenLengthList = new ArrayList<KeyValue>();
        manualGenLengthList.add(new KeyValue(CompletionGenerateLengthLevelEnum.LINE_LEVEL.getLabel(), CosyBundle.message("settings.completion.generate.length.line", new Object[0])));
        manualGenLengthList.add(new KeyValue(CompletionGenerateLengthLevelEnum.LEVEL_1.getLabel(), CosyBundle.message("settings.completion.generate.length.level1", new Object[0])));
        manualGenLengthList.add(new KeyValue(CompletionGenerateLengthLevelEnum.LEVEL_2.getLabel(), CosyBundle.message("settings.completion.generate.length.level2", new Object[0])));
        manualGenLengthList.add(new KeyValue(CompletionGenerateLengthLevelEnum.LEVEL_3.getLabel(), CosyBundle.message("settings.completion.generate.length.level3", new Object[0])));
        this.autoTriggerLengthComboBox.setModel(new DefaultComboBoxModel<KeyValue>(autoGenLengthList.toArray(new KeyValue[autoGenLengthList.size()])));
        this.manualTriggerLengthComboBox.setModel(new DefaultComboBoxModel<KeyValue>(manualGenLengthList.toArray(new KeyValue[manualGenLengthList.size()])));
        this.configCombox(this.autoTriggerLengthComboBox);
        this.configCombox(this.manualTriggerLengthComboBox);
        Project project = ProjectUtil.guessCurrentProject((JComponent)this.getMainPanel());
        this.messageBusConnection = project.getMessageBus().connect();
        this.messageBusConnection.subscribe(AuthLoginNotifier.AUTH_LOGIN_NOTIFICATION, this::notifyLoginAuth);
        this.messageBusConnection.subscribe(AuthLogoutNotifier.AUTH_LOGOUT_NOTIFICATION, this::notifyLogoutAuth);
        this.initLoginPanel(project);
        this.privacyLabel.setForeground(ColorUtil.getLinkForegroundColor());
        this.privacyLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.privacyLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CosyBrowserUtil.browse(LingmaUrls.PRIVACY_URL);
            }
        });
        this.localModelCheckBox.addChangeListener(e -> {
            if (this.localModelCheckBox.isSelected()) {
                this.localModelPanel.setVisible(true);
                this.localModelCheckBox.setForeground(ColorUtil.getLabelForegroundColor());
            } else {
                this.localModelPanel.setVisible(false);
                this.localModelCheckBox.setForeground((Color)new JBColor(UIUtil::getInactiveTextColor));
            }
        });
        this.cloudModelCheckBox.addChangeListener(e -> {
            if (this.cloudModelCheckBox.isSelected()) {
                this.cloudModelPanel.setVisible(true);
                this.cloudModelCheckBox.setForeground(ColorUtil.getLabelForegroundColor());
            } else {
                this.cloudModelPanel.setVisible(false);
                this.cloudModelCheckBox.setForeground((Color)new JBColor(UIUtil::getInactiveTextColor));
            }
        });
        String triggerShortcut = KeyboardUtil.getShortcutText("TriggerInlayCompletionAction");
        this.cloudManualShortcutLabel.setText(String.format(CosyBundle.message("settings.cloud.manual.shortcut.text", new Object[0]), triggerShortcut));
        if (CosyConfig.IDE_NAME.toLowerCase(Locale.ROOT).contains("pycharm")) {
            this.exceptionPanel.setVisible(false);
            this.documentOpenPanel.setVisible(false);
        } else if (!CosyConfig.IDE_NAME.toLowerCase(Locale.ROOT).contains("idea")) {
            this.auxiliaryPanel.setVisible(false);
            this.auxiliaryTitleSeparator.setVisible(false);
        }
        if (CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false)) {
            this.documentOpenPanel.setVisible(false);
            this.privacyPanel.setVisible(false);
            this.privacyTitleLabel.setVisible(false);
            this.exceptionPanel.setVisible(false);
        }
        this.initProxyPanel(project);
    }

    private void initProxyPanel(final Project project) {
        this.systemProxyConfigurationRadioButton.addActionListener(e -> this.manualProxyUrlPanel.setVisible(false));
        this.manualProxyConfigurationRadioButton.addActionListener(e -> this.manualProxyUrlPanel.setVisible(true));
        CosyStartupAdapter startupListener = new CosyStartupAdapter(){

            @Override
            public void onStartup() {
                log.debug("start to get global config");
                if (Cosy.INSTANCE.getLanguageService(project) != null) {
                    GlobalEndpointConfig endpointConfig;
                    GlobalConfig globalConfig = Cosy.INSTANCE.getLanguageService(project).getGlobalConfig(2000L);
                    if (globalConfig != null) {
                        CosyCacheKeys.KEY_GLOBAL_CONFIG.set((UserDataHolder)project, (Object)globalConfig);
                        SwingUtilities.invokeLater(() -> {
                            log.debug("get global config:" + globalConfig);
                            ConfigMainForm.this.setProxyMode(globalConfig.getProxyMode());
                            ConfigMainForm.this.setProxyUrl(globalConfig.getHttpProxy());
                        });
                    }
                    if ((endpointConfig = Cosy.INSTANCE.getLanguageService(project).getEndpointConfig(2000L)) != null) {
                        CosyCacheKeys.KEY_ENDPOINT_CONFIG.set((UserDataHolder)project, (Object)endpointConfig);
                        SwingUtilities.invokeLater(() -> {
                            log.debug("get endpoint config:" + endpointConfig);
                            ConfigMainForm.this.setEndpoint(endpointConfig.getEndpoint());
                        });
                    } else {
                        LingmaAgentUtil.addDefaultEndpointToCache(project);
                    }
                }
            }
        };
        if (Cosy.INSTANCE.checkCosy(project, true, List.of(startupListener))) {
            log.debug("get global config directly");
            startupListener.onStartup();
        } else {
            GlobalConfig globalConfig = (GlobalConfig)CosyCacheKeys.KEY_GLOBAL_CONFIG.get((UserDataHolder)project);
            if (globalConfig != null) {
                log.debug("get global config from cache:" + globalConfig);
                this.setProxyMode(globalConfig.getProxyMode());
                this.setProxyUrl(globalConfig.getHttpProxy());
            }
        }
    }

    private void configCombox(JComboBox<KeyValue> comboBox) {
        comboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component com = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                KeyValue pair = (KeyValue)value;
                this.setText(pair.getLabel());
                return com;
            }
        });
    }

    private void initModelSlider(JSlider modeLevel, JSlider lengthLevel, boolean isManual) {
        modeLevel.addChangeListener(e -> {
            if (modeLevel.getValue() == ModelPowerLevelEnum.SMALL.getLevel()) {
                lengthLevel.setMinimum(CompletionGenerateLengthLevelEnum.LINE_LEVEL.getLevel());
                lengthLevel.setMaximum(CompletionGenerateLengthLevelEnum.LINE_LEVEL.getLevel());
                lengthLevel.setValue(CompletionGenerateLengthLevelEnum.LINE_LEVEL.getLevel());
            } else if (modeLevel.getValue() == ModelPowerLevelEnum.MIDDLE.getLevel()) {
                lengthLevel.setMinimum(CompletionGenerateLengthLevelEnum.LINE_LEVEL.getLevel());
                if (isManual) {
                    lengthLevel.setMaximum(CompletionGenerateLengthLevelEnum.LEVEL_2.getLevel());
                } else {
                    lengthLevel.setMaximum(CompletionGenerateLengthLevelEnum.LEVEL_1.getLevel());
                }
                lengthLevel.setValue(CompletionGenerateLengthLevelEnum.LINE_LEVEL.getLevel());
            } else if (modeLevel.getValue() == ModelPowerLevelEnum.LARGE.getLevel()) {
                lengthLevel.setMinimum(CompletionGenerateLengthLevelEnum.LINE_LEVEL.getLevel());
                lengthLevel.setMaximum(CompletionGenerateLengthLevelEnum.LEVEL_3.getLevel());
                if (isManual) {
                    lengthLevel.setValue(CompletionGenerateLengthLevelEnum.LEVEL_1.getLevel());
                } else {
                    lengthLevel.setValue(CompletionGenerateLengthLevelEnum.LINE_LEVEL.getLevel());
                }
            }
        });
    }

    private void notifyLoginAuth(AuthStatus status) {
        log.info("get login auth object:" + status);
        CosyCacheKeys.KEY_AUTH_STATUS.set((UserDataHolder)ApplicationManager.getApplication(), (Object)status);
        if (status != null && status.getStatus() != null && status.getStatus().intValue() == AuthStateEnum.LOGIN.getValue()) {
            Object orgName;
            this.accountPanel.setVisible(false);
            this.dedicatedDomainRadioButton.setVisible(false);
            this.dedicatedConfigPanel.setVisible(false);
            this.dedicatedLoginBtn.setVisible(false);
            this.btnLogin.setVisible(false);
            this.akLogInButton.setVisible(false);
            this.btnLogout.setVisible(true);
            this.cloudModelCheckBox.setEnabled(true);
            this.cloudModelPanel.setVisible(true);
            this.loginWarnLabel.setVisible(false);
            this.labelLoginState.setForeground(CosyColor.GREEN_TEXT_COLOR);
            String whiteListText = LoginUtil.getWhitelistText(status);
            Object loginInfo = String.format(CosyBundle.message("settings.login.account.tips.logged", new Object[0]), status.getName(), status.getId(), whiteListText);
            if (CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false)) {
                loginInfo = String.format(CosyBundle.message("settings.login.account.tips.logged.vpc", new Object[0]), status.getName(), whiteListText);
            }
            if (StringUtils.isNotBlank((CharSequence)(orgName = status.getOrgName()))) {
                if (((String)orgName).length() > 24) {
                    orgName = ((String)orgName).substring(0, 24) + "...";
                }
                loginInfo = (String)loginInfo + String.format(CosyBundle.message("settings.login.account.tips.org.label", new Object[0]), orgName);
            }
            this.labelLoginState.setText((String)loginInfo);
            this.loginModeConfigPanel.setVisible(false);
            this.tokenLogInButton.setVisible(false);
        } else {
            this.accountPanel.setVisible(true);
            this.dedicatedDomainRadioButton.setVisible(true);
            this.aliyunAccountRadioButton.setVisible(true);
            this.labelLoginState.setForeground((Color)CosyColor.GRAY_TXT_COLOR);
            this.labelLoginState.setText(CosyBundle.messageVpc("settings.login.account.tips.not.logged", new Object[0]));
            CosySetting settings = CosyPersistentSetting.getInstance().getState();
            if (settings != null && LoginModeEnum.DEDICATED.getLabel().equalsIgnoreCase(settings.getLoginMode())) {
                this.dedicatedLoginBtn.setVisible(true);
                this.akLogInButton.setVisible(false);
                this.tokenLogInButton.setVisible(false);
                this.btnLogin.setVisible(false);
                this.loginModeConfigPanel.setVisible(false);
                this.dedicatedConfigPanel.setVisible(true);
            } else if (settings != null && LoginModeEnum.ACCESS_KEY.getLabel().equals(settings.getLoginMode())) {
                this.akLogInButton.setVisible(true);
                this.tokenLogInButton.setVisible(false);
                this.btnLogin.setVisible(false);
                this.dedicatedLoginBtn.setVisible(false);
                this.loginModeConfigPanel.setVisible(true);
                this.dedicatedConfigPanel.setVisible(false);
            } else if (settings != null && LoginModeEnum.PERSONAL_TOKEN.getLabel().equals(settings.getLoginMode())) {
                this.tokenLogInButton.setVisible(true);
                this.akLogInButton.setVisible(false);
                this.btnLogin.setVisible(false);
                this.dedicatedLoginBtn.setVisible(false);
                this.loginModeConfigPanel.setVisible(true);
                this.dedicatedConfigPanel.setVisible(false);
            } else {
                this.akLogInButton.setVisible(false);
                this.tokenLogInButton.setVisible(false);
                this.btnLogin.setVisible(true);
                this.dedicatedLoginBtn.setVisible(false);
                this.loginModeConfigPanel.setVisible(true);
                this.dedicatedConfigPanel.setVisible(false);
            }
            this.btnLogout.setVisible(false);
            this.cloudModelCheckBox.setEnabled(false);
            this.cloudModelPanel.setVisible(false);
            this.loginWarnLabel.setVisible(true);
        }
        this.btnLogin.setEnabled(true);
        this.dedicatedLoginBtn.setEnabled(true);
        this.btnLogout.setEnabled(true);
        this.configAccessKeyUI.checkAkskLoginButtonState();
    }

    private void notifyLogoutAuth(AuthStatus status) {
        log.info("get logout auth object:" + status);
        CosyCacheKeys.KEY_AUTH_STATUS.set((UserDataHolder)ApplicationManager.getApplication(), (Object)status);
        if (status != null && (status.getStatus() == null || status.getStatus().intValue() == AuthStateEnum.NOT_LOGIN.getValue())) {
            this.labelLoginState.setForeground((Color)CosyColor.GRAY_TXT_COLOR);
            this.labelLoginState.setText(CosyBundle.messageVpc("settings.login.account.tips.not.logged", new Object[0]));
            CosySetting settings = CosyPersistentSetting.getInstance().getState();
            if (settings != null && LoginModeEnum.DEDICATED.getLabel().equals(settings.getLoginMode())) {
                this.dedicatedLoginBtn.setVisible(true);
                this.akLogInButton.setVisible(false);
                this.tokenLogInButton.setVisible(false);
                this.btnLogin.setVisible(false);
                this.loginModeConfigPanel.setVisible(false);
                this.dedicatedConfigPanel.setVisible(true);
            } else if (settings != null && LoginModeEnum.ACCESS_KEY.getLabel().equals(settings.getLoginMode())) {
                this.akLogInButton.setVisible(true);
                this.tokenLogInButton.setVisible(false);
                this.btnLogin.setVisible(false);
                this.loginModeConfigPanel.setVisible(true);
                this.dedicatedConfigPanel.setVisible(false);
            } else if (settings != null && LoginModeEnum.PERSONAL_TOKEN.getLabel().equals(settings.getLoginMode())) {
                this.tokenLogInButton.setVisible(true);
                this.akLogInButton.setVisible(false);
                this.btnLogin.setVisible(false);
                this.loginModeConfigPanel.setVisible(true);
                this.dedicatedConfigPanel.setVisible(false);
            } else {
                this.akLogInButton.setVisible(false);
                this.tokenLogInButton.setVisible(false);
                this.btnLogin.setVisible(true);
                this.loginModeConfigPanel.setVisible(true);
                this.dedicatedConfigPanel.setVisible(false);
            }
            this.accountPanel.setVisible(true);
            this.dedicatedDomainRadioButton.setVisible(true);
            this.aliyunAccountRadioButton.setVisible(true);
            this.btnLogout.setVisible(false);
            this.cloudModelCheckBox.setEnabled(false);
            this.cloudModelPanel.setVisible(false);
            this.loginWarnLabel.setVisible(true);
        } else {
            this.btnLogout.setVisible(true);
            this.cloudModelCheckBox.setEnabled(true);
            this.cloudModelPanel.setVisible(true);
            this.loginWarnLabel.setVisible(false);
            this.loginModeConfigPanel.setVisible(false);
        }
        this.btnLogin.setEnabled(true);
        this.btnLogout.setEnabled(true);
        this.dedicatedLoginBtn.setEnabled(true);
        this.configAccessKeyUI.checkAkskLoginButtonState();
    }

    private void initLoginPanel(Project project) {
        if (CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false)) {
            this.configAccessKeyUI = new ConfigAccessKeyUI(project, this.accessTokenTextField, null, this.orgIdTokenComboBox, this.tokenLogInButton, LoginModeEnum.PERSONAL_TOKEN.getLabel());
            this.dedicatedPanel.setVisible(false);
            this.aliyunAccountRadioButton.setText(CosyBundle.messageVpc("settings.login.account.panel.title.vpc", new Object[0]));
            this.aliyunAccountRadioLabel.setText("");
        } else {
            this.configAccessKeyUI = new ConfigAccessKeyUI(project, this.akTextField, this.skTextField, this.orgIdComboBox, this.akLogInButton, LoginModeEnum.ACCESS_KEY.getLabel());
            this.dedicatedPanel.setVisible(true);
        }
        this.accountPanel.setVisible(true);
        this.loginModeConfigPanel.setVisible(true);
        this.akConfigPanel.setVisible(false);
        this.loggedInByAccountRadioButton.setSelected(true);
        this.loggedInByAKRadioButton.setSelected(false);
        this.logInByAccessTokenRadioButton.setSelected(false);
        this.loggedInByAccountRadioButton.addActionListener(e -> {
            this.akConfigPanel.setVisible(false);
            this.tokenConfigPanel.setVisible(false);
            this.btnLogin.setVisible(true);
            this.btnLogin.setEnabled(true);
            this.loggedInByAccountRadioButton.setSelected(true);
            this.loggedInByAKRadioButton.setSelected(false);
            this.logInByAccessTokenRadioButton.setSelected(false);
            this.dedicatedDomainRadioButton.setSelected(false);
        });
        this.loggedInByAKRadioButton.addActionListener(e -> {
            this.akConfigPanel.setVisible(true);
            this.btnLogin.setVisible(false);
            this.akLogInButton.setVisible(true);
            this.checkAndChangeEndpointWhenSelectAkLogin(project);
            this.configAccessKeyUI.checkAkskLoginButtonState();
            this.loggedInByAKRadioButton.setSelected(true);
            this.loggedInByAccountRadioButton.setSelected(false);
            this.logInByAccessTokenRadioButton.setSelected(false);
            this.dedicatedDomainRadioButton.setSelected(false);
        });
        this.logInByAccessTokenRadioButton.addActionListener(e -> {
            this.tokenConfigPanel.setVisible(true);
            this.btnLogin.setVisible(false);
            this.akLogInButton.setVisible(false);
            this.tokenLogInButton.setVisible(true);
            this.logInByAccessTokenRadioButton.setSelected(true);
            this.loggedInByAccountRadioButton.setSelected(false);
            this.loggedInByAKRadioButton.setSelected(false);
            this.dedicatedDomainRadioButton.setSelected(false);
        });
        this.akLogInButton.addActionListener(e -> {
            if (project != null) {
                CosySetting setting = CosyPersistentSetting.getInstance().getState();
                if (setting != null) {
                    this.checkEndpointConfigWhenAliyunLogin(project, setting);
                    setting.setLoginMode(LoginModeEnum.ACCESS_KEY.getLabel());
                } else {
                    log.warn("Setting is null when ak login button entered.");
                }
                this.akLogInButton.setEnabled(false);
                this.labelLoginState.setText(CosyBundle.message("settings.login.account.tips.state.logging.in", new Object[0]));
                LoginParams loginParams = LoginParams.fromAccessKey(this.getLoginAccessKey(), this.getLoginSecretKey(), this.getOrganizationId());
                UserAuthService.getInstance().login(project, this.labelLoginState, loginParams);
            }
        });
        this.tokenLogInButton.addActionListener(e -> {
            if (project != null) {
                CosySetting setting = CosyPersistentSetting.getInstance().getState();
                if (setting != null) {
                    this.checkEndpointConfigWhenAliyunLogin(project, setting);
                    setting.setLoginMode(LoginModeEnum.PERSONAL_TOKEN.getLabel());
                } else {
                    log.warn("Setting is null when token login button entered.");
                }
                this.tokenLogInButton.setEnabled(false);
                this.labelLoginState.setText(CosyBundle.message("settings.login.account.tips.state.logging.in", new Object[0]));
                LoginParams loginParams = LoginParams.fromPersonalToken(this.getLoginAccessToken(), this.getOrganizationIdForToken());
                UserAuthService.getInstance().login(project, this.labelLoginState, loginParams);
            }
        });
        this.getAkLabel.setForeground(ColorUtil.getLinkForegroundColor());
        this.getAkLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.getAkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CosyBrowserUtil.browse(LingmaUrls.GET_ACCESS_KEY_URL);
            }
        });
        this.configAccessKeyUI.setup();
        this.btnLogin.addActionListener(e -> {
            if (project != null) {
                CosySetting setting = CosyPersistentSetting.getInstance().getState();
                if (setting != null) {
                    this.checkEndpointConfigWhenAliyunLogin(project, setting);
                    setting.setLoginMode(LoginModeEnum.ALIYUN_ACCOUNT.getLabel());
                } else {
                    log.warn("Setting is null when token login button entered.");
                }
                this.btnLogin.setEnabled(false);
                this.labelLoginState.setText(CosyBundle.message("settings.login.account.tips.state.logging.in", new Object[0]));
                UserAuthService.getInstance().login(project, this.labelLoginState);
            }
        });
        this.btnLogout.addActionListener(e -> {
            if (project != null) {
                this.btnLogout.setEnabled(false);
                this.labelLoginState.setText(CosyBundle.message("settings.login.account.tips.state.logging.out", new Object[0]));
                UserAuthService.getInstance().logout(project, this.btnLogout);
            }
        });
        this.btnLogin.setVisible(false);
        this.btnLogout.setVisible(false);
        this.cloudModelPanel.setVisible(false);
        this.loginWarnLabel.setForeground(ColorUtil.getInactiveForegroundColor());
        this.loginWarnLabel.setIcon(LingmaIcons.WarningIcon);
        this.loginWarnLabel.setText(CosyBundle.message("settings.cloud.login.require.tips", new Object[0]));
        this.loginWarnLabel.setVisible(true);
        this.labelLoginState.setText(CosyBundle.message("settings.login.account.tips.state.fetch.user", new Object[0]));
        if (CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false)) {
            this.tokenConfigHeaderPanel.setVisible(true);
            this.akConfigHeaderPanel.setVisible(false);
        } else {
            this.tokenConfigHeaderPanel.setVisible(false);
            this.akConfigHeaderPanel.setVisible(true);
        }
        this.aliyunAccountRadioButton.setSelected(true);
        this.dedicatedDomainRadioButton.setSelected(false);
        this.dedicatedConfigPanel.setVisible(false);
        CosySetting cosySetting = CosyPersistentSetting.getInstance().getState();
        if (cosySetting != null && StringUtils.isNotBlank((CharSequence)cosySetting.getDedicatedDomainUrl())) {
            this.setDedicatedUrlField(cosySetting.getDedicatedDomainUrl());
        }
        this.aliyunAccountRadioButton.addActionListener(e -> {
            this.accountPanel.setVisible(true);
            this.loginModeConfigPanel.setVisible(true);
            this.aliyunAccountRadioButton.setSelected(true);
            this.dedicatedConfigPanel.setVisible(false);
            this.dedicatedDomainRadioButton.setSelected(false);
            if (this.loggedInByAccountRadioButton.isSelected()) {
                this.btnLogin.setVisible(true);
            } else if (this.loggedInByAKRadioButton.isSelected()) {
                this.loggedInByAccountRadioButton.setSelected(true);
                this.loggedInByAKRadioButton.setSelected(false);
                this.akConfigPanel.setVisible(false);
                this.btnLogin.setVisible(true);
                this.tokenLogInButton.setVisible(false);
            } else if (this.logInByAccessTokenRadioButton.isSelected()) {
                this.btnLogin.setVisible(false);
                this.akLogInButton.setVisible(false);
                this.tokenLogInButton.setVisible(true);
            }
        });
        this.dedicatedDomainRadioButton.addActionListener(e -> {
            this.dedicatedLoginBtn.setEnabled(true);
            this.loginModeConfigPanel.setVisible(false);
            this.dedicatedConfigPanel.setVisible(true);
            this.aliyunAccountRadioButton.setSelected(false);
            this.dedicatedDomainRadioButton.setSelected(true);
            this.dedicatedLoginBtn.setVisible(true);
        });
        this.dedicatedLoginBtn.addActionListener(e -> {
            CosySetting setting = CosyPersistentSetting.getInstance().getState();
            this.dedicatedLoginBtn.setEnabled(false);
            this.labelLoginState.setText(CosyBundle.message("settings.login.account.tips.state.logging.in", new Object[0]));
            String dedicatedDomainUrl = this.getDedicatedUrlField(true);
            if (StringUtils.isNotBlank((CharSequence)dedicatedDomainUrl)) {
                if (setting != null) {
                    boolean differentEndpointUrl;
                    GlobalEndpointConfig endpointConfig = LingmaAgentUtil.getGlobalEndpointConfigDirectly(project);
                    boolean bl = differentEndpointUrl = endpointConfig != null && endpointConfig.getEndpoint() != null && !endpointConfig.getEndpoint().equals(dedicatedDomainUrl);
                    if (differentEndpointUrl) {
                        log.info("Log in by dedicated login button. Detected dedicated domain url changed, update lingma endpoint config.");
                        this.updateLingmaEndpointConfig(project);
                    } else {
                        log.info("Log in by dedicated login button. Don't need update endpoint, directly login.");
                    }
                    setting.setLoginMode(LoginModeEnum.DEDICATED.getLabel());
                    setting.setDedicatedDomainUrl(dedicatedDomainUrl);
                }
                if (project != null) {
                    UserAuthService.getInstance().login(project, this.labelLoginState, LoginParams.fromDedicatedDomain());
                }
            } else {
                this.dedicatedLoginBtn.setEnabled(true);
            }
        });
        AuthStatus status = UserAuthService.getInstance().getState(project);
        if (status != null) {
            this.notifyLoginAuth(status);
        }
    }

    private void checkAndChangeEndpointWhenSelectAkLogin(Project project) {
        if (project == null) {
            log.warn("project is null when checkAndChangeEndpointWhenSelectAkLogin");
            return;
        }
        CosySetting setting = CosyPersistentSetting.getInstance().getState();
        if (setting != null) {
            log.info("checkAndChangeEndpointWhenSelectAkLogin");
            this.checkEndpointConfigWhenAliyunLogin(project, setting);
            setting.setLoginMode(LoginModeEnum.ACCESS_KEY.getLabel());
        }
    }

    private boolean checkEndpointConfigWhenAliyunLogin(Project project, CosySetting setting) {
        GlobalEndpointConfig endpointConfig = LingmaAgentUtil.getGlobalEndpointConfigDirectly(project);
        boolean hasEndpointConfig = StringUtils.isNotBlank((CharSequence)endpointConfig.getEndpoint());
        if (hasEndpointConfig) {
            log.info("hasEndpointConfig when aliyun login, clear all endpoint settings.");
            if (setting != null) {
                setting.setDedicatedDomainUrl("");
            }
            this.dedicatedUrlField.setText("");
            this.updateLingmaEndpointConfig(project);
        } else {
            log.info("No endpoint config, login directly.");
        }
        return hasEndpointConfig;
    }

    public void updateLingmaGlobalConfig(Project project) {
        if (project != null) {
            CosyStatusBarWidget.updateStatusBar(null, project);
            if (Cosy.INSTANCE.checkCosy(project)) {
                GlobalConfig config = new GlobalConfig();
                if (this.getProxyMode().getType().equals(ProxyModeEnum.MANUAL.getType())) {
                    config.setProxyMode(this.getProxyMode().getType());
                    config.setHttpProxy(this.getProxyUrl());
                } else {
                    config.setProxyMode(this.getProxyMode().getType());
                }
                ThreadUtil.execute(() -> Cosy.INSTANCE.getLanguageService(project).updateGlobalConfig(config, 2000L));
            }
        }
    }

    public void updateLingmaEndpointConfig(Project project) {
        if (project != null) {
            CosyStatusBarWidget.updateStatusBar(null, project);
            if (Cosy.INSTANCE.checkCosy(project)) {
                GlobalEndpointConfig config = new GlobalEndpointConfig();
                if (LoginModeEnum.DEDICATED.getLabel().equals(this.getLoginMode())) {
                    config.setEndpoint(this.getDedicatedUrlField(false));
                } else {
                    config.setEndpoint("");
                }
                CosyCacheKeys.KEY_ENDPOINT_CONFIG.set((UserDataHolder)project, (Object)config);
                UpdateConfigResult result = Cosy.INSTANCE.getLanguageService(project).updateEndpoint(config, 2000L);
                if (!BooleanUtils.isTrue((Boolean)result.getSuccess())) {
                    log.warn("UpdateEndpointConfig error. config=" + JSON.toJSONString((Object)config) + ", result=" + JSON.toJSONString((Object)result));
                } else {
                    log.info("UpdateEndpointConfig success.");
                }
            }
        }
    }

    public String getLoginMode() {
        if (this.dedicatedDomainRadioButton.isSelected()) {
            return LoginModeEnum.DEDICATED.getLabel();
        }
        if (this.loggedInByAKRadioButton.isSelected()) {
            return LoginModeEnum.ACCESS_KEY.getLabel();
        }
        return LoginModeEnum.ALIYUN_ACCOUNT.getLabel();
    }

    public void setLoginMode(String mode) {
        if (LoginModeEnum.ACCESS_KEY.getLabel().equals(mode)) {
            this.loggedInByAKRadioButton.setSelected(true);
            this.akConfigPanel.setVisible(true);
            this.akLogInButton.setVisible(true);
            this.btnLogin.setVisible(false);
            this.tokenLogInButton.setVisible(false);
            this.tokenConfigPanel.setVisible(false);
            this.aliyunAccountRadioButton.setSelected(true);
            this.dedicatedDomainRadioButton.setSelected(false);
            this.dedicatedConfigPanel.setVisible(false);
            this.loggedInByAccountRadioButton.setSelected(false);
            this.loginModeConfigPanel.setVisible(true);
        } else if (LoginModeEnum.PERSONAL_TOKEN.getLabel().equals(mode)) {
            this.logInByAccessTokenRadioButton.setSelected(true);
            this.akConfigPanel.setVisible(false);
            this.akLogInButton.setVisible(false);
            this.btnLogin.setVisible(false);
            this.tokenLogInButton.setVisible(true);
            this.tokenConfigPanel.setVisible(true);
            this.aliyunAccountRadioButton.setSelected(true);
            this.dedicatedDomainRadioButton.setSelected(false);
            this.dedicatedConfigPanel.setVisible(false);
            this.loggedInByAccountRadioButton.setSelected(false);
            this.loginModeConfigPanel.setVisible(true);
        } else if (LoginModeEnum.DEDICATED.getLabel().equals(mode)) {
            this.aliyunAccountRadioButton.setSelected(false);
            this.dedicatedDomainRadioButton.setSelected(true);
            this.dedicatedConfigPanel.setVisible(true);
            this.loginModeConfigPanel.setVisible(false);
            this.akConfigPanel.setVisible(false);
            this.akLogInButton.setVisible(false);
            this.btnLogin.setVisible(false);
            this.tokenLogInButton.setVisible(false);
            this.tokenConfigPanel.setVisible(false);
            this.dedicatedLoginBtn.setVisible(true);
        } else {
            this.loggedInByAccountRadioButton.setSelected(true);
            this.akConfigPanel.setVisible(false);
            this.akLogInButton.setVisible(false);
            this.btnLogin.setVisible(true);
            this.tokenLogInButton.setVisible(false);
            this.tokenConfigPanel.setVisible(false);
            this.aliyunAccountRadioButton.setSelected(true);
            this.dedicatedDomainRadioButton.setSelected(false);
            this.dedicatedConfigPanel.setVisible(false);
            this.loggedInByAKRadioButton.setSelected(false);
            this.logInByAccessTokenRadioButton.setSelected(false);
            this.loginModeConfigPanel.setVisible(true);
        }
        AuthStatus status = (AuthStatus)CosyCacheKeys.KEY_AUTH_STATUS.get((UserDataHolder)ApplicationManager.getApplication());
        if (status != null && status.getStatus() != null && status.getStatus().intValue() == AuthStateEnum.LOGIN.getValue()) {
            this.loginModeConfigPanel.setVisible(false);
            this.dedicatedConfigPanel.setVisible(false);
        }
    }

    public String getLoginAccessKey() {
        return this.akTextField.getText();
    }

    public String getLoginAccessToken() {
        if (this.accessTokenTextField.getText() == null) {
            return "";
        }
        return this.accessTokenTextField.getText();
    }

    public String getLoginSecretKey() {
        if (this.skTextField.getPassword() == null) {
            return null;
        }
        return new String(this.skTextField.getPassword());
    }

    public String getOrganizationId() {
        if (this.orgIdComboBox.getSelectedItem() == null || !(this.orgIdComboBox.getSelectedItem() instanceof AuthOrgItem)) {
            return null;
        }
        AuthOrgItem kv = (AuthOrgItem)this.orgIdComboBox.getSelectedItem();
        return kv.getKey();
    }

    public String getOrganizationIdForToken() {
        if (this.orgIdTokenComboBox.getSelectedItem() == null || !(this.orgIdTokenComboBox.getSelectedItem() instanceof AuthOrgItem)) {
            return null;
        }
        AuthOrgItem kv = (AuthOrgItem)this.orgIdTokenComboBox.getSelectedItem();
        return kv.getKey();
    }

    public void setLoginAccessKey(String ak) {
        this.akTextField.setText(ak);
    }

    public void setLoginSecretKey(String sk) {
        this.skTextField.setText(sk);
    }

    public String getCodeCompletionMode() {
        if (this.completionAutoMode.isSelected()) {
            return CodeCompletionModeEnum.AUTO.mode;
        }
        if (this.completionSpeedMode.isSelected()) {
            return CodeCompletionModeEnum.SPEED.mode;
        }
        return CodeCompletionModeEnum.LENGTH.mode;
    }

    public void setCodeCompletionMode(String mode) {
        if (CodeCompletionModeEnum.AUTO.mode.equals(mode)) {
            this.completionAutoMode.setSelected(true);
        } else if (CodeCompletionModeEnum.SPEED.mode.equals(mode)) {
            this.completionSpeedMode.setSelected(true);
        } else {
            this.completionWholeLineMode.setSelected(true);
        }
    }

    public int getDefaultCodeCompletionCandidateMaxNum() {
        try {
            if (this.candidateNumberSelector.getSelectedItem() != null) {
                int valueOfCandidateSettings = Integer.parseInt((String)this.candidateNumberSelector.getSelectedItem());
                if (valueOfCandidateSettings < CodeCompletionCandidateEnum.MIN.num) {
                    return CodeCompletionCandidateEnum.MIN.num;
                }
                if (valueOfCandidateSettings > CodeCompletionCandidateEnum.MAX.num) {
                    return CodeCompletionCandidateEnum.MAX.num;
                }
                if (valueOfCandidateSettings != CodeCompletionCandidateEnum.DEFAULT.num) {
                    return valueOfCandidateSettings;
                }
            }
        }
        catch (NumberFormatException nfe) {
            log.warn(String.format("Invalid candidate maximum number input: %s, error message: %s: ", this.candidateNumberSelector.getSelectedItem(), nfe.getMessage()));
        }
        return CodeCompletionCandidateEnum.DEFAULT.num;
    }

    public void setDefaultCodeCompletionCandidateMaxNum(int candidateNumber) {
        this.candidateNumberSelector.setSelectedItem(String.valueOf(candidateNumber));
    }

    public DocumentOpenModeEnum getDocumentOpenMode() {
        if (this.ideaButton.isSelected()) {
            return DocumentOpenModeEnum.OPEN_IN_IDEA;
        }
        return DocumentOpenModeEnum.OPEN_IN_WEB;
    }

    public void setDocumentOpenMode(DocumentOpenModeEnum mode) {
        if (DocumentOpenModeEnum.OPEN_IN_IDEA.equals((Object)mode)) {
            this.ideaButton.setSelected(true);
        } else if (DocumentOpenModeEnum.OPEN_IN_WEB.equals((Object)mode)) {
            this.browserButton.setSelected(true);
        }
    }

    public boolean getCodeCompletionSwitch() {
        return this.localModelCheckBox.isSelected();
    }

    public void setCodeCompletionSwitch(Boolean enabled) {
        if (enabled != null && !enabled.booleanValue()) {
            this.localModelCheckBox.setSelected(false);
            this.localModelPanel.setVisible(false);
            this.localModelCheckBox.setForeground((Color)new JBColor(UIUtil::getInactiveTextColor));
        } else {
            this.localModelCheckBox.setSelected(true);
            this.localModelPanel.setVisible(true);
            this.localModelCheckBox.setForeground(ColorUtil.getLabelForegroundColor());
        }
    }

    public boolean getCloudCodeCompletionSwitch() {
        return this.cloudModelCheckBox.isSelected();
    }

    public void setCloudCodeCompletionSwitch(Boolean enabled) {
        if (enabled != null && !enabled.booleanValue()) {
            this.cloudModelCheckBox.setSelected(false);
            this.cloudModelPanel.setVisible(false);
            this.cloudModelCheckBox.setForeground((Color)new JBColor(UIUtil::getInactiveTextColor));
        } else {
            this.cloudModelCheckBox.setSelected(true);
            if (this.cloudModelCheckBox.isEnabled()) {
                this.cloudModelPanel.setVisible(true);
            }
            this.cloudModelCheckBox.setForeground(ColorUtil.getLabelForegroundColor());
        }
    }

    public boolean getEnableCloudAutoTrigger() {
        KeyValue pair = (KeyValue)this.autoTriggerLengthComboBox.getSelectedItem();
        return !pair.getKey().equals(CompletionGenerateLengthLevelEnum.NO.getLabel());
    }

    public void setEnableCloudAutoTrigger(Boolean enabled, String levelLabel) {
        KeyValue pair = null;
        pair = enabled != null && enabled == false ? new KeyValue(CompletionGenerateLengthLevelEnum.NO.getLabel()) : new KeyValue(levelLabel);
        this.autoTriggerLengthComboBox.setSelectedItem(pair);
    }

    public String getUpgradeCheckValue() {
        if (this.autoUpdateCheckBox.isSelected()) {
            return UpgradeChecklEnum.AUTO_INSTALL.getLabel();
        }
        return UpgradeChecklEnum.FORBID_CHECK.getLabel();
    }

    public void setUpgradeCheckValue(String key) {
        if (UpgradeChecklEnum.AUTO_INSTALL.getLabel().equals(key)) {
            this.autoUpdateCheckBox.setSelected(true);
        } else {
            this.autoUpdateCheckBox.setSelected(false);
        }
    }

    public ModelPowerLevelEnum getCloudAutoModelPower() {
        return ModelPowerLevelEnum.LARGE;
    }

    public void setCloudAutoModelPower(String levelLabel) {
    }

    public CompletionGenerateLengthLevelEnum getCloudAutoGenLengthLevel() {
        KeyValue pair = (KeyValue)this.autoTriggerLengthComboBox.getSelectedItem();
        if (pair.getKey().equals(CompletionGenerateLengthLevelEnum.NO.getLabel())) {
            return CompletionGenerateLengthLevelEnum.LEVEL_1;
        }
        return CompletionGenerateLengthLevelEnum.getLevelEnum(pair.getKey());
    }

    public void setCloudAutoGenLengthLevel(String levelLabel) {
        CompletionGenerateLengthLevelEnum level = CompletionGenerateLengthLevelEnum.getLevelEnum(levelLabel);
        if (level != null) {
            this.autoTriggerLengthComboBox.setSelectedItem(new KeyValue(levelLabel));
        }
    }

    public ModelPowerLevelEnum getCloudManualModelPower() {
        return ModelPowerLevelEnum.LARGE;
    }

    public void setCloudManualModelPower(String levelLabel) {
    }

    public CompletionGenerateLengthLevelEnum getCloudManualGenLength() {
        KeyValue pair = (KeyValue)this.manualTriggerLengthComboBox.getSelectedItem();
        return CompletionGenerateLengthLevelEnum.getLevelEnum(pair.getKey());
    }

    public void setCloudManualGenLength(String levelLabel) {
        CompletionGenerateLengthLevelEnum level = CompletionGenerateLengthLevelEnum.getLevelEnum(levelLabel);
        if (level != null) {
            this.manualTriggerLengthComboBox.setSelectedItem(new KeyValue(levelLabel));
        }
    }

    public ExceptionResolveModeEnum getExceptionResolveMode() {
        if (this.enableSearchModeRadioButton.isSelected()) {
            return ExceptionResolveModeEnum.USE_SEARCH;
        }
        return ExceptionResolveModeEnum.USE_GENERATE;
    }

    public void setExceptionResolveMode(ExceptionResolveModeEnum mode) {
        if (ExceptionResolveModeEnum.USE_SEARCH.getType().equals(mode.getType())) {
            this.enableSearchModeRadioButton.setSelected(true);
            this.enableGenerateModeRadioButton.setSelected(false);
        } else {
            this.enableGenerateModeRadioButton.setSelected(true);
            this.enableSearchModeRadioButton.setSelected(false);
        }
    }

    public MethodQuickSwitchEnum getMethodQuickSwitchEnum() {
        if (this.enabledMethodQuickOperRadioButton.isSelected()) {
            return MethodQuickSwitchEnum.ENABLED;
        }
        return MethodQuickSwitchEnum.DISABLED;
    }

    public void setMethodQuickSwitch(MethodQuickSwitchEnum mode) {
        if (MethodQuickSwitchEnum.ENABLED.getType().equals(mode.getType())) {
            this.enabledMethodQuickOperRadioButton.setSelected(true);
            this.disabledMethodQuickOperRadioButton.setSelected(false);
        } else {
            this.disabledMethodQuickOperRadioButton.setSelected(true);
            this.enabledMethodQuickOperRadioButton.setSelected(false);
        }
    }

    public ProxyModeEnum getProxyMode() {
        if (this.systemProxyConfigurationRadioButton.isSelected()) {
            return ProxyModeEnum.SYSTEM;
        }
        return ProxyModeEnum.MANUAL;
    }

    public void setProxyMode(String mode) {
        if (ProxyModeEnum.SYSTEM.getType().equals(mode)) {
            this.systemProxyConfigurationRadioButton.setSelected(true);
            this.manualProxyConfigurationRadioButton.setSelected(false);
            this.manualProxyUrlPanel.setVisible(false);
        } else {
            this.manualProxyConfigurationRadioButton.setSelected(true);
            this.systemProxyConfigurationRadioButton.setSelected(false);
            this.manualProxyUrlPanel.setVisible(true);
        }
    }

    public void setEndpoint(String endpoint) {
        CosySetting setting;
        if (StringUtils.isNotBlank((CharSequence)endpoint) && (setting = CosyPersistentSetting.getInstance().getState()) != null) {
            setting.setLoginMode(LoginModeEnum.DEDICATED.getLabel());
            this.setLoginMode(LoginModeEnum.DEDICATED.getLabel());
        }
    }

    public String getProxyUrl() {
        return this.proxyUrlTextField.getText();
    }

    public void setProxyUrl(String url) {
        this.proxyUrlTextField.setText(url);
    }

    public void setShowInlineSuggestions(Boolean show) {
        if (show == null || !show.booleanValue()) {
            this.showInlineCheckBox.setSelected(false);
        } else {
            this.showInlineCheckBox.setSelected(true);
        }
    }

    public Boolean getShowInlineSuggestions() {
        return this.showInlineCheckBox.isSelected();
    }

    public List<String> getDisableLanguages() {
        String text = this.langTriggerTextField.getText();
        if (StringUtils.isBlank((CharSequence)text)) {
            return Collections.emptyList();
        }
        return Arrays.stream(text.split(",")).map(String::trim).collect(Collectors.toList());
    }

    public void setDisableLanguages(List<String> languages) {
        if (languages == null || languages.isEmpty()) {
            this.langTriggerTextField.setText("");
        } else {
            this.langTriggerTextField.setText(StringUtils.join(languages, (char)','));
        }
    }

    public void setLocalStoragePath(String path) {
        this.localStoragePathField.setText(path);
    }

    public String getLocalStoragePath(boolean verify) {
        String path = this.localStoragePathField.getText();
        if (!verify) {
            return path;
        }
        if (StringUtils.isBlank((CharSequence)path)) {
            NotificationFactory.showToast((JComponent)this.localStoragePathField, MessageType.ERROR, CosyBundle.message("notifications.local.storage.path.empty", new Object[0]));
            return "";
        }
        File localStoragePathFile = new File(path);
        if (!localStoragePathFile.exists() && !localStoragePathFile.mkdirs()) {
            NotificationFactory.showToast((JComponent)this.localStoragePathField, MessageType.ERROR, CosyBundle.message("notifications.local.storage.path.invalid", new Object[0]));
            return "";
        }
        return path;
    }

    public void setDedicatedUrlField(String url) {
        this.dedicatedUrlField.setText(url);
    }

    public String getDedicatedUrlField(boolean verify) {
        String url = this.dedicatedUrlField.getText();
        if (!verify) {
            return url;
        }
        if (StringUtils.isBlank((CharSequence)url)) {
            NotificationFactory.showToast((JComponent)this.dedicatedUrlField, MessageType.ERROR, CosyBundle.message("notifications.dedicated.url.empty", new Object[0]));
            return "";
        }
        boolean isUrlValid = UrlUtil.verifyDomain(url);
        if (!isUrlValid) {
            NotificationFactory.showToast((JComponent)this.dedicatedUrlField, MessageType.ERROR, CosyBundle.message("notifications.dedicated.url.invalid", new Object[0]));
            return "";
        }
        return url;
    }

    protected GlobalEndpointConfig getEndpointConfig(Project project) {
        GlobalEndpointConfig globalConfig = (GlobalEndpointConfig)CosyCacheKeys.KEY_ENDPOINT_CONFIG.get((UserDataHolder)project);
        if (globalConfig == null) {
            if (!Cosy.INSTANCE.checkCosy(project)) {
                return null;
            }
            globalConfig = Cosy.INSTANCE.getLanguageService(project).getEndpointConfig(2000L);
            if (globalConfig != null) {
                CosyCacheKeys.KEY_ENDPOINT_CONFIG.set((UserDataHolder)project, (Object)globalConfig);
            } else {
                LingmaAgentUtil.addDefaultEndpointToCache(project);
            }
        }
        return globalConfig;
    }

    private void createUIComponents() {
        Object[] numbers = new String[CodeCompletionCandidateEnum.MAX.num];
        for (int i = CodeCompletionCandidateEnum.MIN.num; i <= CodeCompletionCandidateEnum.MAX.num; ++i) {
            numbers[i - 1] = String.valueOf(i);
        }
        this.candidateNumberSelector = new ComboBox(numbers);
        this.candidateNumberSelector.setSelectedItem(String.valueOf(CodeCompletionCandidateEnum.DEFAULT.num));
        this.proxyUrlTextField = new JBTextField();
        ((JBTextField)this.proxyUrlTextField).getEmptyText().setText(CosyBundle.message("settings.proxy.panel.tips", new Object[0]));
        this.langTriggerTextField = new JBTextField();
        ((JBTextField)this.langTriggerTextField).getEmptyText().setText(CosyBundle.message("settings.completion.cloud.language.placeholder", new Object[0]));
        this.localStoragePathField = new TextFieldWithBrowseButton();
        SwingHelper.installFileCompletionAndBrowseDialog(null, (TextFieldWithBrowseButton)this.localStoragePathField, (String)"Local Storage Path Selector", (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor().withShowHiddenFiles(SystemInfo.isUnix).withFileFilter(VirtualFile::isDirectory));
    }

    public void dispose() {
        if (this.messageBusConnection != null) {
            this.messageBusConnection.disconnect();
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JPanel jPanel;
        JRadioButton jRadioButton2;
        JCheckBox jCheckBox;
        JLabel jLabel;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JPanel jPanel2;
        JRadioButton jRadioButton5;
        JRadioButton jRadioButton6;
        JPanel jPanel3;
        JRadioButton jRadioButton7;
        JRadioButton jRadioButton8;
        JPanel jPanel4;
        JPanel jPanel5;
        TitledSeparator titledSeparator;
        JCheckBox jCheckBox4;
        JLabel jLabel2;
        JPanel jPanel6;
        TitledSeparator titledSeparator2;
        JRadioButton jRadioButton9;
        JRadioButton jRadioButton10;
        JRadioButton jRadioButton11;
        JPanel jPanel7;
        JLabel jLabel3;
        JPanel jPanel8;
        JButton jButton;
        JTextField jTextField;
        JLabel jLabel4;
        JPanel jPanel9;
        JRadioButton jRadioButton12;
        JPanel jPanel10;
        JLabel jLabel5;
        JRadioButton jRadioButton13;
        JButton jButton2;
        JTextField jTextField2;
        JPanel jPanel11;
        JRadioButton jRadioButton14;
        JPanel jPanel12;
        JButton jButton3;
        JPasswordField jPasswordField;
        JTextField jTextField3;
        JPanel jPanel13;
        JLabel jLabel6;
        JRadioButton jRadioButton15;
        JPanel jPanel14;
        JButton jButton4;
        JRadioButton jRadioButton16;
        JPanel jPanel15;
        JPanel jPanel16;
        JButton jButton5;
        JLabel jLabel7;
        JPanel jPanel17;
        this.createUIComponents();
        this.mainPanel = jPanel17 = new JPanel();
        jPanel17.setLayout((LayoutManager)new GridLayoutManager(18, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel18 = new JPanel();
        jPanel18.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 20, 10, 0), 10, -1, false, false));
        jPanel17.add((Component)jPanel18, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JPanel jPanel19 = new JPanel();
        jPanel19.setLayout(new FlowLayout(0, 5, 5));
        jPanel18.add((Component)jPanel19, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.labelLoginState = jLabel7 = new JLabel();
        jLabel7.setText("Label");
        Component component = jPanel19.add(jLabel7);
        this.btnLogout = jButton5 = new JButton();
        this.$$$loadButtonText$$$(jButton5, ResourceBundle.getBundle("messageBundle").getString("settings.login.panel.btn.logout"));
        Component component2 = jPanel19.add(jButton5);
        this.accountPanel = jPanel16 = new JPanel();
        jPanel16.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel18.add((Component)jPanel16, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.loginModeConfigPanel = jPanel15 = new JPanel();
        jPanel15.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel16.add((Component)jPanel15, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel20 = new JPanel();
        jPanel20.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel15.add((Component)jPanel20, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.loggedInByAccountRadioButton = jRadioButton16 = new JRadioButton();
        jRadioButton16.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton16, ResourceBundle.getBundle("messageBundle").getString("settings.login.mode.logged.account"));
        jPanel20.add((Component)jRadioButton16, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel20.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.btnLogin = jButton4 = new JButton();
        this.$$$loadButtonText$$$(jButton4, ResourceBundle.getBundle("messageBundle").getString("settings.login.panel.btn.login"));
        jPanel20.add((Component)jButton4, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        this.akConfigHeaderPanel = jPanel14 = new JPanel();
        jPanel14.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel15.add((Component)jPanel14, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel21 = new JPanel();
        jPanel21.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel14.add((Component)jPanel21, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.loggedInByAKRadioButton = jRadioButton15 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton15, ResourceBundle.getBundle("messageBundle").getString("settings.login.mode.logged.aksk"));
        jPanel21.add((Component)jRadioButton15, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel21.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.getAkLabel = jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("messageBundle").getString("settings.login.label.get.aksk"));
        jPanel21.add((Component)jLabel6, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.akConfigPanel = jPanel13 = new JPanel();
        jPanel13.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel14.add((Component)jPanel13, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel22 = new JPanel();
        jPanel22.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel13.add((Component)jPanel22, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, ResourceBundle.getBundle("messageBundle").getString("settings.login.label.ak"));
        jPanel22.add((Component)jLabel8, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel22.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.akTextField = jTextField3 = new JTextField();
        jPanel22.add((Component)jTextField3, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(250, -1), new Dimension(250, -1)));
        JLabel jLabel9 = new JLabel();
        this.$$$loadLabelText$$$(jLabel9, ResourceBundle.getBundle("messageBundle").getString("settings.login.label.sk"));
        jPanel22.add((Component)jLabel9, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.skTextField = jPasswordField = new JPasswordField();
        jPanel22.add((Component)jPasswordField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(250, -1), new Dimension(250, -1)));
        JLabel jLabel10 = new JLabel();
        this.$$$loadLabelText$$$(jLabel10, ResourceBundle.getBundle("messageBundle").getString("settings.login.label.orgid"));
        jPanel22.add((Component)jLabel10, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.orgIdComboBox = jComboBox;
        jPanel22.add(jComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(250, -1), new Dimension(250, -1)));
        JPanel jPanel23 = new JPanel();
        jPanel23.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel13.add((Component)jPanel23, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.akLogInButton = jButton3 = new JButton();
        this.$$$loadButtonText$$$(jButton3, ResourceBundle.getBundle("messageBundle").getString("settings.login.panel.btn.login"));
        jPanel23.add((Component)jButton3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel23.add((Component)spacer4, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.tokenConfigHeaderPanel = jPanel12 = new JPanel();
        jPanel12.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel15.add((Component)jPanel12, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel24 = new JPanel();
        jPanel24.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel12.add((Component)jPanel24, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.logInByAccessTokenRadioButton = jRadioButton14 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton14, ResourceBundle.getBundle("messageBundle").getString("settings.login.mode.logged.token"));
        jPanel24.add((Component)jRadioButton14, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel24.add((Component)spacer5, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.tokenConfigPanel = jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel12.add((Component)jPanel11, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel25 = new JPanel();
        jPanel25.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel11.add((Component)jPanel25, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel11 = new JLabel();
        this.$$$loadLabelText$$$(jLabel11, ResourceBundle.getBundle("messageBundle").getString("settings.login.label.access.token"));
        jPanel25.add((Component)jLabel11, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.accessTokenTextField = jTextField2 = new JTextField();
        jPanel25.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(250, -1), new Dimension(250, -1)));
        JLabel jLabel12 = new JLabel();
        this.$$$loadLabelText$$$(jLabel12, ResourceBundle.getBundle("messageBundle").getString("settings.login.label.orgid"));
        jPanel25.add((Component)jLabel12, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox2 = new JComboBox();
        this.orgIdTokenComboBox = jComboBox2;
        jPanel25.add(jComboBox2, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(250, -1), new Dimension(250, -1)));
        JPanel jPanel26 = new JPanel();
        jPanel26.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel11.add((Component)jPanel26, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.tokenLogInButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("messageBundle").getString("settings.login.panel.btn.login"));
        jPanel26.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel26.add((Component)spacer6, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel27 = new JPanel();
        jPanel27.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel16.add((Component)jPanel27, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.aliyunAccountRadioButton = jRadioButton13 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton13, ResourceBundle.getBundle("messageBundle").getString("settings.login.account.panel.title"));
        jPanel27.add((Component)jRadioButton13, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.aliyunAccountRadioLabel = jLabel5 = new JLabel();
        ((Component)jLabel5).setEnabled(false);
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("messageBundle").getString("settings.login.account.panel.tips"));
        jPanel27.add((Component)jLabel5, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel27.add((Component)spacer7, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.dedicatedPanel = jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel18.add((Component)jPanel10, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel28 = new JPanel();
        jPanel28.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.add((Component)jPanel28, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.dedicatedDomainRadioButton = jRadioButton12 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton12, ResourceBundle.getBundle("messageBundle").getString("settings.login.dedicated.panel.title"));
        jPanel28.add((Component)jRadioButton12, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer8 = new Spacer();
        jPanel28.add((Component)spacer8, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer9 = new Spacer();
        jPanel10.add((Component)spacer9, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.dedicatedConfigPanel = jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel10.add((Component)jPanel9, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.dedicatedLabel = jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messageBundle").getString("settings.login.dedicated.url"));
        jPanel9.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.dedicatedUrlField = jTextField = new JTextField();
        jPanel9.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.dedicatedLoginBtn = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messageBundle").getString("settings.login.panel.btn.login"));
        jPanel9.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer10 = new Spacer();
        jPanel9.add((Component)spacer10, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.privacyPanel = jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 20, 10, 0), -1, -1, false, false));
        jPanel17.add((Component)jPanel8, new GridConstraints(16, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        Spacer spacer11 = new Spacer();
        jPanel8.add((Component)spacer11, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.privacyLabel = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messageBundle").getString("settings.privacy.agreement"));
        jPanel8.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer12 = new Spacer();
        jPanel17.add((Component)spacer12, new GridConstraints(17, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.localModelPanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 20, 10, 0), -1, -1, false, false));
        jPanel17.add((Component)jPanel7, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JPanel jPanel29 = new JPanel();
        jPanel29.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(0, 0, 0, 0), 10, -1, false, false));
        jPanel7.add((Component)jPanel29, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel13 = new JLabel();
        this.$$$loadLabelText$$$(jLabel13, ResourceBundle.getBundle("messageBundle").getString("code.completion.length"));
        jPanel29.add((Component)jLabel13, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.completionAutoMode = jRadioButton11 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton11, ResourceBundle.getBundle("messageBundle").getString("code.completion.auto.mode"));
        jPanel29.add((Component)jRadioButton11, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.completionSpeedMode = jRadioButton10 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton10, ResourceBundle.getBundle("messageBundle").getString("code.completion.speed.first"));
        jPanel29.add((Component)jRadioButton10, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.completionWholeLineMode = jRadioButton9 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton9, ResourceBundle.getBundle("messageBundle").getString("code.completion.line.first"));
        jPanel29.add((Component)jRadioButton9, new GridConstraints(0, 3, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer13 = new Spacer();
        jPanel29.add((Component)spacer13, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel30 = new JPanel();
        jPanel30.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), 10, -1, false, false));
        jPanel7.add((Component)jPanel30, new GridConstraints(1, 0, 1, 1, 8, 2, 3, 3, null, null, null));
        JLabel jLabel14 = new JLabel();
        this.$$$loadLabelText$$$(jLabel14, ResourceBundle.getBundle("messageBundle").getString("settings.completion.local.max.number"));
        jPanel30.add((Component)jLabel14, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer14 = new Spacer();
        jPanel30.add((Component)spacer14, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JComboBox<String> jComboBox3 = this.candidateNumberSelector;
        jPanel30.add(jComboBox3, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        TitledSeparator titledSeparator3 = new TitledSeparator();
        titledSeparator3.setText(ResourceBundle.getBundle("messageBundle").getString("settings.login.panel.title"));
        jPanel17.add((Component)titledSeparator3, new GridConstraints(0, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.privacyTitleLabel = titledSeparator2 = new TitledSeparator();
        titledSeparator2.setText(ResourceBundle.getBundle("messageBundle").getString("privacy.agreement"));
        jPanel17.add((Component)titledSeparator2, new GridConstraints(15, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        TitledSeparator titledSeparator4 = new TitledSeparator();
        titledSeparator4.setText(ResourceBundle.getBundle("messageBundle").getString("settings.completion.panel.title"));
        jPanel17.add((Component)titledSeparator4, new GridConstraints(2, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.cloudModelPanel = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 20, 10, 0), -1, 5, false, false));
        jPanel17.add((Component)jPanel6, new GridConstraints(6, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JPanel jPanel31 = new JPanel();
        jPanel31.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), 10, -1, false, false));
        jPanel6.add((Component)jPanel31, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel32 = new JPanel();
        jPanel32.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, 5, false, false));
        jPanel31.add((Component)jPanel32, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel15 = new JLabel();
        this.$$$loadLabelText$$$(jLabel15, ResourceBundle.getBundle("messageBundle").getString("settings.completion.cloud.auto.trigger.label"));
        jPanel32.add((Component)jLabel15, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer15 = new Spacer();
        jPanel32.add((Component)spacer15, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JComboBox jComboBox4 = new JComboBox();
        this.autoTriggerLengthComboBox = jComboBox4;
        jPanel32.add(jComboBox4, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JPanel jPanel33 = new JPanel();
        jPanel33.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel31.add((Component)jPanel33, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel16 = new JLabel();
        this.$$$loadLabelText$$$(jLabel16, ResourceBundle.getBundle("messageBundle").getString("settings.completion.cloud.manual.trigger.label"));
        jPanel33.add((Component)jLabel16, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer16 = new Spacer();
        jPanel33.add((Component)spacer16, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JComboBox jComboBox5 = new JComboBox();
        this.manualTriggerLengthComboBox = jComboBox5;
        jPanel33.add(jComboBox5, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.cloudManualShortcutLabel = jLabel2 = new JLabel();
        jLabel2.setText("Label");
        jPanel33.add((Component)jLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel34 = new JPanel();
        jPanel34.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel31.add((Component)jPanel34, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.showInlineCheckBox = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messageBundle").getString("settings.completion.cloud.show.inline"));
        jPanel34.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer17 = new Spacer();
        jPanel34.add((Component)spacer17, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel35 = new JPanel();
        jPanel35.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel31.add((Component)jPanel35, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel36 = new JPanel();
        jPanel36.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel35.add((Component)jPanel36, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel17 = new JLabel();
        this.$$$loadLabelText$$$(jLabel17, ResourceBundle.getBundle("messageBundle").getString("settings.completion.cloud.language.title"));
        jPanel36.add((Component)jLabel17, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer18 = new Spacer();
        jPanel36.add((Component)spacer18, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel18 = new JLabel();
        ((Component)jLabel18).setEnabled(false);
        this.$$$loadLabelText$$$(jLabel18, ResourceBundle.getBundle("messageBundle").getString("settings.completion.cloud.language.description"));
        jPanel36.add((Component)jLabel18, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel37 = new JPanel();
        jPanel37.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel35.add((Component)jPanel37, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JTextField jTextField4 = this.langTriggerTextField;
        jPanel37.add((Component)jTextField4, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(400, -1), new Dimension(400, -1)));
        this.auxiliaryTitleSeparator = titledSeparator = new TitledSeparator();
        titledSeparator.setText(ResourceBundle.getBundle("messageBundle").getString("settings.auxiliary.function"));
        jPanel17.add((Component)titledSeparator, new GridConstraints(7, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.auxiliaryPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 20, 10, 0), -1, -1, false, false));
        jPanel17.add((Component)jPanel5, new GridConstraints(8, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.exceptionPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel19 = new JLabel();
        this.$$$loadLabelText$$$(jLabel19, ResourceBundle.getBundle("messageBundle").getString("settings.exception.assisted.resolution"));
        jPanel4.add((Component)jLabel19, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer19 = new Spacer();
        jPanel4.add((Component)spacer19, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.enableSearchModeRadioButton = jRadioButton8 = new JRadioButton();
        jRadioButton8.setSelected(false);
        this.$$$loadButtonText$$$(jRadioButton8, ResourceBundle.getBundle("messageBundle").getString("settings.exception.use.document.search"));
        jPanel4.add((Component)jRadioButton8, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.enableGenerateModeRadioButton = jRadioButton7 = new JRadioButton();
        jRadioButton7.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton7, ResourceBundle.getBundle("messageBundle").getString("settings.exception.use.generate"));
        jPanel4.add((Component)jRadioButton7, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.methodQuickPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel20 = new JLabel();
        this.$$$loadLabelText$$$(jLabel20, ResourceBundle.getBundle("messageBundle").getString("settings.method.level.quick.operation"));
        jPanel3.add((Component)jLabel20, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer20 = new Spacer();
        jPanel3.add((Component)spacer20, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.enabledMethodQuickOperRadioButton = jRadioButton6 = new JRadioButton();
        jRadioButton6.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton6, ResourceBundle.getBundle("messageBundle").getString("settings.method.level.enabled"));
        jPanel3.add((Component)jRadioButton6, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.disabledMethodQuickOperRadioButton = jRadioButton5 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton5, ResourceBundle.getBundle("messageBundle").getString("settings.method.level.disabled"));
        jPanel3.add((Component)jRadioButton5, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.documentOpenPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel21 = new JLabel();
        this.$$$loadLabelText$$$(jLabel21, ResourceBundle.getBundle("messageBundle").getString("document.default.open.mode"));
        jPanel2.add((Component)jLabel21, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer21 = new Spacer();
        jPanel2.add((Component)spacer21, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.ideaButton = jRadioButton4 = new JRadioButton();
        jRadioButton4.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton4, ResourceBundle.getBundle("messageBundle").getString("open.in.idea"));
        jPanel2.add((Component)jRadioButton4, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.browserButton = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("messageBundle").getString("open.in.browser"));
        jPanel2.add((Component)jRadioButton3, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel38 = new JPanel();
        jPanel38.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel17.add((Component)jPanel38, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.localModelCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messageBundle").getString("settings.completion.enable.local.model"));
        jPanel38.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer22 = new Spacer();
        jPanel38.add((Component)spacer22, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel39 = new JPanel();
        jPanel39.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel17.add((Component)jPanel39, new GridConstraints(5, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.cloudModelCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messageBundle").getString("settings.completion.enable.cloud.model"));
        jPanel39.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer23 = new Spacer();
        jPanel39.add((Component)spacer23, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.loginWarnLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel39.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        TitledSeparator titledSeparator5 = new TitledSeparator();
        titledSeparator5.setText(ResourceBundle.getBundle("messageBundle").getString("settings.update.panel.title"));
        jPanel17.add((Component)titledSeparator5, new GridConstraints(11, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        JPanel jPanel40 = new JPanel();
        jPanel40.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel17.add((Component)jPanel40, new GridConstraints(12, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        Spacer spacer24 = new Spacer();
        jPanel40.add((Component)spacer24, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.autoUpdateCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messageBundle").getString("settings.update.checkbox.auto.update"));
        jPanel40.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel41 = new JPanel();
        jPanel41.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel17.add((Component)jPanel41, new GridConstraints(10, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JPanel jPanel42 = new JPanel();
        jPanel42.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel41.add((Component)jPanel42, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer25 = new Spacer();
        jPanel42.add((Component)spacer25, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.systemProxyConfigurationRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messageBundle").getString("settings.proxy.panel.enable.item.system"));
        jPanel42.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.manualProxyUrlPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel41.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JTextField jTextField5 = this.proxyUrlTextField;
        jTextField5.setToolTipText("");
        jPanel.add((Component)jTextField5, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer26 = new Spacer();
        jPanel.add((Component)spacer26, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel22 = new JLabel();
        this.$$$loadLabelText$$$(jLabel22, ResourceBundle.getBundle("messageBundle").getString("settings.proxy.panel.input"));
        jPanel.add((Component)jLabel22, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel43 = new JPanel();
        jPanel43.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel41.add((Component)jPanel43, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.manualProxyConfigurationRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messageBundle").getString("settings.proxy.panel.enable.item.manual"));
        jPanel43.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer27 = new Spacer();
        jPanel43.add((Component)spacer27, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        TitledSeparator titledSeparator6 = new TitledSeparator();
        titledSeparator6.setText(ResourceBundle.getBundle("messageBundle").getString("settings.proxy.panel.title"));
        jPanel17.add((Component)titledSeparator6, new GridConstraints(9, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        TitledSeparator titledSeparator7 = new TitledSeparator();
        titledSeparator7.setText(ResourceBundle.getBundle("messageBundle").getString("settings.advanced.settings.title"));
        jPanel17.add((Component)titledSeparator7, new GridConstraints(13, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        JPanel jPanel44 = new JPanel();
        jPanel44.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel17.add((Component)jPanel44, new GridConstraints(14, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel45 = new JPanel();
        jPanel45.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel44.add((Component)jPanel45, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel23 = new JLabel();
        this.$$$loadLabelText$$$(jLabel23, ResourceBundle.getBundle("messageBundle").getString("settings.local.storage.path.label"));
        jPanel45.add((Component)jLabel23, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer28 = new Spacer();
        jPanel45.add((Component)spacer28, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.localStoragePathField;
        jPanel45.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 3, null, new Dimension(200, -1), null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton11);
        buttonGroup.add(jRadioButton10);
        buttonGroup.add(jRadioButton9);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton4);
        buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton8);
        buttonGroup.add(jRadioButton7);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton6);
        buttonGroup.add(jRadioButton5);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
        buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    static class KeyValue {
        String key;
        String label;

        public KeyValue(String key) {
            this.key = key;
        }

        public KeyValue(String key, String label) {
            this.key = key;
            this.label = label;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof KeyValue)) {
                return false;
            }
            KeyValue keyValue = (KeyValue)o;
            return Objects.equals(this.key, keyValue.key);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }

        public String toString() {
            return "KeyValue{key='" + this.key + "', label='" + this.label + "'}";
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public String getLabel() {
            return this.label;
        }

        @Generated
        public void setKey(String key) {
            this.key = key;
        }

        @Generated
        public void setLabel(String label) {
            this.label = label;
        }
    }
}

