/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.ui.config;

import com.alibabacloud.intellij.cosy.core.Cosy;
import com.alibabacloud.intellij.cosy.core.CosyStartupAdapter;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthGrantInfo;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.GetGrantInfosParams;
import com.alibabacloud.intellij.cosy.search.asyn.Debouncer;
import com.alibabacloud.intellij.cosy.search.enums.LoginModeEnum;
import com.alibabacloud.intellij.cosy.ui.config.AuthOrgItem;
import com.alibabacloud.intellij.cosy.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.util.ThreadUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang3.StringUtils;

public class ConfigAccessKeyUI {
    private static final Logger LOGGER = Logger.getInstance(ConfigAccessKeyUI.class);
    private static final long FETCH_DELAY_MILLIS = 500L;
    Project project;
    JTextField akTextField;
    JPasswordField skTextField;
    JComboBox<Object> orgIdComboBox;
    JButton akLogInButton;
    String loginMode;
    Debouncer fetchDebouncer = new Debouncer();

    public ConfigAccessKeyUI(Project project, JTextField akTextField, JPasswordField skTextField, JComboBox<Object> orgIdComboBox, JButton akLogInButton, String loginMode) {
        this.project = project;
        this.akTextField = akTextField;
        this.skTextField = skTextField;
        this.orgIdComboBox = orgIdComboBox;
        this.akLogInButton = akLogInButton;
        this.loginMode = loginMode;
    }

    public void setup() {
        this.configTextField(this.akTextField);
        this.configTextField(this.skTextField);
        this.orgIdComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel com = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value == null) {
                    return com;
                }
                if (value instanceof AuthOrgItem) {
                    this.setText(((AuthOrgItem)value).getDisplay());
                    com.setToolTipText(((AuthOrgItem)value).getDisplay());
                } else {
                    this.setText(value.toString());
                    com.setToolTipText(value.toString());
                }
                return com;
            }
        });
    }

    private void configTextField(JTextField textField) {
        if (textField == null) {
            return;
        }
        textField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                ConfigAccessKeyUI.this.fetchOrganizations(ConfigAccessKeyUI.this.project);
            }
        });
        textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ConfigAccessKeyUI.this.orgIdComboBox.setModel(new DefaultComboBoxModel<Object>(new Object[0]));
                ConfigAccessKeyUI.this.checkAkskLoginButtonState();
                ConfigAccessKeyUI.this.fetchDebouncer.debounce(() -> ConfigAccessKeyUI.this.fetchOrganizations(ConfigAccessKeyUI.this.project), 500L, TimeUnit.MILLISECONDS);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ConfigAccessKeyUI.this.orgIdComboBox.setModel(new DefaultComboBoxModel<Object>(new Object[0]));
                ConfigAccessKeyUI.this.checkAkskLoginButtonState();
                ConfigAccessKeyUI.this.fetchDebouncer.debounce(() -> ConfigAccessKeyUI.this.fetchOrganizations(ConfigAccessKeyUI.this.project), 500L, TimeUnit.MILLISECONDS);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ConfigAccessKeyUI.this.orgIdComboBox.setModel(new DefaultComboBoxModel<Object>(new Object[0]));
                ConfigAccessKeyUI.this.checkAkskLoginButtonState();
                ConfigAccessKeyUI.this.fetchDebouncer.debounce(() -> ConfigAccessKeyUI.this.fetchOrganizations(ConfigAccessKeyUI.this.project), 500L, TimeUnit.MILLISECONDS);
            }
        });
    }

    public void checkAkskLoginButtonState() {
        if (LoginModeEnum.PERSONAL_TOKEN.getLabel().equals(this.loginMode)) {
            if (StringUtils.isNotBlank((CharSequence)this.getLoginAccessKey()) && this.orgIdComboBox.getSelectedItem() instanceof AuthOrgItem) {
                this.akLogInButton.setEnabled(true);
            } else {
                this.akLogInButton.setEnabled(false);
            }
        } else if (StringUtils.isNotBlank((CharSequence)this.getLoginAccessKey()) && StringUtils.isNotBlank((CharSequence)this.getLoginSecretKey()) && this.orgIdComboBox.getSelectedItem() instanceof AuthOrgItem) {
            this.akLogInButton.setEnabled(true);
        } else {
            this.akLogInButton.setEnabled(false);
        }
    }

    private void fetchOrganizations(final Project project) {
        if (LoginModeEnum.PERSONAL_TOKEN.getLabel().equals(this.loginMode)) {
            String ak = this.akTextField.getText();
            if (StringUtils.isBlank((CharSequence)ak)) {
                return;
            }
        } else {
            String ak = this.akTextField.getText();
            String sk = null;
            if (this.skTextField.getPassword() != null) {
                sk = new String(this.skTextField.getPassword());
            }
            if (StringUtils.isBlank((CharSequence)ak) || StringUtils.isBlank(sk)) {
                return;
            }
        }
        if (this.orgIdComboBox.getModel() != null && this.orgIdComboBox.getSelectedItem() != null && this.orgIdComboBox.getSelectedItem() instanceof AuthOrgItem) {
            return;
        }
        this.orgIdComboBox.setModel(new DefaultComboBoxModel<Object>(new Object[]{CosyBundle.message("settings.login.label.orgs.loading", new Object[0])}));
        this.orgIdComboBox.setSelectedIndex(0);
        ThreadUtil.execute(() -> {
            CosyStartupAdapter listener = new CosyStartupAdapter(){

                @Override
                public void onStartup() {
                    ConfigAccessKeyUI.this.updateOrgIds(project);
                }
            };
            if (Cosy.INSTANCE.checkCosy(project, true, Collections.singletonList(listener))) {
                this.updateOrgIds(project);
            }
        });
    }

    private void updateOrgIds(Project project) {
        String ak;
        GetGrantInfosParams getGrantInfosParams = null;
        if (LoginModeEnum.PERSONAL_TOKEN.getLabel().equals(this.loginMode)) {
            ak = this.akTextField.getText();
            if (StringUtils.isBlank((CharSequence)ak)) {
                return;
            }
            getGrantInfosParams = new GetGrantInfosParams(ak);
        } else {
            ak = this.akTextField.getText();
            String sk = null;
            if (this.skTextField.getPassword() != null) {
                sk = new String(this.skTextField.getPassword());
            }
            if (StringUtils.isBlank((CharSequence)ak) || StringUtils.isBlank(sk)) {
                return;
            }
            getGrantInfosParams = new GetGrantInfosParams(ak, sk);
        }
        List<AuthGrantInfo> authGrantInfos = Cosy.INSTANCE.getLanguageService(project).getGrantInfos(getGrantInfosParams, 3000L);
        ArrayList<AuthOrgItem> orgIds = new ArrayList<AuthOrgItem>();
        if (authGrantInfos != null && !authGrantInfos.isEmpty()) {
            for (AuthGrantInfo info : authGrantInfos) {
                AuthOrgItem org;
                LOGGER.debug("get login grant info:" + info);
                if ("personal".equals(info.getGrantType())) {
                    org = new AuthOrgItem(info.getUserId(), info.getUserName(), "personal");
                    orgIds.add(org);
                    continue;
                }
                if (!"organization".equals(info.getGrantType())) continue;
                org = new AuthOrgItem(info.getOrgId(), info.getOrgName(), "org");
                orgIds.add(org);
            }
        }
        SwingUtilities.invokeLater(() -> {
            this.orgIdComboBox.setModel(new DefaultComboBoxModel<AuthOrgItem>(orgIds.toArray(new AuthOrgItem[0])));
            if (!orgIds.isEmpty()) {
                this.orgIdComboBox.setSelectedIndex(0);
            } else {
                NotificationFactory.showToast(this.orgIdComboBox, MessageType.ERROR, CosyBundle.messageVpc("notifications.auth.org.list.not.apply", new Object[0]));
            }
            this.checkAkskLoginButtonState();
        });
    }

    public String getLoginAccessKey() {
        return this.akTextField.getText();
    }

    public String getLoginSecretKey() {
        if (this.skTextField.getPassword() != null) {
            return new String(this.skTextField.getPassword());
        }
        return null;
    }
}

