/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibabacloud.intellij.cosy.chat.model.ChatContextFeature;
import com.alibabacloud.intellij.cosy.common.CosyCacheKeys;
import com.alibabacloud.intellij.cosy.core.Cosy;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.CompletionParams;
import com.alibabacloud.intellij.cosy.editor.model.CosyEditorInlayItem;
import com.alibabacloud.intellij.cosy.editor.model.CosyEditorInlayList;
import com.alibabacloud.intellij.cosy.editor.model.InlayDisposeEventEnum;
import com.alibabacloud.intellij.cosy.search.asyn.Debouncer;
import com.alibabacloud.intellij.cosy.search.enums.CompletionTriggerModeEnum;
import com.alibabacloud.intellij.cosy.search.enums.TrackEventTypeEnum;
import com.alibabacloud.intellij.cosy.service.TelemetryService;
import com.alibabacloud.intellij.cosy.service.TelemetryThread;
import com.alibabacloud.intellij.cosy.service.model.Features;
import com.alibabacloud.intellij.cosy.service.model.TextChangeContext;
import com.alibabacloud.intellij.cosy.service.model.TextChangeReportStrategy;
import com.alibabacloud.intellij.cosy.service.model.TextChangeStat;
import com.alibabacloud.intellij.cosy.service.model.TimestampEnum;
import com.alibabacloud.intellij.cosy.service.model.TypingStat;
import com.alibabacloud.intellij.cosy.ui.search.model.ChatAskTag;
import com.alibabacloud.intellij.cosy.ui.search.model.GenerateInput;
import com.alibabacloud.intellij.cosy.util.ChatTaskUtil;
import com.alibabacloud.intellij.cosy.util.LanguageUtil;
import com.alibabacloud.intellij.cosy.util.ProjectUtils;
import com.alibabacloud.intellij.cosy.util.StringUtils;
import com.alibabacloud.intellij.cosy.util.TypingSpeeder;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class TelemetryServiceImpl
implements TelemetryService {
    static Logger logger = Logger.getInstance(TelemetryServiceImpl.class);
    static Set<String> ignoreCommands = new HashSet<String>(Arrays.asList("Async Render Tongyi Suggestion", "Chat Insert Code"));
    private TypingSpeeder typingSpeeder = new TypingSpeeder();
    private AtomicReference<String> lastCommand = new AtomicReference<Object>(null);
    private AtomicReference<String> currentCommand = new AtomicReference<Object>(null);
    private AtomicReference<String> latestDisposeType = new AtomicReference<Object>(null);
    private AtomicReference<String> latestDisposeCommandName = new AtomicReference<Object>(null);
    private AtomicReference<Boolean> lastAccepted = new AtomicReference<Object>(null);
    private AtomicReference<Long> lastAcceptTimeMs = new AtomicReference<Object>(null);
    private AtomicReference<Long> lastDisposeTimeMs = new AtomicReference<Object>(null);
    private AtomicLong lastAcceptTime = new AtomicLong(0L);
    private final Map<String, Timer> timerMap = new ConcurrentHashMap<String, Timer>();
    private Map<String, Debouncer> textChangeDebouncerMap = new ConcurrentHashMap<String, Debouncer>();

    @Override
    public void initTelemetry(Project project) {
        String basePath = ProjectUtils.getProjectBaseDir(project);
        long delayTime = TimeUnit.SECONDS.toMillis(Features.REPORT_TEXT_CHANGE_FIXED_TIME.longValue());
        try {
            logger.info("start telemetry:" + project.getName());
            Timer timer = this.timerMap.computeIfAbsent(basePath, s -> new Timer());
            timer.scheduleAtFixedRate((TimerTask)new TelemetryThread(project), delayTime, delayTime);
        }
        catch (Exception e) {
            logger.warn("Failed to start telemetry thread. and retry", (Throwable)e);
            this.timerMap.remove(basePath);
            Timer timer = this.timerMap.computeIfAbsent(basePath, s -> new Timer());
            timer.scheduleAtFixedRate((TimerTask)new TelemetryThread(project), delayTime, delayTime);
        }
    }

    @Override
    public void destroyTelemetry(Project project) {
        Timer timer;
        String basePath = ProjectUtils.getProjectBaseDir(project);
        if (this.timerMap.containsKey(basePath) && (timer = this.timerMap.remove(basePath)) != null) {
            timer.cancel();
        }
    }

    @Override
    public void telemetry(Project project, TrackEventTypeEnum eventType, String requestId, Map<String, String> data) {
        try {
            if (!Cosy.INSTANCE.checkCosy(project, false)) {
                logger.warn("invalid cosy service, ignore telemetry");
                return;
            }
            logger.debug("send telemetry: " + eventType.getName() + " " + requestId + " " + data);
            Cosy.INSTANCE.getLanguageService(project).telemetry(eventType.getName(), requestId, data);
        }
        catch (Exception e) {
            logger.warn("telemetry error." + e.getMessage());
        }
    }

    @Override
    public void telemetryChatTask(Project project, TrackEventTypeEnum eventType, String requestId, String sessionId, String chatTask, GenerateInput input) {
        List<ChatAskTag> tagList;
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("chatTask", chatTask);
        data.put("sessionId", sessionId);
        if (input.getChatContext() != null && input.getChatContext().getFileLanguage() != null) {
            data.put("language", input.getChatContext().getFileLanguage());
        }
        if (input.getChatAskInput() != null && CollectionUtils.isNotEmpty(tagList = input.getChatAskInput().getTags())) {
            List<ChatContextFeature> features = ChatTaskUtil.getFeatureFromTag(tagList);
            data.put("features", JSON.toJSONString(features));
        }
        this.telemetry(project, eventType, requestId, data);
    }

    @Override
    public void telemetryChatCodeAccept(Project project, TrackEventTypeEnum eventType, String requestId, String sessionId, String chatTask, String content) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("sourceType", chatTask == null ? "" : chatTask);
        data.put("sourceRequestId", requestId == null ? "" : requestId);
        data.put("acceptCharLength", content == null ? "0" : String.valueOf(content.length()));
        data.put("acceptNewLineCount", content == null ? "0" : String.valueOf(content.split("\n").length));
        this.telemetry(project, eventType, requestId, data);
    }

    @Override
    public void telemetrySessionId(Project project, TrackEventTypeEnum eventType, String requestId, String sessionId) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("sessionId", sessionId);
        this.telemetry(project, eventType, requestId, data);
    }

    @Override
    public void triggerCompletion(CompletionTriggerModeEnum triggerMode, Editor editor, CompletionParams params) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("triggerMode", triggerMode.getName());
        data.put("useLocalModel", String.valueOf(params.getUseLocalModel()));
        data.put("useRemoteModel", String.valueOf(params.getUseRemoteModel()));
        TypingStat stat = this.getTypeStat();
        data.put("avgTypingSpeed", String.valueOf(stat.getAvgTypingSpeed()));
        data.put("lastTypingSpeed", String.valueOf(stat.getLastTypingSpeed()));
        data.put("typingLength", String.valueOf(stat.getTypingLength()));
        data.put("lastTypedChars", stat.getLastTypedChars());
        data.put("currentTypedChars", stat.getCurrentTypedChars());
        data.put("typedCharRowDiff", stat.getTypedCharRowDiff() == null ? null : String.valueOf(stat.getTypedCharRowDiff()));
        if (params.getTextDocument() != null) {
            data.put("language", LanguageUtil.getLanguageByFilePath(params.getTextDocument().getUri()));
        }
        this.buildMeasurements(data, null);
        if (params.getCompletionContextParams() != null) {
            data.put("context", JSON.toJSONString((Object)params.getCompletionContextParams()));
        }
        this.telemetry(editor.getProject(), TrackEventTypeEnum.INLINE_COMPLETION_TRIGGER, params.getRequestId(), data);
    }

    @Override
    public void disposeCompletion(InlayDisposeEventEnum disposeAction, Editor editor, CosyEditorInlayList inlayList) {
        this.disposeCompletion(disposeAction, editor, inlayList, null);
    }

    @Override
    public void disposeCompletion(InlayDisposeEventEnum disposeAction, Editor editor, CosyEditorInlayList inlayList, String commandName) {
        if (InlayDisposeEventEnum.GENERATING.getName().equals(disposeAction.getName()) || InlayDisposeEventEnum.ACCEPTED.getName().equals(disposeAction.getName()) || inlayList == null || inlayList.getItems() == null || inlayList.getItems().isEmpty()) {
            return;
        }
        for (CosyEditorInlayItem item : inlayList.getItems()) {
            if (!item.isAccepted()) continue;
            return;
        }
        CosyEditorInlayItem headItem = inlayList.getItems().get(0);
        String batchId = headItem.getRequestId();
        for (int i = 0; i < inlayList.getItems().size(); ++i) {
            CosyEditorInlayItem item = inlayList.getItems().get(i);
            String disposeType = disposeAction.getName();
            if ("".equals(item.getContent())) {
                disposeType = InlayDisposeEventEnum.EMPTY_RESULT.getName();
            }
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("disposeType", disposeType);
            data.put("rendered", String.valueOf(item.isRendered()));
            data.put("totalLineCount", String.valueOf(item.getTotalLineCount()));
            data.put("totalChars", String.valueOf(item.getContent().length()));
            data.put("index", String.valueOf(i));
            if (i == inlayList.getSelectIndex() && InlayDisposeEventEnum.ACCEPTED.getName().equals(disposeAction.getName())) {
                data.put("accepted", "true");
            } else {
                data.put("accepted", "false");
            }
            if (commandName != null) {
                data.put("commandName", commandName);
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)item.getCacheId())) {
                data.put("cacheId", item.getCacheId());
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)item.getBatchId())) {
                batchId = item.getBatchId();
            }
            data.put("batchId", batchId);
            this.buildMeasurements(data, item);
            this.telemetry(editor.getProject(), TrackEventTypeEnum.INLINE_COMPLETION_DISPOSE, item.getRequestId(), data);
        }
        this.latestDisposeType.getAndSet(disposeAction.getName());
        this.latestDisposeCommandName.getAndSet(commandName);
        this.lastAccepted.getAndSet(false);
        this.lastDisposeTimeMs.getAndSet(System.currentTimeMillis());
    }

    @Override
    public void applyCompletion(Editor editor, CosyEditorInlayItem inlayItem, Integer acceptLineCount) {
        this.lastAcceptTime.getAndSet(System.currentTimeMillis());
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("acceptLineCount", String.valueOf(acceptLineCount));
        data.put("totalLineCount", String.valueOf(inlayItem.getTotalLineCount()));
        data.put("totalChars", String.valueOf(inlayItem.getContent().length()));
        data.put("index", String.valueOf(inlayItem.getRankIndex()));
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)inlayItem.getCacheId())) {
            data.put("cacheId", inlayItem.getCacheId());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)inlayItem.getBatchId())) {
            data.put("batchId", inlayItem.getBatchId());
        }
        this.buildMeasurements(data, inlayItem);
        this.telemetry(editor.getProject(), TrackEventTypeEnum.INLINE_COMPLETION_ACCEPT, inlayItem.getRequestId(), data);
        this.lastAccepted.getAndSet(true);
        this.lastAcceptTimeMs.getAndSet(System.currentTimeMillis());
    }

    @Override
    public void typeRecord(Editor editor, String addedText) {
        this.typingSpeeder.keyTyped(addedText);
        this.typingSpeeder.recordTyping(editor, addedText);
    }

    @Override
    public void telemetryCommand(@NotNull CommandEvent event) {
        if (event == null) {
            TelemetryServiceImpl.$$$reportNull$$$0(0);
        }
        if (ignoreCommands.contains(event.getCommandName())) {
            return;
        }
        String lastCmd = this.currentCommand.getAndSet(event.getCommandName());
        this.lastCommand.getAndSet(lastCmd);
    }

    @Override
    public void clearTypeCommandRecord() {
        this.lastCommand.set(null);
        this.currentCommand.set(null);
        this.typingSpeeder.clear();
    }

    @Override
    public TypingStat getTypeStat() {
        TypingStat stat = new TypingStat();
        stat.setAvgTypingSpeed(this.typingSpeeder.getAvgSpeed());
        stat.setLastTypingSpeed(this.typingSpeeder.getLastSpeed());
        stat.setTypingLength(this.typingSpeeder.getTypedLength());
        stat.setLastTypedChars(this.typingSpeeder.getLastTypedChars());
        stat.setCurrentTypedChars(this.typingSpeeder.getCurrentTypedChars());
        stat.setTypedCharRowDiff(this.typingSpeeder.getTypedCharRowDiff());
        return stat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void telemetryTextChange(TextChangeContext context) {
        String addedText = context.getAddedText();
        if (addedText == null || addedText.trim().isEmpty() && addedText.length() > 1) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        Project project = context.getProject();
        String filePath = context.getFilePath();
        Integer startLineNumber = context.getStartLineNumber();
        if (startLineNumber == null) {
            startLineNumber = 0;
        }
        try {
            Key<List<TextChangeStat>> key = CosyCacheKeys.KEY_TEXT_CHANGE_STAT;
            synchronized (key) {
                ArrayList<TextChangeStat> changeStats = (ArrayList<TextChangeStat>)CosyCacheKeys.KEY_TEXT_CHANGE_STAT.get((UserDataHolder)project);
                logger.debug("text change addedText:" + addedText.replace("\n", "\\n"));
                if (changeStats == null) {
                    changeStats = new ArrayList<TextChangeStat>();
                }
                if (addedText.startsWith("\n")) {
                    String clearText = org.apache.commons.lang3.StringUtils.stripStart((String)addedText, (String)"\n");
                    startLineNumber = startLineNumber + (addedText.length() - clearText.length());
                    addedText = org.apache.commons.lang3.StringUtils.stripEnd((String)clearText, (String)"\n");
                }
                TextChangeStat changeStat = new TextChangeStat();
                changeStat.setFilePath(filePath == null ? UUID.randomUUID().toString() : filePath);
                changeStat.setStartLineNumber(startLineNumber);
                long validLineCount = StringUtils.getNotEmptyLineCount(addedText);
                String[] addedLines = addedText.split("\n");
                changeStat.setChangeCharChangeLength(addedText.length());
                changeStat.setChangeNewLineCount(addedLines.length);
                changeStat.setValidNewLineCount(validLineCount);
                changeStat.setAccepted(context.isAccepted());
                changeStat.setTimestamp(timestamp);
                if (context.getLanguage() != null) {
                    changeStat.setLanguage(context.getLanguage().toLowerCase(Locale.ROOT));
                }
                changeStat.setSource(context.getSource());
                if (startLineNumber != null) {
                    changeStat.setChangeLineNumbers(new HashSet<Integer>());
                    int i = 0;
                    while ((long)i < validLineCount) {
                        changeStat.getChangeLineNumbers().add(startLineNumber + i);
                        ++i;
                    }
                }
                logger.debug("text change stat:" + changeStat);
                changeStats.add(changeStat);
                CosyCacheKeys.KEY_TEXT_CHANGE_STAT.set((UserDataHolder)project, changeStats);
            }
            String basePath = ProjectUtils.getProjectBaseDir(project);
            if (TextChangeReportStrategy.DELAY.getValue().equals(Features.REPORT_TEXT_CHANGE_STRATEGY.stringValue())) {
                Debouncer textChangeDebouncer = this.textChangeDebouncerMap.computeIfAbsent(basePath, s -> new Debouncer());
                textChangeDebouncer.debounce(() -> this.flushTelemetryTextChange(project), Features.REPORT_TEXT_CHANGE_DELAY_TIME.longValue(), TimeUnit.SECONDS);
            }
            Map<String, Timer> map = this.timerMap;
            synchronized (map) {
                if (!this.timerMap.containsKey(basePath)) {
                    this.initTelemetry(project);
                }
            }
        }
        catch (Exception e) {
            logger.warn("telemetryTextChange error", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushTelemetryTextChange(Project project) {
        logger.debug("flush telemetry text change");
        HashMap<String, String> data = new HashMap<String, String>();
        Key<List<TextChangeStat>> key = CosyCacheKeys.KEY_TEXT_CHANGE_STAT;
        synchronized (key) {
            List stats = (List)CosyCacheKeys.KEY_TEXT_CHANGE_STAT.get((UserDataHolder)project);
            if (stats != null && !stats.isEmpty()) {
                Map<String, List> statMap = stats.stream().collect(Collectors.groupingBy(e -> String.format("%s|%s", e.getFilePath(), e.getLanguage()), Collectors.collectingAndThen(Collectors.toList(), list -> {
                    list.sort(Comparator.comparing(TextChangeStat::getTimestamp));
                    return list;
                })));
                long mergeAcceptCharLength = 0L;
                long mergeTotalCharLength = 0L;
                long mergeAcceptNewLineCount = 0L;
                long mergeTotalNewLineCount = 0L;
                long mergeStartTimestamp = 0L;
                long mergeEndTimestamp = 0L;
                ArrayList statDataList = new ArrayList();
                for (Map.Entry<String, List> entry : statMap.entrySet()) {
                    long acceptCharLength = 0L;
                    long totalCharLength = 0L;
                    long acceptNewLineCount = 0L;
                    long totalNewLineCount = 0L;
                    HashMap<String, String> statData = new HashMap<String, String>();
                    List statList = entry.getValue();
                    long lineNumber = -1L;
                    long curValidLineCount = 0L;
                    boolean acceptCurrentLine = false;
                    long startTimestamp = 0L;
                    long endTimestamp = 0L;
                    for (TextChangeStat stat : statList) {
                        boolean statLine = true;
                        if (stat.getStartLineNumber() != null && lineNumber == (long)stat.getStartLineNumber().intValue() && curValidLineCount > 0L) {
                            statLine = false;
                        }
                        if (stat.getValidNewLineCount() == 1L) {
                            if (statLine) {
                                if (stat.isAccepted()) {
                                    acceptNewLineCount += stat.getValidNewLineCount();
                                }
                                totalNewLineCount += stat.getValidNewLineCount();
                            } else if (!acceptCurrentLine && stat.isAccepted()) {
                                acceptCurrentLine = true;
                                acceptNewLineCount += stat.getValidNewLineCount();
                            }
                        } else if (stat.getValidNewLineCount() > 1L) {
                            if (statLine) {
                                if (stat.isAccepted()) {
                                    acceptNewLineCount += stat.getValidNewLineCount();
                                }
                                totalNewLineCount += stat.getValidNewLineCount();
                            } else {
                                if (stat.isAccepted()) {
                                    acceptNewLineCount = !acceptCurrentLine ? (acceptNewLineCount += stat.getValidNewLineCount()) : (acceptNewLineCount += stat.getValidNewLineCount() - 1L);
                                }
                                totalNewLineCount += stat.getValidNewLineCount() - 1L;
                            }
                        }
                        if (stat.isAccepted()) {
                            acceptCharLength += stat.getChangeCharChangeLength();
                        }
                        totalCharLength += stat.getChangeCharChangeLength();
                        if (stat.getLanguage() != null) {
                            statData.put("language", stat.getLanguage());
                        }
                        if (stat.getSource() != null) {
                            statData.put("source", stat.getSource());
                        }
                        if (stat.getStartLineNumber() == null || stat.getChangeNewLineCount() > 1L) {
                            lineNumber = -1L;
                            acceptCurrentLine = false;
                            curValidLineCount = 0L;
                        } else {
                            if (lineNumber != (long)stat.getStartLineNumber().intValue()) {
                                acceptCurrentLine = false;
                                curValidLineCount = 0L;
                            }
                            if (stat.isAccepted()) {
                                acceptCurrentLine = true;
                            }
                            lineNumber = stat.getStartLineNumber().intValue();
                            curValidLineCount += stat.getValidNewLineCount();
                        }
                        if (startTimestamp == 0L || endTimestamp == 0L) {
                            startTimestamp = stat.getTimestamp();
                            endTimestamp = stat.getTimestamp();
                            continue;
                        }
                        startTimestamp = Math.min(startTimestamp, stat.getTimestamp());
                        endTimestamp = Math.max(endTimestamp, stat.getTimestamp());
                    }
                    if (acceptNewLineCount > totalNewLineCount) {
                        totalNewLineCount = acceptNewLineCount;
                    }
                    mergeTotalNewLineCount += totalNewLineCount;
                    mergeTotalCharLength += totalCharLength;
                    mergeAcceptNewLineCount += acceptNewLineCount;
                    mergeAcceptCharLength += acceptCharLength;
                    if (mergeStartTimestamp == 0L || mergeEndTimestamp == 0L) {
                        mergeStartTimestamp = startTimestamp;
                        mergeEndTimestamp = endTimestamp;
                    } else {
                        mergeStartTimestamp = Math.min(mergeStartTimestamp, startTimestamp);
                        mergeEndTimestamp = Math.max(mergeEndTimestamp, endTimestamp);
                    }
                    statData.put("acceptNewLineCount", String.valueOf(acceptNewLineCount));
                    statData.put("acceptCharLength", String.valueOf(acceptCharLength));
                    statData.put("totalNewLineCount", String.valueOf(totalNewLineCount));
                    statData.put("totalCharLength", String.valueOf(totalCharLength));
                    statData.put("startTimestamp", String.valueOf(startTimestamp));
                    statData.put("endTimestamp", String.valueOf(endTimestamp));
                    statDataList.add(statData);
                }
                data.put("acceptNewLineCount", String.valueOf(mergeAcceptNewLineCount));
                data.put("acceptCharLength", String.valueOf(mergeAcceptCharLength));
                data.put("totalNewLineCount", String.valueOf(mergeTotalNewLineCount));
                data.put("totalCharLength", String.valueOf(mergeTotalCharLength));
                data.put("startTimestamp", String.valueOf(mergeStartTimestamp));
                data.put("endTimestamp", String.valueOf(mergeEndTimestamp));
                data.put("details", JSON.toJSONString(statDataList));
                CosyCacheKeys.KEY_TEXT_CHANGE_STAT.set((UserDataHolder)project, null);
            }
        }
        if (!data.isEmpty()) {
            this.telemetry(project, TrackEventTypeEnum.TEXT_CHANGE, UUID.randomUUID().toString(), data);
        }
    }

    @Override
    public void updateTimestamp(String type, long timestamp) {
        if (TimestampEnum.ACCEPT_TIMESTAMP_TYPE.getType().equals(type)) {
            this.lastAcceptTime.getAndSet(timestamp);
        }
    }

    @Override
    public long getTimestamp(String type) {
        if (TimestampEnum.ACCEPT_TIMESTAMP_TYPE.getType().equals(type)) {
            return this.lastAcceptTime.get();
        }
        return 0L;
    }

    @Override
    public void telemetryGenerateCommitMsg(Project project, TrackEventTypeEnum eventType, String requestId) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("request_id", requestId);
        data.put("agent_id", "commit_message");
        this.telemetry(project, eventType, requestId, data);
    }

    private void buildMeasurements(Map<String, String> data, CosyEditorInlayItem item) {
        data.put("measurementLastCommand", this.lastCommand.get());
        data.put("measurementCurrentCommand", this.currentCommand.get());
        data.put("measurementLatestDisposeType", this.latestDisposeType.get());
        data.put("measurementLatestDisposeCommand", this.latestDisposeCommandName.get());
        if (this.lastAccepted.get() != null) {
            data.put("measurementLastAccepted", String.valueOf(this.lastAccepted.get()));
        }
        if (this.lastAcceptTimeMs.get() != null && this.lastAcceptTimeMs.get() > 0L) {
            data.put("measurementLastAcceptTimeMs", String.valueOf(System.currentTimeMillis() - this.lastAcceptTimeMs.get()));
        }
        if (this.lastDisposeTimeMs.get() != null && this.lastDisposeTimeMs.get() > 0L) {
            data.put("measurementLastDisposeTimeMs", String.valueOf(System.currentTimeMillis() - this.lastDisposeTimeMs.get()));
        }
        if (item == null) {
            return;
        }
        data.put("measurementFirstTimeSinceDisplayedMillis", String.valueOf(System.currentTimeMillis() - item.getFirstDisplayTimeMs()));
        data.put("measurementTimeSinceDisplayedMillis", String.valueOf(System.currentTimeMillis() - item.getDisplayTimeMs()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/alibabacloud/intellij/cosy/service/impl/TelemetryServiceImpl", "telemetryCommand"));
    }
}

