/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.service.impl;

import com.alibabacloud.intellij.cosy.chat.model.BadFeedbackParam;
import com.alibabacloud.intellij.cosy.chat.model.ChatAskParam;
import com.alibabacloud.intellij.cosy.chat.model.ChatLikeParam;
import com.alibabacloud.intellij.cosy.chat.model.ChatReplyRequestParam;
import com.alibabacloud.intellij.cosy.chat.model.ChatStopParam;
import com.alibabacloud.intellij.cosy.chat.model.ChatSystemEventParam;
import com.alibabacloud.intellij.cosy.chat.model.result.ChatAskResult;
import com.alibabacloud.intellij.cosy.chat.model.result.ChatLikeResult;
import com.alibabacloud.intellij.cosy.chat.model.result.ChatReplyListResult;
import com.alibabacloud.intellij.cosy.chat.model.result.ChatSystemEventResult;
import com.alibabacloud.intellij.cosy.constants.CosyKey;
import com.alibabacloud.intellij.cosy.core.Cosy;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.FeedbackResult;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.RecommendResult;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.SearchParams;
import com.alibabacloud.intellij.cosy.search.result.SearchValue;
import com.alibabacloud.intellij.cosy.search.util.StringCheckUtil;
import com.alibabacloud.intellij.cosy.service.CosyService;
import com.alibabacloud.intellij.cosy.ui.search.I18NConstant;
import com.alibabacloud.intellij.cosy.ui.search.enums.MethodEnum;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.sun.istack.NotNull;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CosyServiceImpl
implements CosyService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CosyServiceImpl.class);

    @Override
    public RecommendResult searchCode(@NotNull Project project, String query, Set<SearchValue> searchValueList, int page, String actionType, String lastRequestId, List<String> sources) {
        SearchParams searchParams;
        if (!Cosy.INSTANCE.checkCosy(project)) {
            RecommendResult result = new RecommendResult();
            result.setRequestId("DEFAULT");
            result.setErrMsg(I18NConstant.NO_COSY_ERROR);
            return result;
        }
        if (StringUtils.isNotBlank((CharSequence)query)) {
            searchParams = new SearchParams(MethodEnum.NLP_SEARCH, page, 10);
            searchParams.setQuery(query);
        } else {
            searchParams = new SearchParams(MethodEnum.SEARCH, page, 10);
        }
        ArrayList<String> keywords = new ArrayList<String>();
        for (SearchValue searchValue : searchValueList) {
            keywords.add(searchValue.getPack());
        }
        searchParams.setKeywords(keywords);
        searchParams.setSources(sources);
        searchParams.setActionType(actionType);
        if (lastRequestId != null) {
            searchParams.setLastRequestId(lastRequestId);
        }
        if (Cosy.INSTANCE.getLanguageService(project) == null) {
            log.warn("Cosy language service not available.");
            return null;
        }
        return Cosy.INSTANCE.getLanguageService(project).search(searchParams, 10000L);
    }

    @Override
    public RecommendResult searchQA(@NotNull Project project, String query, Set<SearchValue> searchValueList, int page, String actionType, String lastRequestId, List<String> sources) {
        if (!Cosy.INSTANCE.checkCosy(project)) {
            RecommendResult result = new RecommendResult();
            result.setRequestId("DEFAULT");
            result.setErrMsg(I18NConstant.NO_COSY_ERROR);
            return result;
        }
        SearchParams searchParams = new SearchParams(MethodEnum.CODE_DOC_SEARCH, page, 10);
        ArrayList<String> keywords = new ArrayList<String>();
        for (SearchValue searchValue : searchValueList) {
            keywords.add(searchValue.getPack());
        }
        searchParams.setKeywords(keywords);
        searchParams.setSources(sources);
        if (StringUtils.isNotBlank((CharSequence)query)) {
            searchParams.setQuery(query);
        }
        searchParams.setActionType(actionType);
        if (lastRequestId != null) {
            searchParams.setLastRequestId(lastRequestId);
        }
        if (Cosy.INSTANCE.getLanguageService(project) == null) {
            return null;
        }
        return Cosy.INSTANCE.getLanguageService(project).search(searchParams, 10000L);
    }

    @Override
    public RecommendResult searchQAContent(Project project, String docId, String searchAction) {
        if (!Cosy.INSTANCE.checkCosy(project)) {
            return null;
        }
        SearchParams searchParams = new SearchParams(MethodEnum.CODE_DOC_SEARCH);
        searchParams.setActionType(searchAction);
        searchParams.setDocId(docId);
        searchParams.setPageSize(100);
        if (Cosy.INSTANCE.getLanguageService(project) == null) {
            return null;
        }
        return Cosy.INSTANCE.getLanguageService(project).search(searchParams, 10000L);
    }

    @Override
    public RecommendResult suggestCode(@NotNull Project project, String keyword) {
        if (!Cosy.INSTANCE.checkCosy(project)) {
            return null;
        }
        SearchParams searchParams = keyword.contains(" ") || StringCheckUtil.containChinese(keyword) ? new SearchParams(MethodEnum.SUGGESTION, 10) : new SearchParams(MethodEnum.SUGGESTION, 30);
        searchParams.setQuery(keyword);
        RecommendResult recommendResult = Cosy.INSTANCE.getLanguageService(project).search(searchParams, 10000L);
        return recommendResult;
    }

    @Override
    public ChatAskResult chatAsk(@NotNull Project project, ChatAskParam chatAskParam) {
        Set<String> requestIdSet;
        if (!Cosy.INSTANCE.checkCosy(project)) {
            return null;
        }
        if (ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_PROJECT) == null) {
            ApplicationManager.getApplication().putUserData(CosyKey.REQUEST_TO_PROJECT, new ConcurrentHashMap());
        }
        if (ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_ANSWER_LIST) == null) {
            ApplicationManager.getApplication().putUserData(CosyKey.REQUEST_TO_ANSWER_LIST, new ConcurrentHashMap());
        }
        if (ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_ANSWERING) == null) {
            ApplicationManager.getApplication().putUserData(CosyKey.REQUEST_ANSWERING, new ConcurrentHashMap());
        }
        if (CollectionUtils.isNotEmpty(requestIdSet = CosyKey.PROJECT_TO_REQUEST.get(project.getName()))) {
            for (String requestId : requestIdSet) {
                Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_PROJECT)).remove(requestId);
                Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_ANSWER_LIST)).remove(requestId);
                Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_ANSWERING)).remove(requestId);
            }
            CosyKey.PROJECT_TO_REQUEST.get(project.getName()).clear();
        }
        Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_PROJECT)).put(chatAskParam.getRequestId(), project);
        CosyKey.PROJECT_TO_REQUEST.computeIfAbsent(project.getName(), k -> new HashSet());
        CosyKey.PROJECT_TO_REQUEST.get(project.getName()).add(chatAskParam.getRequestId());
        log.info("Start asking. task=" + chatAskParam.getChatTask() + ", sessionId=" + chatAskParam.getSessionId() + ", requestId=" + chatAskParam.getRequestId());
        return Cosy.INSTANCE.getLanguageService(project).chatAsk(chatAskParam, 10000L);
    }

    @Override
    public ChatReplyListResult chatReplyList(Project project, ChatReplyRequestParam chatReplyRequestParam) {
        if (!Cosy.INSTANCE.checkCosy(project)) {
            return null;
        }
        ChatReplyListResult chatReplyListResult = Cosy.INSTANCE.getLanguageService(project).chatReplyRequest(chatReplyRequestParam, 10000L);
        log.info("Get chat reply list. count=" + (chatReplyListResult.getDisplayTasks() == null ? 0 : chatReplyListResult.getDisplayTasks().size()) + ", requestId=" + chatReplyListResult.getRequestId());
        return chatReplyListResult;
    }

    @Override
    public ChatLikeResult chatLike(Project project, ChatLikeParam chatLikeParam) {
        if (!Cosy.INSTANCE.checkCosy(project)) {
            return null;
        }
        log.info("Chat like. like=" + chatLikeParam.getLike() + ", requestId=" + chatLikeParam.getRequestId());
        return Cosy.INSTANCE.getLanguageService(project).chatLike(chatLikeParam, 10000L);
    }

    @Override
    public void chatStop(Project project, ChatStopParam chatStopParam) {
        if (!Cosy.INSTANCE.checkCosy(project)) {
            return;
        }
        log.info("Chat stop. sessionId=" + chatStopParam.getSessionId() + ", requestId=" + chatStopParam.getRequestId());
        Cosy.INSTANCE.getLanguageService(project).chatStop(chatStopParam);
    }

    @Override
    public ChatSystemEventResult chatSystemEvent(Project project, ChatSystemEventParam chatSystemEventParam) {
        if (!Cosy.INSTANCE.checkCosy(project)) {
            return null;
        }
        log.info("Chat system event. event=" + chatSystemEventParam.getSystemEvent() + ", sessionId=" + chatSystemEventParam.getSessionId() + ", requestId=" + chatSystemEventParam.getRequestId());
        return Cosy.INSTANCE.getLanguageService(project).chatSystemEvent(chatSystemEventParam, 10000L);
    }

    @Override
    public FeedbackResult submitFeedback(Project project, BadFeedbackParam badFeedbackParam) {
        if (!Cosy.INSTANCE.checkCosy(project)) {
            return null;
        }
        if (badFeedbackParam == null || project == null) {
            log.error("project or badFeedbackParam is null");
            return null;
        }
        log.info("submit feedback. sessionId=" + badFeedbackParam.getSessionId() + ", requestId=" + badFeedbackParam.getRequestId());
        return Cosy.INSTANCE.getLanguageService(project).submitFeedback(badFeedbackParam, 10000L);
    }
}

