/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.service.impl;

import com.alibabacloud.intellij.cosy.common.CosySetting;
import com.alibabacloud.intellij.cosy.core.Cosy;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.ChangeUserSettingParams;
import com.alibabacloud.intellij.cosy.search.asyn.TrackThreadService;
import com.alibabacloud.intellij.cosy.search.enums.TrackEventTypeEnum;
import com.alibabacloud.intellij.cosy.service.ConfigService;
import com.alibabacloud.intellij.cosy.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.cosy.ui.search.track.ReportStatistic;
import com.alibabacloud.intellij.cosy.ui.statusbar.CosyStatusBarWidget;
import com.alibabacloud.intellij.cosy.util.ApplicationUtil;
import com.alibabacloud.intellij.cosy.util.ThreadUtil;
import com.intellij.openapi.project.Project;

public class ConfigServiceImpl
implements ConfigService {
    TrackThreadService trackThreadService = new TrackThreadService();

    @Override
    public void configCloudCompletionSwitch(Project project, boolean enable) {
        CosySetting setting = CosyPersistentSetting.getInstance().getState();
        if (setting != null) {
            ChangeUserSettingParams params = setting.getParameter();
            if (enable) {
                params.getCloud().setEnable(enable);
            }
            params.getCloud().getAutoTrigger().setEnable(enable);
            CosyStatusBarWidget.updateStatusBar(null, project);
            if (Cosy.INSTANCE.checkCosy(project)) {
                Cosy.INSTANCE.updateConfig(params);
            }
        }
    }

    @Override
    public void configLocalCompletionSwitch(Project project, boolean enable) {
        CosySetting setting = CosyPersistentSetting.getInstance().getState();
        if (setting != null) {
            if (enable) {
                setting.setManualOpenLocalModel(true);
            }
            ChangeUserSettingParams params = setting.getParameter();
            params.getLocal().setEnable(enable);
            CosyStatusBarWidget.updateStatusBar(null, project);
            if (Cosy.INSTANCE.checkCosy(project)) {
                Cosy.INSTANCE.updateConfig(params);
                ThreadUtil.execute(() -> {
                    ReportStatistic reportStatistic = new ReportStatistic(0L, TrackEventTypeEnum.CODE_COMPLETION_SWITCH.getName(), "", 0, 0, 0, enable ? "enabled" : "disabled");
                    this.trackThreadService.execute(project, reportStatistic);
                    if (!enable) {
                        ThreadUtil.sleep(1000L);
                        ApplicationUtil.killCosyProcess();
                        ThreadUtil.sleep(1000L);
                        Cosy.INSTANCE.checkCosy(project);
                    }
                });
            }
        }
    }
}

