/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.service.handler;

import com.alibabacloud.intellij.cosy.service.handler.MergeFileHandler;
import com.alibabacloud.intellij.cosy.util.Md5Util;
import com.alibabacloud.intellij.cosy.util.PsiUtils;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.ArrayList;

public class JavaMergeFileHandler
extends MergeFileHandler {
    @Override
    public String merge(Project project, PsiFile oldFile, PsiFile newFile) {
        PsiElement[] newPsiElements;
        PsiJavaFile oldPsiJavaFile = null;
        PsiJavaFile newPsiJavaFile = null;
        if (oldFile instanceof PsiJavaFile && newFile instanceof PsiJavaFile) {
            oldPsiJavaFile = (PsiJavaFile)oldFile;
            newPsiJavaFile = (PsiJavaFile)newFile;
        }
        if (null == oldPsiJavaFile) {
            return null;
        }
        PsiElement[] oldPsiElements = oldPsiJavaFile.getChildren();
        ArrayList<String> importList = new ArrayList<String>();
        ArrayList<String> fieldList = new ArrayList<String>();
        ArrayList<String> methodContentMD5s = new ArrayList<String>();
        for (PsiElement oldPsiElement : oldPsiElements) {
            int n;
            PsiImportStatement[] importStatements;
            if (oldPsiElement instanceof PsiImportList) {
                PsiImportList psiImportList = (PsiImportList)oldPsiElement;
                PsiImportStatement[] psiImportStatementArray = importStatements = psiImportList.getImportStatements();
                n = psiImportStatementArray.length;
                for (int i = 0; i < n; ++i) {
                    PsiImportStatement importStatement = psiImportStatementArray[i];
                    importList.add(importStatement.getQualifiedName());
                }
                continue;
            }
            if (oldPsiElement instanceof PsiField) {
                PsiField psiField = (PsiField)oldPsiElement;
                fieldList.add(String.format("%s-%s", psiField.getType().getPresentableText(), psiField.getName()));
                continue;
            }
            if (!(oldPsiElement instanceof PsiClass)) continue;
            PsiElement[] psiClass = (PsiElement[])oldPsiElement;
            importStatements = psiClass.getChildren();
            int n2 = importStatements.length;
            for (n = 0; n < n2; ++n) {
                PsiImportStatement classChild = importStatements[n];
                if (!(classChild instanceof PsiMethod)) continue;
                PsiMethod psiMethod = (PsiMethod)classChild;
                methodContentMD5s.add(Md5Util.encode(psiMethod.getText().trim().getBytes()));
            }
        }
        ArrayList<PsiImportStatement> importListToAdd = new ArrayList<PsiImportStatement>();
        ArrayList<PsiField> fieldListToAdd = new ArrayList<PsiField>();
        ArrayList<PsiMethod> methodsToAdd = new ArrayList<PsiMethod>();
        for (PsiElement newPsiElement : newPsiElements = newPsiJavaFile.getChildren()) {
            if (newPsiElement instanceof PsiImportList) {
                PsiImportStatement[] importStatements;
                PsiImportList psiImportList = (PsiImportList)newPsiElement;
                PsiImportStatement[] psiImportStatementArray = importStatements = psiImportList.getImportStatements();
                int n = psiImportStatementArray.length;
                for (int i = 0; i < n; ++i) {
                    PsiImportStatement importStatement = psiImportStatementArray[i];
                    if (importList.contains(importStatement.getQualifiedName())) continue;
                    importListToAdd.add(importStatement);
                }
                continue;
            }
            if (!(newPsiElement instanceof PsiClass)) continue;
            PsiClass newPsiClass = (PsiClass)newPsiElement;
            for (PsiElement classChild : newPsiClass.getChildren()) {
                PsiField psiField;
                if (classChild instanceof PsiMethod) {
                    PsiMethod psiMethod = (PsiMethod)classChild;
                    if (methodContentMD5s.contains(Md5Util.encode(psiMethod.getText().trim().getBytes()))) continue;
                    methodsToAdd.add(psiMethod);
                    continue;
                }
                if (!(classChild instanceof PsiField) || fieldList.contains(String.format("%s-%s", (psiField = (PsiField)classChild).getType().getPresentableText(), psiField.getName()))) continue;
                fieldListToAdd.add(psiField);
            }
        }
        PsiElement lastImportStatement = oldPsiElements[0];
        PsiElement lastFieldStatement = null;
        PsiElement lastMethodStatement = null;
        for (PsiElement oldPsiElement : oldPsiElements) {
            if (oldPsiElement instanceof PsiPackageStatement) {
                lastImportStatement = oldPsiElement;
            }
            if (oldPsiElement instanceof PsiImportList) {
                PsiImportList psiImportList = (PsiImportList)oldPsiElement;
                PsiImportStatement[] importStatements = psiImportList.getImportStatements();
                if (importStatements.length <= 0) continue;
                lastImportStatement = importStatements[importStatements.length - 1];
                continue;
            }
            if (!(oldPsiElement instanceof PsiClass)) continue;
            PsiClass psiClass = (PsiClass)oldPsiElement;
            for (PsiElement classChild : psiClass.getChildren()) {
                if (classChild instanceof PsiMethod) {
                    PsiMethod psiMethod = (PsiMethod)classChild;
                    if (lastFieldStatement == null) {
                        lastFieldStatement = PsiUtils.findPrevAtOffset((PsiFile)oldPsiJavaFile, psiMethod.getTextRange().getStartOffset(), PsiWhiteSpace.class);
                    }
                    lastMethodStatement = psiMethod;
                    continue;
                }
                if (!(classChild instanceof PsiField)) continue;
                PsiField psiField = (PsiField)classChild;
                lastFieldStatement = psiField;
                if (lastMethodStatement != null) continue;
                lastMethodStatement = PsiUtils.findNextAtOffset((PsiFile)oldPsiJavaFile, psiField.getTextRange().getEndOffset(), PsiWhiteSpace.class);
            }
        }
        for (PsiImportStatement psiImportStatement : importListToAdd) {
            if (oldPsiJavaFile.getImportList() != null) {
                oldPsiJavaFile.getImportList().add((PsiElement)psiImportStatement);
                continue;
            }
            lastImportStatement = lastImportStatement.add((PsiElement)psiImportStatement);
        }
        PsiClass[] theClassArray = oldPsiJavaFile.getClasses();
        PsiClass theClass = null;
        if (theClassArray.length > 0) {
            theClass = theClassArray[0];
        }
        if (lastMethodStatement != null) {
            for (PsiMethod psiMethod : methodsToAdd) {
                if (theClass != null) {
                    try {
                        theClass.add((PsiElement)psiMethod);
                    }
                    catch (IndexNotReadyException e) {
                        lastMethodStatement = lastMethodStatement.add((PsiElement)psiMethod);
                    }
                    continue;
                }
                lastMethodStatement = lastMethodStatement.add((PsiElement)psiMethod);
            }
        }
        if (lastFieldStatement != null) {
            for (PsiField psiField : fieldListToAdd) {
                if (theClass != null) {
                    try {
                        theClass.add((PsiElement)psiField);
                    }
                    catch (IndexNotReadyException e) {
                        lastFieldStatement = lastFieldStatement.add((PsiElement)psiField);
                    }
                    continue;
                }
                lastFieldStatement = lastFieldStatement.add((PsiElement)psiField);
            }
        }
        return CodeStyleManager.getInstance((Project)project).reformat((PsiElement)oldPsiJavaFile).getText();
    }
}

