/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.search.util;

import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.Tag;

public class JsoupUtil {
    public static String truncateHTML(String content, int len) {
        Document dirtyDocument = Jsoup.parse((String)content);
        Element source = dirtyDocument.body();
        Document clean = Document.createShell((String)dirtyDocument.baseUri());
        Element dest = clean.body();
        JsoupUtil.truncateHTML(source, dest, len);
        return dest.outerHtml().replace("<body>", "").replace("</body>", "");
    }

    private static void truncateHTML(Element source, Element dest, int len) {
        List sourceChildren = source.childNodes();
        for (Node sourceChild : sourceChildren) {
            if (sourceChild instanceof Element) {
                Element sourceEl = (Element)sourceChild;
                Element destChild = JsoupUtil.createSafeElement(sourceEl);
                int txt = dest.text().length();
                if (txt >= len) break;
                dest.appendChild((Node)destChild);
                JsoupUtil.truncateHTML(sourceEl, destChild, len -= txt);
                continue;
            }
            if (!(sourceChild instanceof TextNode)) continue;
            int destLeng = dest.text().length();
            if (destLeng >= len) break;
            TextNode sourceText = (TextNode)sourceChild;
            int txtLength = sourceText.getWholeText().length();
            if (destLeng + txtLength > len) {
                int tmp = len - destLeng;
                String txt = sourceText.getWholeText().substring(0, tmp) + "...";
                TextNode destText = new TextNode(txt);
                dest.appendChild((Node)destText);
                break;
            }
            TextNode destText = new TextNode(sourceText.getWholeText());
            dest.appendChild((Node)destText);
        }
    }

    private static Element createSafeElement(Element sourceEl) {
        String sourceTag = sourceEl.tagName();
        Attributes destAttrs = new Attributes();
        Element dest = new Element(Tag.valueOf((String)sourceTag), sourceEl.baseUri(), destAttrs);
        Attributes sourceAttrs = sourceEl.attributes();
        for (Attribute sourceAttr : sourceAttrs) {
            destAttrs.put(sourceAttr);
        }
        return dest;
    }
}

