/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.search.ui;

import com.intellij.ide.ui.laf.darcula.ui.DarculaTabbedPaneUI;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;

public class WrapTabbedPaneUI
extends DarculaTabbedPaneUI {
    private static final JBValue OFFSET = new JBValue.Float(1.0f);

    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        if (1 != tabPlacement && 3 != tabPlacement) {
            return super.calculateTabWidth(tabPlacement, tabIndex, metrics);
        }
        Insets insets = this.tabPane.getInsets();
        if (this.tabPane.getTabCount() == 0) {
            return this.tabPane.getSize().width - insets.left - insets.right;
        }
        Dimension dimension = this.tabPane.getSize();
        int padding = this.tabPane.getInsets().left + this.tabPane.getInsets().right;
        int remainingWidth = dimension.width - padding;
        return (int)Math.floor((double)remainingWidth * 1.0 / (double)this.tabPane.getTabCount());
    }

    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        if (2 != tabPlacement && 4 != tabPlacement) {
            return super.calculateTabHeight(tabPlacement, tabIndex, fontHeight);
        }
        Insets insets = this.tabPane.getInsets();
        if (this.tabPane.getTabCount() == 0) {
            return this.tabPane.getSize().height - insets.top - insets.bottom;
        }
        Dimension dimension = this.tabPane.getSize();
        int padding = insets.top + this.tabPane.getInsets().bottom;
        int remainHeight = dimension.height - padding;
        return (int)Math.floor((double)remainHeight * 1.0 / (double)this.tabPane.getTabCount());
    }

    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (isSelected) {
            g.setColor(this.tabPane.isEnabled() ? JBUI.CurrentTheme.TabbedPane.ENABLED_SELECTED_COLOR : JBUI.CurrentTheme.TabbedPane.DISABLED_SELECTED_COLOR);
            boolean wrap = this.tabPane.getTabLayoutPolicy() == 0;
            switch (tabPlacement) {
                default: {
                    int normalWidth = super.calculateTabWidth(tabPlacement, tabIndex, this.getFontMetrics());
                    int hPadding = (int)((double)(w - normalWidth) / 2.0);
                    int offset = JBUI.CurrentTheme.TabbedPane.SELECTION_HEIGHT.get() - (wrap ? OFFSET.get() : 0);
                    g.fillRect(x + hPadding, y + h - offset, normalWidth, JBUI.CurrentTheme.TabbedPane.SELECTION_HEIGHT.get());
                    break;
                }
                case 2: {
                    int normalHeight = super.calculateTabHeight(tabPlacement, tabIndex, this.getFontMetrics().getHeight());
                    int vPadding = (int)((double)(h - normalHeight) / 2.0);
                    int offset = JBUI.CurrentTheme.TabbedPane.SELECTION_HEIGHT.get() - (wrap ? OFFSET.get() : 0);
                    g.fillRect(x + w - offset, y + vPadding, JBUI.CurrentTheme.TabbedPane.SELECTION_HEIGHT.get(), normalHeight);
                    break;
                }
                case 3: {
                    int normalWidth = super.calculateTabWidth(tabPlacement, tabIndex, this.getFontMetrics());
                    int hPadding = (int)((double)(w - normalWidth) / 2.0);
                    int offset = wrap ? OFFSET.get() : 0;
                    g.fillRect(x + hPadding, y - offset, normalWidth, JBUI.CurrentTheme.TabbedPane.SELECTION_HEIGHT.get());
                    break;
                }
                case 4: {
                    int normalHeight = super.calculateTabHeight(tabPlacement, tabIndex, this.getFontMetrics().getHeight());
                    int vPadding = (int)((double)(h - normalHeight) / 2.0);
                    int offset = wrap ? OFFSET.get() : 0;
                    g.fillRect(x - offset, y + vPadding, JBUI.CurrentTheme.TabbedPane.SELECTION_HEIGHT.get(), normalHeight);
                }
            }
        }
    }
}

