/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.search.ui;

import com.intellij.ide.ui.laf.darcula.ui.DarculaProgressBarUI;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.UIUtilities;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;

public class ColorProgressBarUI
extends DarculaProgressBarUI {
    private static final Color START_COLOR = new JBColor(new Color(255, 130, 0), new Color(255, 130, 0));
    private static final Color END_COLOR = new JBColor(new Color(56, 139, 217), new Color(56, 139, 217));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintIndeterminate(Graphics g, JComponent c) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            Shape shape;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            Rectangle r = new Rectangle(this.progressBar.getSize());
            if (c.isOpaque()) {
                g2.setColor(c.getParent().getBackground());
                g2.fill(r);
            }
            Insets i = this.progressBar.getInsets();
            JBInsets.removeFrom((Rectangle)r, (Insets)i);
            int orientation = this.progressBar.getOrientation();
            Color startColor = START_COLOR;
            Color endColor = END_COLOR;
            int pHeight = this.progressBar.getPreferredSize().height;
            int pWidth = this.progressBar.getPreferredSize().width;
            int yOffset = r.y + (r.height - pHeight) / 2;
            int xOffset = r.x + (r.width - pWidth) / 2;
            int step = JBUIScale.scale((int)6);
            if (orientation == 0) {
                shape = this.getShapedRect(r.x, yOffset, r.width, pHeight, pHeight);
                yOffset = r.y + pHeight / 2;
                g2.setPaint(new GradientPaint(r.x + this.getAnimationIndex() * step * 2, yOffset, startColor, r.x + this.getFrameCount() * step + this.getAnimationIndex() * step * 2, yOffset, endColor, true));
            } else {
                shape = this.getShapedRect(xOffset, r.y, pWidth, r.height, pWidth);
                xOffset = r.x + pWidth / 2;
                g2.setPaint(new GradientPaint(xOffset, r.y + this.getAnimationIndex() * step * 2, startColor, xOffset, r.y + this.getFrameCount() * step + this.getAnimationIndex() * step * 2, endColor, true));
            }
            g2.fill(shape);
            if (this.progressBar.isStringPainted()) {
                if (this.progressBar.getOrientation() == 0) {
                    this.paintString((Graphics2D)g, i.left, i.top, r.width, r.height, this.boxRect.x, this.boxRect.width);
                } else {
                    this.paintString((Graphics2D)g, i.left, i.top, r.width, r.height, this.boxRect.y, this.boxRect.height);
                }
            }
        }
        finally {
            g2.dispose();
        }
    }

    private void paintString(Graphics2D g, int x, int y, int w, int h, int fillStart, int amountFull) {
        String progressString = this.progressBar.getString();
        g.setFont(this.progressBar.getFont());
        Point renderLocation = this.getStringPlacement(g, progressString, x, y, w, h);
        Rectangle oldClip = g.getClipBounds();
        g.setColor(this.getSelectionBackground());
        if (this.progressBar.getOrientation() == 0) {
            UIUtilities.drawString((JComponent)this.progressBar, (Graphics)g, (String)progressString, (int)renderLocation.x, (int)renderLocation.y);
            g.setColor(this.getSelectionForeground());
            g.clipRect(fillStart, y, amountFull, h);
        } else {
            AffineTransform rotate = AffineTransform.getRotateInstance(1.5707963267948966);
            g.setFont(this.progressBar.getFont().deriveFont(rotate));
            renderLocation = this.getStringPlacement(g, progressString, x, y, w, h);
            UIUtilities.drawString((JComponent)this.progressBar, (Graphics)g, (String)progressString, (int)renderLocation.x, (int)renderLocation.y);
            g.setColor(this.getSelectionForeground());
            g.clipRect(x, fillStart, w, amountFull);
        }
        UIUtilities.drawString((JComponent)this.progressBar, (Graphics)g, (String)progressString, (int)renderLocation.x, (int)renderLocation.y);
        g.setClip(oldClip);
    }

    private Shape getShapedRect(float x, float y, float w, float h, float ar) {
        boolean flatEnds = UIUtil.isUnderWin10LookAndFeel() || this.progressBar.getClientProperty("ProgressBar.flatEnds") == Boolean.TRUE;
        return flatEnds ? new Rectangle2D.Float(x, y, w, h) : new RoundRectangle2D.Float(x, y, w, h, ar, ar);
    }
}

