/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.search.action;

import com.alibabacloud.intellij.cosy.search.enums.SearchActionTypeEnum;
import com.alibabacloud.intellij.cosy.search.enums.SearchValueTypeEnum;
import com.alibabacloud.intellij.cosy.search.result.SearchContext;
import com.alibabacloud.intellij.cosy.search.result.SearchValue;
import com.alibabacloud.intellij.cosy.search.util.PsiElementParser;
import com.alibabacloud.intellij.cosy.ui.search.I18NConstant;
import com.alibabacloud.intellij.cosy.ui.search.SearchToolWindowFactory;
import com.alibabacloud.intellij.cosy.ui.search.enums.OperationEnum;
import com.alibabacloud.intellij.cosy.ui.search.topic.AnySearchNotifier;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeSearchIntentionAction
extends BaseIntentionAction
implements LowPriorityAction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CodeSearchIntentionAction.class);

    @NotNull
    public String getText() {
        String string = I18NConstant.SEARCH_ACTION_NAME;
        if (string == null) {
            CodeSearchIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        return "CodeSearchIntentionAction";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @Nullable PsiFile psiFile) {
        if (project == null) {
            CodeSearchIntentionAction.$$$reportNull$$$0(1);
        }
        if (psiFile == null) {
            return false;
        }
        PsiModifierListOwner owner = CodeSearchIntentionAction.getContainer(psiFile, editor.getCaretModel().getOffset(), true);
        if (owner == null) {
            return false;
        }
        return this.isApplicable((PsiElement)owner);
    }

    public static PsiModifierListOwner getContainer(PsiFile file, int offset, boolean availableOnReference) {
        PsiElement id;
        PsiModifierListOwner listOwner;
        PsiElement target;
        PsiReference reference;
        PsiReference psiReference = reference = availableOnReference ? file.findReferenceAt(offset) : null;
        if (reference != null) {
            target = reference.resolve();
            if (target instanceof PsiMember) {
                return (PsiMember)target;
            }
            if (target instanceof PsiVariable) {
                return (PsiVariable)target;
            }
        }
        if ((listOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)(target = file.findElementAt(offset)), PsiModifierListOwner.class, (boolean)false)) instanceof PsiParameter) {
            return listOwner;
        }
        if (listOwner instanceof PsiNameIdentifierOwner && (id = ((PsiNameIdentifierOwner)listOwner).getNameIdentifier()) != null && id.getTextRange().containsOffset(offset)) {
            return listOwner;
        }
        return null;
    }

    public boolean isApplicable(PsiElement psiElement) {
        return psiElement instanceof PsiVariable || psiElement instanceof PsiClass || psiElement instanceof PsiMethod;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            CodeSearchIntentionAction.$$$reportNull$$$0(2);
        }
        if (psiFile == null) {
            CodeSearchIntentionAction.$$$reportNull$$$0(3);
        }
        try {
            SearchValue searchValue;
            PsiModifierListOwner owner = CodeSearchIntentionAction.getContainer(psiFile, editor.getCaretModel().getOffset(), true);
            PsiElement original = owner.getOriginalElement();
            Object psiElement = this.isApplicable(original) ? original : owner;
            PsiElementParser psiElementParser = new PsiElementParser();
            String itemClass = psiElementParser.resolveClass((PsiElement)psiElement);
            log.info("The class of psiElement {} is {}.", (Object)psiElement.toString(), (Object)itemClass);
            String text = psiElement.toString().split(":")[1];
            if (psiElement instanceof PsiVariable) {
                text = ((PsiVariable)psiElement).getType().getPresentableText();
            }
            ActionsKt.runInEdt((ModalityState)ModalityState.any(), () -> {
                SearchToolWindowFactory.showToolWindow(project);
                return null;
            });
            if (psiElement instanceof PsiClass) {
                searchValue = new SearchValue(itemClass, text, SearchValueTypeEnum.CLASS.getType());
            } else if (psiElement instanceof PsiMethod) {
                if (itemClass != null) {
                    if (((PsiMethod)psiElement).isConstructor()) {
                        searchValue = new SearchValue(itemClass, text, SearchValueTypeEnum.METHOD.getType());
                    } else {
                        String[] itemClassList = itemClass.split("\\.");
                        searchValue = new SearchValue(itemClass + "." + text, itemClassList[itemClassList.length - 1] + "." + text, SearchValueTypeEnum.METHOD.getType());
                    }
                } else {
                    searchValue = new SearchValue("", text, SearchValueTypeEnum.METHOD.getType());
                }
            } else {
                searchValue = psiElement instanceof PsiVariable ? new SearchValue(itemClass, text, SearchValueTypeEnum.CLASS.getType()) : new SearchValue("", text, null);
            }
            SearchContext context = new SearchContext(OperationEnum.CLEAR_AND_ADD.text, SearchActionTypeEnum.INTENTION_CLICK_TRIGGER.getType());
            ((AnySearchNotifier)project.getMessageBus().syncPublisher(AnySearchNotifier.ANY_SEARCH_NOTIFICATION)).anySearch(context, searchValue);
        }
        catch (Exception exception) {
            log.info("CodeSearchIntentionAction error : {} ", (Object)exception.getMessage());
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/alibabacloud/intellij/cosy/search/action/CodeSearchIntentionAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/alibabacloud/intellij/cosy/search/action/CodeSearchIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

