/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.listener;

import com.alibabacloud.intellij.cosy.LingmaApplication;
import com.alibabacloud.intellij.cosy.completion.template.TemplateSettingLoader;
import com.alibabacloud.intellij.cosy.constants.CosyKey;
import com.alibabacloud.intellij.cosy.core.Cosy;
import com.alibabacloud.intellij.cosy.service.TelemetryService;
import com.alibabacloud.intellij.cosy.shared.cache.TrieCacheManager;
import com.alibabacloud.intellij.cosy.util.ProjectUtils;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManagerListener;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CosyProjectManagerListener
implements ProjectManagerListener {
    private static final Logger log = Logger.getInstance(CosyProjectManagerListener.class);
    public static final String TEMPLATE_LOADING_KEY = "TEMPLATE_LOADING_KEY";
    private Map<String, Timer> timerMap = new ConcurrentHashMap<String, Timer>();

    public void projectOpened(@NotNull Project project) {
        if (project == null) {
            CosyProjectManagerListener.$$$reportNull$$$0(0);
        }
        LingmaApplication.init();
        Cosy.INSTANCE.start(project);
        PropertiesComponent storage = PropertiesComponent.getInstance((Project)project);
        storage.unsetValue("PROJECT_CLASS_LOADING_KEY");
        TelemetryService.getInstance().initTelemetry(project);
        TemplateSettingLoader.getInstance().run();
    }

    public void projectClosing(@NotNull Project project) {
        if (project == null) {
            CosyProjectManagerListener.$$$reportNull$$$0(1);
        }
        log.info("Closing cosy...");
        TelemetryService.getInstance().destroyTelemetry(project);
        Cosy.INSTANCE.close(project);
        TrieCacheManager.getProjectClassTrieCache().clear();
        ProjectUtils.updateProjectClassCacheState(project, Boolean.FALSE);
    }

    private void cleanCacheData(Project project) {
        @Nullable Map cacheData = (Map)ApplicationManager.getApplication().getUserData(CosyKey.fileVariableKey);
        if (cacheData != null && cacheData.containsKey(project.getLocationHash())) {
            cacheData.remove(project.getLocationHash());
            ApplicationManager.getApplication().putUserData(CosyKey.fileVariableKey, (Object)cacheData);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/alibabacloud/intellij/cosy/listener/CosyProjectManagerListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "projectOpened";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "projectClosing";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

