/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.listener;

import com.alibabacloud.intellij.cosy.common.CosySetting;
import com.alibabacloud.intellij.cosy.editor.CosyInlayManager;
import com.alibabacloud.intellij.cosy.editor.model.CompletionTriggerConfig;
import com.alibabacloud.intellij.cosy.editor.model.InlayDisposeEventEnum;
import com.alibabacloud.intellij.cosy.editor.model.InlayTriggerEventEnum;
import com.alibabacloud.intellij.cosy.search.enums.CompletionTriggerModeEnum;
import com.alibabacloud.intellij.cosy.service.TelemetryService;
import com.alibabacloud.intellij.cosy.service.model.TimestampEnum;
import com.alibabacloud.intellij.cosy.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.cosy.util.EditorUtil;
import com.alibabacloud.intellij.cosy.util.PsiUtils;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupManagerListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class CosyLookupManagerListener
implements LookupManagerListener {
    private static final Logger LOGGER = Logger.getInstance(CosyLookupManagerListener.class);
    private static final long LAST_ACCEPTED_TIME = 200L;

    public void activeLookupChanged(@Nullable Lookup oldLookup, @Nullable Lookup newLookup) {
        boolean isShowInline;
        PsiFile psiFile = this.getFile(oldLookup, newLookup);
        CosySetting settings = CosyPersistentSetting.getInstance().getState();
        boolean bl = isShowInline = settings != null && settings.getParameter() != null && settings.getParameter().getCloud().isShowInlineWhenIDECompletion();
        if (isShowInline) {
            return;
        }
        if (psiFile != null && !CosyPersistentSetting.getInstance().isEnableCloudCompletion(settings, CompletionTriggerModeEnum.AUTO)) {
            return;
        }
        if (oldLookup != null && newLookup == null) {
            Editor editor;
            LOGGER.debug("active lookup changed, lookup closed");
            PsiFile file = oldLookup.getPsiFile();
            if (file != null && EditorUtil.isSelectedEditor(editor = oldLookup.getEditor()) && CosyInlayManager.getInstance().isAvailable(editor) && EditorUtil.isAvailableLanguage(editor) && System.currentTimeMillis() - TelemetryService.getInstance().getTimestamp(TimestampEnum.ACCEPT_TIMESTAMP_TYPE.getType()) > 200L && !CosyInlayManager.getInstance().hasCompletionInlays(editor)) {
                if (CosyInlayManager.getInstance().hasCompletionInlays(editor)) {
                    CosyInlayManager.getInstance().disposeInlays(editor, InlayDisposeEventEnum.POPUP_COMPLETION_FINISHED);
                }
                SwingUtilities.invokeLater(() -> {
                    if (this.isValidTriggerPosition(editor)) {
                        CosyInlayManager.getInstance().editorChanged(CompletionTriggerConfig.lineLevelConfig(InlayTriggerEventEnum.LOOKUP_FINISHED), editor, CompletionTriggerModeEnum.AUTO);
                    }
                });
            }
        } else if (newLookup != null && oldLookup == null) {
            LOGGER.debug("active lookup changed, lookup open");
            Editor editor = newLookup.getEditor();
            if (CosyInlayManager.getInstance().isAvailable(editor)) {
                CosyInlayManager.getInstance().cancelCompletion(editor);
            }
        }
    }

    private PsiFile getFile(@Nullable Lookup oldLookup, @Nullable Lookup newLookup) {
        Lookup validLookup = newLookup != null ? newLookup : oldLookup;
        return validLookup != null ? validLookup.getPsiFile() : null;
    }

    private boolean isValidTriggerPosition(Editor editor) {
        char prefixChar;
        if (editor == null || editor.getDocument().isInBulkUpdate() || editor.getCaretModel().getCaretCount() > 1) {
            return false;
        }
        if (!PsiUtils.checkCaretAround(editor)) {
            LOGGER.debug("invalid caret around, ignore trigger");
            return false;
        }
        if (PsiUtils.isImportElement(null, editor)) {
            LOGGER.debug("ignore trigger import statement");
            return false;
        }
        int caretOffset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        int lineIndex = document.getLineNumber(caretOffset);
        TextRange lineSuffixRange = TextRange.create((int)caretOffset, (int)document.getLineEndOffset(lineIndex));
        String lineSuffix = document.getText(lineSuffixRange).trim();
        TextRange linePrefixRange = TextRange.create((int)document.getLineStartOffset(lineIndex), (int)caretOffset);
        String linePrefix = document.getText(linePrefixRange).trim();
        if (StringUtils.isNotBlank((CharSequence)lineSuffix) && StringUtils.isNotBlank((CharSequence)linePrefix) && (lineSuffix.charAt(0) == ')' || lineSuffix.charAt(0) == ']' || lineSuffix.charAt(0) == '=') && ((prefixChar = linePrefix.charAt(linePrefix.length() - 1)) >= 'a' && prefixChar <= 'z' || prefixChar >= 'A' && prefixChar <= 'Z' || prefixChar >= '0' && prefixChar <= '9' || prefixChar == '_' || prefixChar == ')')) {
            LOGGER.debug("invalid bracket char around caret, ignore trigger");
            return false;
        }
        return true;
    }
}

