/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.listener;

import com.alibabacloud.intellij.cosy.common.CosyCacheKeys;
import com.alibabacloud.intellij.cosy.completion.model.CosyCompletionItem;
import com.alibabacloud.intellij.cosy.core.Cosy;
import com.alibabacloud.intellij.cosy.editor.CosyInlayManager;
import com.alibabacloud.intellij.cosy.editor.model.InlayDisposeEventEnum;
import com.alibabacloud.intellij.cosy.service.TelemetryService;
import com.alibabacloud.intellij.cosy.service.model.TextChangeContext;
import com.alibabacloud.intellij.cosy.util.CompletionUtil;
import com.alibabacloud.intellij.cosy.util.EditorUtil;
import com.alibabacloud.intellij.cosy.util.LanguageUtil;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.UserDataHolder;
import org.eclipse.lsp4j.Command;
import org.jetbrains.annotations.NotNull;

public class CosyLookupListener
implements LookupListener {
    private static final Logger log = Logger.getInstance(CosyLookupListener.class);
    private static CosyLookupListener instance;

    private CosyLookupListener() {
    }

    public static CosyLookupListener getInstance() {
        if (instance == null) {
            instance = new CosyLookupListener();
        }
        return instance;
    }

    public void itemSelected(@NotNull LookupEvent event) {
        if (event == null) {
            CosyLookupListener.$$$reportNull$$$0(0);
        }
        if (event.isCanceledExplicitly()) {
            return;
        }
        if (event.getItem() != null && event.getItem().getObject() instanceof CosyCompletionItem) {
            CosyCompletionItem item = (CosyCompletionItem)event.getItem().getObject();
            Command command = item.getOriginItem().getCommand();
            log.debug(String.format("Item is %s, cmd is %s", item.getOriginItem().getLabel(), command.toString()));
            ApplicationManager.getApplication().invokeLater(() -> {
                if (event.getLookup() != null && event.getLookup().getProject() != null && Cosy.INSTANCE.getLanguageService(event.getLookup().getProject()) != null) {
                    Cosy.INSTANCE.getLanguageService(event.getLookup().getProject()).itemSelected(item);
                }
            });
            int startLineNumber = event.getLookup().getEditor().getCaretModel().getLogicalPosition().line;
            String content = CompletionUtil.getCompletionText(item.getOriginItem());
            content = content.replace("$0", "");
            String filePath = EditorUtil.getEditorFilePath(event.getLookup().getEditor());
            CosyCacheKeys.KEY_SELECT_LOOKUP_ITEM.set((UserDataHolder)event.getLookup().getEditor(), (Object)content);
            TelemetryService.getInstance().telemetryTextChange(new TextChangeContext(event.getLookup().getProject(), filePath, content, startLineNumber, true, LanguageUtil.getLanguageByFilePath(filePath), "completion"));
            CosyInlayManager.getInstance().disposeInlays(event.getLookup().getEditor(), InlayDisposeEventEnum.SELECT_COSY_POPUP_COMPLETION);
        } else if (event.getItem() != null) {
            CosyCacheKeys.KEY_SELECT_LOOKUP_ITEM.set((UserDataHolder)event.getLookup().getEditor(), null);
            CosyInlayManager.getInstance().disposeInlays(event.getLookup().getEditor(), InlayDisposeEventEnum.SELECT_POPUP_COMPLETION);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/alibabacloud/intellij/cosy/listener/CosyLookupListener", "itemSelected"));
    }
}

