/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.listener;

import com.alibabacloud.intellij.cosy.editor.CosyInlayManager;
import com.alibabacloud.intellij.cosy.editor.model.CompletionTriggerConfig;
import com.alibabacloud.intellij.cosy.editor.model.InlayDisposeEventEnum;
import com.alibabacloud.intellij.cosy.editor.model.InlayTriggerEventEnum;
import com.alibabacloud.intellij.cosy.search.enums.CompletionTriggerModeEnum;
import com.alibabacloud.intellij.cosy.util.CompletionUtil;
import com.alibabacloud.intellij.cosy.util.EditorUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.event.BulkAwareDocumentListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class CosyDocumentListener
implements BulkAwareDocumentListener {
    private static Logger LOGGER = Logger.getInstance(CosyDocumentListener.class);
    @NotNull
    private final Editor editor;

    public CosyDocumentListener(@NotNull Editor editor) {
        if (editor == null) {
            CosyDocumentListener.$$$reportNull$$$0(0);
        }
        this.editor = editor;
    }

    public void documentChangedNonBulk(@NotNull DocumentEvent event) {
        Project project;
        if (event == null) {
            CosyDocumentListener.$$$reportNull$$$0(1);
        }
        if ((project = this.editor.getProject()) == null || project.isDisposed()) {
            return;
        }
        if (!EditorUtil.isSelectedEditor(this.editor)) {
            return;
        }
        if (!CosyInlayManager.getInstance().isAvailable(this.editor)) {
            return;
        }
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        if (commandProcessor.isUndoTransparentActionInProgress()) {
            return;
        }
        if (commandProcessor.getCurrentCommandName() != null) {
            return;
        }
        int changeOffset = event.getOffset() + event.getNewLength();
        if (this.editor.getCaretModel().getOffset() != changeOffset) {
            return;
        }
        if (!EditorUtil.isAvailableLanguage(this.editor)) {
            return;
        }
        int offset = event.getOffset() + event.getNewLength();
        if (this.isIgnoreChange(event, this.editor, offset)) {
            CosyInlayManager.getInstance().disposeInlays(this.editor, InlayDisposeEventEnum.DOCUMENT_CHANGE);
        } else {
            CosyInlayManager.getInstance().editorChanged(CompletionTriggerConfig.defaultConfig(InlayTriggerEventEnum.DOCUMENT_CHANGE), this.editor, changeOffset, CompletionTriggerModeEnum.AUTO);
        }
    }

    private boolean isIgnoreChange(DocumentEvent event, Editor editor, int offset) {
        Document document = event.getDocument();
        if (event.getNewLength() < 1) {
            return true;
        }
        if (!editor.getEditorKind().equals((Object)EditorKind.MAIN_EDITOR) && !ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        if (!EditorModificationUtil.checkModificationAllowed((Editor)editor) || document.getRangeGuard(offset, offset) != null) {
            document.fireReadOnlyModificationAttempt();
            return true;
        }
        return !CompletionUtil.isValidDocumentChange(document, offset, event.getOffset());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/alibabacloud/intellij/cosy/listener/CosyDocumentListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "documentChangedNonBulk";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

