/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.listener;

import com.alibabacloud.intellij.cosy.common.CosyCacheKeys;
import com.alibabacloud.intellij.cosy.common.CosySetting;
import com.alibabacloud.intellij.cosy.completion.model.CosyCompletionItem;
import com.alibabacloud.intellij.cosy.completion.template.TemplateSettingLoader;
import com.alibabacloud.intellij.cosy.constants.TongyiCommands;
import com.alibabacloud.intellij.cosy.editor.CosyInlayManager;
import com.alibabacloud.intellij.cosy.editor.model.CompletionTriggerConfig;
import com.alibabacloud.intellij.cosy.editor.model.InlayDisposeEventEnum;
import com.alibabacloud.intellij.cosy.editor.model.InlayTriggerEventEnum;
import com.alibabacloud.intellij.cosy.service.TelemetryService;
import com.alibabacloud.intellij.cosy.service.model.Features;
import com.alibabacloud.intellij.cosy.service.model.TextChangeContext;
import com.alibabacloud.intellij.cosy.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.cosy.util.CompletionUtil;
import com.alibabacloud.intellij.cosy.util.DocumentUtils;
import com.alibabacloud.intellij.cosy.util.EditorUtil;
import com.alibabacloud.intellij.cosy.util.LanguageUtil;
import com.alibabacloud.intellij.cosy.util.PsiUtils;
import com.alibabacloud.intellij.cosy.util.StringUtils;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class CosyCommandListener
implements CommandListener {
    private static final Logger LOG = Logger.getInstance(CosyCommandListener.class);
    private static final List<String> skipCommands = Arrays.asList("Undo", "Backspace", "Paste", "Redo", "Copy", "\u64a4\u6d88\u7c98\u8d34", "\u9000\u683c", "\u7c98\u8d34", "\u91cd\u505a\u7c98\u8d34", "\u590d\u5236");
    private static final Set<String> TEXT_CHANGE_COMMANDS = Set.of("Paste", "\u7c98\u8d34", "\u91cd\u505a\u7c98\u8d34", "Typing", "\u8f93\u5165", "Choose Lookup Item", "\u9009\u62e9\u67e5\u8be2\u6761\u76ee", "\u9009\u62e9\u67e5\u8be2\u9879");
    private static final Set<String> PASTE_COMMANDS = Set.of("Paste", "\u7c98\u8d34", "\u91cd\u505a\u7c98\u8d34");
    private static final Set<String> SELECT_LOOKUP_COMMANDS = Set.of("Choose Lookup Item", "\u9009\u62e9\u67e5\u8be2\u6761\u76ee", "\u9009\u62e9\u67e5\u8be2\u9879");
    private static final Set<String> LEFT_BRACKET_CHARS = Set.of("{", "(");
    private static final Set<String> RIGHT_BRACKET_CHARS = Set.of("}", ")");
    private static final Set<String> ALLOW_COMMANDS = Set.of("Typing", "\u8f93\u5165");
    private static final List<String> ignoreCommands = Arrays.asList("Apply Tongyi Inline Suggestion", "Async Render Tongyi Suggestion", "Chat Insert Code");
    private final Project project;
    private final AtomicInteger activeCommands;
    private final AtomicBoolean startedWithEditor;
    private final AtomicReference<UndoTransparentActionState> undoTransparentActionStamp;

    public CosyCommandListener(@NotNull Project project) {
        if (project == null) {
            CosyCommandListener.$$$reportNull$$$0(0);
        }
        this.activeCommands = new AtomicInteger();
        this.startedWithEditor = new AtomicBoolean(false);
        this.undoTransparentActionStamp = new AtomicReference();
        this.project = project;
    }

    public void commandStarted(@NotNull CommandEvent event) {
        if (event == null) {
            CosyCommandListener.$$$reportNull$$$0(1);
        }
        if (this.activeCommands.getAndIncrement() > 0) {
            LOG.info("Skipping nested commandStarted. Event: " + event);
            return;
        }
        Editor editor = EditorUtil.getSelectedEditorSafely(this.project);
        if (editor != null) {
            this.startedWithEditor.set(true);
            CosyCacheKeys.COMMAND_STATE_KEY.set((UserDataHolder)editor, (Object)CosyCommandListener.createCommandState(editor));
        } else {
            this.startedWithEditor.set(false);
        }
    }

    public void commandFinished(@NotNull CommandEvent event) {
        TemplateManager templateManager;
        if (event == null) {
            CosyCommandListener.$$$reportNull$$$0(2);
        }
        if (this.activeCommands.decrementAndGet() > 0) {
            LOG.info("Skipping nested commandFinished. Event: " + event);
            return;
        }
        if (!this.startedWithEditor.get() || event.getCommandName() == null) {
            return;
        }
        Editor editor = EditorUtil.getSelectedEditorSafely(this.project);
        if (editor == null) {
            LOG.debug("invalid editor from project:" + this.project);
            return;
        }
        Document document = event.getDocument();
        if (document == null) {
            document = editor.getDocument();
        }
        if (!DocumentUtils.isValidEditorDocument(document)) {
            LOG.debug("invalid document:" + document);
            return;
        }
        CosyInlayManager editorManager = CosyInlayManager.getInstance();
        if (!editorManager.isAvailable(editor) || editor.getCaretModel().getCaretCount() > 1 || !EditorUtil.isAvailableLanguage(editor)) {
            return;
        }
        if (!EditorUtil.isActiveProjectEditor(editor)) {
            return;
        }
        CommandEditorState commandStartState = (CommandEditorState)CosyCacheKeys.COMMAND_STATE_KEY.get((UserDataHolder)editor);
        if (commandStartState != null) {
            CommandEditorState commandEndState = CosyCommandListener.createCommandState(editor);
            this.recordTextChange(editor, event, commandStartState, commandEndState);
        }
        if ((templateManager = TemplateManager.getInstance((Project)this.project)).getActiveTemplate(editor) != null) {
            LOG.debug("Skipping template completion. Event: " + event.getCommandName());
            editorManager.disposeInlays(editor, InlayDisposeEventEnum.LIVE_TEMPLATE, event.getCommandName());
            return;
        }
        if (commandStartState != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)commandStartState.getSelectionText())) {
            return;
        }
        String commandName = event.getCommandName().toLowerCase(Locale.ROOT);
        if (ignoreCommands.contains(event.getCommandName()) || commandName.contains("tongyi") || TongyiCommands.ALL_TONGYI_COMMANDS.contains(event.getCommandName())) {
            return;
        }
        if (event.getCommandName() != null && this.isSkipCommand(event.getCommandName())) {
            LOG.debug("Skipping invalid command. Event: " + event.getCommandName());
            editor.getDocument().putUserData(CosyCacheKeys.KEY_LAST_CHANGE_TEXT, null);
            editorManager.disposeInlays(editor, InlayDisposeEventEnum.CHANGE_COMMAND, event.getCommandName());
            return;
        }
        if (commandStartState != null) {
            CommandEditorState commandEndState = CosyCommandListener.createCommandState(editor);
            this.recordType(editor, event, commandStartState, commandEndState);
            if (!"".equals(event.getCommandName()) && LOG.isDebugEnabled()) {
                LOG.debug("document command: " + event.getCommandName());
            }
            boolean needTrggier = false;
            if (ALLOW_COMMANDS.contains(event.getCommandName())) {
                needTrggier = true;
            } else if (this.triggerWhenLookup(editor)) {
                needTrggier = true;
            }
            if (needTrggier && this.isDocumentModified(editor, commandStartState, commandEndState) && !this.isCompletionTemplate(editor)) {
                editorManager.editorChanged(CompletionTriggerConfig.defaultConfig(InlayTriggerEventEnum.TYPING), editor);
            } else if (CosyCommandListener.isCaretPositionChange(commandStartState, commandEndState)) {
                editorManager.disposeInlays(editor, InlayDisposeEventEnum.CHANGE_CARET, event.getCommandName());
            } else {
                editorManager.cancelCompletion(editor);
            }
        }
    }

    private boolean triggerWhenLookup(@NotNull Editor editor) {
        if (editor == null) {
            CosyCommandListener.$$$reportNull$$$0(3);
        }
        boolean needTrggier = false;
        LookupEx activeLookup = LookupManager.getActiveLookup((Editor)editor);
        if (activeLookup != null) {
            CosySetting settings = CosyPersistentSetting.getInstance().getState();
            if (settings != null && settings.getParameter() != null && settings.getParameter().getCloud().isShowInlineWhenIDECompletion()) {
                needTrggier = true;
            } else {
                List items = activeLookup.getItems();
                if (!items.isEmpty()) {
                    int validCount = 0;
                    for (LookupElement item : items) {
                        if (item.getObject() instanceof CosyCompletionItem || item.getClass().getName().contains("LookupElementDecorator$InsertingDecorator")) continue;
                        ++validCount;
                    }
                    if (validCount == 0) {
                        needTrggier = true;
                    }
                }
            }
        }
        return needTrggier;
    }

    private boolean isSkipCommand(String commandName) {
        boolean skip = skipCommands.stream().anyMatch(commandName::contains);
        if (!skip && commandName.toLowerCase(Locale.ROOT).contains("vim")) {
            skip = true;
        }
        return skip;
    }

    public void undoTransparentActionStarted() {
        Editor editor = EditorUtil.getSelectedEditorSafely(this.project);
        this.undoTransparentActionStamp.set(editor != null ? CosyCommandListener.createUndoTransparentState(editor) : null);
    }

    public void undoTransparentActionFinished() {
    }

    private static long getDocumentStamp(@NotNull Document document) {
        if (document == null) {
            CosyCommandListener.$$$reportNull$$$0(4);
        }
        if (document instanceof DocumentEx) {
            return ((DocumentEx)document).getModificationSequence();
        }
        return document.getModificationStamp();
    }

    @NotNull
    private static CommandEditorState createCommandState(@NotNull Editor editor) {
        if (editor == null) {
            CosyCommandListener.$$$reportNull$$$0(5);
        }
        int offset = editor.getCaretModel().getOffset();
        int line = editor.getDocument().getLineNumber(offset);
        int lineStartOffset = editor.getDocument().getLineStartOffset(line);
        int lineEndOffset = editor.getDocument().getLineEndOffset(line);
        String linePrefix = editor.getDocument().getText(new TextRange(lineStartOffset, offset));
        String lineSuffix = editor.getDocument().getText(new TextRange(offset, lineEndOffset));
        return new CommandEditorState(CosyCommandListener.getDocumentStamp(editor.getDocument()), editor.getCaretModel().getVisualPosition(), linePrefix, lineSuffix, editor.getSelectionModel().getSelectedText(), editor.getCaretModel().getOffset());
    }

    @NotNull
    private static UndoTransparentActionState createUndoTransparentState(@NotNull Editor editor) {
        if (editor == null) {
            CosyCommandListener.$$$reportNull$$$0(6);
        }
        return new UndoTransparentActionState(editor, CosyCommandListener.getDocumentStamp(editor.getDocument()));
    }

    private boolean isDocumentModified(@NotNull Editor editor, @NotNull CommandEditorState first, @NotNull CommandEditorState second) {
        if (editor == null) {
            CosyCommandListener.$$$reportNull$$$0(7);
        }
        if (first == null) {
            CosyCommandListener.$$$reportNull$$$0(8);
        }
        if (second == null) {
            CosyCommandListener.$$$reportNull$$$0(9);
        }
        if (first.modificationStamp == second.modificationStamp) {
            return false;
        }
        if (!editor.getEditorKind().equals((Object)EditorKind.MAIN_EDITOR) && !ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        if (!EditorModificationUtil.checkModificationAllowed((Editor)editor)) {
            return true;
        }
        try {
            PsiElement element = PsiUtils.getCaratElement(editor);
            if (element != null) {
                LOG.debug("caret element class:" + element.getClass() + " parent:" + element.getParent().getClass());
            } else {
                LOG.debug("caret commandFinished isDocumentModification element is null");
            }
            if (element != null && PsiUtils.checkCaretAround(editor) && !PsiUtils.isJavaMethodNewLine(editor, element, second.getOffset(), first.getOffset()) && !PsiUtils.isLiteralElement(editor, element) && !PsiUtils.isImportElement(element, editor)) {
                return CompletionUtil.isValidDocumentChange(editor.getDocument(), second.getOffset(), first.getOffset(), element);
            }
            LOG.debug("commandFinished isDocumentModification invalid psi");
            return false;
        }
        catch (Exception e) {
            LOG.error("fail to check document modified.", (Throwable)e);
            return false;
        }
    }

    private boolean isCompletionTemplate(@NotNull Editor editor) {
        String currentContent;
        if (editor == null) {
            CosyCommandListener.$$$reportNull$$$0(10);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(currentContent = DocumentUtils.getCurrentLine(editor))) && TemplateSettingLoader.getInstance().getCurrentTemplateKeys(editor).contains(currentContent.trim())) {
            LOG.debug(String.format("Current content %s matches with live template, skip", currentContent));
            return true;
        }
        return false;
    }

    private void recordType(Editor editor, CommandEvent event, CommandEditorState first, CommandEditorState second) {
        int previousOffset = first.getOffset();
        int newOffset = second.getOffset();
        if (newOffset < 0 || previousOffset > newOffset) {
            return;
        }
        String addedText = editor.getDocument().getText(new TextRange(previousOffset, newOffset));
        TelemetryService.getInstance().typeRecord(editor, addedText);
        TelemetryService.getInstance().telemetryCommand(event);
    }

    private void recordTextChange(Editor editor, CommandEvent event, CommandEditorState first, CommandEditorState second) {
        String commandName = event.getCommandName();
        if (!TEXT_CHANGE_COMMANDS.contains(commandName)) {
            return;
        }
        int previousOffset = first.getOffset();
        int newOffset = second.getOffset();
        if (newOffset < 0 || previousOffset > newOffset) {
            return;
        }
        Object addedText = editor.getDocument().getText(new TextRange(previousOffset, newOffset));
        int lineNumber = editor.getDocument().getLineNumber(previousOffset);
        boolean accept = false;
        String source = "completion";
        if (PASTE_COMMANDS.contains(commandName)) {
            String copyContent;
            String clipText = EditorUtil.getCopyPasteText();
            if (clipText != null) {
                addedText = clipText;
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(copyContent = (String)CosyCacheKeys.KEY_COPY_PASTE.get((UserDataHolder)ApplicationManager.getApplication()))) && StringUtils.matchCopyContent((String)addedText, copyContent)) {
                accept = true;
                source = "chat";
            } else if (!Features.REPORT_TEXT_CHANGE_PASTE_ENABLE.booleanValue().booleanValue()) {
                LOG.debug("ignore other paste event for " + (String)addedText);
                return;
            }
        } else if (SELECT_LOOKUP_COMMANDS.contains(commandName)) {
            String selectItem = (String)CosyCacheKeys.KEY_SELECT_LOOKUP_ITEM.get((UserDataHolder)editor);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)selectItem) && selectItem.contains(((String)addedText).trim())) {
                CosyCacheKeys.KEY_SELECT_LOOKUP_ITEM.set((UserDataHolder)editor, null);
                return;
            }
        } else if (previousOffset > 1 && ((String)addedText).startsWith("\n") && ((String)addedText).trim().isEmpty()) {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)first.getCaretPrevChar()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)first.getCaretNextChar()) && LEFT_BRACKET_CHARS.contains(first.getCaretPrevChar()) && RIGHT_BRACKET_CHARS.contains(first.getCaretNextChar())) {
                addedText = (String)addedText + "\n}";
            }
        } else {
            TemplateManager templateManager = TemplateManager.getInstance((Project)this.project);
            Template template = templateManager.getActiveTemplate(editor);
            if (template == null || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)template.getKey())) {
                // empty if block
            }
        }
        LOG.debug("recordTextChange commandName:" + commandName + " accept:" + accept + " addedText:" + (String)addedText);
        String filePath = EditorUtil.getEditorFilePath(editor);
        TelemetryService.getInstance().telemetryTextChange(new TextChangeContext(editor.getProject(), filePath, (String)addedText, lineNumber, accept, LanguageUtil.getLanguageByFilePath(filePath), source));
    }

    private static boolean isCaretPositionChange(@NotNull CommandEditorState first, @NotNull CommandEditorState second) {
        if (first == null) {
            CosyCommandListener.$$$reportNull$$$0(11);
        }
        if (second == null) {
            CosyCommandListener.$$$reportNull$$$0(12);
        }
        return !first.visualPosition.equals((Object)second.visualPosition);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
        }
        objectArray2[1] = "com/alibabacloud/intellij/cosy/listener/CosyCommandListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "commandStarted";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "commandFinished";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerWhenLookup";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getDocumentStamp";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createCommandState";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createUndoTransparentState";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isDocumentModified";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isCompletionTemplate";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isCaretPositionChange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class CommandEditorState {
        private final long modificationStamp;
        private final VisualPosition visualPosition;
        private final String lineSuffix;
        private final String linePrefix;
        private final String selectionText;
        private final int offset;

        public CommandEditorState(long modificationStamp, VisualPosition visualPosition, String linePrefix, String lineSuffix, String selectionText, int offset) {
            this.modificationStamp = modificationStamp;
            this.visualPosition = visualPosition;
            this.linePrefix = linePrefix;
            this.lineSuffix = lineSuffix;
            this.selectionText = selectionText;
            this.offset = offset;
        }

        public String getCaretPrevChar() {
            if (this.linePrefix != null && !this.linePrefix.isEmpty()) {
                return this.linePrefix.substring(this.linePrefix.length() - 1);
            }
            return null;
        }

        public String getCaretNextChar() {
            if (this.lineSuffix != null && !this.lineSuffix.isEmpty()) {
                return this.lineSuffix.substring(0, 1);
            }
            return null;
        }

        @Generated
        public long getModificationStamp() {
            return this.modificationStamp;
        }

        @Generated
        public VisualPosition getVisualPosition() {
            return this.visualPosition;
        }

        @Generated
        public String getLineSuffix() {
            return this.lineSuffix;
        }

        @Generated
        public String getLinePrefix() {
            return this.linePrefix;
        }

        @Generated
        public String getSelectionText() {
            return this.selectionText;
        }

        @Generated
        public int getOffset() {
            return this.offset;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CommandEditorState)) {
                return false;
            }
            CommandEditorState other = (CommandEditorState)o;
            if (this.getModificationStamp() != other.getModificationStamp()) {
                return false;
            }
            VisualPosition this$visualPosition = this.getVisualPosition();
            VisualPosition other$visualPosition = other.getVisualPosition();
            if (this$visualPosition == null ? other$visualPosition != null : !this$visualPosition.equals(other$visualPosition)) {
                return false;
            }
            String this$lineSuffix = this.getLineSuffix();
            String other$lineSuffix = other.getLineSuffix();
            if (this$lineSuffix == null ? other$lineSuffix != null : !this$lineSuffix.equals(other$lineSuffix)) {
                return false;
            }
            String this$linePrefix = this.getLinePrefix();
            String other$linePrefix = other.getLinePrefix();
            if (this$linePrefix == null ? other$linePrefix != null : !this$linePrefix.equals(other$linePrefix)) {
                return false;
            }
            String this$selectionText = this.getSelectionText();
            String other$selectionText = other.getSelectionText();
            if (this$selectionText == null ? other$selectionText != null : !this$selectionText.equals(other$selectionText)) {
                return false;
            }
            return this.getOffset() == other.getOffset();
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $modificationStamp = this.getModificationStamp();
            result = result * 59 + (int)($modificationStamp >>> 32 ^ $modificationStamp);
            VisualPosition $visualPosition = this.getVisualPosition();
            result = result * 59 + ($visualPosition == null ? 43 : $visualPosition.hashCode());
            String $lineSuffix = this.getLineSuffix();
            result = result * 59 + ($lineSuffix == null ? 43 : $lineSuffix.hashCode());
            String $linePrefix = this.getLinePrefix();
            result = result * 59 + ($linePrefix == null ? 43 : $linePrefix.hashCode());
            String $selectionText = this.getSelectionText();
            result = result * 59 + ($selectionText == null ? 43 : $selectionText.hashCode());
            result = result * 59 + this.getOffset();
            return result;
        }

        @Generated
        public String toString() {
            return "CosyCommandListener.CommandEditorState(modificationStamp=" + this.getModificationStamp() + ", visualPosition=" + this.getVisualPosition() + ", lineSuffix=" + this.getLineSuffix() + ", linePrefix=" + this.getLinePrefix() + ", selectionText=" + this.getSelectionText() + ", offset=" + this.getOffset() + ")";
        }
    }

    private static final class UndoTransparentActionState {
        @NotNull
        private final Editor editor;
        private final long modificationStamp;

        public UndoTransparentActionState(@NotNull Editor editor, long modificationStamp) {
            if (editor == null) {
                UndoTransparentActionState.$$$reportNull$$$0(0);
            }
            this.editor = editor;
            this.modificationStamp = modificationStamp;
        }

        @NotNull
        @Generated
        public Editor getEditor() {
            Editor editor = this.editor;
            if (editor == null) {
                UndoTransparentActionState.$$$reportNull$$$0(1);
            }
            return editor;
        }

        @Generated
        public long getModificationStamp() {
            return this.modificationStamp;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UndoTransparentActionState)) {
                return false;
            }
            UndoTransparentActionState other = (UndoTransparentActionState)o;
            Editor this$editor = this.getEditor();
            Editor other$editor = other.getEditor();
            if (this$editor == null ? other$editor != null : !this$editor.equals(other$editor)) {
                return false;
            }
            return this.getModificationStamp() == other.getModificationStamp();
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Editor $editor = this.getEditor();
            result = result * 59 + ($editor == null ? 43 : $editor.hashCode());
            long $modificationStamp = this.getModificationStamp();
            result = result * 59 + (int)($modificationStamp >>> 32 ^ $modificationStamp);
            return result;
        }

        @Generated
        public String toString() {
            return "CosyCommandListener.UndoTransparentActionState(editor=" + this.getEditor() + ", modificationStamp=" + this.getModificationStamp() + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/alibabacloud/intellij/cosy/listener/CosyCommandListener$UndoTransparentActionState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/alibabacloud/intellij/cosy/listener/CosyCommandListener$UndoTransparentActionState";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

