/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.listener;

import com.alibabacloud.intellij.cosy.common.CosySetting;
import com.alibabacloud.intellij.cosy.core.Cosy;
import com.alibabacloud.intellij.cosy.linguist.cache.JDKClassLoading;
import com.alibabacloud.intellij.cosy.linguist.cache.ProjectClassLoading;
import com.alibabacloud.intellij.cosy.shared.cache.TrieCacheManager;
import com.alibabacloud.intellij.cosy.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.cosy.util.ProjectUtils;
import com.intellij.ide.util.RunOnceUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.lsp4j.DeleteFilesParams;
import org.eclipse.lsp4j.FileDelete;
import org.eclipse.lsp4j.FileRename;
import org.eclipse.lsp4j.RenameFilesParams;
import org.jetbrains.annotations.NotNull;

public class CosyBulkFileListener
implements BulkFileListener {
    private static final Logger log = Logger.getInstance(CosyBulkFileListener.class);
    public static final String JDK_CLASS_CACHE_ID = "JDK_CLASS_LOADING";
    private static final double QPS_THRESHOLD = 2.0;
    private static Lock saveFileLock = new ReentrantLock();
    private static final Set<String> SAVE_ALLOW_EXTS = new HashSet<String>(Arrays.asList("java", "py"));

    public void after(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            CosyBulkFileListener.$$$reportNull$$$0(0);
        }
        for (VFileEvent vFileEvent : events) {
            if (vFileEvent instanceof VFileContentChangeEvent) {
                this.saveCache(vFileEvent);
                continue;
            }
            if (vFileEvent instanceof VFileDeleteEvent) {
                this.doDeleteFile((VFileDeleteEvent)vFileEvent);
                continue;
            }
            if (!(vFileEvent instanceof VFileMoveEvent)) continue;
            this.doMoveFile((VFileMoveEvent)vFileEvent);
        }
    }

    public void saveCache(VFileEvent event) {
        CosySetting setting = CosyPersistentSetting.getInstance().getState();
        if (setting == null || setting.getParameter() == null || !setting.getParameter().getLocal().getEnable().booleanValue()) {
            return;
        }
        Project project = ProjectLocator.getInstance().guessProjectForFile(event.getFile());
        if (project == null) {
            return;
        }
        try {
            RunOnceUtil.runOnceForApp((String)JDK_CLASS_CACHE_ID, (Runnable)new JDKClassLoading(project));
            DumbService.getInstance((Project)project).runWhenSmart((Runnable)new ProjectClassLoading(project));
            boolean isCached = ProjectUtils.getProjectClassCacheState(project);
            if (!isCached) {
                ProjectUtils.addProjectScopeClassesCache(project);
            } else {
                PsiClass psiClass;
                VirtualFile vFile = event.getFile();
                if (vFile == null || !vFile.isValid()) {
                    log.warn("VFile is invalid" + vFile);
                    return;
                }
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(vFile);
                if (psiFile instanceof PsiJavaFile && ((PsiJavaFile)psiFile).getClasses().length > 0 && (psiClass = ((PsiJavaFile)psiFile).getClasses()[0]) != null) {
                    String name = psiClass.getName();
                    Optional cachedNames = TrieCacheManager.getProjectClassTrieCache().get(name);
                    if (cachedNames.isEmpty() || !((List)cachedNames.get()).contains(name)) {
                        TrieCacheManager.getProjectClassTrieCache().set(psiClass.getName());
                    }
                }
            }
        }
        catch (Throwable e) {
            log.warn("Encountered error when save psi class cache", e);
        }
    }

    private void doDeleteFile(VFileDeleteEvent event) {
        try {
            Project project = ProjectLocator.getInstance().guessProjectForFile(event.getFile());
            if (project == null || !Cosy.INSTANCE.checkCosy(project)) {
                return;
            }
            log.info("Delete file:" + event);
            DeleteFilesParams params = new DeleteFilesParams();
            params.setFiles(Collections.singletonList(new FileDelete(event.getFile().getPresentableUrl())));
            Cosy.INSTANCE.getLanguageService(project).getServer().getWorkspaceService().didDeleteFiles(params);
        }
        catch (Throwable e) {
            log.warn("Encountered error when delete file:" + event, e);
        }
    }

    private void doMoveFile(VFileMoveEvent event) {
        try {
            Project project = ProjectLocator.getInstance().guessProjectForFile(event.getFile());
            if (project == null || !Cosy.INSTANCE.checkCosy(project)) {
                return;
            }
            log.info("Move file:" + event);
            RenameFilesParams params = new RenameFilesParams();
            FileRename fileRename = new FileRename();
            String fileName = event.getFile().getName();
            fileRename.setOldUri(new File(event.getOldParent().getPresentableUrl(), fileName).getAbsolutePath());
            fileRename.setNewUri(new File(event.getNewParent().getPresentableUrl(), fileName).getAbsolutePath());
            params.setFiles(Collections.singletonList(fileRename));
            Cosy.INSTANCE.getLanguageService(project).getServer().getWorkspaceService().didRenameFiles(params);
        }
        catch (Throwable e) {
            log.warn("Encountered error when move file:" + event, e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/alibabacloud/intellij/cosy/listener/CosyBulkFileListener", "after"));
    }
}

