/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.linguist.psi.model;

import com.alibabacloud.intellij.cosy.linguist.enums.PsiElementClassEnum;
import com.alibabacloud.intellij.cosy.linguist.enums.ResolvedTypeEnum;
import com.alibabacloud.intellij.cosy.linguist.psi.model.CosyPsiElementBase;
import com.alibabacloud.intellij.cosy.linguist.psi.model.resolved.CosyPsiMethod;
import com.alibabacloud.intellij.cosy.linguist.psi.model.resolved.CosyPsiType;
import com.alibabacloud.intellij.cosy.linguist.util.CosyPsiUtils;
import com.alibabacloud.intellij.cosy.shared.cache.CacheManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import java.util.Arrays;
import java.util.stream.Collectors;
import lombok.Generated;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class CosyPsiMethodCallExpression
extends CosyPsiElementBase {
    private static final Logger log = Logger.getInstance(CosyPsiMethodCallExpression.class);
    public static final int PARSE_TYPE_TIMEOUT = 20;
    CosyPsiMethod cosyPsiMethod;

    public CosyPsiMethodCallExpression() {
        this.psiElementClass = PsiElementClassEnum.PSI_METHOD_CALL_EXPRESSION.getFullName();
    }

    @Override
    public void parse(PsiElement psiElement) {
        this.cosyPsiMethod = new CosyPsiMethod();
        if (psiElement instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression psiMethodCallExpression = (PsiMethodCallExpression)psiElement;
            PsiType psiType = psiMethodCallExpression.getType();
            if (psiType != null) {
                CosyPsiType callerType = CosyPsiUtils.convertPsiType(psiType);
                PsiClass originalClass = PsiTypesUtil.getPsiClass((PsiType)psiType);
                CacheManager.getInheritClassCache().set(originalClass);
                CosyPsiUtils.findMethodsFieldsFromPsiTypeWhenDot(callerType, originalClass, psiElement, false);
                this.cosyPsiMethod.setCallReturnType(callerType);
            }
            PsiType[] args = psiMethodCallExpression.getArgumentList().getExpressionTypes();
            CosyPsiType[] cosyArgs = Arrays.stream(args).map(CosyPsiUtils::convertPsiType).collect(Collectors.toList()).toArray(new CosyPsiType[args.length]);
            this.cosyPsiMethod.setArgumentList(cosyArgs);
            PsiMethod psiMethod = psiMethodCallExpression.resolveMethod();
            if (psiMethod != null) {
                this.cosyPsiMethod.setReturnType(CosyPsiUtils.convertPsiType(psiMethod.getReturnType()));
                this.cosyPsiMethod.setMethodName(psiMethod.getName());
            } else {
                this.cosyPsiMethod.setResolvedType(ResolvedTypeEnum.PSI_UNRESOLVED_METHOD.name());
            }
        }
    }

    @Override
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("text", (Object)this.getText());
        b.add("psiElementClass", (Object)this.getPsiElementClass());
        b.add("children", (Object)this.getChildren());
        b.add("cosyPsiMethod", (Object)this.getCosyPsiMethod());
        return b.toString();
    }

    @Generated
    public CosyPsiMethod getCosyPsiMethod() {
        return this.cosyPsiMethod;
    }

    @Generated
    public void setCosyPsiMethod(CosyPsiMethod cosyPsiMethod) {
        this.cosyPsiMethod = cosyPsiMethod;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CosyPsiMethodCallExpression)) {
            return false;
        }
        CosyPsiMethodCallExpression other = (CosyPsiMethodCallExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CosyPsiMethod this$cosyPsiMethod = this.getCosyPsiMethod();
        CosyPsiMethod other$cosyPsiMethod = other.getCosyPsiMethod();
        return !(this$cosyPsiMethod == null ? other$cosyPsiMethod != null : !((Object)this$cosyPsiMethod).equals(other$cosyPsiMethod));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CosyPsiMethodCallExpression;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        CosyPsiMethod $cosyPsiMethod = this.getCosyPsiMethod();
        result = result * 59 + ($cosyPsiMethod == null ? 43 : ((Object)$cosyPsiMethod).hashCode());
        return result;
    }
}

