/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.linguist.psi.model;

import com.alibabacloud.intellij.cosy.linguist.enums.PsiElementClassEnum;
import com.alibabacloud.intellij.cosy.linguist.psi.model.CosyPsiElementBase;
import com.alibabacloud.intellij.cosy.linguist.psi.model.resolved.CosyPsiClass;
import com.alibabacloud.intellij.cosy.linguist.psi.model.resolved.CosyPsiType;
import com.alibabacloud.intellij.cosy.linguist.psi.model.resolved.CosyPsiVariable;
import com.alibabacloud.intellij.cosy.linguist.psi.model.resolved.CosyResolvedBase;
import com.alibabacloud.intellij.cosy.linguist.util.CosyPsiUtils;
import com.alibabacloud.intellij.cosy.shared.cache.CacheManager;
import com.alibabacloud.intellij.cosy.shared.cache.TrieCacheManager;
import com.alibabacloud.intellij.cosy.util.StringUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.tree.java.PsiReferenceExpressionImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.PsiTypesUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;
import org.jsoup.internal.StringUtil;

public class CosyPsiJavaCodeReferenceElement
extends CosyPsiElementBase {
    private static final Logger log = Logger.getInstance(CosyPsiJavaCodeReferenceElement.class);
    public static final int GUESS_TIME_LIMIT = 20;
    CosyPsiType referenceType;
    CosyResolvedBase resolved;
    List<CosyResolvedBase> guessedResolve;

    public CosyPsiJavaCodeReferenceElement() {
        this.psiElementClass = PsiElementClassEnum.PSI_JAVA_CODE_REFERENCE_ELEMENT.getFullName();
    }

    @Override
    public void parse(PsiElement psiElement) {
        if (psiElement instanceof PsiJavaCodeReferenceElement) {
            PsiElement resolved;
            PsiType psiType;
            PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = (PsiJavaCodeReferenceElement)psiElement;
            if (psiJavaCodeReferenceElement instanceof PsiReferenceExpressionImpl && (psiType = ((PsiReferenceExpressionImpl)psiJavaCodeReferenceElement).getType()) != null) {
                this.setReferenceType(CosyPsiUtils.convertPsiType(psiType));
            }
            if ((resolved = psiJavaCodeReferenceElement.resolve()) != null) {
                if (resolved instanceof PsiClass) {
                    PsiClass psiClass = (PsiClass)resolved;
                    CacheManager.getInheritClassCache().set(psiClass);
                    this.tacklePsiClass(psiClass, psiElement);
                } else if (resolved instanceof PsiMethod) {
                    this.resolved = CosyPsiUtils.convertPsiMethod((PsiMethod)resolved);
                } else if (resolved instanceof PsiVariable) {
                    PsiVariable psiVariable = (PsiVariable)resolved;
                    CosyPsiVariable cosyPsiVariable = CosyPsiUtils.convertPsiVariable(psiVariable);
                    PsiClass variableClass = PsiTypesUtil.getPsiClass((PsiType)psiVariable.getType());
                    if (variableClass != null) {
                        CosyPsiType variableType = cosyPsiVariable.getPsiType();
                        CosyPsiUtils.findMethodsFieldsFromPsiTypeWhenDot(variableType, variableClass, psiElement, false);
                    }
                    this.resolved = cosyPsiVariable;
                } else {
                    log.warn(String.format("Unknown resolved psi expression type %s", resolved.getClass()));
                }
            } else {
                String rawElementName = StringUtils.removeAngleBrackets(psiElement.getText());
                if (rawElementName.contains(".") || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)rawElementName)) {
                    return;
                }
                if (Character.isUpperCase(rawElementName.charAt(0))) {
                    this.guessClass(psiElement, rawElementName);
                } else if (Character.isLowerCase(rawElementName.charAt(0))) {
                    this.guessVariable(psiElement, rawElementName);
                }
            }
        }
    }

    private void guessVariable(PsiElement psiElement, String rawElementName) {
        Map variableTypeMap;
        Optional optional;
        if (rawElementName == null || psiElement == null) {
            log.warn("guessVariable rawElementName or psiElement is null");
            return;
        }
        String filePath = CacheManager.getVariableClassCache().getCurrentFilePath();
        if (StringUtil.isBlank((String)filePath)) {
            log.warn("guessVariable filePath is blank");
        }
        if ((optional = CacheManager.getVariableClassCache().get(filePath)).isPresent() && (variableTypeMap = (Map)optional.get()).containsKey(rawElementName)) {
            try {
                PsiType psiType = (PsiType)variableTypeMap.get(rawElementName);
                CosyPsiVariable cosyPsiVariable = new CosyPsiVariable();
                cosyPsiVariable.setPsiType(CosyPsiUtils.convertPsiType(psiType));
                cosyPsiVariable.setVariableName(rawElementName);
                PsiClass variableClass = PsiTypesUtil.getPsiClass((PsiType)psiType);
                if (variableClass != null) {
                    CosyPsiType variableType = cosyPsiVariable.getPsiType();
                    CosyPsiUtils.findMethodsFieldsFromPsiTypeWhenDot(variableType, variableClass, psiElement, false);
                }
                log.info(String.format("Guess variable %s from cache, type=%s", rawElementName, psiType.getPresentableText()));
                this.resolved = cosyPsiVariable;
            }
            catch (Exception e) {
                log.warn(String.format("Guess variable element encountered exception: %s", e.getMessage()));
            }
        }
    }

    private void guessClass(PsiElement psiElement, String rawClassName) {
        Optional optional = CacheManager.getInheritClassCache().get(rawClassName);
        if (optional.isPresent()) {
            log.info(String.format("Load from cache for unresolved java reference %s", psiElement.getText()));
            this.tacklePsiClass((PsiClass)optional.get(), psiElement);
        } else {
            FutureTask<Object> task = new FutureTask<Object>(() -> {
                Project project;
                PsiClass[] potentials;
                Optional optionalStrings = TrieCacheManager.getProjectClassTrieCache().get(rawClassName);
                if (optionalStrings.isPresent() && ((List)optionalStrings.get()).contains(rawClassName) && (potentials = PsiShortNamesCache.getInstance((Project)(project = psiElement.getProject())).getClassesByName(rawClassName, GlobalSearchScope.allScope((Project)project))).length > 0) {
                    this.tacklePsiClass(potentials[0], psiElement);
                }
                return true;
            });
            ApplicationManager.getApplication().runReadAction(task);
            try {
                task.get(20L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException e) {
                log.warn("guessClass interrupted or exception" + e.getMessage());
            }
            catch (TimeoutException e) {
                log.warn("guessClass timeout (20ms)");
            }
        }
    }

    private void tacklePsiClass(PsiClass psiClass, PsiElement psiElement) {
        CosyPsiClass cosyPsiClass = new CosyPsiClass();
        CosyPsiType cosyPsiType = new CosyPsiType();
        cosyPsiType.setTypeName(psiClass.getName());
        cosyPsiType.setTypeFullPath(psiClass.getQualifiedName());
        CosyPsiUtils.findMethodsFieldsFromPsiTypeWhenDot(cosyPsiType, psiClass, psiElement, true);
        CosyPsiUtils.findConstructorForPsiTypeWhenNew(cosyPsiType, psiClass, psiElement);
        cosyPsiClass.setPsiType(cosyPsiType);
        this.resolved = cosyPsiClass;
    }

    @Override
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("text", (Object)this.getText());
        b.add("psiElementClass", (Object)this.getPsiElementClass());
        b.add("children", (Object)this.getChildren());
        b.add("referenceType", (Object)this.getReferenceType());
        b.add("resolvedType", (Object)this.getResolved());
        return b.toString();
    }

    @Generated
    public CosyPsiType getReferenceType() {
        return this.referenceType;
    }

    @Generated
    public CosyResolvedBase getResolved() {
        return this.resolved;
    }

    @Generated
    public List<CosyResolvedBase> getGuessedResolve() {
        return this.guessedResolve;
    }

    @Generated
    public void setReferenceType(CosyPsiType referenceType) {
        this.referenceType = referenceType;
    }

    @Generated
    public void setResolved(CosyResolvedBase resolved) {
        this.resolved = resolved;
    }

    @Generated
    public void setGuessedResolve(List<CosyResolvedBase> guessedResolve) {
        this.guessedResolve = guessedResolve;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CosyPsiJavaCodeReferenceElement)) {
            return false;
        }
        CosyPsiJavaCodeReferenceElement other = (CosyPsiJavaCodeReferenceElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CosyPsiType this$referenceType = this.getReferenceType();
        CosyPsiType other$referenceType = other.getReferenceType();
        if (this$referenceType == null ? other$referenceType != null : !((Object)this$referenceType).equals(other$referenceType)) {
            return false;
        }
        CosyResolvedBase this$resolved = this.getResolved();
        CosyResolvedBase other$resolved = other.getResolved();
        if (this$resolved == null ? other$resolved != null : !this$resolved.equals(other$resolved)) {
            return false;
        }
        List<CosyResolvedBase> this$guessedResolve = this.getGuessedResolve();
        List<CosyResolvedBase> other$guessedResolve = other.getGuessedResolve();
        return !(this$guessedResolve == null ? other$guessedResolve != null : !((Object)this$guessedResolve).equals(other$guessedResolve));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CosyPsiJavaCodeReferenceElement;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        CosyPsiType $referenceType = this.getReferenceType();
        result = result * 59 + ($referenceType == null ? 43 : ((Object)$referenceType).hashCode());
        CosyResolvedBase $resolved = this.getResolved();
        result = result * 59 + ($resolved == null ? 43 : $resolved.hashCode());
        List<CosyResolvedBase> $guessedResolve = this.getGuessedResolve();
        result = result * 59 + ($guessedResolve == null ? 43 : ((Object)$guessedResolve).hashCode());
        return result;
    }
}

