/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.linguist.psi.core;

import com.alibabacloud.intellij.cosy.linguist.enums.PsiElementClassEnum;
import com.alibabacloud.intellij.cosy.linguist.psi.model.CosyDefaultPsiElement;
import com.alibabacloud.intellij.cosy.linguist.psi.model.CosyPsiElement;
import com.alibabacloud.intellij.cosy.linguist.psi.model.CosyPsiElementBase;
import com.alibabacloud.intellij.cosy.shared.cache.CacheManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.serviceContainer.AlreadyDisposedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class CosyPsiManager {
    private static final Logger log = Logger.getInstance(CosyPsiManager.class);
    private static final List<PsiElementClassEnum> SUPPORT_CLASS_ENUMS = Arrays.asList(PsiElementClassEnum.PSI_JAVA_CODE_REFERENCE_ELEMENT, PsiElementClassEnum.PSI_LITERAL_EXPRESSION, PsiElementClassEnum.PSI_METHOD_CALL_EXPRESSION, PsiElementClassEnum.PSI_LOCAL_VARIABLE, PsiElementClassEnum.PSI_EXPRESSION_LIST, PsiElementClassEnum.PSI_ERROR_ELEMENT, PsiElementClassEnum.PSI_NEW_EXPRESSION, PsiElementClassEnum.PSI_IDENTIFIER, PsiElementClassEnum.PSI_KEYWORD, PsiElementClassEnum.PSI_WHITE_SPACE, PsiElementClassEnum.PSI_TYPE_ELEMENT, PsiElementClassEnum.PSI_JAVA_TOKEN, PsiElementClassEnum.PSI_ASSIGNMENT_EXPRESSION, PsiElementClassEnum.PSI_DEFAULT);

    public static CosyPsiElement convertToCosyPsiElement(PsiElement psiElement, String cacheKey) {
        try {
            LinkedList<MutablePair> queue = new LinkedList<MutablePair>();
            CosyPsiElement cosyPsiElement = CosyPsiManager.guessCosyPsiElement(psiElement);
            MutablePair pair = new MutablePair((Object)psiElement, (Object)cosyPsiElement);
            ((CosyPsiElement)pair.getRight()).setText(psiElement.getText());
            queue.add(pair);
            while (!queue.isEmpty()) {
                Pair node = (Pair)queue.poll();
                PsiElement[] children = ((PsiElement)node.getLeft()).getChildren();
                ArrayList<CosyPsiElement> cosyChildrenList = new ArrayList<CosyPsiElement>(children.length);
                for (PsiElement currentPsiElement : children) {
                    CosyPsiElement currentCosyPsiElement = CosyPsiManager.guessCosyPsiElement(currentPsiElement);
                    if (currentCosyPsiElement instanceof CosyDefaultPsiElement && currentPsiElement.getChildren().length == 0) continue;
                    currentCosyPsiElement.setText(currentPsiElement.getText());
                    currentCosyPsiElement.setChildren(new CosyPsiElement[currentPsiElement.getChildren().length]);
                    cosyChildrenList.add(currentCosyPsiElement);
                    queue.offer(new MutablePair((Object)currentPsiElement, (Object)currentCosyPsiElement));
                }
                ((CosyPsiElement)node.getRight()).setChildren(cosyChildrenList.toArray(new CosyPsiElement[0]));
            }
            CacheManager.getCosyPsiTreeCache().set(cacheKey, cosyPsiElement);
            return (CosyPsiElement)pair.getRight();
        }
        catch (AlreadyDisposedException alreadyDisposedException) {
            log.warn(String.format("Convert psi element encountered AlreadyDisposedException. %s", alreadyDisposedException.getMessage()));
            return null;
        }
    }

    public static CosyPsiElement guessCosyPsiElement(PsiElement psiElement) {
        long st = System.currentTimeMillis();
        for (PsiElementClassEnum classEnum : SUPPORT_CLASS_ENUMS) {
            if (!classEnum.accept(psiElement)) continue;
            CosyPsiElementBase cosyPsiElement = classEnum.getInstance();
            cosyPsiElement.parse(psiElement);
            return cosyPsiElement;
        }
        return new CosyDefaultPsiElement();
    }
}

