/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.linguist.provider;

import com.alibabacloud.intellij.cosy.linguist.model.ClassItem;
import com.alibabacloud.intellij.cosy.linguist.model.DefaultItem;
import com.alibabacloud.intellij.cosy.linguist.model.ItemBase;
import com.alibabacloud.intellij.cosy.linguist.provider.ProviderBase;
import com.alibabacloud.intellij.cosy.util.ProjectUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ClassLiteralProvider
implements ProviderBase {
    private static final Logger log = Logger.getInstance(ClassLiteralProvider.class);
    static final PsiJavaElementPattern.Capture<PsiElement> CLASS_LITERAL_PATTERN = (PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().and((ElementPattern)PsiJavaPatterns.psiElement(PsiIdentifier.class))).and((ElementPattern)PsiJavaPatterns.psiElement().withText((ElementPattern)StandardPatterns.string().matches("[A-Z].*")));
    static final String ORIGIN = "CLASS_LITERAL_PATTERN";
    static final int PRIORITY = 9;

    @Override
    public boolean isApplicable(PsiElement psiElement) {
        return CLASS_LITERAL_PATTERN.accepts((Object)psiElement);
    }

    @Override
    public List<ItemBase> provide(Project project, final PsiElement psiElement) {
        long st = System.currentTimeMillis();
        List<String> classNames = ProjectUtils.loadAllClassNames(project, psiElement.getText(), new Predicate<String>(){

            @Override
            public boolean test(String s) {
                return s.startsWith(psiElement.getText());
            }
        });
        List<ItemBase> classList = classNames.stream().map(n -> new ClassItem((String)n, null, ORIGIN, 9)).collect(Collectors.toList());
        if (classList.isEmpty()) {
            classList.add(new DefaultItem());
        }
        log.debug(String.format("ClassLiteralProvider consumed %d ms", System.currentTimeMillis() - st));
        return classList;
    }

    @Override
    public String getOrigin() {
        return ORIGIN;
    }

    @Override
    public int getPriority() {
        return 9;
    }
}

