/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.linguist.provider;

import com.alibabacloud.intellij.cosy.linguist.model.DefaultItem;
import com.alibabacloud.intellij.cosy.linguist.model.ItemBase;
import com.alibabacloud.intellij.cosy.linguist.provider.AfterNewProvider;
import com.alibabacloud.intellij.cosy.linguist.provider.AfterThrowNewProvider;
import com.alibabacloud.intellij.cosy.linguist.provider.ClassLiteralProvider;
import com.alibabacloud.intellij.cosy.linguist.provider.ProviderBase;
import com.alibabacloud.intellij.cosy.linguist.provider.StaticClassOrVariableDotProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class AvailableListManager {
    static List<ProviderBase> PROVIDERS = Arrays.asList(new StaticClassOrVariableDotProvider(), new AfterNewProvider(), new AfterThrowNewProvider(), new ClassLiteralProvider());

    public static List<ItemBase> extractAvailableList(Project project, PsiElement psiElement) {
        ArrayList<ItemBase> availableList = new ArrayList<ItemBase>();
        if (project == null || psiElement == null) {
            return availableList;
        }
        for (ProviderBase provider : PROVIDERS) {
            if (!provider.isApplicable(psiElement)) continue;
            availableList.addAll(provider.provide(project, psiElement));
        }
        if (availableList.isEmpty()) {
            return availableList;
        }
        List nameList = availableList.stream().map(e -> e.getName()).collect(Collectors.toList());
        if (nameList.stream().allMatch(n -> "$EMPTY_LIST$".equals(n))) {
            availableList.clear();
            availableList.add(new DefaultItem());
            return availableList;
        }
        return availableList.stream().filter(e -> !"$EMPTY_LIST$".equals(e.getName())).collect(Collectors.toList());
    }
}

