/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.linguist.processor;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import org.eclipse.lsp4j.Position;

public abstract class TextDocumentProcessorBase {
    protected int row;
    protected int col;
    protected String uri;
    protected Project project;
    protected PsiFile psiFile;

    public TextDocumentProcessorBase(String uri, Position position) {
        this.uri = uri;
        this.row = position.getLine();
        this.col = position.getCharacter();
    }

    public void initPsi() {
        File file = new File(this.uri);
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(file);
        if (virtualFile != null) {
            this.project = ProjectLocator.getInstance().guessProjectForFile(virtualFile);
        }
        if (this.project != null) {
            this.psiFile = PsiManager.getInstance((Project)this.project).findFile(virtualFile);
        }
    }
}

