/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.linguist.processor;

import com.alibabacloud.intellij.cosy.linguist.model.ClassPair;
import com.alibabacloud.intellij.cosy.linguist.processor.TextDocumentProcessorBase;
import com.alibabacloud.intellij.cosy.util.ProjectUtils;
import com.alibabacloud.intellij.cosy.util.StringUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.eclipse.lsp4j.Position;

public class IsInheritsProcessor
extends TextDocumentProcessorBase {
    private static final Logger log = Logger.getInstance(IsInheritsProcessor.class);
    private List<ClassPair> classPairs;

    public IsInheritsProcessor(List<ClassPair> classPairs, String uri, Position position) {
        super(uri, position);
        this.classPairs = classPairs;
    }

    public List<Boolean> check() {
        CopyOnWriteArrayList<Boolean> inherits = new CopyOnWriteArrayList<Boolean>();
        ReadAction.run(this::initPsi);
        if (this.project == null || this.project.isDisposed()) {
            log.warn("Project is disposed, skip inherits processor");
            return inherits;
        }
        if (DumbService.isDumb((Project)this.project)) {
            log.warn("project is dumb, skip is inherits processor");
            return inherits;
        }
        long st0 = System.currentTimeMillis();
        log.debug(String.format("start check inheritor for size %d", this.classPairs.size()));
        FutureTask<List> task = new FutureTask<List>(() -> {
            for (ClassPair pair : this.classPairs) {
                String parentFullPath;
                long st1 = System.currentTimeMillis();
                String child = pair.getChild();
                String parent = pair.getParent();
                ArrayList<String> classes = new ArrayList<String>();
                String childFullPath = StringUtils.removeAngleBrackets(child);
                if (childFullPath.equals(parentFullPath = StringUtils.removeAngleBrackets(parent))) {
                    inherits.add(true);
                    continue;
                }
                classes.add(childFullPath);
                classes.add(parentFullPath);
                List<PsiClass> psiClasses = ProjectUtils.getPsiClassByName(this.project, classes);
                if (psiClasses == null || psiClasses.size() != 2) {
                    log.warn(String.format("IsInherit processor get class by name failed. Pair: %s", ((Object)classes).toString()));
                    inherits.add(false);
                }
                long st2 = System.currentTimeMillis();
                log.debug(String.format("get psi class consumed %d", st2 - st1));
                PsiClass childClass = psiClasses.get(0);
                PsiClass parentClass = psiClasses.get(1);
                boolean result = false;
                if (childClass != null && parentClass != null) {
                    log.debug("class is not null, check inheritor");
                    result = childClass.isInheritor(parentClass, true);
                }
                long st3 = System.currentTimeMillis();
                log.debug(String.format("judge inheritor consumed %d", st3 - st3));
                inherits.add(result);
            }
            return inherits;
        });
        List<Boolean> inheritResult = new CopyOnWriteArrayList();
        ApplicationManager.getApplication().runReadAction(task);
        try {
            inheritResult = (List)task.get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.warn("Get is inheritor failed", (Throwable)e);
        }
        if (inheritResult.size() != this.classPairs.size()) {
            log.warn(String.format("Inherit result size doesn't match with input, return all false. Result size: %d, input size: %d", inheritResult.size(), this.classPairs.size()));
            inheritResult = new ArrayList();
            for (int i = 0; i < this.classPairs.size(); ++i) {
                inheritResult.add(Boolean.FALSE);
            }
        }
        long end = System.currentTimeMillis();
        log.debug(String.format("finish check inheritor for size %d, consumed %d", this.classPairs.size(), end - st0));
        return inheritResult;
    }
}

