/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.linguist.processor;

import com.alibabacloud.intellij.cosy.linguist.model.ItemBase;
import com.alibabacloud.intellij.cosy.linguist.processor.TextDocumentProcessorBase;
import com.alibabacloud.intellij.cosy.linguist.provider.AvailableListManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.eclipse.lsp4j.Position;

public class AvailableListProcessor
extends TextDocumentProcessorBase {
    private static final Logger log = Logger.getInstance(AvailableListProcessor.class);

    public AvailableListProcessor(String uri, Position position) {
        super(uri, position);
    }

    public List<ItemBase> getAvailableList() {
        ArrayList<ItemBase> empty = new ArrayList<ItemBase>();
        ReadAction.run(this::initPsi);
        if (this.uri == null || this.project == null || this.psiFile == null || this.project.isDisposed()) {
            log.warn("uri == null || project == null || psiFile == null || project.isDisposed(), skip available list processor");
            return empty;
        }
        if (DumbService.isDumb((Project)this.project)) {
            log.warn("project is dumb, skip available list processor");
            return empty;
        }
        long st = System.currentTimeMillis();
        FutureTask<List> task = new FutureTask<List>(() -> {
            Editor editor = ((FileEditorManagerImpl)FileEditorManager.getInstance((Project)this.project)).getSelectedTextEditor(true);
            if (editor == null) {
                return empty;
            }
            int currentOffset = editor.getDocument().getLineEndOffset(this.row - 1) + this.col;
            PsiElement currentElement = PsiUtilCore.getElementAtOffset((PsiFile)this.psiFile, (int)currentOffset);
            if (currentElement == null) {
                return empty;
            }
            return AvailableListManager.extractAvailableList(this.project, currentElement);
        });
        ApplicationManager.getApplication().runReadAction(task);
        log.debug(String.format("Available list consumed %d ms", System.currentTimeMillis() - st));
        try {
            return (List)task.get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.warn("Get available list failed", (Throwable)e);
            return new ArrayList<ItemBase>();
        }
    }
}

