/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.editor.request;

import com.alibabacloud.intellij.cosy.common.CosySetting;
import com.alibabacloud.intellij.cosy.editor.request.RuleBaseDelayStrategy;
import com.alibabacloud.intellij.cosy.search.enums.CompletionTriggerModeEnum;
import com.alibabacloud.intellij.cosy.service.TelemetryService;
import com.alibabacloud.intellij.cosy.service.model.Features;
import com.alibabacloud.intellij.cosy.service.model.TypingStat;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;

public class TypeSpeedDelayStrategy
extends RuleBaseDelayStrategy {
    private static final Logger LOGGER = Logger.getInstance(TypeSpeedDelayStrategy.class);

    @Override
    public long calculateDelay(CosySetting settings, Editor editor, CompletionTriggerModeEnum triggerMode, boolean isComment) {
        if (CompletionTriggerModeEnum.MANUAL.getName().equals(triggerMode.getName())) {
            return super.calculateDelay(settings, editor, triggerMode, isComment);
        }
        TypingStat stat = TelemetryService.getInstance().getTypeStat();
        double avgSpeed = stat.getAvgTypingSpeed();
        long minDelay = Features.COMPLETION_AUTO_MIN_DELAY.longValue();
        if (avgSpeed <= 0.0) {
            return super.calculateDelay(settings, editor, triggerMode, isComment);
        }
        if (avgSpeed < (double)minDelay) {
            if (isComment) {
                return super.calculateDelay(settings, editor, triggerMode, isComment);
            }
            return minDelay;
        }
        long extDelay = Features.COMPLETION_AUTO_TYPE_SPEED_EXT_DELAY.longValue();
        long delay = (long)(avgSpeed + (double)extDelay);
        if (isComment) {
            long defaultValue = super.calculateDelay(settings, editor, triggerMode, isComment);
            delay = Math.max(delay, defaultValue);
        }
        return delay;
    }
}

