/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.editor.request;

import com.alibabacloud.intellij.cosy.common.CosyCacheKeys;
import com.alibabacloud.intellij.cosy.common.CosySetting;
import com.alibabacloud.intellij.cosy.completion.CosyCompletionService;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.ChangeUserSettingParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.CompletionContextParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.CompletionParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.RemoteModelParams;
import com.alibabacloud.intellij.cosy.editor.DefaultInlayCompletionCollector;
import com.alibabacloud.intellij.cosy.editor.model.CompletionTriggerConfig;
import com.alibabacloud.intellij.cosy.editor.model.InlayCompletionRequest;
import com.alibabacloud.intellij.cosy.editor.request.DelayStrategy;
import com.alibabacloud.intellij.cosy.editor.request.RuleBaseDelayStrategy;
import com.alibabacloud.intellij.cosy.editor.request.TypeSpeedDelayStrategy;
import com.alibabacloud.intellij.cosy.search.enums.CompletionGenerateLengthLevelEnum;
import com.alibabacloud.intellij.cosy.search.enums.CompletionTriggerModeEnum;
import com.alibabacloud.intellij.cosy.search.enums.ModelPowerLevelEnum;
import com.alibabacloud.intellij.cosy.service.TelemetryService;
import com.alibabacloud.intellij.cosy.service.UserAuthService;
import com.alibabacloud.intellij.cosy.service.model.Features;
import com.alibabacloud.intellij.cosy.service.model.Measurements;
import com.alibabacloud.intellij.cosy.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.cosy.util.PsiUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.jetbrains.annotations.NotNull;

public class InlayPreviewRequest {
    private static final long REQUEST_TIMEOUT = 10000L;
    private static final Logger LOGGER = Logger.getInstance(InlayPreviewRequest.class);
    private static final long INLAY_COMPLETION_TOGGLE_DELAY = 75L;

    private InlayPreviewRequest() {
    }

    public static InlayPreviewRequest build() {
        return new InlayPreviewRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(@NotNull CompletionTriggerConfig config, Editor editor, CompletionTriggerModeEnum triggerMode) {
        FileDocumentManager fileDocumentManager;
        VirtualFile virtualFile;
        CosySetting settings;
        if (config == null) {
            InlayPreviewRequest.$$$reportNull$$$0(0);
        }
        if (!this.isAllowInvoke(settings = CosyPersistentSetting.getInstance().getState(), editor, triggerMode)) {
            return;
        }
        ChangeUserSettingParams.AbstractModelTrigger modelTrigger = null;
        modelTrigger = CompletionTriggerModeEnum.AUTO.getName().equals(triggerMode.getName()) ? (settings == null ? null : settings.getParameter().getCloud().getAutoTrigger()) : (settings == null ? null : settings.getParameter().getCloud().getManualTrigger());
        int offset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        String lineSuffixCode = document.getText(TextRange.create((int)offset, (int)document.getLineEndOffset(document.getLineNumber(offset))));
        String modelLevel = modelTrigger != null ? modelTrigger.getModelLevel() : ModelPowerLevelEnum.LARGE.getLabel();
        String generateLength = modelTrigger != null ? modelTrigger.getGenerateLength() : CompletionGenerateLengthLevelEnum.LEVEL_1.getLabel();
        boolean isComment = false;
        PsiElement element = PsiUtils.getCaratElement(editor);
        if (element != null && PsiUtils.isCommentElement(element, editor)) {
            isComment = true;
        }
        if (StringUtils.isNotBlank((CharSequence)lineSuffixCode) || isComment) {
            generateLength = CompletionGenerateLengthLevelEnum.LINE_LEVEL.getLabel();
        }
        if (config.getForceGenerateLengthLevel() != null) {
            generateLength = config.getForceGenerateLengthLevel().getLabel();
        }
        if ((virtualFile = (fileDocumentManager = FileDocumentManager.getInstance()).getFile(editor.getDocument())) == null) {
            LOGGER.warn("invalid virtual file for:" + editor.getDocument());
            return;
        }
        LogicalPosition position = editor.getCaretModel().getLogicalPosition();
        int line = position.line;
        int column = editor.getCaretModel().getOffset() - editor.getDocument().getLineStartOffset(line);
        column = column > 0 ? column : position.column;
        int tabWidth = editor.getSettings().getTabSize(editor.getProject());
        CompletionParams params = new CompletionParams();
        params.setRequestId(UUID.randomUUID().toString());
        params.setFileContent(editor.getDocument().getText());
        params.setPosition(new Position(line, column));
        params.setTextDocument(new TextDocumentIdentifier(virtualFile.getPresentableUrl()));
        params.setUseLocalModel(false);
        params.setUseRemoteModel(true);
        params.setRemoteModelParams(new RemoteModelParams(triggerMode.getName(), true, 0.1, 0.9, generateLength, modelLevel, tabWidth, null));
        DelayStrategy delayStrategy = this.getDelayStrategy();
        long delay = delayStrategy.calculateDelay(settings, editor, triggerMode, isComment);
        Measurements measurements = Measurements.build(editor);
        measurements.setCompletionDelayMs(delay);
        params.setCompletionContextParams(new CompletionContextParams(isComment, config.getTriggerEvent() == null ? null : config.getTriggerEvent().getName(), measurements));
        Key<InlayCompletionRequest> key = CosyCacheKeys.KEY_COMPLETION_LATEST_REQUEST;
        synchronized (key) {
            InlayCompletionRequest oldRequest = (InlayCompletionRequest)CosyCacheKeys.KEY_COMPLETION_LATEST_REQUEST.get((UserDataHolder)editor);
            if (oldRequest != null) {
                oldRequest.cancel();
                Disposer.dispose((Disposable)oldRequest);
                CosyCacheKeys.KEY_COMPLETION_LATEST_REQUEST.set((UserDataHolder)editor, null);
            }
            LOGGER.info("inlay completion request id:" + params.getRequestId());
            InlayCompletionRequest request = new InlayCompletionRequest(params, editor);
            DefaultInlayCompletionCollector collector = new DefaultInlayCompletionCollector(editor, request);
            request.setCollector(collector);
            CosyCacheKeys.KEY_COMPLETION_LATEST_REQUEST.set((UserDataHolder)editor, (Object)request);
            CosyCacheKeys.KEY_COMPLETION_LATEST_PROJECT_REQUEST.set((UserDataHolder)editor.getProject(), (Object)request);
            CosyCompletionService.getInstance().asyncCompletionInlay(request, delay, 10000L, (Consumer<CompletionParams>)((Consumer)p -> TelemetryService.getInstance().triggerCompletion(triggerMode, editor, params)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toggle(Editor editor, InlayCompletionRequest oldRequest) {
        String triggerMode;
        CosySetting settings = CosyPersistentSetting.getInstance().getState();
        String string = triggerMode = oldRequest.getParams().getRemoteModelParams() != null ? oldRequest.getParams().getRemoteModelParams().getTriggerMode() : CompletionTriggerModeEnum.AUTO.getName();
        if (!this.isAllowInvoke(settings, editor, CompletionTriggerModeEnum.getTriggerModeEnum(triggerMode))) {
            LOGGER.warn("ignore invoke completion request, need user login auth");
            return;
        }
        int tabWidth = editor.getSettings().getTabSize(editor.getProject());
        CompletionParams params = new CompletionParams();
        params.setRequestId(UUID.randomUUID().toString());
        params.setFileContent(oldRequest.getParams().getFileContent());
        params.setPosition(oldRequest.getParams().getPosition());
        params.setTextDocument(oldRequest.getParams().getTextDocument());
        params.setUseLocalModel(false);
        params.setUseRemoteModel(true);
        String generateLength = oldRequest.getParams().getRemoteModelParams() != null ? oldRequest.getParams().getRemoteModelParams().getGenerateLength() : CompletionGenerateLengthLevelEnum.LEVEL_1.getLabel();
        String modelLevel = oldRequest.getParams().getRemoteModelParams() != null ? oldRequest.getParams().getRemoteModelParams().getModelLevel() : ModelPowerLevelEnum.LARGE.getLabel();
        Random random = new Random();
        params.setRemoteModelParams(new RemoteModelParams(triggerMode, true, 0.3, 0.9, generateLength, modelLevel, tabWidth, random.nextInt(1001) + 1));
        params.setCompletionContextParams(oldRequest.getParams().getCompletionContextParams());
        Key<InlayCompletionRequest> key = CosyCacheKeys.KEY_COMPLETION_LATEST_REQUEST;
        synchronized (key) {
            if (oldRequest != null) {
                oldRequest.cancel();
                Disposer.dispose((Disposable)oldRequest);
                CosyCacheKeys.KEY_COMPLETION_LATEST_REQUEST.set((UserDataHolder)editor, null);
            }
            LOGGER.info("inlay toggle completion request id:" + params.getRequestId());
            InlayCompletionRequest request = new InlayCompletionRequest(params, editor, oldRequest.getCursorOffset());
            DefaultInlayCompletionCollector collector = new DefaultInlayCompletionCollector(editor, request);
            request.setCollector(collector);
            CosyCacheKeys.KEY_COMPLETION_LATEST_REQUEST.set((UserDataHolder)editor, (Object)request);
            CosyCacheKeys.KEY_COMPLETION_LATEST_PROJECT_REQUEST.set((UserDataHolder)editor.getProject(), (Object)request);
            CosyCompletionService.getInstance().asyncCompletionInlay(request, 75L, 10000L, (Consumer<CompletionParams>)((Consumer)p -> TelemetryService.getInstance().triggerCompletion(CompletionTriggerModeEnum.TOGGLE, editor, params)));
        }
    }

    private boolean isAllowInvoke(CosySetting settings, Editor editor, CompletionTriggerModeEnum triggerMode) {
        if (!CosyPersistentSetting.getInstance().isEnableCloudCompletion(settings, triggerMode)) {
            return false;
        }
        AuthStatus authStatus = (AuthStatus)CosyCacheKeys.KEY_AUTH_STATUS.get((UserDataHolder)ApplicationManager.getApplication());
        if (authStatus == null) {
            authStatus = UserAuthService.getInstance().getState(editor.getProject());
            CosyCacheKeys.KEY_AUTH_STATUS.set((UserDataHolder)ApplicationManager.getApplication(), (Object)authStatus);
        }
        return authStatus != null && authStatus.isAllow();
    }

    private DelayStrategy getDelayStrategy() {
        String delayStrategy = Features.COMPLETION_AUTO_DELAY_STRATEGY.stringValue();
        if (StringUtils.isBlank((CharSequence)delayStrategy) || "default".equals(delayStrategy)) {
            return new RuleBaseDelayStrategy();
        }
        if ("TypeSpeed".equals(delayStrategy)) {
            return new TypeSpeedDelayStrategy();
        }
        return new RuleBaseDelayStrategy();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/alibabacloud/intellij/cosy/editor/request/InlayPreviewRequest", "generate"));
    }
}

