/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.editor.model;

import com.alibabacloud.intellij.cosy.core.lsp.model.params.CompletionParams;
import com.alibabacloud.intellij.cosy.editor.InlayCompletionCollector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class InlayCompletionRequest
implements Disposable {
    CompletionParams params;
    Editor editor;
    int cursorOffset;
    boolean useTabs;
    int tabWidth;
    InlayCompletionCollector collector;
    boolean canceled = false;

    public InlayCompletionRequest(CompletionParams params, Editor editor) {
        this.params = params;
        this.editor = editor;
        this.cursorOffset = editor.getCaretModel().getOffset();
        Project project = editor.getProject();
        if (project != null) {
            this.useTabs = editor.getSettings().isUseTabCharacter(project);
            this.tabWidth = editor.getSettings().getTabSize(project);
        }
    }

    public InlayCompletionRequest(CompletionParams params, Editor editor, int cursorOffset) {
        this.params = params;
        this.editor = editor;
        this.cursorOffset = cursorOffset;
        Project project = editor.getProject();
        if (project != null) {
            this.useTabs = editor.getSettings().isUseTabCharacter(project);
            this.tabWidth = editor.getSettings().getTabSize(project);
        }
    }

    public void dispose() {
        this.canceled = true;
    }

    public void cancel() {
        if (this.canceled) {
            return;
        }
        this.canceled = true;
        Disposer.dispose((Disposable)this);
    }

    public boolean equalsRequest(@NotNull InlayCompletionRequest o) {
        if (o == null) {
            InlayCompletionRequest.$$$reportNull$$$0(0);
        }
        if (this.params == null || o.getParams() == null) {
            return false;
        }
        return this.params.getRequestId() == o.getParams().getRequestId();
    }

    public Disposable getDisposable() {
        return this;
    }

    @Generated
    public CompletionParams getParams() {
        return this.params;
    }

    @Generated
    public Editor getEditor() {
        return this.editor;
    }

    @Generated
    public int getCursorOffset() {
        return this.cursorOffset;
    }

    @Generated
    public boolean isUseTabs() {
        return this.useTabs;
    }

    @Generated
    public int getTabWidth() {
        return this.tabWidth;
    }

    @Generated
    public InlayCompletionCollector getCollector() {
        return this.collector;
    }

    @Generated
    public boolean isCanceled() {
        return this.canceled;
    }

    @Generated
    public void setParams(CompletionParams params) {
        this.params = params;
    }

    @Generated
    public void setEditor(Editor editor) {
        this.editor = editor;
    }

    @Generated
    public void setCursorOffset(int cursorOffset) {
        this.cursorOffset = cursorOffset;
    }

    @Generated
    public void setUseTabs(boolean useTabs) {
        this.useTabs = useTabs;
    }

    @Generated
    public void setTabWidth(int tabWidth) {
        this.tabWidth = tabWidth;
    }

    @Generated
    public void setCollector(InlayCompletionCollector collector) {
        this.collector = collector;
    }

    @Generated
    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlayCompletionRequest)) {
            return false;
        }
        InlayCompletionRequest other = (InlayCompletionRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CompletionParams this$params = this.getParams();
        CompletionParams other$params = other.getParams();
        if (this$params == null ? other$params != null : !((Object)((Object)this$params)).equals((Object)other$params)) {
            return false;
        }
        Editor this$editor = this.getEditor();
        Editor other$editor = other.getEditor();
        if (this$editor == null ? other$editor != null : !this$editor.equals(other$editor)) {
            return false;
        }
        if (this.getCursorOffset() != other.getCursorOffset()) {
            return false;
        }
        if (this.isUseTabs() != other.isUseTabs()) {
            return false;
        }
        if (this.getTabWidth() != other.getTabWidth()) {
            return false;
        }
        InlayCompletionCollector this$collector = this.getCollector();
        InlayCompletionCollector other$collector = other.getCollector();
        if (this$collector == null ? other$collector != null : !this$collector.equals(other$collector)) {
            return false;
        }
        return this.isCanceled() == other.isCanceled();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InlayCompletionRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CompletionParams $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)((Object)$params)).hashCode());
        Editor $editor = this.getEditor();
        result = result * 59 + ($editor == null ? 43 : $editor.hashCode());
        result = result * 59 + this.getCursorOffset();
        result = result * 59 + (this.isUseTabs() ? 79 : 97);
        result = result * 59 + this.getTabWidth();
        InlayCompletionCollector $collector = this.getCollector();
        result = result * 59 + ($collector == null ? 43 : $collector.hashCode());
        result = result * 59 + (this.isCanceled() ? 79 : 97);
        return result;
    }

    @Generated
    public String toString() {
        return "InlayCompletionRequest(params=" + this.getParams() + ", editor=" + this.getEditor() + ", cursorOffset=" + this.getCursorOffset() + ", useTabs=" + this.isUseTabs() + ", tabWidth=" + this.getTabWidth() + ", collector=" + this.getCollector() + ", canceled=" + this.isCanceled() + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/alibabacloud/intellij/cosy/editor/model/InlayCompletionRequest", "equalsRequest"));
    }
}

