/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.editor;

import com.alibabacloud.intellij.cosy.ui.search.I18NConstant;
import com.alibabacloud.intellij.cosy.ui.search.color.CosyColor;
import com.alibabacloud.intellij.cosy.ui.search.listener.SelectionMouseListener;
import com.alibabacloud.intellij.cosy.util.KeyboardUtil;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.JBUI;
import icons.CommonIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class InlayCompletionHintFactory {
    private static final Logger LOGGER = Logger.getInstance(InlayCompletionHintFactory.class);

    public static void showHintAtCaret(@NotNull Editor editor) {
        if (editor == null) {
            InlayCompletionHintFactory.$$$reportNull$$$0(0);
        }
        try {
            LOGGER.info("createAndShowHint position");
            InlayCompletionHintFactory.showEditorHint(new LightweightHint(InlayCompletionHintFactory.createInlineHintComponent()), editor, (short)1, 42, 0, false);
        }
        catch (Throwable e) {
            LOGGER.warn("Failed to show inline key bindings hints", e);
        }
    }

    public static void showChatButtonAtCaret(@NotNull Editor editor) {
        if (editor == null) {
            InlayCompletionHintFactory.$$$reportNull$$$0(1);
        }
        try {
            LOGGER.info("createAndShowChatButton position");
            LightweightHint hint = new LightweightHint(InlayCompletionHintFactory.createInlineHintChatButton(editor));
            InlayCompletionHintFactory.showEditorHint(hint, editor, (short)1, 42, 0, false);
        }
        catch (Throwable e) {
            LOGGER.warn("Failed to show inline key bindings hints", e);
        }
    }

    private static JComponent createInlineHintChatButton(Editor editor) {
        ChatHintJComponent component = new ChatHintJComponent(editor);
        return component;
    }

    public static void showHintAtPosition(@NotNull Editor editor, @NotNull Point pos) {
        if (editor == null) {
            InlayCompletionHintFactory.$$$reportNull$$$0(2);
        }
        if (pos == null) {
            InlayCompletionHintFactory.$$$reportNull$$$0(3);
        }
        try {
            LOGGER.info("createAndShowHint position:" + pos);
            HintManagerImpl.getInstanceImpl().showEditorHint(new LightweightHint(InlayCompletionHintFactory.createInlineHintComponent()), editor, pos, 42, 0, false);
        }
        catch (Throwable e) {
            LOGGER.warn("Failed to show inline key bindings hints", e);
        }
    }

    public static void showEditorHint(LightweightHint hint, Editor editor, @HintManager.PositionFlags short constraint, @HintManager.HideFlags int flags, int timeout, boolean reviveOnEditorChange) {
        LogicalPosition pos = editor.getCaretModel().getLogicalPosition();
        Point p = HintManagerImpl.getHintPosition((LightweightHint)hint, (Editor)editor, (LogicalPosition)pos, (short)constraint);
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, p, flags, timeout, reviveOnEditorChange, HintManagerImpl.createHintHint((Editor)editor, (Point)p, (LightweightHint)hint, (short)constraint));
    }

    private static JComponent createInlineHintComponent() {
        SimpleColoredComponent component = HintUtil.createInformationComponent();
        component.setIconOnTheRight(true);
        component.setIcon(CommonIcons.AI);
        SimpleColoredText coloredText = new SimpleColoredText(InlayCompletionHintFactory.hintText(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        coloredText.appendToComponent((ColoredTextContainer)component);
        return new InlineKeybindingHintComponent(component);
    }

    private static String hintText() {
        int cancelShortcut;
        String nextShortcut = KeyboardUtil.getShortcutText("ShowCosyNextInlayCompletionAction");
        String prevShortcut = KeyboardUtil.getShortcutText("ShowCosyPrevInlayCompletionAction");
        String acceptShortcut = KeyboardUtil.getShortcutText("ApplyCosyInlayCompletion");
        String disposeShortcut = KeyboardUtil.getShortcutText("DisposeCosyInlayCompletionAction");
        String triggerShortcut = KeyboardUtil.getShortcutText("TriggerInlayCompletionAction");
        int applyShortcut = KeyboardUtil.getShortcutKeyCode("ApplyCosyInlayCompletion");
        if (applyShortcut == 9) {
            acceptShortcut = "Tab";
        }
        if ((cancelShortcut = KeyboardUtil.getShortcutKeyCode("DisposeCosyInlayCompletionAction")) == 27) {
            disposeShortcut = "Esc";
        }
        return String.format("Accept:%s Prev/Next:%s/%s Cancel:%s Trigger:%s", acceptShortcut, prevShortcut, nextShortcut, disposeShortcut, triggerShortcut);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
        }
        objectArray2[1] = "com/alibabacloud/intellij/cosy/editor/InlayCompletionHintFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "showHintAtCaret";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "showChatButtonAtCaret";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "showHintAtPosition";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ChatHintJComponent
    extends JComponent {
        JButton chatButton;

        public ChatHintJComponent(Editor editor) {
            String shortcutStr = KeyboardUtil.getShortcutText("TriggerCosySelectionChatAction", "");
            this.chatButton = new JButton(I18NConstant.ACTION_TRIGGER_SELECTION_CHAT + " " + shortcutStr);
            this.chatButton.setBorder(BorderFactory.createLineBorder((Color)CosyColor.CHAT_QUICK_ENTRY_BORDER_COLOR, 1, true));
            this.chatButton.setBackground((Color)CosyColor.CHAT_QUICK_ENTRY_BG_COLOR);
            this.chatButton.setSize(80, 20);
            SelectionMouseListener mouseListener = SelectionMouseListener.getListener(editor);
            this.chatButton.addMouseListener(mouseListener);
            this.add(this.chatButton);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(80, 20);
        }
    }

    public static class InlineKeybindingChatHintComponent
    extends JPanel {
        public InlineKeybindingChatHintComponent(@NotNull JComponent component) {
            if (component == null) {
                InlineKeybindingChatHintComponent.$$$reportNull$$$0(0);
            }
            super(new BorderLayout());
            this.setBorder((Border)JBUI.Borders.empty());
            this.add((Component)component, "Center");
            this.setOpaque(true);
            this.setBackground(component.getBackground());
            this.revalidate();
            this.repaint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/alibabacloud/intellij/cosy/editor/InlayCompletionHintFactory$InlineKeybindingChatHintComponent", "<init>"));
        }
    }

    public static class InlineKeybindingHintComponent
    extends JPanel {
        public InlineKeybindingHintComponent(@NotNull SimpleColoredComponent component) {
            if (component == null) {
                InlineKeybindingHintComponent.$$$reportNull$$$0(0);
            }
            super(new BorderLayout());
            this.setBorder((Border)JBUI.Borders.empty());
            this.add((Component)component, "Center");
            this.setOpaque(true);
            this.setBackground(component.getBackground());
            this.revalidate();
            this.repaint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/alibabacloud/intellij/cosy/editor/InlayCompletionHintFactory$InlineKeybindingHintComponent", "<init>"));
        }
    }
}

