/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.editor;

import com.alibabacloud.intellij.cosy.common.CosySetting;
import com.alibabacloud.intellij.cosy.editor.ChatHintSettings;
import com.alibabacloud.intellij.cosy.search.enums.MethodQuickSwitchEnum;
import com.alibabacloud.intellij.cosy.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.cosy.ui.search.I18NConstant;
import com.alibabacloud.intellij.cosy.ui.search.generate.ChatQuestionManager;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.util.JavaPsiUtils;
import com.alibabacloud.intellij.cosy.util.PsiUtils;
import com.intellij.codeInsight.hints.ChangeListener;
import com.intellij.codeInsight.hints.FactoryInlayHintsCollector;
import com.intellij.codeInsight.hints.ImmediateConfigurable;
import com.intellij.codeInsight.hints.InlayHintsCollector;
import com.intellij.codeInsight.hints.InlayHintsProvider;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.SettingsKey;
import com.intellij.codeInsight.hints.presentation.AttributesTransformerPresentation;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.SequencePresentation;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.SmartList;
import icons.LingmaIcons;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CosyEditorChatHintProvider
implements InlayHintsProvider<ChatHintSettings> {
    private static final String CODE_LENS_ID = "Lingma";
    private static final SettingsKey<ChatHintSettings> KEY = new SettingsKey("Lingma");

    @Nullable
    public InlayHintsCollector getCollectorFor(@NotNull PsiFile file, @NotNull Editor editor, @NotNull ChatHintSettings settings, @NotNull InlayHintsSink __) {
        if (file == null) {
            CosyEditorChatHintProvider.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            CosyEditorChatHintProvider.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            CosyEditorChatHintProvider.$$$reportNull$$$0(2);
        }
        if (__ == null) {
            CosyEditorChatHintProvider.$$$reportNull$$$0(3);
        }
        return new FactoryInlayHintsCollector(editor){

            public boolean collect(@NotNull PsiElement element, @NotNull Editor editor, @NotNull InlayHintsSink sink) {
                CosySetting setting;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (editor == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (sink == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((setting = CosyPersistentSetting.getInstance().getState()) != null && setting.getMethodQuickSwitchEnum() != null && MethodQuickSwitchEnum.DISABLED.getType().equals(setting.getMethodQuickSwitchEnum().getType())) {
                    return true;
                }
                PsiElement prevSibling = element.getPrevSibling();
                if (!(prevSibling == null || prevSibling instanceof PsiWhiteSpace && prevSibling.textContains('\n'))) {
                    return true;
                }
                if (!PsiUtils.instanceOf((Object)element, "com.intellij.psi.PsiMethod", "com.jetbrains.python.psi.PyFunction") || PsiUtils.instanceOf((Object)element, "com.intellij.psi.PsiTypeParameter")) {
                    return true;
                }
                if (PsiUtils.instanceOf((Object)element, "com.intellij.psi.PsiMethod") && CosyEditorChatHintProvider.isInvalidJavaMethod(element)) {
                    return true;
                }
                InlResult inlResult = new InlResult(){

                    @Override
                    public void onClick(final @NotNull Editor editor, final @NotNull PsiElement element, @NotNull MouseEvent event) {
                        if (editor == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (element == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (event == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if (editor.getProject() == null) {
                            return;
                        }
                        List<ChatQuestionManager.ChatQuestion> popupActions = ChatQuestionManager.getMethodHintQuestions();
                        ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<ChatQuestionManager.ChatQuestion>("", popupActions){

                            @NotNull
                            public String getTextFor(ChatQuestionManager.ChatQuestion value) {
                                String string = value.getQuestion();
                                if (string == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                return string;
                            }

                            @Nullable
                            public PopupStep<?> onChosen(ChatQuestionManager.ChatQuestion selectedValue, boolean finalChoice) {
                                ActionManager actionManager = ActionManager.getInstance();
                                AnAction action = actionManager.getAction(selectedValue.getActionId());
                                TextRange range = element.getTextRange();
                                editor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
                                DataContext dataContext = DataManager.getInstance().getDataContext((Component)editor.getComponent());
                                AnActionEvent event = new AnActionEvent(null, dataContext, "MenuPopup", new Presentation(), actionManager, 0);
                                action.actionPerformed(event);
                                return FINAL_CHOICE;
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/alibabacloud/intellij/cosy/editor/CosyEditorChatHintProvider$1$1$1", "getTextFor"));
                            }
                        });
                        popup.showInScreenCoordinates((Component)editor.getComponent(), event.getLocationOnScreen());
                    }

                    @Override
                    @NotNull
                    public String getRegularText() {
                        String string = CosyBundle.message("method.quick.ask.text", new Object[0]);
                        if (string == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                            case 3: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 3;
                                break;
                            }
                            case 3: {
                                n2 = 2;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "editor";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "element";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "event";
                                break;
                            }
                            case 3: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/alibabacloud/intellij/cosy/editor/CosyEditorChatHintProvider$1$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/alibabacloud/intellij/cosy/editor/CosyEditorChatHintProvider$1$1";
                                break;
                            }
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getRegularText";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "onClick";
                                break;
                            }
                            case 3: {
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                            case 3: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                };
                PresentationFactory factory = this.getFactory();
                Document document = editor.getDocument();
                int offset = CosyEditorChatHintProvider.getAnchorOffset(element);
                int line = document.getLineNumber(offset);
                int startOffset = document.getLineStartOffset(line);
                String linePrefix = editor.getDocument().getText(new TextRange(startOffset, offset));
                int column = (offset += CosyEditorChatHintProvider.this.findRealOffsetBySpace(editor, linePrefix)) - startOffset;
                SmartList presentations = new SmartList();
                presentations.add(factory.textSpacePlaceholder(column, true));
                presentations.add(factory.smallScaledIcon(LingmaIcons.QuickLogoIcon));
                presentations.add(factory.smallScaledIcon(AllIcons.Actions.FindAndShowNextMatchesSmall));
                presentations.add(factory.textSpacePlaceholder(1, true));
                SequencePresentation shiftedPresentation = new SequencePresentation((List)presentations);
                InlayPresentation finalPresentation = factory.referenceOnHover((InlayPresentation)shiftedPresentation, (event, translated) -> inlResult.onClick(editor, element, event));
                sink.addBlockElement(startOffset, true, true, 300, finalPresentation);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "editor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "sink";
                        break;
                    }
                }
                objectArray[1] = "com/alibabacloud/intellij/cosy/editor/CosyEditorChatHintProvider$1";
                objectArray[2] = "collect";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private int findRealOffsetBySpace(@NotNull Editor editor, String linePrefix) {
        if (editor == null) {
            CosyEditorChatHintProvider.$$$reportNull$$$0(4);
        }
        int tabWidth = editor.getSettings().getTabSize(editor.getProject());
        int totalOffset = 0;
        for (int i = 0; i < linePrefix.length(); ++i) {
            if (linePrefix.charAt(i) != '\t') continue;
            totalOffset += tabWidth;
        }
        return totalOffset;
    }

    private static boolean isInvalidJavaMethod(@NotNull PsiElement element) {
        if (element == null) {
            CosyEditorChatHintProvider.$$$reportNull$$$0(5);
        }
        if (!PsiUtils.instanceOf((Object)element.getParent(), "com.intellij.psi.PsiClass")) {
            return false;
        }
        return JavaPsiUtils.isInvalidJavaMethod(element);
    }

    private static int getAnchorOffset(@NotNull PsiElement element) {
        if (element == null) {
            CosyEditorChatHintProvider.$$$reportNull$$$0(6);
        }
        if (PsiUtils.instanceOf((Object)element, "com.jetbrains.python.psi.PyFunction")) {
            return element.getTextRange().getStartOffset();
        }
        for (PsiElement child : element.getChildren()) {
            if (child instanceof PsiComment || child instanceof PsiWhiteSpace) continue;
            return child.getTextRange().getStartOffset();
        }
        return element.getTextRange().getStartOffset();
    }

    private static boolean isHover(@NotNull Editor editor, @NotNull PsiElement element) {
        if (editor == null) {
            CosyEditorChatHintProvider.$$$reportNull$$$0(7);
        }
        if (element == null) {
            CosyEditorChatHintProvider.$$$reportNull$$$0(8);
        }
        return editor.getCaretModel().getOffset() >= element.getTextRange().getStartOffset() && editor.getCaretModel().getOffset() <= element.getTextRange().getEndOffset();
    }

    @NotNull
    private static InlayPresentation createPresentation(@NotNull PresentationFactory factory, @NotNull PsiElement element, @NotNull Editor editor, @NotNull InlResult result) {
        InlayPresentation finalPresentation;
        if (factory == null) {
            CosyEditorChatHintProvider.$$$reportNull$$$0(9);
        }
        if (element == null) {
            CosyEditorChatHintProvider.$$$reportNull$$$0(10);
        }
        if (editor == null) {
            CosyEditorChatHintProvider.$$$reportNull$$$0(11);
        }
        if (result == null) {
            CosyEditorChatHintProvider.$$$reportNull$$$0(12);
        }
        InlayPresentation textPresentation = factory.smallText(result.getRegularText());
        AttributesTransformerPresentation colorTextPresentation = new AttributesTransformerPresentation(textPresentation, __ -> editor.getColorsScheme().getAttributes(CodeInsightColors.INFORMATION_ATTRIBUTES));
        InlayPresentation inlayPresentation = finalPresentation = factory.referenceOnHover((InlayPresentation)colorTextPresentation, (event, translated) -> result.onClick(editor, element, event));
        if (inlayPresentation == null) {
            CosyEditorChatHintProvider.$$$reportNull$$$0(13);
        }
        return inlayPresentation;
    }

    @NotNull
    public ChatHintSettings createSettings() {
        return new ChatHintSettings();
    }

    @NotNull
    public String getName() {
        String string = I18NConstant.COSY_PLUGIN_NAME;
        if (string == null) {
            CosyEditorChatHintProvider.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public SettingsKey<ChatHintSettings> getKey() {
        SettingsKey<ChatHintSettings> settingsKey = KEY;
        if (settingsKey == null) {
            CosyEditorChatHintProvider.$$$reportNull$$$0(15);
        }
        return settingsKey;
    }

    @NotNull
    public static SettingsKey<ChatHintSettings> getSettingsKey() {
        SettingsKey<ChatHintSettings> settingsKey = KEY;
        if (settingsKey == null) {
            CosyEditorChatHintProvider.$$$reportNull$$$0(16);
        }
        return settingsKey;
    }

    public String getPreviewText() {
        return null;
    }

    @NotNull
    public ImmediateConfigurable createConfigurable(@NotNull ChatHintSettings settings) {
        if (settings == null) {
            CosyEditorChatHintProvider.$$$reportNull$$$0(17);
        }
        return new ImmediateConfigurable(){

            @NotNull
            public JComponent createComponent(@NotNull ChangeListener listener) {
                if (listener == null) {
                    2.$$$reportNull$$$0(0);
                }
                JPanel panel = new JPanel();
                panel.setVisible(false);
                JPanel jPanel = panel;
                if (jPanel == null) {
                    2.$$$reportNull$$$0(1);
                }
                return jPanel;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "listener";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/alibabacloud/intellij/cosy/editor/CosyEditorChatHintProvider$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/alibabacloud/intellij/cosy/editor/CosyEditorChatHintProvider$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createComponent";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createComponent";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public boolean isLanguageSupported(@NotNull Language language) {
        if (language == null) {
            CosyEditorChatHintProvider.$$$reportNull$$$0(18);
        }
        return true;
    }

    public boolean isVisibleInSettings() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "__";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/alibabacloud/intellij/cosy/editor/CosyEditorChatHintProvider";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/alibabacloud/intellij/cosy/editor/CosyEditorChatHintProvider";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createPresentation";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCollectorFor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findRealOffsetBySpace";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isInvalidJavaMethod";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAnchorOffset";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isHover";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createPresentation";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isLanguageSupported";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface InlResult {
        public void onClick(@NotNull Editor var1, @NotNull PsiElement var2, @NotNull MouseEvent var3);

        @NotNull
        public String getRegularText();
    }
}

