/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.editor;

import com.alibabacloud.intellij.cosy.editor.CosyInlayManager;
import com.alibabacloud.intellij.cosy.util.KeyboardUtil;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CosyEditorActionHandler
extends EditorActionHandler {
    private static final Logger LOG = Logger.getInstance(CosyEditorActionHandler.class);
    private static final Set<String> HANDLEABLE_ACTIONS = new HashSet<String>(Arrays.asList("EditorTab", "EditorChooseLookupItemReplace", "EditorChooseLookupItem", "EditorEscape", "ExpandLiveTemplateByTab", "NextTemplateVariable", "\u6807\u7b7e\u9875", "\u9009\u62e9\u67e5\u8be2\u6761\u76ee\u66ff\u6362", "\u9009\u62e9\u67e5\u8be2\u6761\u76ee", "Esc", "\u6309 Tab \u5c55\u5f00\u5b9e\u65f6\u6a21\u677f", "\u4e0b\u4e00\u4e2a\u6a21\u677f\u53d8\u91cf\u6216\u5b8c\u6210\u5c31\u5730\u91cd\u6784"));
    private static final Map<Integer, Set<String>> acceptActions = Map.of(9, Set.of("EditorTab", "EditorChooseLookupItemReplace", "ExpandLiveTemplateByTab", "\u6807\u7b7e\u9875", "\u9009\u62e9\u67e5\u8be2\u6761\u76ee\u66ff\u6362", "\u9009\u62e9\u67e5\u8be2\u6761\u76ee", "NextTemplateVariable"), 39, Set.of("EditorRight", "\u53f3"), 37, Set.of("EditorLeft", "\u5de6"), 38, Set.of("EditorUp", "\u4e0a"), 40, Set.of("EditorDown", "\u4e0b"));
    private final EditorActionHandler handler;
    private final String action;

    public CosyEditorActionHandler(EditorActionHandler handler, String action) {
        this.handler = handler;
        this.action = action;
    }

    protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        if (editor == null) {
            CosyEditorActionHandler.$$$reportNull$$$0(0);
        }
        if (caret == null) {
            CosyEditorActionHandler.$$$reportNull$$$0(1);
        }
        return this.handler.isEnabled(editor, caret, dataContext);
    }

    protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
        if (editor == null) {
            CosyEditorActionHandler.$$$reportNull$$$0(2);
        }
        boolean executeOriginHandler = true;
        LOG.info("execute action:" + this.action);
        if (HANDLEABLE_ACTIONS.contains(this.action) && CosyInlayManager.getInstance().hasCompletionInlays(editor)) {
            int applyShortcut = KeyboardUtil.getShortcutKeyCode("ApplyCosyInlayCompletion");
            int disposeShortcut = KeyboardUtil.getShortcutKeyCode("DisposeCosyInlayCompletionAction");
            LOG.info("allow action:" + this.action + " accept:" + applyShortcut + " dispose:" + disposeShortcut);
            if (acceptActions.containsKey(applyShortcut) && acceptActions.get(applyShortcut).contains(this.action)) {
                LOG.info("do insert inlay:" + this.action);
                ActionManager actionManager = ActionManager.getInstance();
                AnAction action = actionManager.getAction("ApplyCosyInlayCompletion");
                ActionUtil.invokeAction((AnAction)action, (DataContext)dataContext, (String)"EditorTab", null, null);
                executeOriginHandler = false;
            } else if (disposeShortcut == 27 && this.action.equals("EditorEscape")) {
                LOG.info("do escape inlay:" + this.action);
                ActionManager actionManager = ActionManager.getInstance();
                AnAction action = actionManager.getAction("DisposeCosyInlayCompletionAction");
                ActionUtil.invokeAction((AnAction)action, (DataContext)dataContext, (String)"TextEditorWithPreview", null, null);
            }
        }
        if (executeOriginHandler) {
            try {
                this.handler.execute(editor, caret, dataContext);
            }
            catch (Exception e) {
                LOG.warn("execute action:" + this.action + " failed", (Throwable)e);
            }
        }
    }

    public boolean executeInCommand(@NotNull Editor editor, DataContext dataContext) {
        if (editor == null) {
            CosyEditorActionHandler.$$$reportNull$$$0(3);
        }
        return this.handler.executeInCommand(editor, dataContext);
    }

    public boolean runForAllCarets() {
        return this.handler.runForAllCarets();
    }

    public DocCommandGroupId getCommandGroupId(@NotNull Editor editor) {
        if (editor == null) {
            CosyEditorActionHandler.$$$reportNull$$$0(4);
        }
        return this.handler.getCommandGroupId(editor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
        }
        objectArray2[1] = "com/alibabacloud/intellij/cosy/editor/CosyEditorActionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledForCaret";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecute";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "executeInCommand";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getCommandGroupId";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

