/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.core.websocket;

import com.alibabacloud.intellij.cosy.core.lsp.LanguageClientImpl;
import com.alibabacloud.intellij.cosy.core.lsp.model.LanguageClient;
import com.alibabacloud.intellij.cosy.core.lsp.model.LanguageServer;
import com.alibabacloud.intellij.cosy.core.websocket.CosyWebSocketLauncherBuilder;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.Session;
import lombok.Generated;
import org.eclipse.lsp4j.jsonrpc.Launcher;

@ClientEndpoint
public class CosyWebSocketClient {
    private static final Logger log = Logger.getInstance(CosyWebSocketClient.class);
    private Session session;
    LanguageServer server;
    LanguageClient client;
    URI uri;

    public CosyWebSocketClient(URI uri) {
        this.uri = uri;
        this.client = new LanguageClientImpl();
    }

    public void connect() throws DeploymentException, IOException {
        long connectSt = System.currentTimeMillis();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(CosyWebSocketClient.class.getClassLoader());
            this.session = ContainerProvider.getWebSocketContainer().connectToServer((Object)this, this.uri);
            Launcher launcher = new CosyWebSocketLauncherBuilder().setSession(this.session).setLocalService(this.client).setRemoteInterface(LanguageServer.class).validateMessages(true).create();
            this.server = (LanguageServer)launcher.getRemoteProxy();
            log.info(String.format("Cosy websocket startup succeed, cost %d ms", System.currentTimeMillis() - connectSt));
        }
        catch (DeploymentException e) {
            log.warn(String.format("Cosy connect failed, cost %d ms", System.currentTimeMillis() - connectSt), (Throwable)e);
            throw new DeploymentException("Deploying websocket encountered error");
        }
        catch (IOException e) {
            log.error("Connecting websocket encountered IO Exception", (Throwable)e);
            throw new IOException("Connecting websocket encountered IO Exceptionr");
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    public boolean isSessionOpen() {
        return this.session != null && this.session.isOpen();
    }

    public void closeSession() {
        if (this.isSessionOpen()) {
            try {
                this.session.close();
                log.info("Session closed");
            }
            catch (IOException e) {
                log.warn("Session close encountered error" + e.getMessage());
            }
        } else {
            log.warn("Session is already closed");
        }
    }

    public void sendMessage(String str) {
        this.session.getAsyncRemote().sendText(str);
    }

    public LanguageServer getServer() {
        return this.server;
    }

    public LanguageClient getClient() {
        return this.client;
    }

    @OnError
    public void error(Session session, Throwable t) {
        log.error("WebSocket encountered error", t);
    }

    @OnClose
    public void close(Session session, CloseReason reason) {
        log.info("WebSocket closed, reason: " + reason.getReasonPhrase() + " code:" + (Serializable)(reason.getCloseCode() != null ? Integer.valueOf(reason.getCloseCode().getCode()) : "unknown"));
    }

    @Generated
    public Session getSession() {
        return this.session;
    }
}

