/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.core.lsp.model.params;

import com.alibabacloud.intellij.cosy.search.enums.LoginModeEnum;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class LoginParams {
    String loginType;
    String accessKey;
    String secretKey;
    String userName;
    String orgId;
    String personalToken;

    public static LoginParams fromUserName(String userName) {
        LoginParams result = new LoginParams();
        result.setLoginType(LoginModeEnum.USERNAME_ONLY.getLabel());
        result.setUserName(userName);
        return result;
    }

    public static LoginParams fromAccessKey(String accessKey, String secretKey, String orgId) {
        LoginParams result = new LoginParams();
        result.setLoginType(LoginModeEnum.ACCESS_KEY.getLabel());
        result.setAccessKey(accessKey);
        result.setSecretKey(secretKey);
        result.setOrgId(orgId);
        return result;
    }

    public static LoginParams fromAliyun() {
        LoginParams result = new LoginParams();
        result.setLoginType(LoginModeEnum.ALIYUN_ACCOUNT.getLabel());
        return result;
    }

    public static LoginParams fromDedicatedDomain() {
        LoginParams result = new LoginParams();
        result.setLoginType(LoginModeEnum.DEDICATED.getLabel());
        return result;
    }

    public static LoginParams fromPersonalToken(String personalToken, String orgId) {
        LoginParams result = new LoginParams();
        result.setLoginType(LoginModeEnum.PERSONAL_TOKEN.getLabel());
        result.setPersonalToken(personalToken);
        result.setOrgId(orgId);
        return result;
    }

    public boolean validate() {
        if (LoginModeEnum.ALIYUN_ACCOUNT.getLabel().equals(this.getLoginType())) {
            return true;
        }
        if (LoginModeEnum.ACCESS_KEY.getLabel().equals(this.getLoginType())) {
            return StringUtils.isNotBlank((CharSequence)this.getAccessKey()) && StringUtils.isNotBlank((CharSequence)this.getSecretKey());
        }
        if (LoginModeEnum.USERNAME_ONLY.getLabel().equals(this.getLoginType())) {
            return StringUtils.isNotBlank((CharSequence)this.getUserName());
        }
        if (LoginModeEnum.PERSONAL_TOKEN.getLabel().equals(this.getLoginType())) {
            return StringUtils.isNotBlank((CharSequence)this.getPersonalToken());
        }
        return LoginModeEnum.DEDICATED.getLabel().equals(this.getLoginType());
    }

    @Generated
    public String getLoginType() {
        return this.loginType;
    }

    @Generated
    public String getAccessKey() {
        return this.accessKey;
    }

    @Generated
    public String getSecretKey() {
        return this.secretKey;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public String getOrgId() {
        return this.orgId;
    }

    @Generated
    public String getPersonalToken() {
        return this.personalToken;
    }

    @Generated
    public void setLoginType(String loginType) {
        this.loginType = loginType;
    }

    @Generated
    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    @Generated
    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    @Generated
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Generated
    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    @Generated
    public void setPersonalToken(String personalToken) {
        this.personalToken = personalToken;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoginParams)) {
            return false;
        }
        LoginParams other = (LoginParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$loginType = this.getLoginType();
        String other$loginType = other.getLoginType();
        if (this$loginType == null ? other$loginType != null : !this$loginType.equals(other$loginType)) {
            return false;
        }
        String this$accessKey = this.getAccessKey();
        String other$accessKey = other.getAccessKey();
        if (this$accessKey == null ? other$accessKey != null : !this$accessKey.equals(other$accessKey)) {
            return false;
        }
        String this$secretKey = this.getSecretKey();
        String other$secretKey = other.getSecretKey();
        if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$orgId = this.getOrgId();
        String other$orgId = other.getOrgId();
        if (this$orgId == null ? other$orgId != null : !this$orgId.equals(other$orgId)) {
            return false;
        }
        String this$personalToken = this.getPersonalToken();
        String other$personalToken = other.getPersonalToken();
        return !(this$personalToken == null ? other$personalToken != null : !this$personalToken.equals(other$personalToken));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LoginParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $loginType = this.getLoginType();
        result = result * 59 + ($loginType == null ? 43 : $loginType.hashCode());
        String $accessKey = this.getAccessKey();
        result = result * 59 + ($accessKey == null ? 43 : $accessKey.hashCode());
        String $secretKey = this.getSecretKey();
        result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $orgId = this.getOrgId();
        result = result * 59 + ($orgId == null ? 43 : $orgId.hashCode());
        String $personalToken = this.getPersonalToken();
        result = result * 59 + ($personalToken == null ? 43 : $personalToken.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LoginParams(loginType=" + this.getLoginType() + ", accessKey=" + this.getAccessKey() + ", secretKey=" + this.getSecretKey() + ", userName=" + this.getUserName() + ", orgId=" + this.getOrgId() + ", personalToken=" + this.getPersonalToken() + ")";
    }

    @Generated
    public LoginParams() {
    }

    @Generated
    public LoginParams(String loginType, String accessKey, String secretKey, String userName, String orgId, String personalToken) {
        this.loginType = loginType;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.userName = userName;
        this.orgId = orgId;
        this.personalToken = personalToken;
    }
}

