/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.core.lsp;

import com.alibaba.fastjson.JSON;
import com.alibabacloud.intellij.cosy.chat.model.BadFeedbackParam;
import com.alibabacloud.intellij.cosy.chat.model.ChatAskParam;
import com.alibabacloud.intellij.cosy.chat.model.ChatLikeParam;
import com.alibabacloud.intellij.cosy.chat.model.ChatReplyRequestParam;
import com.alibabacloud.intellij.cosy.chat.model.ChatStopParam;
import com.alibabacloud.intellij.cosy.chat.model.ChatSystemEventParam;
import com.alibabacloud.intellij.cosy.chat.model.GenerateCommitMsgParam;
import com.alibabacloud.intellij.cosy.chat.model.result.ChatAskResult;
import com.alibabacloud.intellij.cosy.chat.model.result.ChatLikeResult;
import com.alibabacloud.intellij.cosy.chat.model.result.ChatReplyListResult;
import com.alibabacloud.intellij.cosy.chat.model.result.ChatSystemEventResult;
import com.alibabacloud.intellij.cosy.common.CosyConfig;
import com.alibabacloud.intellij.cosy.completion.model.CosyCompletionItem;
import com.alibabacloud.intellij.cosy.constants.Constants;
import com.alibabacloud.intellij.cosy.core.lsp.model.LanguageClient;
import com.alibabacloud.intellij.cosy.core.lsp.model.LanguageServer;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthGrantInfo;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthLogoutResult;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.ChatSession;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.FeedbackResult;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.GlobalConfig;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.GlobalEndpointConfig;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.IdeSeriesType;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.LoginStartResult;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.RecommendResult;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.UpdateConfigResult;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.ChangeUserSettingParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.CompletionParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.DelChatRecordParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.DelChatSessionParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.GeneralStatisticsParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.GenerateCommitMsgResult;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.GetChatSessionParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.GetGrantInfosParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.ItemSelectedParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.ListChatHistoryParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.LoginParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.SearchParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.UpdateParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.UpdateResult;
import com.alibabacloud.intellij.cosy.core.websocket.CosyWebSocketClient;
import com.alibabacloud.intellij.cosy.search.asyn.Debouncer;
import com.alibabacloud.intellij.cosy.ui.search.track.ReportStatistic;
import com.alibabacloud.intellij.cosy.ui.statusbar.CosyStatusBarWidget;
import com.alibabacloud.intellij.cosy.util.ApplicationUtil;
import com.google.gson.Gson;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.util.Consumer;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.websocket.DeploymentException;
import lombok.Generated;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class LanguageWebSocketService {
    private static final Logger log = Logger.getInstance(LanguageWebSocketService.class);
    LanguageClient client;
    LanguageServer server;
    CosyWebSocketClient webSocketClient;
    public static final String COSY_URI_LINK_PREFIX = "ws://127.0.0.1:";
    private final Debouncer completionDebouncer;
    private final Debouncer inlayCompletionDebouncer;

    private LanguageWebSocketService(CosyWebSocketClient webSocketClient, LanguageClient client, LanguageServer server) {
        this.webSocketClient = webSocketClient;
        this.client = client;
        this.server = server;
        this.completionDebouncer = new Debouncer();
        this.inlayCompletionDebouncer = new Debouncer();
    }

    public static LanguageWebSocketService createService(int port) throws URISyntaxException {
        CosyWebSocketClient webSocketClient = new CosyWebSocketClient(new URI(COSY_URI_LINK_PREFIX + port));
        return new LanguageWebSocketService(webSocketClient, webSocketClient.getClient(), webSocketClient.getServer());
    }

    public void connect() throws DeploymentException, IOException {
        this.webSocketClient.connect();
        this.server = this.webSocketClient.getServer();
    }

    public void cancelInlayCompletion() {
        this.inlayCompletionDebouncer.shutdown();
    }

    public List<CompletionItem> completionWithDebouncer(CompletionParams params, long timeout) {
        return this.completionWithDebouncer(params, 10L, timeout);
    }

    public List<CompletionItem> completionWithDebouncer(CompletionParams params, long delayTime, long timeout) {
        ArrayList<CompletionItem> completionItems = new ArrayList<CompletionItem>();
        Future future = this.completionDebouncer.debounce(params.getRequestId(), () -> this.completion(params, timeout), delayTime, TimeUnit.MILLISECONDS);
        try {
            List result = (List)future.get(timeout, TimeUnit.MILLISECONDS);
            if (result != null) {
                completionItems.addAll(result);
            }
        }
        catch (TimeoutException e) {
            log.warn("cosy completion request timeout, RequestId:" + params.getRequestId());
        }
        catch (CancellationException e) {
            log.warn("cosy completion request canceled, RequestId:" + params.getRequestId());
        }
        catch (InterruptedException e) {
            log.warn("cosy completion debouncer is interrupted, RequestId:" + params.getRequestId());
        }
        catch (Exception e) {
            log.warn("cosy completion error " + e.getMessage() + ", RequestId:" + params.getRequestId(), (Throwable)e);
        }
        return completionItems;
    }

    public List<CompletionItem> completionInlayWithDebouncer(CompletionParams params, long delayTime, long timeout) {
        ArrayList<CompletionItem> completionItems = new ArrayList<CompletionItem>();
        Future future = this.inlayCompletionDebouncer.debounce(params.getRequestId(), () -> this.completion(params, timeout), delayTime, TimeUnit.MILLISECONDS);
        try {
            List result = (List)future.get(timeout, TimeUnit.MILLISECONDS);
            if (result != null) {
                completionItems.addAll(result);
            }
        }
        catch (TimeoutException e) {
            log.warn("cosy completion request timeout, RequestId:" + params.getRequestId());
        }
        catch (CancellationException e) {
            log.warn("cosy completion request canceled, RequestId:" + params.getRequestId());
        }
        catch (InterruptedException e) {
            log.warn("cosy completion debouncer is interrupted, RequestId:" + params.getRequestId());
        }
        catch (Exception e) {
            log.warn("cosy completion error " + e.getMessage() + ", RequestId:" + params.getRequestId(), (Throwable)e);
        }
        return completionItems;
    }

    public void aysncCompletionInlayWithDebouncer(Editor editor, CompletionParams params, long delayTime, long timeout, Consumer<CompletionParams> consumer) {
        this.inlayCompletionDebouncer.debounce(params.getRequestId(), () -> {
            if (consumer != null) {
                consumer.consume((Object)params);
            }
            CosyStatusBarWidget.setStatusBarGenerating(editor.getProject(), true, false);
            List<CompletionItem> ret = this.completion(params, timeout);
            CosyStatusBarWidget.setStatusBarGenerating(editor.getProject(), false, true);
            return ret;
        }, delayTime, TimeUnit.MILLISECONDS);
    }

    public List<CompletionItem> completion(CompletionParams params, long timeout) {
        List result = null;
        try {
            log.info("tongyi trigger completion:" + params.getRequestId() + " local:" + params.getUseLocalModel() + " remote:" + params.getUseRemoteModel());
            CompletableFuture<Either<List<CompletionItem>, CompletionList>> future = this.server.getTextDocumentService().completion(params);
            Either<List<CompletionItem>, CompletionList> either = future.get(timeout, TimeUnit.MILLISECONDS);
            CompletionList list = (CompletionList)either.getRight();
            result = list != null ? list.getItems() : (List)either.getLeft();
        }
        catch (InterruptedException e) {
            log.warn("cosy completion request interrupted");
        }
        catch (TimeoutException e) {
            log.warn("cosy completion request timeout");
        }
        catch (Exception e) {
            log.warn("cosy completion error " + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public RecommendResult search(SearchParams params, long timeout) {
        RecommendResult recommendResult = null;
        log.info("params: " + JSON.toJSON((Object)params));
        try {
            CompletableFuture<Object> future = this.server.getSnippetService().search(params);
            Object either = future.get(timeout, TimeUnit.MILLISECONDS);
            recommendResult = (RecommendResult)JSON.parseObject((String)JSON.toJSONString((Object)either), RecommendResult.class);
        }
        catch (TimeoutException e) {
            log.warn("cosy search request timeout");
        }
        catch (Exception e) {
            log.warn("cosy search error " + e.getMessage(), (Throwable)e);
        }
        return recommendResult;
    }

    public void updateReport(ReportStatistic reportStatistic) {
        this.server.getSnippetService().report(reportStatistic);
    }

    public void changeUsageStatisticsSetting(ChangeUserSettingParams params) {
        this.server.changeUserSetting(params);
    }

    public void itemSelected(CosyCompletionItem item) {
        List arguments = item.getOriginItem().getCommand().getArguments();
        if (arguments.size() > 0) {
            Gson gson = new Gson();
            ItemSelectedParams params = (ItemSelectedParams)gson.fromJson(arguments.get(0).toString(), ItemSelectedParams.class);
            this.server.itemSelected(params);
        }
    }

    public ChatAskResult chatAsk(ChatAskParam params, long timeout) {
        ChatAskResult chatAskResult = null;
        log.debug("params: " + JSON.toJSON((Object)params));
        try {
            CompletableFuture<Object> future = this.server.getChatService().ask(params);
            Object either = future.get(timeout, TimeUnit.MILLISECONDS);
            chatAskResult = (ChatAskResult)JSON.parseObject((String)JSON.toJSONString((Object)either), ChatAskResult.class);
        }
        catch (TimeoutException e) {
            log.warn("cosy chat ask request timeout");
        }
        catch (Exception e) {
            log.warn("cosy chat ask error " + e.getMessage(), (Throwable)e);
        }
        return chatAskResult;
    }

    public ChatReplyListResult chatReplyRequest(ChatReplyRequestParam params, long timeout) {
        ChatReplyListResult chatReplyListResult = null;
        log.debug("params: " + JSON.toJSON((Object)params));
        try {
            CompletableFuture<Object> future = this.server.getChatService().replyRequest(params);
            Object either = future.get(timeout, TimeUnit.MILLISECONDS);
            chatReplyListResult = (ChatReplyListResult)JSON.parseObject((String)JSON.toJSONString((Object)either), ChatReplyListResult.class);
        }
        catch (TimeoutException e) {
            log.warn("cosy chat reply request timeout");
        }
        catch (Exception e) {
            log.warn("cosy chat reply error " + e.getMessage(), (Throwable)e);
        }
        return chatReplyListResult;
    }

    public ChatLikeResult chatLike(ChatLikeParam params, long timeout) {
        ChatLikeResult chatLikeResult = null;
        log.debug("params: " + JSON.toJSON((Object)params));
        try {
            CompletableFuture<Object> future = this.server.getChatService().like(params);
            Object either = future.get(timeout, TimeUnit.MILLISECONDS);
            chatLikeResult = (ChatLikeResult)JSON.parseObject((String)JSON.toJSONString((Object)either), ChatLikeResult.class);
        }
        catch (TimeoutException e) {
            log.warn("cosy chat like request timeout");
        }
        catch (Exception e) {
            log.warn("cosy chat like error " + e.getMessage(), (Throwable)e);
        }
        return chatLikeResult;
    }

    public void chatStop(ChatStopParam params) {
        log.debug("params: " + JSON.toJSON((Object)params));
        try {
            this.server.getChatService().stop(params);
        }
        catch (Exception e) {
            log.warn("cosy chat stop error " + e.getMessage(), (Throwable)e);
        }
    }

    public ChatSystemEventResult chatSystemEvent(ChatSystemEventParam params, long timeout) {
        ChatSystemEventResult chatSystemEventResult = null;
        log.debug("params: " + JSON.toJSON((Object)params));
        try {
            CompletableFuture<Object> future = this.server.getChatService().systemEvent(params);
            Object either = future.get(timeout, TimeUnit.MILLISECONDS);
            chatSystemEventResult = (ChatSystemEventResult)JSON.parseObject((String)JSON.toJSONString((Object)either), ChatSystemEventResult.class);
        }
        catch (TimeoutException e) {
            log.warn("cosy chat system event request timeout");
        }
        catch (Exception e) {
            log.warn("cosy chat system event error " + e.getMessage(), (Throwable)e);
        }
        return chatSystemEventResult;
    }

    public List<ChatSession> listAllSessions(ListChatHistoryParams listChatHistoryParams, long timeout) {
        List<ChatSession> chatHistoryRecords = null;
        log.debug("params: " + JSON.toJSON((Object)listChatHistoryParams));
        try {
            CompletableFuture<List<ChatSession>> future = this.server.getChatService().listAllSessions(listChatHistoryParams);
            chatHistoryRecords = future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            log.warn("Lingma chat list all sessions request timeout");
        }
        catch (Exception e) {
            log.warn("Lingma chat list all sessions error " + e.getMessage(), (Throwable)e);
        }
        return chatHistoryRecords;
    }

    public ChatSession getSessionById(GetChatSessionParams getChatSessionParams, long timeout) {
        ChatSession chatSession = null;
        log.debug("params: " + JSON.toJSON((Object)getChatSessionParams));
        try {
            CompletableFuture<ChatSession> future = this.server.getChatService().getSessionById(getChatSessionParams);
            chatSession = future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            log.warn("Lingma chat get session by id request timeout");
        }
        catch (Exception e) {
            log.warn("Lingma chat get session by id error " + e.getMessage(), (Throwable)e);
        }
        return chatSession;
    }

    public boolean deleteChatById(DelChatRecordParams delChatRecordParams) {
        log.debug("params: " + JSON.toJSON((Object)delChatRecordParams));
        try {
            this.server.getChatService().deleteChatById(delChatRecordParams);
            return true;
        }
        catch (Exception e) {
            log.warn("Lingma chat delete chat by id error " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean deleteSessionById(DelChatSessionParams delChatSessionParams) {
        log.debug("params: " + JSON.toJSON((Object)delChatSessionParams));
        try {
            this.server.getChatService().deleteSessionById(delChatSessionParams);
            return true;
        }
        catch (Exception e) {
            log.warn("Lingma chat delete session by id error " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean clearAllSessions() {
        try {
            this.server.getChatService().clearAllSessions();
            return true;
        }
        catch (Exception e) {
            log.warn("Lingma chat clear all sessions error " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public LoginStartResult authLogin(LoginParams loginParams, long timeout) {
        try {
            CompletableFuture<LoginStartResult> future = this.server.getAuthService().login(loginParams);
            return future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            log.warn("cosy auth login request timeout");
        }
        catch (Exception e) {
            log.warn("cosy login error " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public AuthStatus authStatus(long timeout) {
        return this.authStatus(timeout, 1);
    }

    public AuthStatus authStatus(long timeout, int retryCount) {
        for (int i = 0; i < retryCount; ++i) {
            try {
                CompletableFuture<AuthStatus> future = this.server.getAuthService().status();
                return future.get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                log.warn("cosy get auth status timeout");
            }
            catch (Exception e) {
                log.warn("cosy get auth status error " + e.getMessage(), (Throwable)e);
            }
            if (i >= retryCount - 1) continue;
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean authLogout(long timeout) {
        try {
            CompletableFuture<AuthLogoutResult> future = this.server.getAuthService().logout();
            AuthLogoutResult result = future.get(timeout, TimeUnit.MILLISECONDS);
            if (result != null && result.getSuccess() != null) {
                return result.getSuccess();
            }
        }
        catch (TimeoutException e) {
            log.warn("cosy auth logout timeout");
        }
        catch (Exception e) {
            log.warn("cosy logout error " + e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public List<AuthGrantInfo> getGrantInfos(GetGrantInfosParams params, long timeout) {
        try {
            CompletableFuture<List<AuthGrantInfo>> future = this.server.getAuthService().grantInfos(params);
            return future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            log.warn("cosy auth get grant infos timeout");
        }
        catch (Exception e) {
            log.warn("cosy auth get grant infos error " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public GlobalConfig getGlobalConfig(long timeout) {
        try {
            CompletableFuture<GlobalConfig> future = this.server.getGlobalConfig();
            return future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            log.warn("get global config timeout");
        }
        catch (Exception e) {
            log.warn("cosy global config error " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public void updateGlobalConfig(GlobalConfig params, long timeout) {
        try {
            this.server.updateGlobalConfig(params);
        }
        catch (Exception e) {
            log.warn("cosy update global config error " + e.getMessage(), (Throwable)e);
        }
    }

    public GlobalEndpointConfig getEndpointConfig(long timeout) {
        try {
            CompletableFuture<GlobalEndpointConfig> future = this.server.getEndpoint();
            return future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            log.warn("get global endpoint timeout");
        }
        catch (Exception e) {
            log.warn("cosy global endpoint error " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public UpdateConfigResult updateEndpoint(GlobalEndpointConfig params, long timeout) {
        try {
            CompletableFuture<UpdateConfigResult> future = this.server.updateEndpoint(params);
            return future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            log.warn("cosy update endpoint config error " + e.getMessage(), (Throwable)e);
            return new UpdateConfigResult(false);
        }
    }

    public FeedbackResult submitFeedback(BadFeedbackParam badFeedbackParam, long timeout) {
        FeedbackResult feedbackResult = null;
        log.debug("params: " + JSON.toJSON((Object)badFeedbackParam));
        try {
            CompletableFuture<Object> future = this.server.getFeedbackService().submit(badFeedbackParam);
            Object either = future.get(timeout, TimeUnit.MILLISECONDS);
            feedbackResult = (FeedbackResult)JSON.parseObject((String)JSON.toJSONString((Object)either), FeedbackResult.class);
        }
        catch (TimeoutException e) {
            log.warn("cosy submit feedback request timeout");
        }
        catch (Exception e) {
            log.warn("cosy submit feedback error " + e.getMessage(), (Throwable)e);
        }
        return feedbackResult;
    }

    public void telemetry(String eventType, String requestId, Map<String, String> data) {
        GeneralStatisticsParams params = new GeneralStatisticsParams();
        params.setEventType(eventType);
        params.setRequestId(requestId);
        params.setEventData(data);
        params.setIdeVersion(CosyConfig.IDE_VERSION);
        params.setIdeType(CosyConfig.IDE_NAME);
        this.server.telemetry(params);
    }

    public UpdateResult ideUpdate(boolean autoDownload, long timeout) {
        try {
            UpdateParams params = new UpdateParams();
            params.setAutoDownload(autoDownload);
            params.setIdeType(IdeSeriesType.JETBRAINS.getName().toLowerCase(Locale.ROOT));
            params.setIdeVersion(ApplicationUtil.getApplicationVersion());
            params.setPluginVersion(Constants.getPluginVersion());
            CompletableFuture<UpdateResult> future = this.server.ideUpdate(params);
            return future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            log.warn("cosy update timeout");
        }
        catch (Exception e) {
            log.warn("cosy update error " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public GenerateCommitMsgResult generateCommitMsg(GenerateCommitMsgParam params, long timeout) {
        GenerateCommitMsgResult generateCommitMsgResult = null;
        log.debug("params: " + JSON.toJSON((Object)params));
        try {
            CompletableFuture<GenerateCommitMsgResult> future = this.server.generateCommitMsg(params);
            GenerateCommitMsgResult either = future.get(timeout, TimeUnit.MILLISECONDS);
            generateCommitMsgResult = (GenerateCommitMsgResult)JSON.parseObject((String)JSON.toJSONString((Object)either), GenerateCommitMsgResult.class);
        }
        catch (TimeoutException e) {
            log.warn("cosy generate commit message request timeout");
        }
        catch (Exception e) {
            log.warn("cosy generate commit message  error " + e.getMessage(), (Throwable)e);
        }
        return generateCommitMsgResult;
    }

    public LanguageServer getServer() {
        return this.server;
    }

    public boolean isSessionOpen() {
        return this.webSocketClient.isSessionOpen();
    }

    public void closeSession() {
        this.webSocketClient.closeSession();
    }

    public CosyWebSocketClient getWebSocketClient() {
        return this.webSocketClient;
    }

    @Generated
    public LanguageClient getClient() {
        return this.client;
    }
}

