/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.core.lsp;

import com.alibabacloud.intellij.cosy.chat.action.CosyCommitMessageGenerationAction;
import com.alibabacloud.intellij.cosy.chat.processor.ChatAnswerProcessor;
import com.alibabacloud.intellij.cosy.chat.processor.ChatFinishProcessor;
import com.alibabacloud.intellij.cosy.chat.processor.ChatProcessStepCallbackParamsProcessor;
import com.alibabacloud.intellij.cosy.common.CosyCacheKeys;
import com.alibabacloud.intellij.cosy.core.lsp.exception.LspInputInvalidException;
import com.alibabacloud.intellij.cosy.core.lsp.model.LanguageClient;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.GlobalConfig;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.GlobalEndpointConfig;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.CandidateAnalyzeParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.ChatAnswerParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.ChatFinishParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.ChatProcessStepCallbackParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.GenerateCommitMsgAnswerParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.GenerateCommitMsgFinishParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.InheritClassAnalyzeParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.PublishExperimentalParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.UpdateMessage;
import com.alibabacloud.intellij.cosy.editor.model.InlayCompletionRequest;
import com.alibabacloud.intellij.cosy.linguist.model.CandidateWithPsi;
import com.alibabacloud.intellij.cosy.linguist.model.ItemBase;
import com.alibabacloud.intellij.cosy.linguist.processor.AvailableListProcessor;
import com.alibabacloud.intellij.cosy.linguist.processor.CandidateAnalyzeProcessor;
import com.alibabacloud.intellij.cosy.linguist.processor.IsInheritsProcessor;
import com.alibabacloud.intellij.cosy.linguist.processor.ListVariablesProcessor;
import com.alibabacloud.intellij.cosy.linguist.psi.model.resolved.CosyPsiVariable;
import com.alibabacloud.intellij.cosy.service.FeatureService;
import com.alibabacloud.intellij.cosy.service.UserAuthService;
import com.alibabacloud.intellij.cosy.update.PluginDiskInstaller;
import com.alibabacloud.intellij.cosy.util.EditorUtil;
import com.alibabacloud.intellij.cosy.util.LoginUtil;
import com.alibabacloud.intellij.cosy.util.ProjectUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import java.io.File;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.SwingUtilities;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import org.eclipse.lsp4j.TextDocumentPositionParams;

public class LanguageClientImpl
implements LanguageClient {
    private static final Logger log = Logger.getInstance(LanguageClientImpl.class);
    private static ConcurrentLinkedQueue<String> invalidRequestQueue = new ConcurrentLinkedQueue();
    private static final int MAX_INVALID_SIZE = 20;

    @Override
    public void telemetryEvent(Object object) {
    }

    @Override
    public void publishDiagnostics(PublishDiagnosticsParams diagnostics) {
    }

    @Override
    public void showMessage(MessageParams messageParams) {
        log.info(messageParams.getMessage());
    }

    @Override
    public CompletableFuture<MessageActionItem> showMessageRequest(ShowMessageRequestParams requestParams) {
        return null;
    }

    @Override
    public void logMessage(MessageParams message) {
        log.info(message.getMessage());
    }

    @Override
    public CompletableFuture<List<ItemBase>> showAvailableList(TextDocumentPositionParams params) {
        if (params == null || params.getTextDocument().getUri() == null || params.getPosition() == null) {
            return LanguageClientImpl.failed(new LspInputInvalidException(String.format("Get available list input params %s invalid", params.toString())));
        }
        AvailableListProcessor availableListProcessor = new AvailableListProcessor(params.getTextDocument().getUri(), params.getPosition());
        return CompletableFuture.supplyAsync(() -> availableListProcessor.getAvailableList());
    }

    @Override
    public CompletableFuture<List<CandidateWithPsi>> analyzeCandidate(CandidateAnalyzeParams params) {
        if (params == null || CollectionUtils.isEmpty(params.getCandidates()) || params.getTextDocument().getUri() == null || params.getPosition() == null) {
            return LanguageClientImpl.failed(new LspInputInvalidException(String.format("Candidate analyze params %s invalid", params.toString())));
        }
        CandidateAnalyzeProcessor candidateAnalyzeProcessor = new CandidateAnalyzeProcessor(params.getCandidates(), params.getTextDocument().getUri(), params.getPosition());
        return CompletableFuture.supplyAsync(() -> candidateAnalyzeProcessor.analyze());
    }

    @Override
    public CompletableFuture<List<CosyPsiVariable>> listVariables(TextDocumentPositionParams params) {
        if (params == null || params.getTextDocument().getUri() == null || params.getPosition() == null) {
            return LanguageClientImpl.failed(new LspInputInvalidException(String.format("List variables params %s invalid", params.toString())));
        }
        ListVariablesProcessor listVariablesProcessor = new ListVariablesProcessor(params.getTextDocument().getUri(), params.getPosition());
        return CompletableFuture.supplyAsync(() -> listVariablesProcessor.list());
    }

    @Override
    public CompletableFuture<List<Boolean>> isInherits(InheritClassAnalyzeParams params) {
        if (params == null || params.getTextDocument().getUri() == null || params.getPosition() == null || params.getClassPairs() == null) {
            return LanguageClientImpl.failed(new LspInputInvalidException(String.format("Is inherits params %s invalid", params.toString())));
        }
        IsInheritsProcessor isInheritsProcessor = new IsInheritsProcessor(params.getClassPairs(), params.getTextDocument().getUri(), params.getPosition());
        return CompletableFuture.supplyAsync(() -> isInheritsProcessor.check());
    }

    @Override
    public CompletableFuture<Boolean> answer(ChatAnswerParams chatAnswerParams) {
        if (chatAnswerParams == null) {
            return LanguageClientImpl.failed(new Exception("chatAnswerParams is null."));
        }
        ChatAnswerProcessor chatAnswerProcessor = new ChatAnswerProcessor(chatAnswerParams);
        log.debug("Answering. sessionId=" + chatAnswerParams.getSessionId() + ", requestId=" + chatAnswerParams.getRequestId());
        return CompletableFuture.supplyAsync(chatAnswerProcessor::updateAnswer);
    }

    @Override
    public CompletableFuture<Boolean> processStepCallback(ChatProcessStepCallbackParams chatProcessStepCallbackParams) {
        if (chatProcessStepCallbackParams == null) {
            return LanguageClientImpl.failed(new Exception("chatProcessStepCallbackParams is null."));
        }
        ChatProcessStepCallbackParamsProcessor chatProcessStepCallbackParamsProcessor = new ChatProcessStepCallbackParamsProcessor(chatProcessStepCallbackParams);
        log.debug("Process step callback. sessionId=" + chatProcessStepCallbackParams.getSessionId() + ", requestId=" + chatProcessStepCallbackParams.getRequestId());
        return CompletableFuture.supplyAsync(chatProcessStepCallbackParamsProcessor::updateProcessStep);
    }

    @Override
    public CompletableFuture<Boolean> finish(ChatFinishParams chatFinishParams) {
        if (chatFinishParams == null) {
            return LanguageClientImpl.failed(new Exception("chatAnswerParams is null."));
        }
        log.info("Ask finish. sessionId=" + chatFinishParams.getSessionId() + " requestId=" + chatFinishParams.getRequestId());
        ChatFinishProcessor chatFinishProcessor = new ChatFinishProcessor(chatFinishParams);
        return CompletableFuture.supplyAsync(chatFinishProcessor::finish);
    }

    public static <R> CompletableFuture<R> failed(Throwable error) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(error);
        return future;
    }

    @Override
    public CompletableFuture<Boolean> collectCompletionResult(CompletionItem completionItem) {
        String requestId = null;
        String cacheRequestId = null;
        if (completionItem.getData() instanceof JsonObject) {
            JsonElement cacheIdEl;
            JsonObject jsonObject = (JsonObject)completionItem.getData();
            JsonElement el = jsonObject.get("RequestId");
            if (el != null) {
                requestId = el.getAsString();
            }
            if ((cacheIdEl = jsonObject.get("CacheId")) != null) {
                cacheRequestId = cacheIdEl.getAsString();
            }
            log.info("receive request result " + requestId + " cacheId:" + cacheRequestId);
            if (StringUtils.isNotBlank((CharSequence)requestId)) {
                for (String id : invalidRequestQueue) {
                    if (!id.equals(requestId)) continue;
                    log.info("ignore invalid request " + requestId);
                    return CompletableFuture.completedFuture(true);
                }
            }
        }
        String finalRequestId = requestId;
        SwingUtilities.invokeLater(() -> {
            log.debug("run swing request result " + finalRequestId);
            InlayCompletionRequest req = this.getInlayCompletionRequest();
            if (req == null) {
                log.warn("invalid request in editor");
                invalidRequestQueue.offer(finalRequestId);
                if (invalidRequestQueue.size() > 20) {
                    invalidRequestQueue.poll();
                }
                return;
            }
            if (req.isCanceled()) {
                log.warn(req.getParams().getRequestId() + " request has canceled");
                return;
            }
            if (finalRequestId != null && !req.getParams().getRequestId().equals(finalRequestId)) {
                log.debug("ignore request id:" + finalRequestId);
                invalidRequestQueue.offer(finalRequestId);
                if (invalidRequestQueue.size() > 20) {
                    invalidRequestQueue.poll();
                }
                return;
            }
            req.getCollector().onCollect(completionItem);
            req.getCollector().onComplete();
        });
        return CompletableFuture.completedFuture(false);
    }

    private InlayCompletionRequest getInlayCompletionRequest() {
        InlayCompletionRequest req = null;
        Editor editor = EditorUtil.getActiveEditor();
        if (editor == null) {
            log.warn("Cannot get active editor, try get by project");
            Project project = ProjectUtils.getActiveProject();
            if (project != null) {
                req = (InlayCompletionRequest)CosyCacheKeys.KEY_COMPLETION_LATEST_PROJECT_REQUEST.get((UserDataHolder)project);
            }
        } else {
            req = (InlayCompletionRequest)CosyCacheKeys.KEY_COMPLETION_LATEST_REQUEST.get((UserDataHolder)editor);
        }
        return req;
    }

    @Override
    public CompletableFuture<Void> authReport(AuthStatus authStatus) {
        log.info("consuming auth report:" + authStatus);
        LoginUtil.setLoginResult(authStatus);
        LoginUtil.notifyAuthLogin();
        return CompletableFuture.runAsync(() -> SwingUtilities.invokeLater(() -> UserAuthService.getInstance().authReport(authStatus)));
    }

    @Override
    public CompletableFuture<Void> changeEndpointConfig(GlobalEndpointConfig endpointConfig) {
        log.info("JetBrains changeEndpointConfig:" + (endpointConfig != null ? endpointConfig.getEndpoint() : "null"));
        return CompletableFuture.runAsync(() -> SwingUtilities.invokeLater(() -> {
            Project activeProject = ProjectUtils.getActiveProject();
            if (activeProject != null) {
                CosyCacheKeys.KEY_ENDPOINT_CONFIG.set((UserDataHolder)activeProject, (Object)endpointConfig);
            }
        }));
    }

    @Override
    public CompletableFuture<Void> changeGlobalConfig(GlobalConfig globalConfig) {
        return CompletableFuture.runAsync(() -> SwingUtilities.invokeLater(() -> {
            Project activeProject = ProjectUtils.getActiveProject();
            if (activeProject != null) {
                CosyCacheKeys.KEY_GLOBAL_CONFIG.set((UserDataHolder)activeProject, (Object)globalConfig);
            }
        }));
    }

    @Override
    public void publishExperimental(PublishExperimentalParams experimental) {
        if (experimental != null && experimental.getFeatures() != null) {
            FeatureService.getInstance().updateFeatures(experimental.getFeatures());
        }
    }

    @Override
    public CompletableFuture<Void> updateReady(UpdateMessage updateMessage) {
        log.info("consuming update ready:" + updateMessage);
        return CompletableFuture.runAsync(() -> {
            File file = new File(updateMessage.getFilePath());
            if (!file.exists()) {
                log.warn("update file not exist:" + updateMessage.getFilePath());
                return;
            }
            SwingUtilities.invokeLater(() -> {
                Project activeProject = ProjectUtils.getActiveProject();
                if (activeProject != null) {
                    PluginDiskInstaller.installFromDisk(activeProject, file);
                } else {
                    log.warn("invalid active project");
                }
            });
        });
    }

    @Override
    public CompletableFuture<Boolean> commitMsgAnswer(GenerateCommitMsgAnswerParams generateCommitMsgAnswerParams) {
        CosyCommitMessageGenerationAction commitMessageGenerationAction = (CosyCommitMessageGenerationAction)ActionManager.getInstance().getAction("TriggerCosyCommitMessageGenerationAction");
        log.info("commitMsgAnswer answering. requestId=" + generateCommitMsgAnswerParams.getRequestId() + ", text=" + generateCommitMsgAnswerParams.getText());
        return CompletableFuture.supplyAsync(() -> commitMessageGenerationAction.updateAnswer(generateCommitMsgAnswerParams));
    }

    @Override
    public CompletableFuture<Boolean> commitMsgFinish(GenerateCommitMsgFinishParams generateCommitMsgFinishParams) {
        CosyCommitMessageGenerationAction commitMessageGenerationAction = (CosyCommitMessageGenerationAction)ActionManager.getInstance().getAction("TriggerCosyCommitMessageGenerationAction");
        return CompletableFuture.supplyAsync(() -> commitMessageGenerationAction.finishAnswer(generateCommitMsgFinishParams));
    }
}

