/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.core;

import com.alibabacloud.intellij.cosy.common.CosyConfig;
import com.alibabacloud.intellij.cosy.common.CosySetting;
import com.alibabacloud.intellij.cosy.constants.Constants;
import com.alibabacloud.intellij.cosy.core.BinaryManager;
import com.alibabacloud.intellij.cosy.core.BinaryRunner;
import com.alibabacloud.intellij.cosy.core.CosyStartupListener;
import com.alibabacloud.intellij.cosy.core.lsp.LanguageWebSocketService;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.IdePlatformType;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.IdeSeriesType;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.InitializeResultExt;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.ChangeUserSettingParams;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.InitializeParamsWithConfig;
import com.alibabacloud.intellij.cosy.core.websocket.CosyHeartbeatRunner;
import com.alibabacloud.intellij.cosy.search.enums.CodeCompletionCandidateEnum;
import com.alibabacloud.intellij.cosy.search.enums.CodeCompletionModeEnum;
import com.alibabacloud.intellij.cosy.service.FeatureService;
import com.alibabacloud.intellij.cosy.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.cosy.ui.notifications.GrantAuthorNotification;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.util.ApplicationUtil;
import com.alibabacloud.intellij.cosy.util.JsonUtil;
import com.alibabacloud.intellij.cosy.util.LoginUtil;
import com.alibabacloud.intellij.cosy.util.ProcessUtils;
import com.alibabacloud.intellij.cosy.util.ProjectUtils;
import com.alibabacloud.intellij.cosy.util.SlideWindowStatQps;
import com.alibabacloud.intellij.cosy.util.StringUtils;
import com.alibabacloud.intellij.cosy.util.ThreadUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class Cosy {
    private static final Logger log = Logger.getInstance(Cosy.class);
    private static final long STARTUP_TIMEOUT = 10000L;
    public static final Cosy INSTANCE = new Cosy();
    public static final int DEFAULT_LINGMA_PORT = 36510;
    public Map<String, Boolean> readyMap;
    private Map<String, LanguageWebSocketService> languageServiceMap;
    private BinaryRunner binaryRunner;
    public int cosyStartRetryTimes = 0;
    public static final String COSY_INFO_FILE_NAME = ".info";
    public static final int MAX_COSY_START_RETRY_TIMES = 3;
    public static final int INFO_FILE_EXISTS_WAIT_TIME_MS = 500;
    public static final int MAX_INFO_FILE_RETRY_TIMES = 20;
    public static final int INFO_FILE_LINE_COUNT = 2;
    private SlideWindowStatQps statQps;
    private Map<String, Lock> startLockMap = new ConcurrentHashMap<String, Lock>();
    private Map<String, AtomicBoolean> startingStateMap = new ConcurrentHashMap<String, AtomicBoolean>();

    @Contract(pure=true)
    private Cosy() {
        this.readyMap = new ConcurrentHashMap<String, Boolean>();
        this.languageServiceMap = new ConcurrentHashMap<String, LanguageWebSocketService>();
        this.statQps = new SlideWindowStatQps();
    }

    public void start(Project project) {
        this.start(project, Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Project project, List<CosyStartupListener> listeners) {
        if (project == null || project.getBasePath() == null) {
            log.warn("Project is not defined when Cosy is starting");
            listeners.forEach(CosyStartupListener::onCancelled);
            return;
        }
        AtomicBoolean startingState = this.startingStateMap.computeIfAbsent(project.getName(), e -> new AtomicBoolean(false));
        if (startingState.get()) {
            log.warn("Project " + project.getName() + " is starting cosy, ignore repeat starting");
            listeners.forEach(CosyStartupListener::onCancelled);
            return;
        }
        AtomicBoolean atomicBoolean = startingState;
        synchronized (atomicBoolean) {
            if (startingState.get()) {
                log.warn("Project " + project.getName() + " is starting cosy, ignore repeat starting");
                listeners.forEach(CosyStartupListener::onCancelled);
                return;
            }
            startingState.getAndSet(true);
            ThreadUtil.execute(() -> this.doStart(project, listeners, startingState));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStart(Project project, List<CosyStartupListener> listeners, AtomicBoolean startingState) {
        ArrayList<WorkspaceFolder> workspaceFolders = new ArrayList<WorkspaceFolder>();
        WorkspaceFolder folder = new WorkspaceFolder();
        folder.setName(project.getName());
        folder.setUri(ProjectUtils.getProjectBaseDir(project));
        workspaceFolders.add(folder);
        InitializeParamsWithConfig params = new InitializeParamsWithConfig();
        params.setWorkspaceFolders(workspaceFolders);
        Lock startLock = this.startLockMap.computeIfAbsent(project.getName(), e -> new ReentrantLock());
        if (!startLock.tryLock()) {
            log.warn("Cannot get start lock for project:" + project.getName());
            listeners.forEach(CosyStartupListener::onCancelled);
            return;
        }
        try {
            log.info(CosyBundle.message("check.cosy.version.state", new Object[0]));
            BinaryManager.INSTANCE.checkBinary(false);
            log.info("starting to startup cosy");
            log.info(CosyBundle.message("start.cosy.process.state", new Object[0]));
            if (INSTANCE.startup(project, params, listeners, false)) {
                log.info("succeed to startup cosy");
                GrantAuthorNotification.notifyNeedLogin(project, false);
                this.cosyStartRetryTimes = 0;
            } else {
                log.info("failed to startup cosy");
                GrantAuthorNotification.notifyError(project);
                listeners.forEach(CosyStartupListener::onFailed);
            }
        }
        finally {
            startingState.getAndSet(false);
            startLock.unlock();
        }
    }

    private File getCosyHomeDir() {
        File homeDir = CosyConfig.getHomeDirectory().toFile();
        log.info("cosy home dir " + homeDir);
        if (!homeDir.exists() && !homeDir.mkdirs()) {
            log.error("fail to create directory " + homeDir);
            return null;
        }
        return homeDir;
    }

    public boolean startup(Project project, InitializeParamsWithConfig params, boolean debugMode) {
        return this.startup(project, params, Collections.emptyList(), debugMode);
    }

    public boolean startup(Project project, InitializeParamsWithConfig params, List<CosyStartupListener> listeners, boolean debugMode) {
        try {
            File homeDir = this.getCosyHomeDir();
            if (homeDir == null) {
                log.warn("Invalid binary directory");
                return false;
            }
            if (this.binaryRunner == null) {
                this.binaryRunner = new BinaryRunner(homeDir);
            }
            if (this.cosyStartRetryTimes == 3) {
                log.warn(String.format("Init Cosy language service error, reached maximum retry times (%d)", this.cosyStartRetryTimes));
                return false;
            }
            boolean isInitSuccess = this.initCosyLanguageService(project, homeDir, debugMode);
            if (!isInitSuccess) {
                log.warn("Cosy init failed");
                return true;
            }
            log.info("Cosy process connected succeed");
            LanguageWebSocketService languageService = this.languageServiceMap.get(project.getLocationHash());
            if (languageService.getServer() == null) {
                log.warn("The server of language service is null");
                return false;
            }
            this.addConfigToInitializeParams(params);
            log.info("Cosy send initialize message");
            CompletableFuture<InitializeResultExt> future = languageService.getServer().initialize(params);
            InitializeResultExt latestInitializeResult = future.get(10000L, TimeUnit.MILLISECONDS);
            log.info("Cosy initialize receive InitializeResultExt");
            if (latestInitializeResult != null) {
                if (log.isDebugEnabled()) {
                    log.debug("get cosy initialize result" + JsonUtil.toJson((Object)latestInitializeResult));
                }
                FeatureService.getInstance().updateFeatures(latestInitializeResult.getExperimental());
            }
            this.readyMap.put(project.getLocationHash(), Boolean.TRUE);
            AuthStatus status = languageService.authStatus(3000L);
            if (status != null) {
                log.info("get login status:" + status.getStatus());
                LoginUtil.updateAuthStatus(project, status, false);
            }
            listeners.forEach(CosyStartupListener::onStartup);
            return true;
        }
        catch (TimeoutException e) {
            log.warn("startup cosy timeout");
            listeners.forEach(CosyStartupListener::onTimeout);
            return true;
        }
        catch (Exception e) {
            log.error("startup cosy failed.", (Throwable)e);
            return false;
        }
    }

    public boolean checkCosyProcess() {
        File homeDir = this.getCosyHomeDir();
        if (homeDir == null) {
            return false;
        }
        File infoFile = new File(homeDir, COSY_INFO_FILE_NAME);
        if (!infoFile.exists()) {
            return false;
        }
        Pair<Integer, Long> infoPair = this.checkInfoFile(infoFile);
        if (infoPair != null) {
            Integer port = (Integer)infoPair.first;
            Long pid = (Long)infoPair.second;
            if (pid != null && port != null && ProcessUtils.isProcessAlive(pid)) {
                log.info("check process pid:" + pid + " port:" + port + " valid");
                return true;
            }
        }
        return false;
    }

    private void addConfigToInitializeParams(InitializeParamsWithConfig params) {
        params.setIdeSeries(IdeSeriesType.JETBRAINS.getName());
        params.setIdePlatform(IdePlatformType.IDEA.getName());
        params.setPluginVersion(Constants.getPluginVersion());
        params.setIdeVersion(ApplicationUtil.getApplicationVersion());
        CosySetting setting = CosyPersistentSetting.getInstance().getState();
        boolean isAllowStatistics = setting != null && setting.isAllowReportUsage();
        params.setAllowStatistics(isAllowStatistics);
        String inferenceModeChanged = setting == null || setting.getParameter() == null ? CodeCompletionModeEnum.AUTO.mode : setting.getParameter().getLocal().getInferenceMode();
        params.setInferenceMode(inferenceModeChanged);
        int maxCandidateNumChanged = setting == null || setting.getParameter() == null ? CodeCompletionCandidateEnum.DEFAULT.num : setting.getParameter().getLocal().getMaxCandidateNum();
        params.setMaxCandidateNum(maxCandidateNumChanged);
    }

    private boolean initCosyLanguageService(Project project, File homeDir, boolean debugMode) throws IOException {
        File infoFile = new File(homeDir, COSY_INFO_FILE_NAME);
        if (infoFile.exists()) {
            log.info(".info exists, start to connect Cosy server");
            return this.connectCosyServer(project, homeDir, debugMode);
        }
        log.info(".info not exist, start to create Cosy process");
        return this.startCosy(project, homeDir, debugMode);
    }

    private boolean startCosy(Project project, File homeDir, boolean debugMode) throws IOException {
        ++this.cosyStartRetryTimes;
        if (this.cosyStartRetryTimes >= 3) {
            return false;
        }
        if (this.binaryRunner == null) {
            this.binaryRunner = new BinaryRunner(homeDir);
        }
        if (!this.binaryRunner.run(debugMode)) {
            log.warn("Cosy binary run failed");
            return false;
        }
        return this.connectCosyServer(project, homeDir, debugMode);
    }

    private boolean connectCosyServer(Project project, File homeDir, boolean debugMode) throws IOException {
        File infoFile = new File(homeDir, COSY_INFO_FILE_NAME);
        Pair<Integer, Long> infoPair = this.readCosyInfoFile(20);
        if (infoPair == null) {
            log.warn("Cannot read from .info, connect to Cosy server failed");
            return false;
        }
        Integer port = (Integer)infoPair.first;
        Long pid = (Long)infoPair.second;
        if (port == null || pid == null) {
            log.warn("Cannot get port and pid from .info file, connect failed");
            return false;
        }
        try {
            log.info("Connecting port " + port + " pid:" + pid);
            LanguageWebSocketService languageService = LanguageWebSocketService.createService(port);
            languageService.connect();
            this.languageServiceMap.put(project.getLocationHash(), languageService);
            Thread heartBeat = new Thread(new CosyHeartbeatRunner(project, languageService.getWebSocketClient().getSession(), languageService.getServer()));
            heartBeat.start();
        }
        catch (Exception e) {
            log.warn("Connect to Cosy server error, try to kill process and restart", (Throwable)e);
            INSTANCE.killProcessAndDeleteInfoFile(pid);
            return this.startCosy(project, homeDir, debugMode);
        }
        return true;
    }

    public void killProcessAndDeleteInfoFile(Long pid) {
        if (pid > 0L && ProcessUtils.isProcessAlive(pid)) {
            log.info(String.format("%d is alive, try to kill", pid));
            ProcessUtils.killProcess(pid);
        }
        this.deleteInfoFile();
    }

    public void deleteInfoFile() {
        File homeDir = this.getCosyHomeDir();
        if (homeDir == null) {
            return;
        }
        File infoFile = new File(homeDir, COSY_INFO_FILE_NAME);
        if (infoFile.exists()) {
            try {
                infoFile.delete();
                log.info("Delete .info file success.");
            }
            catch (Exception deleteException) {
                log.warn("Delete .info file encountered exception", (Throwable)deleteException);
            }
        }
    }

    public Pair<Integer, Long> readCosyInfoFile(int maxRetryTimes) {
        File homeDir = this.getCosyHomeDir();
        if (homeDir == null) {
            return null;
        }
        File infoFile = new File(homeDir, COSY_INFO_FILE_NAME);
        Integer port = null;
        Long pid = null;
        int i = 0;
        while (i < maxRetryTimes) {
            Pair<Integer, Long> infoPair = this.checkInfoFile(infoFile);
            if (infoPair != null) {
                port = (Integer)infoPair.first;
                pid = (Long)infoPair.second;
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                log.warn("Thread sleep is interrupted when waiting for .info file");
            }
            log.info(String.format("Retry for fetching .info for %d times, %d times left", ++i, maxRetryTimes - i));
        }
        if (port != null && pid != null) {
            return new Pair(port, pid);
        }
        return this.findProcessAndPortByName();
    }

    private Pair<Integer, Long> findProcessAndPortByName() {
        log.info("try find process and port by name");
        List<Long> cosyPidList = ProcessUtils.findCosyPidList();
        String pidListStr = org.apache.commons.lang3.StringUtils.join(cosyPidList, (String)",");
        log.info(String.format("Found cosy pid list: %s", pidListStr == null ? "null" : pidListStr));
        if (CollectionUtils.isNotEmpty(cosyPidList)) {
            return new Pair((Object)36510, (Object)cosyPidList.get(0));
        }
        if (ProcessUtils.isWindowsPlatform()) {
            return new Pair((Object)36510, (Object)0L);
        }
        return null;
    }

    private Pair<Integer, Long> checkInfoFile(@NotNull File infoFile) {
        if (infoFile == null) {
            Cosy.$$$reportNull$$$0(0);
        }
        if (!infoFile.exists()) {
            log.info(".info file not exist, wait 100ms and retry");
        } else {
            try {
                String rawText = FileUtils.readFileToString((File)infoFile, (Charset)StandardCharsets.UTF_8);
                if (rawText == null || rawText.isEmpty()) {
                    log.warn(".info file is empty, check failed");
                    return null;
                }
                String[] lines = rawText.split("\r\n|\n");
                if (lines.length != 2) {
                    log.warn(".info file is empty or has more or less than 2 lines:" + rawText);
                    return null;
                }
                Long port = StringUtils.getNumberFromString(lines[0]);
                Long pid = StringUtils.getNumberFromString(lines[1]);
                log.info("Read.info file get port:" + port + ", pid:" + pid);
                if (port == null || pid == null) {
                    log.warn("Cannot get port and pid from.info file, check failed");
                    return null;
                }
                return new Pair((Object)port.intValue(), (Object)pid);
            }
            catch (IOException e) {
                log.warn("Parsing .info file encountered Exception", (Throwable)e);
            }
            catch (Throwable throwable) {
                log.warn("Check info file encountered Throwable", throwable);
            }
        }
        return null;
    }

    public void close(Project project) {
        if (project == null) {
            return;
        }
        String key = project.getLocationHash();
        if (this.languageServiceMap.containsKey(key) && this.languageServiceMap.get(key) != null) {
            this.languageServiceMap.get(key).closeSession();
            this.languageServiceMap.remove(key);
        }
        if (this.readyMap.containsKey(key) && this.readyMap.get(key) != null) {
            this.readyMap.remove(key);
        }
        if (this.readyMap.size() == 0 && this.languageServiceMap.size() == 0) {
            this.binaryRunner = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart(Project project, List<CosyStartupListener> listeners) {
        AtomicBoolean startingState = this.startingStateMap.computeIfAbsent(project.getName(), e -> new AtomicBoolean(false));
        if (startingState.get()) {
            log.warn("Project " + project.getName() + " is restarting cosy, ignore repeat restarting");
            return;
        }
        AtomicBoolean atomicBoolean = startingState;
        synchronized (atomicBoolean) {
            if (startingState.get()) {
                log.warn("Project " + project.getName() + " is restarting cosy, ignore repeat restarting");
                return;
            }
            this.close(project);
        }
        if (listeners == null) {
            listeners = Collections.emptyList();
        }
        this.start(project, listeners);
    }

    private boolean isReady(Project project) {
        if (this.readyMap == null || project == null) {
            return false;
        }
        return this.readyMap.containsKey(project.getLocationHash()) && Boolean.TRUE.equals(this.readyMap.get(project.getLocationHash()));
    }

    public boolean checkCosy(Project project) {
        return this.checkCosy(project, true);
    }

    public boolean checkCosy(Project project, boolean autoRestart) {
        return this.checkCosy(project, autoRestart, Collections.emptyList());
    }

    public boolean checkCosy(Project project, boolean autoRestart, List<CosyStartupListener> listeners) {
        LanguageWebSocketService languageWebSocketService = INSTANCE.getLanguageService(project);
        boolean isReady = this.isReady(project);
        if (!isReady || languageWebSocketService == null || !languageWebSocketService.isSessionOpen()) {
            if (autoRestart) {
                this.restart(project, listeners);
            }
            return false;
        }
        return true;
    }

    public boolean checkAndWaitCosyState(ProgressIndicator progressIndicator, @NotNull Project project) {
        if (project == null) {
            Cosy.$$$reportNull$$$0(1);
        }
        boolean succeed = false;
        long maxTime = TimeUnit.SECONDS.toMillis(20L);
        long startTime = System.currentTimeMillis();
        log.info("Waiting to start cosy and checking state");
        while (true) {
            ProgressIndicatorUtils.checkCancelledEvenWithPCEDisabled((ProgressIndicator)progressIndicator);
            if (INSTANCE.checkCosy(project, false)) {
                succeed = true;
                log.info("Checking cosy state: OK");
                break;
            }
            if (System.currentTimeMillis() - startTime > maxTime) {
                log.info("Checking cosy state: timeout");
                break;
            }
            log.info("Checking cosy state: waiting");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return succeed;
    }

    public LanguageWebSocketService getLanguageService(Project project) {
        if (project == null) {
            return null;
        }
        if (this.languageServiceMap.containsKey(project.getLocationHash()) && this.languageServiceMap.get(project.getLocationHash()) != null) {
            return this.languageServiceMap.get(project.getLocationHash());
        }
        return null;
    }

    private List<LanguageWebSocketService> getAllLanguageServices() {
        return this.languageServiceMap.values().stream().filter(languageService -> languageService != null).collect(Collectors.toList());
    }

    public void updateConfig(ChangeUserSettingParams params) {
        INSTANCE.getAllLanguageServices().forEach(languageService -> languageService.changeUsageStatisticsSetting(params));
    }

    public SlideWindowStatQps getStatQps() {
        return this.statQps;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/alibabacloud/intellij/cosy/core/Cosy";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkInfoFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAndWaitCosyState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

