/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.core;

import com.alibabacloud.intellij.cosy.common.CosyConfig;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.ConfigInfo;
import com.alibabacloud.intellij.cosy.util.JsonUtil;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;

public final class ConfigManager {
    private static final Logger LOG = Logger.getInstance(ConfigManager.class);
    private static final String CONFIG_CACHE_NAME = "COSY_CONFIG";
    public static final ConfigManager INSTANCE = new ConfigManager();
    private static final ConfigInfo DEFAULT_CONFIG = new ConfigInfo();
    Cache<String, ConfigInfo> configCache = Caffeine.newBuilder().expireAfterWrite(24L, TimeUnit.HOURS).maximumSize(2L).build();

    private ConfigManager() {
    }

    public synchronized ConfigInfo getConfig() {
        ConfigInfo cacheConfig = (ConfigInfo)this.configCache.getIfPresent((Object)CONFIG_CACHE_NAME);
        if (cacheConfig != null) {
            return cacheConfig;
        }
        File workDirectory = CosyConfig.getHomeDirectory().toFile();
        File binDir = new File(workDirectory, "bin");
        File configFile = new File(binDir, "env.json");
        if (!configFile.exists()) {
            return DEFAULT_CONFIG;
        }
        try {
            String json = FileUtils.readFileToString((File)configFile, (String)"UTF-8");
            Map<String, Object> data = JsonUtil.fromJson(json);
            if (data == null) {
                return DEFAULT_CONFIG;
            }
            ConfigInfo config = new ConfigInfo(data);
            this.configCache.put((Object)CONFIG_CACHE_NAME, (Object)config);
            return config;
        }
        catch (Exception e) {
            LOG.warn("fail to get config.", (Throwable)e);
            return DEFAULT_CONFIG;
        }
    }
}

