/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.constants;

import com.alibabacloud.intellij.cosy.chat.enums.AgentTagEnum;
import com.alibabacloud.intellij.cosy.chat.enums.ChatTaskEnum;
import com.alibabacloud.intellij.cosy.chat.enums.ScopeTagEnum;
import com.alibabacloud.intellij.cosy.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.cosy.ui.search.model.SuggestPrompt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class InputConstants {
    public static final String GENERATE_CODE_SLASH = "/generate code";
    public static final String EXPLAIN_CODE_SLASH = "/explain code";
    public static final String GENERATE_TESTCASE_SLASH = "/generate unit test";
    public static final String GENERATE_COMMENT_SLASH = "/generate comment";
    public static final String GENERATE_OPTIMIZATION_SLASH = "/generate optimization";
    public static final String HELP_SLASH = "/help";
    public static final Map<String, SuggestPrompt> WELCOMING_SUGGEST_PROMPT_MAP = new LinkedHashMap<String, SuggestPrompt>(){
        {
            this.put("explain code", new SuggestPrompt(ChatTaskEnum.EXPLAIN_CODE.getName(), InputConstants.EXPLAIN_CODE_SLASH, "action:TriggerCosyExplainCodeGenerationAction"));
            this.put("generate unit test", new SuggestPrompt(ChatTaskEnum.GENERATE_TESTCASE.getName(), InputConstants.GENERATE_TESTCASE_SLASH, "action:TriggerCosyTestcaseGenerationAction"));
            this.put("generate comment", new SuggestPrompt(ChatTaskEnum.CODE_GENERATE_COMMENT.getName(), InputConstants.GENERATE_COMMENT_SLASH, "action:TriggerCosyCodeGenerateCommentGenerationAction"));
            this.put("generate optimization", new SuggestPrompt(ChatTaskEnum.OPTIMIZE_CODE.getName(), InputConstants.GENERATE_OPTIMIZATION_SLASH, "action:TriggerCosyOptimizeCodeGenerationAction"));
        }
    };
    public static final Map<String, SuggestPrompt> CONTEXT_SUGGEST_PROMPT_MAP = new LinkedHashMap<String, SuggestPrompt>(){
        {
            this.put("clear context", new SuggestPrompt(null, "/clear context", "action:TriggerCosyClearHistoryAction"));
        }
    };
    public static final Map<String, SuggestPrompt> WELCOMING_HELP_MAP = new LinkedHashMap<String, SuggestPrompt>(){
        {
            this.put("help", new SuggestPrompt(ChatTaskEnum.CHAT_HELP.getName(), InputConstants.HELP_SLASH, "action:TriggerCosyHelpAction"));
        }
    };
    public static final Map<String, SuggestPrompt> AGENT_SUGGEST_PROMPT_MAP = new LinkedHashMap<String, SuggestPrompt>(){
        {
            this.put("workspace", new SuggestPrompt(AgentTagEnum.WORKSPACE.getId(), AgentTagEnum.WORKSPACE.getName(), null));
            this.put(CosyBundle.message("tag.agent.lingma", new Object[0]), new SuggestPrompt(AgentTagEnum.LINGMA.getId(), AgentTagEnum.LINGMA.getName(), null));
        }
    };
    public static final Map<String, SuggestPrompt> SCOPE_SUGGEST_PROMPT_MAP = new LinkedHashMap<String, SuggestPrompt>(){
        {
            this.put("team docs", new SuggestPrompt(ScopeTagEnum.TEAM_DOCS.getId(), ScopeTagEnum.TEAM_DOCS.getName(), null));
        }
    };
    public static final Map<String, String> CHAT_TASK_QUERY_MAP = new LinkedHashMap<String, String>(){
        {
            this.put(ChatTaskEnum.DESCRIPTION_GENERATE_CODE.getName(), InputConstants.GENERATE_CODE_SLASH);
            this.put(ChatTaskEnum.EXPLAIN_CODE.getName(), InputConstants.EXPLAIN_CODE_SLASH);
            this.put(ChatTaskEnum.GENERATE_TESTCASE.getName(), InputConstants.GENERATE_TESTCASE_SLASH);
            this.put(ChatTaskEnum.CODE_GENERATE_COMMENT.getName(), InputConstants.GENERATE_COMMENT_SLASH);
            this.put(ChatTaskEnum.OPTIMIZE_CODE.getName(), InputConstants.GENERATE_OPTIMIZATION_SLASH);
        }
    };
    public static final Map<String, String> CHAT_TASK_ACTION_MAP = new LinkedHashMap<String, String>(){
        {
            this.put(ChatTaskEnum.DESCRIPTION_GENERATE_CODE.getName(), "TriggerCosyDescriptionGenerateCodeGenerationAction");
            this.put(ChatTaskEnum.EXPLAIN_CODE.getName(), "TriggerCosyExplainCodeGenerationAction");
            this.put(ChatTaskEnum.GENERATE_TESTCASE.getName(), "TriggerCosyTestcaseGenerationAction");
            this.put(ChatTaskEnum.CODE_GENERATE_COMMENT.getName(), "TriggerCosyCodeGenerateCommentGenerationAction");
            this.put(ChatTaskEnum.OPTIMIZE_CODE.getName(), "TriggerCosyOptimizeCodeGenerationAction");
        }
    };
    public static final Map<String, String> TASK_SLASH_ACTION_MAP = new LinkedHashMap<String, String>(){
        {
            this.put(InputConstants.GENERATE_CODE_SLASH, "TriggerCosyDescriptionGenerateCodeGenerationAction");
            this.put(InputConstants.EXPLAIN_CODE_SLASH, "TriggerCosyExplainCodeGenerationAction");
            this.put(InputConstants.GENERATE_TESTCASE_SLASH, "TriggerCosyTestcaseGenerationAction");
            this.put(InputConstants.GENERATE_COMMENT_SLASH, "TriggerCosyCodeGenerateCommentGenerationAction");
            this.put(InputConstants.GENERATE_OPTIMIZATION_SLASH, "TriggerCosyOptimizeCodeGenerationAction");
        }
    };
    public static final List<String> SIMPLE_CODE_RELATED_TASKS = Arrays.asList(ChatTaskEnum.CODE_GENERATE_COMMENT.getName(), ChatTaskEnum.EXPLAIN_CODE.getName(), ChatTaskEnum.OPTIMIZE_CODE.getName());
    public static final List<String> QUESTION_OBJECT_TASKS = Arrays.asList(ChatTaskEnum.SEARCH_TITLE_ASK.getName(), ChatTaskEnum.DOCUMENT_TRANSLATE.getName());
    public static final List<String> TASK_TAG_LIST = new ArrayList<String>(){
        {
            this.add(InputConstants.GENERATE_CODE_SLASH);
            this.add(InputConstants.EXPLAIN_CODE_SLASH);
            this.add(InputConstants.GENERATE_TESTCASE_SLASH);
            this.add(InputConstants.GENERATE_COMMENT_SLASH);
            this.add(InputConstants.GENERATE_OPTIMIZATION_SLASH);
            this.add(InputConstants.HELP_SLASH);
        }
    };
    public static final List<String> AGENT_TAG_LIST = new ArrayList<String>(){
        {
            this.add(AgentTagEnum.WORKSPACE.getName());
            this.add(AgentTagEnum.LINGMA.getName());
        }
    };
    public static final List<String> SCOPE_TAG_LIST = new ArrayList<String>(){
        {
            this.add(ScopeTagEnum.TEAM_DOCS.getName());
        }
    };
}

