/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.chat.processor;

import com.alibabacloud.intellij.cosy.constants.CosyKey;
import com.alibabacloud.intellij.cosy.core.lsp.model.model.ChatStep;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.ChatProcessStepCallbackParams;
import com.alibabacloud.intellij.cosy.ui.search.topic.GenerateStepCallbackNotifier;
import com.alibabacloud.intellij.cosy.util.ChatSessionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.Map;
import java.util.Objects;
import javax.swing.SwingUtilities;

public class ChatProcessStepCallbackParamsProcessor {
    private static final Logger log = Logger.getInstance(ChatProcessStepCallbackParamsProcessor.class);
    private ChatProcessStepCallbackParams chatProcessStepCallbackParams;

    public ChatProcessStepCallbackParamsProcessor(ChatProcessStepCallbackParams chatProcessStepCallbackParams) {
        this.chatProcessStepCallbackParams = chatProcessStepCallbackParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean updateProcessStep() {
        if (this.chatProcessStepCallbackParams == null || this.chatProcessStepCallbackParams.getStep() == null || this.chatProcessStepCallbackParams.getStatus() == null || this.chatProcessStepCallbackParams.getRequestId() == null) {
            log.error("Chat process step callback.");
            return false;
        }
        Project project = (Project)Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_PROJECT)).get(this.chatProcessStepCallbackParams.getRequestId());
        if (project == null) {
            log.debug("Cannot find project in chat process step callback processor by request_id " + this.chatProcessStepCallbackParams.getRequestId());
            return false;
        }
        ChatSessionUtil.updateAnsweringStatus(this.chatProcessStepCallbackParams.getRequestId());
        ChatStep stepItem = ChatStep.builder().step(this.chatProcessStepCallbackParams.getStep()).description(this.chatProcessStepCallbackParams.getDescription()).status(this.chatProcessStepCallbackParams.getStatus()).result(this.chatProcessStepCallbackParams.getResult()).build();
        try {
            SwingUtilities.invokeAndWait(() -> ((GenerateStepCallbackNotifier)project.getMessageBus().syncPublisher(GenerateStepCallbackNotifier.GENERATE_PROCESS_STEP_CALLBACK_NOTIFICATION)).push(this.chatProcessStepCallbackParams.getRequestId(), this.chatProcessStepCallbackParams.getSessionId(), stepItem));
        }
        catch (Exception e) {
            log.error("Update process step error.", (Throwable)e);
            Boolean bl = false;
            return bl;
        }
        finally {
            Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_ANSWER_LIST)).remove(this.chatProcessStepCallbackParams.getRequestId());
        }
        return true;
    }
}

