/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.chat.processor;

import com.alibabacloud.intellij.cosy.constants.CosyKey;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.ChatFinishParams;
import com.alibabacloud.intellij.cosy.ui.search.topic.GenerateStreamStopNotifier;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.Map;
import java.util.Objects;
import javax.swing.SwingUtilities;

public class ChatFinishProcessor {
    private static final Logger log = Logger.getInstance(ChatFinishProcessor.class);
    private ChatFinishParams chatFinishParams;

    public ChatFinishProcessor(ChatFinishParams chatFinishParams) {
        this.chatFinishParams = chatFinishParams;
    }

    public Boolean finish() {
        if (this.chatFinishParams == null || this.chatFinishParams.getRequestId() == null || this.chatFinishParams.getSessionId() == null) {
            log.error("Chat answer params contain null.");
            return false;
        }
        Project project = (Project)Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_PROJECT)).get(this.chatFinishParams.getRequestId());
        Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_PROJECT)).remove(this.chatFinishParams.getRequestId());
        Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_ANSWERING)).remove(this.chatFinishParams.getRequestId());
        if (project == null) {
            log.warn("Cannot find project in chat finish processor by request_id " + this.chatFinishParams.getRequestId());
            return false;
        }
        try {
            SwingUtilities.invokeAndWait(() -> ((GenerateStreamStopNotifier)project.getMessageBus().syncPublisher(GenerateStreamStopNotifier.GENERATE_STREAM_STOP_NOTIFICATION)).stop(this.chatFinishParams.getRequestId(), this.chatFinishParams.getSessionId(), this.chatFinishParams.getStatusCode(), this.chatFinishParams.getReason()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }
}

