/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.chat.processor;

import com.alibabacloud.intellij.cosy.chat.model.ChatAnswerSnippet;
import com.alibabacloud.intellij.cosy.constants.CosyKey;
import com.alibabacloud.intellij.cosy.core.lsp.model.params.ChatAnswerParams;
import com.alibabacloud.intellij.cosy.ui.search.topic.GenerateStreamPushNotifier;
import com.alibabacloud.intellij.cosy.util.ChatSessionUtil;
import com.alibabacloud.intellij.cosy.util.ThreadUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class ChatAnswerProcessor {
    private static final Logger log = Logger.getInstance(ChatAnswerProcessor.class);
    private static final Pattern CODE_MATCHER = Pattern.compile("(```[\\w#+]*\n*)|(`{2,3}[\\w#+]+\n*)", 32);
    private ChatAnswerParams chatAnswerParams;

    public ChatAnswerProcessor(ChatAnswerParams chatAnswerParams) {
        this.chatAnswerParams = chatAnswerParams;
    }

    public Boolean updateAnswer() {
        if (this.chatAnswerParams == null || this.chatAnswerParams.getText() == null || this.chatAnswerParams.getOverwrite() == null) {
            log.error("Chat answer params contain null.");
            return false;
        }
        Project project = (Project)Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_PROJECT)).get(this.chatAnswerParams.getRequestId());
        if (project == null) {
            log.debug("Cannot find project in chat answer processor by request_id " + this.chatAnswerParams.getRequestId());
            return false;
        }
        ChatSessionUtil.updateAnsweringStatus(this.chatAnswerParams.getRequestId());
        Boolean isFirstThread = false;
        Map answerListMap = (Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_ANSWER_LIST);
        if (answerListMap.get(this.chatAnswerParams.getRequestId()) == null) {
            answerListMap.put(this.chatAnswerParams.getRequestId(), new CopyOnWriteArrayList());
            isFirstThread = true;
        }
        CopyOnWriteArrayList chatAnswerList = (CopyOnWriteArrayList)answerListMap.get(this.chatAnswerParams.getRequestId());
        ChatAnswerSnippet newChatAnswer = ChatAnswerSnippet.builder().text(this.chatAnswerParams.getText()).timestamp(this.chatAnswerParams.getTimestamp()).isDisplayed(false).overwrite(this.chatAnswerParams.getOverwrite()).build();
        this.appendNewAnswer(chatAnswerList, newChatAnswer);
        if (!isFirstThread.booleanValue()) {
            return true;
        }
        ThreadUtil.execute(() -> {
            try {
                while (true) {
                    Project currentProject;
                    if ((currentProject = (Project)Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_PROJECT)).get(this.chatAnswerParams.getRequestId())) == null) {
                        CopyOnWriteArrayList currentChatAnswerList = (CopyOnWriteArrayList)answerListMap.get(this.chatAnswerParams.getRequestId());
                        Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_ANSWER_LIST)).remove(this.chatAnswerParams.getRequestId());
                        if (project != null && CollectionUtils.isNotEmpty((Collection)currentChatAnswerList)) {
                            Boolean overwrite = false;
                            ArrayList<String> chatAnswerTextList = new ArrayList<String>();
                            for (ChatAnswerSnippet chatAnswerSnippet : currentChatAnswerList) {
                                if (BooleanUtils.isTrue((Boolean)chatAnswerSnippet.getOverwrite())) {
                                    chatAnswerTextList.clear();
                                    overwrite = true;
                                    chatAnswerTextList.add(chatAnswerSnippet.getText());
                                    continue;
                                }
                                chatAnswerTextList.add(chatAnswerSnippet.getText());
                            }
                            Boolean finalOverwrite = overwrite;
                            String allAnswerText = StringUtils.join((Object[])chatAnswerTextList.toArray(), (String)"");
                            SwingUtilities.invokeAndWait(() -> ((GenerateStreamPushNotifier)project.getMessageBus().syncPublisher(GenerateStreamPushNotifier.GENERATE_STREAM_PUSH_NOTIFICATION)).push(this.chatAnswerParams.getRequestId(), this.chatAnswerParams.getSessionId(), allAnswerText, finalOverwrite, true));
                        }
                        break;
                    }
                    this.doTyping(chatAnswerList, project);
                }
            }
            catch (Exception e) {
                log.error("Update answer error.", (Throwable)e);
            }
            finally {
                Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_ANSWER_LIST)).remove(this.chatAnswerParams.getRequestId());
            }
        });
        return true;
    }

    private void doTyping(CopyOnWriteArrayList<ChatAnswerSnippet> chatAnswerSnippets, Project project) {
        ArrayList<ChatAnswerSnippet> restChatAnswerSnippets = new ArrayList<ChatAnswerSnippet>();
        for (ChatAnswerSnippet chatAnswerSnippet : chatAnswerSnippets) {
            if (!BooleanUtils.isFalse((Boolean)chatAnswerSnippet.getIsDisplayed())) continue;
            restChatAnswerSnippets.add(chatAnswerSnippet);
        }
        while (CollectionUtils.isNotEmpty(restChatAnswerSnippets)) {
            String currentStr;
            ChatAnswerSnippet chatAnswerSnippet = (ChatAnswerSnippet)restChatAnswerSnippets.get(0);
            for (StringBuffer answerTextBuffer = new StringBuffer(chatAnswerSnippet.getText()); answerTextBuffer != null && answerTextBuffer.length() > 0; answerTextBuffer = answerTextBuffer.delete(0, currentStr.length())) {
                Project currentProject = (Project)Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_PROJECT)).get(this.chatAnswerParams.getRequestId());
                if (currentProject == null) {
                    return;
                }
                Matcher matcher = CODE_MATCHER.matcher(answerTextBuffer);
                currentStr = matcher.find() && matcher.start() == 0 ? matcher.group(0) : answerTextBuffer.substring(0, 1);
                try {
                    SwingUtilities.invokeAndWait(() -> ((GenerateStreamPushNotifier)project.getMessageBus().syncPublisher(GenerateStreamPushNotifier.GENERATE_STREAM_PUSH_NOTIFICATION)).push(this.chatAnswerParams.getRequestId(), this.chatAnswerParams.getSessionId(), currentStr, this.chatAnswerParams.getOverwrite(), false));
                }
                catch (InterruptedException e) {
                    log.error("Update answer error.", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    log.error("Update answer error.", (Throwable)e);
                }
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            chatAnswerSnippet.setIsDisplayed(true);
            restChatAnswerSnippets.clear();
            for (ChatAnswerSnippet answerSnippet : chatAnswerSnippets) {
                if (!BooleanUtils.isFalse((Boolean)answerSnippet.getIsDisplayed())) continue;
                restChatAnswerSnippets.add(answerSnippet);
            }
        }
    }

    private List<ChatAnswerSnippet> appendNewAnswer(CopyOnWriteArrayList<ChatAnswerSnippet> chatAnswerSnippets, ChatAnswerSnippet newAnswerSnippet) {
        chatAnswerSnippets.add(newAnswerSnippet);
        chatAnswerSnippets.sort(Comparator.comparing(ChatAnswerSnippet::getTimestamp));
        return chatAnswerSnippets;
    }
}

