/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.chat.factory;

import com.alibabacloud.intellij.cosy.chat.enums.FileLanguageEnum;
import com.alibabacloud.intellij.cosy.chat.factory.BaseChatContextDtoBuilder;
import com.alibabacloud.intellij.cosy.chat.model.ChatContext;
import com.alibabacloud.intellij.cosy.chat.model.task.dto.TestcaseGenerationDto;
import com.alibabacloud.intellij.cosy.ui.search.model.GenerateInput;
import java.util.HashMap;
import java.util.Map;

public class TestcaseGenerationDtoBuilder
extends BaseChatContextDtoBuilder {
    private static final Map<String, String> LANGUAGE_CLASS_METHOD_TEMPLATE = new HashMap<String, String>(){
        private static final long serialVersionUID = 4595657320804394643L;
        {
            this.put(FileLanguageEnum.JAVA.getName(), "public class %s {\n   %s\n}");
            this.put(FileLanguageEnum.PYTHON.getName(), "class %s:\n   %s\n");
        }
    };

    @Override
    public Object build(GenerateInput generateInput, String displayText) {
        String selectionCode = generateInput.getChatContext().getSourceCode();
        ChatContext chatContext = generateInput.getChatContext();
        TestcaseGenerationDto testcaseGenerationDto = TestcaseGenerationDto.builder().code(this.formatTestcaseCode(chatContext)).selectionCode(selectionCode).selectionRange(chatContext.getRange()).fileCode(chatContext.getFileCode()).language(generateInput.getChatContext().getFileLanguage().toLowerCase()).filePath(chatContext.getFilePath()).build();
        return this.fillBaseInfo(generateInput, testcaseGenerationDto);
    }

    private String formatTestcaseCode(ChatContext chatContext) {
        String language;
        String methodContent = chatContext.getMethodContent();
        String className = chatContext.getClassName();
        if (className == null) {
            className = "DemoClass";
        }
        if ((language = chatContext.getFileLanguage()) == null || !LANGUAGE_CLASS_METHOD_TEMPLATE.containsKey(language.toLowerCase())) {
            return methodContent;
        }
        return String.format(LANGUAGE_CLASS_METHOD_TEMPLATE.get(language.toLowerCase()), className, methodContent);
    }
}

