/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.chat.factory;

import com.alibabacloud.intellij.cosy.chat.enums.ChatTaskEnum;
import com.alibabacloud.intellij.cosy.chat.factory.BaseChatContextDtoBuilder;
import com.alibabacloud.intellij.cosy.chat.factory.CodeRelatedDtoBuilder;
import com.alibabacloud.intellij.cosy.chat.factory.DescriptionCodeDtoBuilder;
import com.alibabacloud.intellij.cosy.chat.factory.QuestionDtoBuilder;
import com.alibabacloud.intellij.cosy.chat.factory.QuestionObjectDtoBuilder;
import com.alibabacloud.intellij.cosy.chat.factory.ReplyTaskDtoBuilder;
import com.alibabacloud.intellij.cosy.chat.factory.RetryTaskDtoBuilder;
import com.alibabacloud.intellij.cosy.chat.factory.TestcaseGenerationDtoBuilder;
import com.alibabacloud.intellij.cosy.constants.InputConstants;

public class ChatContextDtoBuilderFactory {
    public static BaseChatContextDtoBuilder getChatContextDtoBuilder(String chatTask) {
        if (chatTask == null) {
            return null;
        }
        if (ChatTaskEnum.DESCRIPTION_GENERATE_CODE.getName().equals(chatTask)) {
            return new DescriptionCodeDtoBuilder();
        }
        if (ChatTaskEnum.GENERATE_TESTCASE.getName().equals(chatTask)) {
            return new TestcaseGenerationDtoBuilder();
        }
        if (InputConstants.SIMPLE_CODE_RELATED_TASKS.contains(chatTask)) {
            return new CodeRelatedDtoBuilder();
        }
        if (InputConstants.QUESTION_OBJECT_TASKS.contains(chatTask)) {
            return new QuestionObjectDtoBuilder();
        }
        if (ChatTaskEnum.REPLY_TASK.getName().equals(chatTask)) {
            return new ReplyTaskDtoBuilder();
        }
        if (ChatTaskEnum.RETRY_TASK.getName().equals(chatTask)) {
            return new RetryTaskDtoBuilder();
        }
        return new QuestionDtoBuilder();
    }
}

