/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.cosy.chat.action;

import com.alibabacloud.intellij.cosy.chat.enums.ChatTaskEnum;
import com.alibabacloud.intellij.cosy.chat.enums.TriggerPlaceEnum;
import com.alibabacloud.intellij.cosy.chat.model.ChatAskInput;
import com.alibabacloud.intellij.cosy.chat.model.ChatContext;
import com.alibabacloud.intellij.cosy.chat.model.Position;
import com.alibabacloud.intellij.cosy.chat.model.Range;
import com.alibabacloud.intellij.cosy.common.CosyCacheKeys;
import com.alibabacloud.intellij.cosy.constants.InputConstants;
import com.alibabacloud.intellij.cosy.search.enums.SearchActionTypeEnum;
import com.alibabacloud.intellij.cosy.search.enums.TrackEventTypeEnum;
import com.alibabacloud.intellij.cosy.search.result.SearchContext;
import com.alibabacloud.intellij.cosy.service.TelemetryService;
import com.alibabacloud.intellij.cosy.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.cosy.ui.search.I18NConstant;
import com.alibabacloud.intellij.cosy.ui.search.SearchToolWindowFactory;
import com.alibabacloud.intellij.cosy.ui.search.enums.OperationEnum;
import com.alibabacloud.intellij.cosy.ui.search.model.ChatAskTag;
import com.alibabacloud.intellij.cosy.ui.search.model.GenerateInput;
import com.alibabacloud.intellij.cosy.ui.search.topic.AnyGenerateNotifier;
import com.alibabacloud.intellij.cosy.util.FileUtil;
import com.alibabacloud.intellij.cosy.util.PsiUtils;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.UpdateInBackground;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import icons.CommonIcons;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.swing.Icon;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public abstract class BaseCosySelectGenerationAction
extends AnAction
implements UpdateInBackground {
    private static Logger log = Logger.getInstance(BaseCosySelectGenerationAction.class);
    public static final int MAX_SELECTION_CODE_LINES = 1000;
    public static Map<String, TrackEventTypeEnum> PLACE_EVENT_TYPE_MAPPING = new HashMap<String, TrackEventTypeEnum>(){
        private static final long serialVersionUID = 4215657320805394643L;
        {
            this.put(TriggerPlaceEnum.EDITOR_POPUP.getName(), TrackEventTypeEnum.CHAT_TRIGGER_RIGHT_CLICK);
            this.put(TriggerPlaceEnum.TOOL_WINDOW.getName(), TrackEventTypeEnum.CHAT_TRIGGER_QUICK_BUTTON);
            this.put(TriggerPlaceEnum.MENU_POPUP.getName(), TrackEventTypeEnum.CHAT_TRIGGER_METHOD);
            this.put(TriggerPlaceEnum.ASK_INPUT_PANEL.getName(), TrackEventTypeEnum.CHAT_TRIGGER_ASK_PANEL);
        }
    };

    public void actionPerformed(@NotNull AnActionEvent e) {
        Editor editor;
        if (e == null) {
            BaseCosySelectGenerationAction.$$$reportNull$$$0(0);
        }
        if ((editor = (Editor)e.getData(PlatformDataKeys.EDITOR)) == null) {
            return;
        }
        Project project = e.getProject();
        if (project == null) {
            log.error("Cannot find project in BaseCosySelectGenerationAction.");
            return;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        String code = selectionModel.getSelectedText();
        Range range = null;
        VisualPosition visualStartPosition = selectionModel.getSelectionStartPosition();
        VisualPosition visualEndPosition = selectionModel.getSelectionEndPosition();
        if (visualStartPosition != null && visualEndPosition != null) {
            int startLine = editor.visualToLogicalPosition((VisualPosition)visualStartPosition).line;
            int startCharacter = 0;
            int endLine = editor.visualToLogicalPosition((VisualPosition)visualEndPosition).line;
            int endCharacter = editor.getDocument().getLineEndOffset(endLine) - editor.getDocument().getLineStartOffset(endLine);
            code = editor.getDocument().getText(new TextRange(editor.getDocument().getLineStartOffset(startLine), editor.getDocument().getLineEndOffset(endLine)));
            range = Range.builder().start(Position.builder().line(startLine).character(startCharacter).build()).end(Position.builder().line(endLine).character(endCharacter).build()).build();
        }
        if (StringUtils.isBlank((CharSequence)code) || this.needCheckCode() && !this.containsCode(project, psiFile, code, selectionModel)) {
            NotificationFactory.showInfoNotification(project, I18NConstant.CHAT_NOTIFY_SELECT_CODE);
            return;
        }
        if (this.getCodeLines(code) > 1000) {
            NotificationFactory.showInfoNotification(project, String.format(I18NConstant.CHAT_NOTIFY_SELECTION_LINE_EXCEED, 1000));
            return;
        }
        ChatContext chatContext = this.buildChatContext(project, psiFile, code, selectionModel, range);
        ChatAskInput chatAskInput = this.getChatAskInput(e);
        GenerateInput genInput = new GenerateInput(this.getChatTaskEnum().getDisplayText(), this.getChatTaskEnum().getName(), chatContext, chatAskInput);
        SearchContext context = new SearchContext(OperationEnum.CLEAR_AND_ADD.text, SearchActionTypeEnum.RIGHT_CLICK_TRIGGER.getType());
        String requestId = UUID.randomUUID().toString();
        TrackEventTypeEnum eventType = PLACE_EVENT_TYPE_MAPPING.getOrDefault(e.getPlace(), TrackEventTypeEnum.CHAT_TRIGGER_RIGHT_CLICK);
        TelemetryService.getInstance().telemetryChatTask(project, eventType, requestId, chatContext.getSessionId(), this.getChatTaskEnum().getName(), genInput);
        CosyCacheKeys.NEED_INIT_WELCOME_WINDOW.set((UserDataHolder)project, (Object)false);
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Code Search");
        if (toolWindow == null) {
            ToolWindowManager.getInstance((Project)project).registerToolWindow(RegisterToolWindowTask.closable((String)"Code Search", (Icon)CommonIcons.AI, (ToolWindowAnchor)ToolWindowAnchor.RIGHT));
            toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Code Search");
        }
        ToolWindow finalToolWindow = toolWindow;
        ApplicationManager.getApplication().invokeLater(() -> {
            if (finalToolWindow != null) {
                if (finalToolWindow.getContentManager().findContent(I18NConstant.MAIN_CONTENT_NAME) == null) {
                    SearchToolWindowFactory.createSearchMainPanelAndGenerateContentForm(project, finalToolWindow, (Consumer<Project>)((Consumer)project1 -> ((AnyGenerateNotifier)project1.getMessageBus().syncPublisher(AnyGenerateNotifier.ANY_GENERATE_NOTIFICATION)).anyGenerate(context, genInput, requestId)));
                } else {
                    SearchToolWindowFactory.showToolWindow(project);
                    ((AnyGenerateNotifier)project.getMessageBus().syncPublisher(AnyGenerateNotifier.ANY_GENERATE_NOTIFICATION)).anyGenerate(context, genInput, requestId);
                }
            }
        });
    }

    private ChatAskInput getChatAskInput(@NotNull AnActionEvent e) {
        Object askDataObj;
        ChatAskInput chatAskInput;
        if (e == null) {
            BaseCosySelectGenerationAction.$$$reportNull$$$0(1);
        }
        ChatAskInput chatAskInput2 = chatAskInput = (askDataObj = e.getDataContext().getData("ask.input")) == null ? null : (ChatAskInput)askDataObj;
        if (chatAskInput == null) {
            String chatTask = this.getChatTaskEnum().getName();
            String text = InputConstants.CHAT_TASK_QUERY_MAP.get(chatTask);
            ChatAskTag tag = ChatAskTag.ofTask(chatTask, text);
            chatAskInput = new ChatAskInput(null, Collections.singletonList(tag));
        }
        return chatAskInput;
    }

    protected ChatContext buildChatContext(Project project, PsiFile psiFile, String code, SelectionModel selectionModel, Range range) {
        return ChatContext.builder().fileLanguage(FileUtil.getLanguageFileType(project)).filePath(psiFile == null || psiFile.getVirtualFile() == null ? null : psiFile.getVirtualFile().getPath()).fileCode(psiFile == null ? null : psiFile.getText()).sessionId(null).range(range).sourceCode(code).localeLanguage(Locale.getDefault().getLanguage()).build();
    }

    protected boolean needCheckCode() {
        return true;
    }

    private boolean containsCode(Project project, PsiFile psiFile, String code, SelectionModel selectionModel) {
        return PsiUtils.containsCode(project, psiFile, selectionModel);
    }

    private int getCodeLines(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return 1;
        }
        return code.split("\n").length;
    }

    protected abstract ChatTaskEnum getChatTaskEnum();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/alibabacloud/intellij/cosy/chat/action/BaseCosySelectGenerationAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getChatAskInput";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

